/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001=\u0011AER5mKNK8\u000f^3n\u0005\u0006\u001cX\rZ\"iK\u000e\\\u0007o\\5oi\u001aKG.Z'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001C\u0006\u000e1!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0016\u0007\",7m\u001b9pS:$h)\u001b7f\u001b\u0006t\u0017mZ3s!\tYRF\u0004\u0002\u001dW9\u0011QD\u000b\b\u0003=%r!a\b\u0015\u000f\u0005\u0001:cBA\u0011'\u001d\t\u0011S%D\u0001$\u0015\t!c\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\ta#!A\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\n\u00059z#a\u0005*f]\u0006lW\rS3ma\u0016\u0014X*\u001a;i_\u0012\u001c(B\u0001\u0017\u0003!\t\tD'D\u00013\u0015\t\u0019\u0004\"\u0001\u0005j]R,'O\\1m\u0013\t)$GA\u0004M_\u001e<\u0017N\\4\t\u0011]\u0002!\u0011!Q\u0001\na\nA\u0001]1uQB\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0003MNT!!\u0010\u0006\u0002\r!\fGm\\8q\u0013\ty$H\u0001\u0003QCRD\u0007\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0002D\r6\tAI\u0003\u0002Fy\u0005!1m\u001c8g\u0013\t9EIA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006\u0013\u0002!\tAS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007-cU\n\u0005\u0002\u0018\u0001!)q\u0007\u0013a\u0001q!)\u0011\t\u0013a\u0001\u0005\"91\b\u0001b\u0001\n#yU#\u0001)\u0011\u0005e\n\u0016B\u0001*;\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\u0007)\u0002\u0001\u000b\u0011\u0002)\u0002\u0007\u0019\u001c\b\u0005C\u0003W\u0001\u0011\u0005s+\u0001\u0003mSN$Hc\u0001-_?B\u0019\u0011#W.\n\u0005i\u0013\"!B!se\u0006L\bCA\u001d]\u0013\ti&H\u0001\u0006GS2,7\u000b^1ukNDQaN+A\u0002aBQ\u0001Y+A\u0002\u0005\faAZ5mi\u0016\u0014\bCA\u001dc\u0013\t\u0019'H\u0001\u0006QCRDg)\u001b7uKJDQ!\u001a\u0001\u0005B\u0019\fa!\\6eSJ\u001cHCA4k!\t\t\u0002.\u0003\u0002j%\t!QK\\5u\u0011\u00159D\r1\u00019\u0011\u0015a\u0007\u0001\"\u0011n\u00039\u0019'/Z1uKR+W\u000e\u001d$jY\u0016$\"A\\9\u0011\u0005ez\u0017B\u00019;\u0005I15\u000bR1uC>+H\u000f];u'R\u0014X-Y7\t\u000b]Z\u0007\u0019\u0001\u001d\t\u000bM\u0004A\u0011\t;\u0002\u0019\r\u0014X-\u0019;f\u0003R|W.[2\u0015\u0007UL(\u0010\u0005\u0002wo:\u0011qcK\u0005\u0003q>\u0012QdQ1oG\u0016dG.\u00192mK\u001a\u001bF)\u0019;b\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0006oI\u0004\r\u0001\u000f\u0005\u0006wJ\u0004\r\u0001`\u0001\u0014_Z,'o\u001e:ji\u0016Le\rU8tg&\u0014G.\u001a\t\u0003#uL!A \n\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0011\u0001B8qK:$B!!\u0002\u0002\fA\u0019\u0011(a\u0002\n\u0007\u0005%!HA\tG'\u0012\u000bG/Y%oaV$8\u000b\u001e:fC6DQaN@A\u0002aBq!a\u0004\u0001\t\u0003\n\t\"\u0001\u0004fq&\u001cHo\u001d\u000b\u0004y\u0006M\u0001BB\u001c\u0002\u000e\u0001\u0007\u0001\bC\u0004\u0002\u0018\u0001!\t%!\u0007\u0002\u001dI,g.Y7f)\u0016l\u0007OR5mKR9q-a\u0007\u0002 \u0005\r\u0002bBA\u000f\u0003+\u0001\r\u0001O\u0001\bgJ\u001c\u0007+\u0019;i\u0011\u001d\t\t#!\u0006A\u0002a\nq\u0001Z:u!\u0006$\b\u000e\u0003\u0004|\u0003+\u0001\r\u0001 \u0005\b\u0003O\u0001A\u0011IA\u0015\u0003\u0019!W\r\\3uKR\u0019q-a\u000b\t\r]\n)\u00031\u00019\u0011\u001d\ty\u0003\u0001C!\u0003c\tq![:M_\u000e\fG.F\u0001}\u0001")
public class FileSystemBasedCheckpointFileManager
implements CheckpointFileManager,
CheckpointFileManager.RenameHelperMethods,
Logging {
    private final FileSystem fs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public FileStatus[] list(Path path) {
        return CheckpointFileManager.list$(this, path);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public FileSystem fs() {
        return this.fs;
    }

    @Override
    public FileStatus[] list(Path path, PathFilter filter) {
        return this.fs().listStatus(path, filter);
    }

    @Override
    public void mkdirs(Path path) {
        this.fs().mkdirs(path, FsPermission.getDirDefault());
    }

    @Override
    public FSDataOutputStream createTempFile(Path path) {
        return this.fs().create(path, true);
    }

    @Override
    public CheckpointFileManager.CancellableFSDataOutputStream createAtomic(Path path, boolean overwriteIfPossible) {
        return new CheckpointFileManager.RenameBasedFSDataOutputStream(this, path, overwriteIfPossible);
    }

    @Override
    public FSDataInputStream open(Path path) {
        return this.fs().open(path);
    }

    @Override
    public boolean exists(Path path) {
        try {
            return this.fs().getFileStatus(path) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public void renameTempFile(Path srcPath, Path dstPath, boolean overwriteIfPossible) {
        if (!overwriteIfPossible && this.fs().exists(dstPath)) {
            throw new FileAlreadyExistsException(new StringBuilder(51).append("Failed to rename ").append(srcPath).append(" to ").append(dstPath).append(" as destination already exists").toString());
        }
        if (!this.fs().rename(srcPath, dstPath)) {
            if (this.fs().exists(dstPath)) {
                if (!overwriteIfPossible) {
                    throw new FileAlreadyExistsException(new StringBuilder(35).append("Failed to rename as ").append(dstPath).append(" already exists").toString());
                }
            } else {
                if (!this.fs().exists(srcPath)) {
                    throw new FileNotFoundException(new StringBuilder(34).append("Failed to rename as ").append(srcPath).append(" was not found").toString());
                }
                String msg = new StringBuilder(56).append("Failed to rename temp file ").append(srcPath).append(" to ").append(dstPath).append(" as rename returned false").toString();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new IOException(msg);
            }
        }
    }

    @Override
    public void delete(Path path) {
        try {
            this.fs().delete(path, true);
        }
        catch (FileNotFoundException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Failed to delete ").append(path).append(" as it does not exist").toString());
        }
    }

    @Override
    public boolean isLocal() {
        FileSystem fileSystem = this.fs();
        boolean bl = fileSystem instanceof LocalFileSystem ? true : fileSystem instanceof RawLocalFileSystem;
        boolean bl2 = bl;
        return bl2;
    }

    public FileSystemBasedCheckpointFileManager(Path path, Configuration hadoopConf) {
        CheckpointFileManager.$init$(this);
        CheckpointFileManager.RenameHelperMethods.$init$(this);
        Logging.$init$((Logging)this);
        this.fs = path.getFileSystem(hadoopConf);
    }
}

