/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.sql.Date;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeTimeout$;
import org.apache.spark.sql.catalyst.plans.logical.ProcessingTimeTimeout$;
import org.apache.spark.sql.execution.streaming.GroupStateImpl$;
import org.apache.spark.sql.streaming.GroupState;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug!B\u0001\u0003\u0001\u0019q!AD$s_V\u00048\u000b^1uK&k\u0007\u000f\u001c\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u000b\u0003\u001fu\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0019q#G\u000e\u000e\u0003aQ!a\u0001\u0004\n\u0005iA\"AC$s_V\u00048\u000b^1uKB\u0011A$\b\u0007\u0001\t\u0015q\u0002A1\u0001!\u0005\u0005\u00196\u0001A\t\u0003C\u0011\u0002\"!\u0005\u0012\n\u0005\r\u0012\"a\u0002(pi\"Lgn\u001a\t\u0003#\u0015J!A\n\n\u0003\u0007\u0005s\u0017\u0010\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u00035y\u0007\u000f^5p]\u0006dg+\u00197vKB\u0019\u0011CK\u000e\n\u0005-\u0012\"AB(qi&|g\u000e\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003U\u0011\u0017\r^2i!J|7-Z:tS:<G+[7f\u001bN\u0004\"!E\u0018\n\u0005A\u0012\"\u0001\u0002'p]\u001eD\u0001B\r\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0015KZ,g\u000e\u001e+j[\u0016<\u0016\r^3s[\u0006\u00148.T:\t\u0011Q\u0002!\u0011!Q\u0001\nU\n1\u0002^5nK>,HoQ8oMB\u0011qCN\u0005\u0003oa\u0011\u0011c\u0012:pkB\u001cF/\u0019;f)&lWm\\;u\u0011!I\u0004A!b\u0001\n\u0003R\u0014a\u00035bgRKW.\u001a3PkR,\u0012a\u000f\t\u0003#qJ!!\u0010\n\u0003\u000f\t{w\u000e\\3b]\"Aq\b\u0001B\u0001B\u0003%1(\u0001\u0007iCN$\u0016.\\3e\u001fV$\b\u0005\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003<\u0003A9\u0018\r^3s[\u0006\u00148\u000e\u0015:fg\u0016tG\u000fC\u0003D\u0001\u0011%A)\u0001\u0004=S:LGO\u0010\u000b\b\u000b\u001eC\u0015JS&M!\r1\u0005aG\u0007\u0002\u0005!)\u0001F\u0011a\u0001S!)QF\u0011a\u0001]!)!G\u0011a\u0001]!)AG\u0011a\u0001k!)\u0011H\u0011a\u0001w!)\u0011I\u0011a\u0001w!9a\n\u0001a\u0001\n\u0013y\u0015!\u0002<bYV,W#A\u000e\t\u000fE\u0003\u0001\u0019!C\u0005%\u0006Ia/\u00197vK~#S-\u001d\u000b\u0003'Z\u0003\"!\u0005+\n\u0005U\u0013\"\u0001B+oSRDqa\u0016)\u0002\u0002\u0003\u00071$A\u0002yIEBa!\u0017\u0001!B\u0013Y\u0012A\u0002<bYV,\u0007\u0005C\u0004\\\u0001\u0001\u0007I\u0011\u0002\u001e\u0002\u000f\u0011,g-\u001b8fI\"9Q\f\u0001a\u0001\n\u0013q\u0016a\u00033fM&tW\rZ0%KF$\"aU0\t\u000f]c\u0016\u0011!a\u0001w!1\u0011\r\u0001Q!\nm\n\u0001\u0002Z3gS:,G\r\t\u0005\bG\u0002\u0001\r\u0011\"\u0003;\u0003\u001d)\b\u000fZ1uK\u0012Dq!\u001a\u0001A\u0002\u0013%a-A\u0006va\u0012\fG/\u001a3`I\u0015\fHCA*h\u0011\u001d9F-!AA\u0002mBa!\u001b\u0001!B\u0013Y\u0014\u0001C;qI\u0006$X\r\u001a\u0011\t\u000f-\u0004\u0001\u0019!C\u0005u\u00059!/Z7pm\u0016$\u0007bB7\u0001\u0001\u0004%IA\\\u0001\fe\u0016lwN^3e?\u0012*\u0017\u000f\u0006\u0002T_\"9q\u000b\\A\u0001\u0002\u0004Y\u0004BB9\u0001A\u0003&1(\u0001\u0005sK6|g/\u001a3!\u0011\u001d\u0019\b\u00011A\u0005\nQ\f\u0001\u0003^5nK>,H\u000fV5nKN$\u0018-\u001c9\u0016\u00039BqA\u001e\u0001A\u0002\u0013%q/\u0001\u000buS6,w.\u001e;US6,7\u000f^1na~#S-\u001d\u000b\u0003'bDqaV;\u0002\u0002\u0003\u0007a\u0006\u0003\u0004{\u0001\u0001\u0006KAL\u0001\u0012i&lWm\\;u)&lWm\u001d;b[B\u0004\u0003\"\u0002?\u0001\t\u0003R\u0014AB3ySN$8\u000fC\u0003\u007f\u0001\u0011\u0005s*A\u0002hKRDq!!\u0001\u0001\t\u0003\n\u0019!A\u0005hKR|\u0005\u000f^5p]V\t\u0011\u0006C\u0004\u0002\b\u0001!\t%!\u0003\u0002\rU\u0004H-\u0019;f)\r\u0019\u00161\u0002\u0005\b\u0003\u001b\t)\u00011\u0001\u001c\u0003!qWm\u001e,bYV,\u0007bBA\t\u0001\u0011\u0005\u00131C\u0001\u0007e\u0016lwN^3\u0015\u0003MCq!a\u0006\u0001\t\u0003\nI\"\u0001\ntKR$\u0016.\\3pkR$UO]1uS>tGcA*\u0002\u001c!9\u0011QDA\u000b\u0001\u0004q\u0013A\u00033ve\u0006$\u0018n\u001c8Ng\"9\u0011q\u0003\u0001\u0005B\u0005\u0005BcA*\u0002$!A\u0011QEA\u0010\u0001\u0004\t9#\u0001\u0005ekJ\fG/[8o!\u0011\tI#a\u000e\u000f\t\u0005-\u00121\u0007\t\u0004\u0003[\u0011RBAA\u0018\u0015\r\t\tdH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U\"#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\tYD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003k\u0011\u0002bBA \u0001\u0011\u0005\u0013\u0011I\u0001\u0014g\u0016$H+[7f_V$H+[7fgR\fW\u000e\u001d\u000b\u0004'\u0006\r\u0003bBA#\u0003{\u0001\rAL\u0001\fi&lWm\u001d;b[Bl5\u000fC\u0004\u0002@\u0001!\t%!\u0013\u0015\u000bM\u000bY%!\u0014\t\u000f\u0005\u0015\u0013q\ta\u0001]!A\u0011qJA$\u0001\u0004\t9#\u0001\nbI\u0012LG/[8oC2$UO]1uS>t\u0007bBA \u0001\u0011\u0005\u00131\u000b\u000b\u0004'\u0006U\u0003\u0002CA,\u0003#\u0002\r!!\u0017\u0002\u0013QLW.Z:uC6\u0004\b\u0003BA.\u0003Gj!!!\u0018\u000b\u0007\u001d\tyF\u0003\u0002\u0002b\u0005!!.\u0019<b\u0013\u0011\t)'!\u0018\u0003\t\u0011\u000bG/\u001a\u0005\b\u0003\u007f\u0001A\u0011IA5)\u0015\u0019\u00161NA7\u0011!\t9&a\u001aA\u0002\u0005e\u0003\u0002CA(\u0003O\u0002\r!a\n\t\u000f\u0005E\u0004\u0001\"\u0011\u0002t\u0005)r-\u001a;DkJ\u0014XM\u001c;XCR,'/\\1sW6\u001bH#\u0001\u0018\t\u000f\u0005]\u0004\u0001\"\u0011\u0002t\u0005Qr-\u001a;DkJ\u0014XM\u001c;Qe>\u001cWm]:j]\u001e$\u0016.\\3Ng\"9\u00111\u0010\u0001\u0005B\u0005u\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0002BBAA\u0001\u0011\u0005!(\u0001\u0006iCN\u0014V-\\8wK\u0012Da!!\"\u0001\t\u0003Q\u0014A\u00035bgV\u0003H-\u0019;fI\"1\u0011\u0011\u0012\u0001\u0005\u0002Q\f1cZ3u)&lWm\\;u)&lWm\u001d;b[BDq!!$\u0001\t\u0013\ty)A\u0007qCJ\u001cX\rR;sCRLwN\u001c\u000b\u0004]\u0005E\u0005\u0002CA\u0013\u0003\u0017\u0003\r!a\n\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0014\u0005a2\r[3dWRKW.Z8viRKW.Z:uC6\u0004\u0018\t\u001c7po\u0016$w\u0001CAM\u0005!\u0005a!a'\u0002\u001d\u001d\u0013x.\u001e9Ti\u0006$X-S7qYB\u0019a)!(\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0004\u0002 N\u0019\u0011Q\u0014\t\t\u000f\r\u000bi\n\"\u0001\u0002$R\u0011\u00111\u0014\u0005\n\u0003O\u000biJ1A\u0005\u0002Q\fABT(`)&kUi\u0015+B\u001bBC\u0001\"a+\u0002\u001e\u0002\u0006IAL\u0001\u000e\u001d>{F+S'F'R\u000bU\n\u0015\u0011\t\u0011\u0005=\u0016Q\u0014C\u0001\u0003c\u000b!c\u0019:fCR,gi\u001c:TiJ,\u0017-\\5oOV!\u00111WA])9\t),a/\u0002@\u0006\u0005\u00171YAc\u0003\u000f\u0004BA\u0012\u0001\u00028B\u0019A$!/\u0005\ry\tiK1\u0001!\u0011\u001dA\u0013Q\u0016a\u0001\u0003{\u0003B!\u0005\u0016\u00028\"1Q&!,A\u00029BaAMAW\u0001\u0004q\u0003B\u0002\u001b\u0002.\u0002\u0007Q\u0007\u0003\u0004:\u0003[\u0003\ra\u000f\u0005\u0007\u0003\u00065\u0006\u0019A\u001e\t\u0011\u0005-\u0017Q\u0014C\u0001\u0003\u001b\fab\u0019:fCR,gi\u001c:CCR\u001c\u0007\u000e\u0006\u0004\u0002P\u0006E\u00171\u001b\t\u0004\r\u0002!\u0003B\u0002\u001b\u0002J\u0002\u0007Q\u0007\u0003\u0004B\u0003\u0013\u0004\ra\u000f")
public class GroupStateImpl<S>
implements GroupState<S> {
    private final long batchProcessingTimeMs;
    private final long eventTimeWatermarkMs;
    private final GroupStateTimeout timeoutConf;
    private final boolean hasTimedOut;
    private final boolean watermarkPresent;
    private S value;
    private boolean defined;
    private boolean updated;
    private boolean removed;
    private long timeoutTimestamp;

    public static GroupStateImpl<Object> createForBatch(GroupStateTimeout groupStateTimeout, boolean bl) {
        return GroupStateImpl$.MODULE$.createForBatch(groupStateTimeout, bl);
    }

    public static <S> GroupStateImpl<S> createForStreaming(Option<S> option, long l, long l2, GroupStateTimeout groupStateTimeout, boolean bl, boolean bl2) {
        return GroupStateImpl$.MODULE$.createForStreaming(option, l, l2, groupStateTimeout, bl, bl2);
    }

    public static long NO_TIMESTAMP() {
        return GroupStateImpl$.MODULE$.NO_TIMESTAMP();
    }

    @Override
    public boolean hasTimedOut() {
        return this.hasTimedOut;
    }

    private S value() {
        return this.value;
    }

    private void value_$eq(S x$1) {
        this.value = x$1;
    }

    private boolean defined() {
        return this.defined;
    }

    private void defined_$eq(boolean x$1) {
        this.defined = x$1;
    }

    private boolean updated() {
        return this.updated;
    }

    private void updated_$eq(boolean x$1) {
        this.updated = x$1;
    }

    private boolean removed() {
        return this.removed;
    }

    private void removed_$eq(boolean x$1) {
        this.removed = x$1;
    }

    private long timeoutTimestamp() {
        return this.timeoutTimestamp;
    }

    private void timeoutTimestamp_$eq(long x$1) {
        this.timeoutTimestamp = x$1;
    }

    @Override
    public boolean exists() {
        return this.defined();
    }

    @Override
    public S get() {
        if (!this.defined()) {
            throw new NoSuchElementException("State is either not defined or has already been removed");
        }
        return this.value();
    }

    @Override
    public Option<S> getOption() {
        return this.defined() ? new Some(this.value()) : None$.MODULE$;
    }

    @Override
    public void update(S newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("'null' is not a valid state value");
        }
        this.value_$eq(newValue);
        this.defined_$eq(true);
        this.updated_$eq(true);
        this.removed_$eq(false);
    }

    @Override
    public void remove() {
        this.defined_$eq(false);
        this.updated_$eq(false);
        this.removed_$eq(true);
    }

    @Override
    public void setTimeoutDuration(long durationMs) {
        GroupStateTimeout groupStateTimeout = this.timeoutConf;
        ProcessingTimeTimeout$ processingTimeTimeout$ = ProcessingTimeTimeout$.MODULE$;
        if (groupStateTimeout == null ? processingTimeTimeout$ != null : !groupStateTimeout.equals(processingTimeTimeout$)) {
            throw new UnsupportedOperationException("Cannot set timeout duration without enabling processing time timeout in [map|flatMap]GroupsWithState");
        }
        if (durationMs <= 0L) {
            throw new IllegalArgumentException("Timeout duration must be positive");
        }
        this.timeoutTimestamp_$eq(durationMs + this.batchProcessingTimeMs);
    }

    @Override
    public void setTimeoutDuration(String duration) {
        this.setTimeoutDuration(this.parseDuration(duration));
    }

    @Override
    public void setTimeoutTimestamp(long timestampMs) {
        this.checkTimeoutTimestampAllowed();
        if (timestampMs <= 0L) {
            throw new IllegalArgumentException("Timeout timestamp must be positive");
        }
        if (this.eventTimeWatermarkMs != GroupStateImpl$.MODULE$.NO_TIMESTAMP() && timestampMs < this.eventTimeWatermarkMs) {
            throw new IllegalArgumentException(new StringBuilder(48).append("Timeout timestamp (").append(timestampMs).append(") cannot be earlier than the ").append(new StringBuilder(20).append("current watermark (").append(this.eventTimeWatermarkMs).append(")").toString()).toString());
        }
        this.timeoutTimestamp_$eq(timestampMs);
    }

    @Override
    public void setTimeoutTimestamp(long timestampMs, String additionalDuration) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(this.parseDuration(additionalDuration) + timestampMs);
    }

    @Override
    public void setTimeoutTimestamp(Date timestamp) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(timestamp.getTime());
    }

    @Override
    public void setTimeoutTimestamp(Date timestamp, String additionalDuration) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(timestamp.getTime() + this.parseDuration(additionalDuration));
    }

    @Override
    public long getCurrentWatermarkMs() {
        if (!this.watermarkPresent) {
            throw new UnsupportedOperationException("Cannot get event time watermark timestamp without setting watermark before [map|flatMap]GroupsWithState");
        }
        return this.eventTimeWatermarkMs;
    }

    @Override
    public long getCurrentProcessingTimeMs() {
        return this.batchProcessingTimeMs;
    }

    public String toString() {
        return new StringBuilder(12).append("GroupState(").append(this.getOption().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<undefined>")).append(")").toString();
    }

    public boolean hasRemoved() {
        return this.removed();
    }

    public boolean hasUpdated() {
        return this.updated();
    }

    public long getTimeoutTimestamp() {
        return this.timeoutTimestamp();
    }

    private long parseDuration(String duration) {
        if (StringUtils.isBlank((CharSequence)duration)) {
            throw new IllegalArgumentException("Provided duration is null or blank.");
        }
        String intervalString = duration.startsWith("interval") ? duration : new StringBuilder(9).append("interval ").append(duration).toString();
        CalendarInterval cal = CalendarInterval.fromString((String)intervalString);
        if (cal == null) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Provided duration (").append(duration).append(") is not valid.").toString());
        }
        if (cal.milliseconds() < 0L || cal.months < 0) {
            throw new IllegalArgumentException(new StringBuilder(36).append("Provided duration (").append(duration).append(") is not positive").toString());
        }
        long millisPerMonth = 2678400000L;
        return cal.milliseconds() + (long)cal.months * millisPerMonth;
    }

    private void checkTimeoutTimestampAllowed() {
        GroupStateTimeout groupStateTimeout = this.timeoutConf;
        EventTimeTimeout$ eventTimeTimeout$ = EventTimeTimeout$.MODULE$;
        if (groupStateTimeout == null ? eventTimeTimeout$ != null : !groupStateTimeout.equals(eventTimeTimeout$)) {
            throw new UnsupportedOperationException("Cannot set timeout timestamp without enabling event time timeout in [map|flatMapGroupsWithState");
        }
    }

    public GroupStateImpl(Option<S> optionalValue, long batchProcessingTimeMs, long eventTimeWatermarkMs, GroupStateTimeout timeoutConf, boolean hasTimedOut, boolean watermarkPresent) {
        this.batchProcessingTimeMs = batchProcessingTimeMs;
        this.eventTimeWatermarkMs = eventTimeWatermarkMs;
        this.timeoutConf = timeoutConf;
        this.hasTimedOut = hasTimedOut;
        this.watermarkPresent = watermarkPresent;
        this.value = optionalValue.getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        this.defined = optionalValue.isDefined();
        this.updated = false;
        this.removed = false;
        this.timeoutTimestamp = GroupStateImpl$.MODULE$.NO_TIMESTAMP();
    }
}

