/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.SinkFileStatus;
import org.apache.spark.sql.execution.streaming.SinkFileStatus$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001=\u0011!$T1oS\u001a,7\u000f\u001e$jY\u0016\u001cu.\\7jiB\u0013x\u000e^8d_2T!a\u0001\u0003\u0002\u0013M$(/Z1nS:<'BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!aq\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\tIwN\u0003\u0002\u0016\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0018%\t\u0011b)\u001b7f\u0007>lW.\u001b;Qe>$xnY8m!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u00051\u0019VM]5bY&T\u0018M\u00197f!\ty\u0002%D\u0001\u0015\u0013\t\tCCA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\nQA[8c\u0013\u0012\u0004\"!\n\u0017\u000f\u0005\u0019R\u0003CA\u0014\u001b\u001b\u0005A#BA\u0015\u000f\u0003\u0019a$o\\8u}%\u00111FG\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,5!A\u0001\u0007\u0001B\u0001B\u0003%A%\u0001\u0003qCRD\u0007\"\u0002\u001a\u0001\t\u0003\u0019\u0014A\u0002\u001fj]&$h\bF\u00025m]\u0002\"!\u000e\u0001\u000e\u0003\tAQaI\u0019A\u0002\u0011BQ\u0001M\u0019A\u0002\u0011B\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001e\u0002\u0015\u0005$G-\u001a3GS2,7/F\u0001<!\ra\u0014\tJ\u0007\u0002{)\u0011ahP\u0001\b[V$\u0018M\u00197f\u0015\t\u0001%$\u0001\u0006d_2dWm\u0019;j_:L!AQ\u001f\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\n\t\u0002\u0001\r\u00111A\u0005\n\u0015\u000ba\"\u00193eK\u00124\u0015\u000e\\3t?\u0012*\u0017\u000f\u0006\u0002G\u0013B\u0011\u0011dR\u0005\u0003\u0011j\u0011A!\u00168ji\"9!jQA\u0001\u0002\u0004Y\u0014a\u0001=%c!IA\n\u0001a\u0001\u0002\u0003\u0006KaO\u0001\fC\u0012$W\r\u001a$jY\u0016\u001c\b\u0005\u000b\u0002L\u001dB\u0011\u0011dT\u0005\u0003!j\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0013I\u0003\u0001\u0019!a\u0001\n\u0013\u0019\u0016a\u00024jY\u0016dunZ\u000b\u0002)B\u0011Q'V\u0005\u0003-\n\u0011\u0011CR5mKN#(/Z1n'&t7\u000eT8h\u0011%A\u0006\u00011AA\u0002\u0013%\u0011,A\u0006gS2,Gj\\4`I\u0015\fHC\u0001$[\u0011\u001dQu+!AA\u0002QC\u0011\u0002\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002+\u0002\u0011\u0019LG.\u001a'pO\u0002B#a\u0017(\t\u0013}\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0017a\u00022bi\u000eD\u0017\nZ\u000b\u0002CB\u0011\u0011DY\u0005\u0003Gj\u0011A\u0001T8oO\"IQ\r\u0001a\u0001\u0002\u0004%IAZ\u0001\fE\u0006$8\r[%e?\u0012*\u0017\u000f\u0006\u0002GO\"9!\nZA\u0001\u0002\u0004\t\u0007\"C5\u0001\u0001\u0004\u0005\t\u0015)\u0003b\u0003!\u0011\u0017\r^2i\u0013\u0012\u0004\u0003\"B6\u0001\t\u0003a\u0017\u0001F:fiV\u0004X*\u00198jM\u0016\u001cHo\u00149uS>t7\u000fF\u0002G[:DQA\u00156A\u0002QCQa\u00186A\u0002\u0005DQ\u0001\u001d\u0001\u0005BE\f\u0001b]3ukBTuN\u0019\u000b\u0003\rJDQa]8A\u0002Q\f!B[8c\u0007>tG/\u001a=u!\t)(0D\u0001w\u0015\t9\b0A\u0005nCB\u0014X\rZ;dK*\u0011\u0011PC\u0001\u0007Q\u0006$wn\u001c9\n\u0005m4(A\u0003&pE\u000e{g\u000e^3yi\")Q\u0010\u0001C!}\u0006I1m\\7nSRTuN\u0019\u000b\u0005\r~\f\t\u0001C\u0003ty\u0002\u0007A\u000fC\u0004\u0002\u0004q\u0004\r!!\u0002\u0002\u0017Q\f7o[\"p[6LGo\u001d\t\u0007\u0003\u000f\t\t\"a\u0006\u000f\t\u0005%\u0011Q\u0002\b\u0004O\u0005-\u0011\"A\u000e\n\u0007\u0005=!$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0011Q\u0003\u0002\u0004'\u0016\f(bAA\b5A!\u0011\u0011DA\u001a\u001d\u0011\tY\"a\f\u000f\t\u0005u\u0011Q\u0006\b\u0005\u0003?\tYC\u0004\u0003\u0002\"\u0005%b\u0002BA\u0012\u0003Oq1aJA\u0013\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\u0016\u0011%\u00111\u0003F\u0005\u0004\u0003c\u0011\u0012A\u0005$jY\u0016\u001cu.\\7jiB\u0013x\u000e^8d_2LA!!\u000e\u00028\t\tB+Y:l\u0007>lW.\u001b;NKN\u001c\u0018mZ3\u000b\u0007\u0005E\"\u0003C\u0004\u0002<\u0001!\t%!\u0010\u0002\u0011\u0005\u0014wN\u001d;K_\n$2ARA \u0011\u0019\u0019\u0018\u0011\ba\u0001i\"9\u00111\t\u0001\u0005B\u0005\u0015\u0013!C:fiV\u0004H+Y:l)\r1\u0015q\t\u0005\t\u0003\u0013\n\t\u00051\u0001\u0002L\u0005YA/Y:l\u0007>tG/\u001a=u!\r)\u0018QJ\u0005\u0004\u0003\u001f2(A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqRDq!a\u0015\u0001\t\u0003\n)&A\boK^$\u0016m]6UK6\u0004h)\u001b7f)\u001d!\u0013qKA-\u0003GB\u0001\"!\u0013\u0002R\u0001\u0007\u00111\n\u0005\t\u00037\n\t\u00061\u0001\u0002^\u0005\u0019A-\u001b:\u0011\te\ty\u0006J\u0005\u0004\u0003CR\"AB(qi&|g\u000eC\u0004\u0002f\u0005E\u0003\u0019\u0001\u0013\u0002\u0007\u0015DH\u000fC\u0004\u0002j\u0001!\t%a\u001b\u0002-9,w\u000fV1tWR+W\u000e\u001d$jY\u0016\f%m\u001d)bi\"$r\u0001JA7\u0003_\n\u0019\b\u0003\u0005\u0002J\u0005\u001d\u0004\u0019AA&\u0011\u001d\t\t(a\u001aA\u0002\u0011\n1\"\u00192t_2,H/\u001a#je\"9\u0011QMA4\u0001\u0004!\u0003bBA<\u0001\u0011\u0005\u0013\u0011P\u0001\u000bG>lW.\u001b;UCN\\G\u0003BA\f\u0003wB\u0001\"!\u0013\u0002v\u0001\u0007\u00111\n\u0005\b\u0003\u007f\u0002A\u0011IAA\u0003%\t'm\u001c:u)\u0006\u001c8\u000eF\u0002G\u0003\u0007C\u0001\"!\u0013\u0002~\u0001\u0007\u00111\n")
public class ManifestFileCommitProtocol
extends FileCommitProtocol
implements scala.Serializable,
Logging {
    private final String path;
    private transient ArrayBuffer<String> addedFiles;
    private transient FileStreamSinkLog fileLog;
    private long batchId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ArrayBuffer<String> addedFiles() {
        return this.addedFiles;
    }

    private void addedFiles_$eq(ArrayBuffer<String> x$1) {
        this.addedFiles = x$1;
    }

    private FileStreamSinkLog fileLog() {
        return this.fileLog;
    }

    private void fileLog_$eq(FileStreamSinkLog x$1) {
        this.fileLog = x$1;
    }

    private long batchId() {
        return this.batchId;
    }

    private void batchId_$eq(long x$1) {
        this.batchId = x$1;
    }

    public void setupManifestOptions(FileStreamSinkLog fileLog, long batchId) {
        this.fileLog_$eq(fileLog);
        this.batchId_$eq(batchId);
    }

    public void setupJob(JobContext jobContext) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable & scala.Serializable)() -> "setupManifestOptions must be called before this function");
    }

    public void commitJob(JobContext jobContext, Seq<FileCommitProtocol.TaskCommitMessage> taskCommits) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable & scala.Serializable)() -> "setupManifestOptions must be called before this function");
        SinkFileStatus[] fileStatuses = (SinkFileStatus[])((TraversableOnce)taskCommits.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)x$1.obj(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SinkFileStatus.class));
        if (!this.fileLog().add(this.batchId(), (Object[])fileStatuses)) {
            throw new IllegalStateException(new StringBuilder(25).append("Race while writing batch ").append(this.batchId()).toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Committed batch ").append(this.batchId()).toString());
    }

    public void abortJob(JobContext jobContext) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable & scala.Serializable)() -> "setupManifestOptions must be called before this function");
    }

    public void setupTask(TaskAttemptContext taskContext) {
        this.addedFiles_$eq((ArrayBuffer<String>)new ArrayBuffer());
    }

    public String newTaskTempFile(TaskAttemptContext taskContext, Option<String> dir, String ext) {
        int split = taskContext.getTaskAttemptID().getTaskID().getId();
        String uuid = UUID.randomUUID().toString();
        int arg$macro$5 = split;
        String arg$macro$6 = uuid;
        String arg$macro$7 = ext;
        String filename = new StringOps("part-%05d-%s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$5), arg$macro$6, arg$macro$7}));
        String file = (String)dir.map((Function1 & Serializable & scala.Serializable)d -> new Path(new Path($this.path, d), filename).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Path($this.path, filename).toString());
        this.addedFiles().$plus$eq((Object)file);
        return file;
    }

    public String newTaskTempFileAbsPath(TaskAttemptContext taskContext, String absoluteDir, String ext) {
        throw new UnsupportedOperationException(new StringBuilder(52).append((Object)this).append(" does not support adding files with an absolute path").toString());
    }

    public FileCommitProtocol.TaskCommitMessage commitTask(TaskAttemptContext taskContext) {
        FileCommitProtocol.TaskCommitMessage taskCommitMessage;
        if (this.addedFiles().nonEmpty()) {
            FileSystem fs = new Path((String)this.addedFiles().head()).getFileSystem(taskContext.getConfiguration());
            Seq statuses = (Seq)this.addedFiles().map((Function1 & Serializable & scala.Serializable)f -> SinkFileStatus$.MODULE$.apply(fs.getFileStatus(new Path(f))), ArrayBuffer$.MODULE$.canBuildFrom());
            taskCommitMessage = new FileCommitProtocol.TaskCommitMessage((Object)statuses);
        } else {
            taskCommitMessage = new FileCommitProtocol.TaskCommitMessage((Object)Seq$.MODULE$.empty());
        }
        return taskCommitMessage;
    }

    public void abortTask(TaskAttemptContext taskContext) {
    }

    public ManifestFileCommitProtocol(String jobId, String path) {
        this.path = path;
        Logging.$init$((Logging)this);
    }
}

