/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.UUID;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanExec;
import org.apache.spark.sql.execution.streaming.BaseStreamingSink;
import org.apache.spark.sql.execution.streaming.BaseStreamingSource;
import org.apache.spark.sql.execution.streaming.EventTimeStats;
import org.apache.spark.sql.execution.streaming.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.ProgressReporter$;
import org.apache.spark.sql.execution.streaming.ProgressReporter$ExecutionStats$;
import org.apache.spark.sql.execution.streaming.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.streaming.SinkProgress;
import org.apache.spark.sql.streaming.SourceProgress;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.util.Clock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rEeaB\u0001\u0003!\u0003\r\ta\u0004\u0002\u0011!J|wM]3tgJ+\u0007o\u001c:uKJT!a\u0001\u0003\u0002\u0013M$(/Z1nS:<'BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u001b\u001b\u0005A\"BA\r\t\u0003!Ig\u000e^3s]\u0006d\u0017BA\u000e\u0019\u0005\u001daunZ4j]\u001eDQ!\b\u0001\u0005\u0002y\ta\u0001J5oSR$C#A\u0010\u0011\u0005E\u0001\u0013BA\u0011\u0013\u0005\u0011)f.\u001b;\u0007\t\r\u0002\u0001\t\n\u0002\u000f\u000bb,7-\u001e;j_:\u001cF/\u0019;t'\u0011\u0011\u0003#\n\u0015\u0011\u0005E1\u0013BA\u0014\u0013\u0005\u001d\u0001&o\u001c3vGR\u0004\"!E\u0015\n\u0005)\u0012\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0017#\u0005+\u0007I\u0011A\u0017\u0002\u0013%t\u0007/\u001e;S_^\u001cX#\u0001\u0018\u0011\t=2\u0014(\u0010\b\u0003aQ\u0002\"!\r\n\u000e\u0003IR!a\r\b\u0002\rq\u0012xn\u001c;?\u0013\t)$#\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u00121!T1q\u0015\t)$\u0003\u0005\u0002;w5\t!!\u0003\u0002=\u0005\t\u0019\")Y:f'R\u0014X-Y7j]\u001e\u001cv.\u001e:dKB\u0011\u0011CP\u0005\u0003\u007fI\u0011A\u0001T8oO\"A\u0011I\tB\tB\u0003%a&\u0001\u0006j]B,HOU8xg\u0002B\u0001b\u0011\u0012\u0003\u0016\u0004%\t\u0001R\u0001\u000fgR\fG/Z(qKJ\fGo\u001c:t+\u0005)\u0005c\u0001$L\u001d:\u0011q)\u0013\b\u0003c!K\u0011aE\u0005\u0003\u0015J\tq\u0001]1dW\u0006<W-\u0003\u0002M\u001b\n\u00191+Z9\u000b\u0005)\u0013\u0002CA(R\u001b\u0005\u0001&BA\u0002\u0007\u0013\t\u0011\u0006KA\u000bTi\u0006$Xm\u00149fe\u0006$xN\u001d)s_\u001e\u0014Xm]:\t\u0011Q\u0013#\u0011#Q\u0001\n\u0015\u000bqb\u001d;bi\u0016|\u0005/\u001a:bi>\u00148\u000f\t\u0005\t-\n\u0012)\u001a!C\u0001/\u0006qQM^3oiRKW.Z*uCR\u001cX#\u0001-\u0011\t=2\u0014,\u0017\t\u0003_iK!a\u0017\u001d\u0003\rM#(/\u001b8h\u0011!i&E!E!\u0002\u0013A\u0016aD3wK:$H+[7f'R\fGo\u001d\u0011\t\u000b}\u0013C\u0011\u00011\u0002\rqJg.\u001b;?)\u0011\t7\rZ3\u0011\u0005\t\u0014S\"\u0001\u0001\t\u000b1r\u0006\u0019\u0001\u0018\t\u000b\rs\u0006\u0019A#\t\u000bYs\u0006\u0019\u0001-\t\u000f\u001d\u0014\u0013\u0011!C\u0001Q\u0006!1m\u001c9z)\u0011\t\u0017N[6\t\u000f12\u0007\u0013!a\u0001]!91I\u001aI\u0001\u0002\u0004)\u0005b\u0002,g!\u0003\u0005\r\u0001\u0017\u0005\b[\n\n\n\u0011\"\u0001o\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001c\u0016\u0003]A\\\u0013!\u001d\t\u0003e^l\u0011a\u001d\u0006\u0003iV\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005Y\u0014\u0012AC1o]>$\u0018\r^5p]&\u0011\u0001p\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u0002>##\u0003%\ta_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0005a(FA#q\u0011\u001dq(%%A\u0005\u0002}\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0002)\u0012\u0001\f\u001d\u0005\n\u0003\u000b\u0011\u0013\u0011!C!\u0003\u000f\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0005!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\tA\u0001\\1oO*\u0011\u00111C\u0001\u0005U\u00064\u0018-C\u0002\\\u0003\u001bA\u0011\"!\u0007#\u0003\u0003%\t!a\u0007\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0001cA\t\u0002 %\u0019\u0011\u0011\u0005\n\u0003\u0007%sG\u000fC\u0005\u0002&\t\n\t\u0011\"\u0001\u0002(\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0015\u0003_\u00012!EA\u0016\u0013\r\tiC\u0005\u0002\u0004\u0003:L\bBCA\u0019\u0003G\t\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005U\"%!A\u0005B\u0005]\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0002CBA\u001e\u0003\u0003\nI#\u0004\u0002\u0002>)\u0019\u0011q\b\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002D\u0005u\"\u0001C%uKJ\fGo\u001c:\t\u0013\u0005\u001d#%!A\u0005\u0002\u0005%\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-\u0013\u0011\u000b\t\u0004#\u00055\u0013bAA(%\t9!i\\8mK\u0006t\u0007BCA\u0019\u0003\u000b\n\t\u00111\u0001\u0002*!I\u0011Q\u000b\u0012\u0002\u0002\u0013\u0005\u0013qK\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q\u0004\u0005\n\u00037\u0012\u0013\u0011!C!\u0003;\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0013A\u0011\"!\u0019#\u0003\u0003%\t%a\u0019\u0002\r\u0015\fX/\u00197t)\u0011\tY%!\u001a\t\u0015\u0005E\u0012qLA\u0001\u0002\u0004\tIcB\u0005\u0002j\u0001\t\t\u0011#\u0001\u0002l\u0005qQ\t_3dkRLwN\\*uCR\u001c\bc\u00012\u0002n\u0019A1\u0005AA\u0001\u0012\u0003\tygE\u0003\u0002n\u0005E\u0004\u0006\u0005\u0005\u0002t\u0005ed&\u0012-b\u001b\t\t)HC\u0002\u0002xI\tqA];oi&lW-\u0003\u0003\u0002|\u0005U$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9q,!\u001c\u0005\u0002\u0005}DCAA6\u0011)\tY&!\u001c\u0002\u0002\u0013\u0015\u0013Q\f\u0005\u000b\u0003\u000b\u000bi'!A\u0005\u0002\u0006\u001d\u0015!B1qa2LHcB1\u0002\n\u0006-\u0015Q\u0012\u0005\u0007Y\u0005\r\u0005\u0019\u0001\u0018\t\r\r\u000b\u0019\t1\u0001F\u0011\u00191\u00161\u0011a\u00011\"Q\u0011\u0011SA7\u0003\u0003%\t)a%\u0002\u000fUt\u0017\r\u001d9msR!\u0011QSAQ!\u0015\t\u0012qSAN\u0013\r\tIJ\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rE\tiJL#Y\u0013\r\tyJ\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u0013\u0005\r\u0016qRA\u0001\u0002\u0004\t\u0017a\u0001=%a!9\u0011q\u0015\u0001\u0007\u0012\u0005%\u0016AA5e+\t\tY\u000b\u0005\u0003\u0002.\u0006MVBAAX\u0015\u0011\t\t,!\u0005\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003k\u000byK\u0001\u0003V+&#\u0005bBA]\u0001\u0019E\u0011\u0011V\u0001\u0006eVt\u0017\n\u001a\u0005\b\u0003{\u0003a\u0011CA`\u0003\u0011q\u0017-\\3\u0016\u0003eCq!a1\u0001\r#\t)-\u0001\u0007ue&<w-\u001a:DY>\u001c7.\u0006\u0002\u0002HB!\u0011\u0011ZAg\u001b\t\tYMC\u0002\u00022\"IA!a4\u0002L\n)1\t\\8dW\"9\u00111\u001b\u0001\u0007\u0012\u0005U\u0017a\u00037pO&\u001c\u0017\r\u001c)mC:,\"!a6\u0011\t\u0005e\u0017q]\u0007\u0003\u00037TA!!8\u0002`\u00069An\\4jG\u0006d'\u0002BAq\u0003G\fQ\u0001\u001d7b]NT1!!:\u0007\u0003!\u0019\u0017\r^1msN$\u0018\u0002BAu\u00037\u00141\u0002T8hS\u000e\fG\u000e\u00157b]\"9\u0011Q\u001e\u0001\u0007\u0012\u0005=\u0018!\u00047bgR,\u00050Z2vi&|g.\u0006\u0002\u0002rB!\u00111_A{\u001b\u0005!\u0011bAA|\t\tq\u0011+^3ss\u0016CXmY;uS>t\u0007bBA~\u0001\u0019E\u0011Q`\u0001\b]\u0016<H)\u0019;b+\t\ty\u0010E\u00030me\n9\u000eC\u0004\u0003\u0004\u00011\tB!\u0002\u0002\u000fM|WO]2fgV\u0011!q\u0001\t\u0004\r.K\u0004b\u0002B\u0006\u0001\u0019E!QB\u0001\u0005g&t7.\u0006\u0002\u0003\u0010A\u0019!H!\u0005\n\u0007\tM!AA\tCCN,7\u000b\u001e:fC6LgnZ*j].DqAa\u0006\u0001\r#\u0011I\"A\tpM\u001a\u001cX\r^*fc6+G/\u00193bi\u0006,\"Aa\u0007\u0011\u0007i\u0012i\"C\u0002\u0003 \t\u0011\u0011c\u00144gg\u0016$8+Z9NKR\fG-\u0019;b\u0011\u001d\u0011\u0019\u0003\u0001D\t\u0005K\tabY;se\u0016tGOQ1uG\"LE-F\u0001>\u0011\u001d\u0011I\u0003\u0001D\t\u0005W\tAb\u001d9be.\u001cVm]:j_:,\"A!\f\u0011\t\t=\"\u0011G\u0007\u0002\r%\u0019!1\u0007\u0004\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000f\t]\u0002A\"\u0005\u0003:\u0005I\u0001o\\:u\u000bZ,g\u000e\u001e\u000b\u0004?\tm\u0002\u0002\u0003B\u001f\u0005k\u0001\rAa\u0010\u0002\u000b\u00154XM\u001c;\u0011\t\t\u0005#q\t\b\u0004\u001f\n\r\u0013b\u0001B#!\u000612\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'/\u0003\u0003\u0003J\t-#!B#wK:$(b\u0001B#!\"I!q\n\u0001A\u0002\u0013%!QE\u0001\u001dGV\u0014(/\u001a8u)JLwmZ3s'R\f'\u000f\u001e+j[\u0016\u001cH/Y7q\u0011%\u0011\u0019\u0006\u0001a\u0001\n\u0013\u0011)&\u0001\u0011dkJ\u0014XM\u001c;Ue&<w-\u001a:Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9`I\u0015\fHcA\u0010\u0003X!I\u0011\u0011\u0007B)\u0003\u0003\u0005\r!\u0010\u0005\n\u00057\u0002\u0001\u0019!C\u0005\u0005K\t!dY;se\u0016tG\u000f\u0016:jO\u001e,'/\u00128e)&lWm\u001d;b[BD\u0011Ba\u0018\u0001\u0001\u0004%IA!\u0019\u0002=\r,(O]3oiR\u0013\u0018nZ4fe\u0016sG\rV5nKN$\u0018-\u001c9`I\u0015\fHcA\u0010\u0003d!I\u0011\u0011\u0007B/\u0003\u0003\u0005\r!\u0010\u0005\f\u0005O\u0002\u0001\u0019!a\u0001\n\u0013\u0011I'\u0001\u000edkJ\u0014XM\u001c;Ue&<w-\u001a:Ti\u0006\u0014Ho\u00144gg\u0016$8/\u0006\u0002\u0003lA!qFN\u001dZ\u0011-\u0011y\u0007\u0001a\u0001\u0002\u0004%IA!\u001d\u0002=\r,(O]3oiR\u0013\u0018nZ4feN#\u0018M\u001d;PM\u001a\u001cX\r^:`I\u0015\fHcA\u0010\u0003t!Q\u0011\u0011\u0007B7\u0003\u0003\u0005\rAa\u001b\t\u0017\t]\u0004\u00011AA\u0002\u0013%!\u0011N\u0001\u0019GV\u0014(/\u001a8u)JLwmZ3s\u000b:$wJ\u001a4tKR\u001c\bb\u0003B>\u0001\u0001\u0007\t\u0019!C\u0005\u0005{\nAdY;se\u0016tG\u000f\u0016:jO\u001e,'/\u00128e\u001f\u001a47/\u001a;t?\u0012*\u0017\u000fF\u0002 \u0005\u007fB!\"!\r\u0003z\u0005\u0005\t\u0019\u0001B6\u0011%\u0011\u0019\t\u0001a\u0001\n\u0013\u0011)#A\rmCN$HK]5hO\u0016\u00148\u000b^1siRKW.Z:uC6\u0004\b\"\u0003BD\u0001\u0001\u0007I\u0011\u0002BE\u0003ua\u0017m\u001d;Ue&<w-\u001a:Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9`I\u0015\fHcA\u0010\u0003\f\"I\u0011\u0011\u0007BC\u0003\u0003\u0005\r!\u0010\u0005\n\u0005\u001f\u0003!\u0019!C\u0005\u0005#\u000b!cY;se\u0016tG\u000fR;sCRLwN\\:NgV\u0011!1\u0013\t\u0007\u0005+\u0013Y*W\u001f\u000e\u0005\t]%\u0002\u0002BM\u0003{\tq!\\;uC\ndW-\u0003\u0003\u0003\u001e\n]%a\u0002%bg\"l\u0015\r\u001d\u0005\n\u0005C\u0003\u0001\u0019!C\u0005\u0005G\u000b1#\\3ue&\u001cw+\u0019:oS:<Gj\\4hK\u0012,\"!a\u0013\t\u0013\t\u001d\u0006\u00011A\u0005\n\t%\u0016aF7fiJL7mV1s]&tw\rT8hO\u0016$w\fJ3r)\ry\"1\u0016\u0005\u000b\u0003c\u0011)+!AA\u0002\u0005-\u0003\"\u0003BX\u0001\t\u0007I\u0011\u0002BY\u00039\u0001(o\\4sKN\u001c()\u001e4gKJ,\"Aa-\u0011\r\tU%Q\u0017B]\u0013\u0011\u00119La&\u0003\u000bE+X-^3\u0011\u0007=\u0013Y,C\u0002\u0003>B\u0013ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010\u0015:pOJ,7o\u001d\u0005\n\u0005\u0003\u0004!\u0019!C\u0005\u0005K\t1D\\8ECR\f\u0007K]8he\u0016\u001c8/\u0012<f]RLe\u000e^3sm\u0006d\u0007\"\u0003Bc\u0001\u0001\u0007I\u0011\u0002B\u0013\u0003ma\u0017m\u001d;O_\u0012\u000bG/\u0019)s_\u001e\u0014Xm]:Fm\u0016tG\u000fV5nK\"I!\u0011\u001a\u0001A\u0002\u0013%!1Z\u0001 Y\u0006\u001cHOT8ECR\f\u0007K]8he\u0016\u001c8/\u0012<f]R$\u0016.\\3`I\u0015\fHcA\u0010\u0003N\"I\u0011\u0011\u0007Bd\u0003\u0003\u0005\r!\u0010\u0005\n\u0005#\u0004!\u0019!C\u0005\u0005'\fq\u0002^5nKN$\u0018-\u001c9G_Jl\u0017\r^\u000b\u0003\u0005+\u0004BAa6\u0003^6\u0011!\u0011\u001c\u0006\u0005\u00057\f\t\"\u0001\u0003uKb$\u0018\u0002\u0002Bp\u00053\u0014\u0001cU5na2,G)\u0019;f\r>\u0014X.\u0019;\t\u0013\t\r\b\u00011A\u0005\u0012\t\u0015\u0018!D2veJ,g\u000e^*uCR,8/\u0006\u0002\u0003hB\u0019qJ!;\n\u0007\t-\bK\u0001\u000bTiJ,\u0017-\\5oOF+XM]=Ti\u0006$Xo\u001d\u0015\u0005\u0005C\u0014y\u000fE\u0002\u0012\u0005cL1Aa=\u0013\u0005!1x\u000e\\1uS2,\u0007\"\u0003B|\u0001\u0001\u0007I\u0011\u0003B}\u0003E\u0019WO\u001d:f]R\u001cF/\u0019;vg~#S-\u001d\u000b\u0004?\tm\bBCA\u0019\u0005k\f\t\u00111\u0001\u0003h\"9!q \u0001\u0005\u0002\t\u0015\u0018AB:uCR,8\u000fC\u0004\u0004\u0004\u0001!\ta!\u0002\u0002\u001dI,7-\u001a8u!J|wM]3tgV\u00111q\u0001\t\u0006#\r%!\u0011X\u0005\u0004\u0007\u0017\u0011\"!B!se\u0006L\bbBB\b\u0001\u0011\u00051\u0011C\u0001\rY\u0006\u001cH\u000f\u0015:pOJ,7o]\u000b\u0003\u0005sCaa!\u0006\u0001\t#q\u0012\u0001D:uCJ$HK]5hO\u0016\u0014\bbBB\r\u0001\u0011E11D\u0001\u0015e\u0016\u001cwN\u001d3Ue&<w-\u001a:PM\u001a\u001cX\r^:\u0015\u000b}\u0019iba\n\t\u0011\r}1q\u0003a\u0001\u0007C\tAA\u001a:p[B\u0019!ha\t\n\u0007\r\u0015\"A\u0001\bTiJ,\u0017-\u001c)s_\u001e\u0014Xm]:\t\u0011\r%2q\u0003a\u0001\u0007C\t!\u0001^8\t\u000f\r5\u0002\u0001\"\u0003\u00040\u0005qQ\u000f\u001d3bi\u0016\u0004&o\\4sKN\u001cHcA\u0010\u00042!A11GB\u0016\u0001\u0004\u0011I,A\u0006oK^\u0004&o\\4sKN\u001c\bbBB\u001c\u0001\u0011E1\u0011H\u0001\u000eM&t\u0017n\u001d5Ue&<w-\u001a:\u0015\u0007}\u0019Y\u0004\u0003\u0005\u0004>\rU\u0002\u0019AA&\u0003)A\u0017m\u001d(fo\u0012\u000bG/\u0019\u0005\b\u0007\u0003\u0002A\u0011BB\"\u0003m)\u0007\u0010\u001e:bGR\u001cF/\u0019;f\u001fB,'/\u0019;pe6+GO]5dgR\u0019Qi!\u0012\t\u0011\ru2q\ba\u0001\u0003\u0017Bqa!\u0013\u0001\t\u0013\u0019Y%A\u000bfqR\u0014\u0018m\u0019;Fq\u0016\u001cW\u000f^5p]N#\u0018\r^:\u0015\u0007\u0005\u001ci\u0005\u0003\u0005\u0004>\r\u001d\u0003\u0019AA&\u0011\u001d\u0019\t\u0006\u0001C\u0005\u0007'\n1$\u001a=ue\u0006\u001cGoU8ve\u000e,Gk\u001c(v[&s\u0007/\u001e;S_^\u001cH#\u0001\u0018\t\u000f\r]\u0003\u0001\"\u0005\u0004Z\u0005y!/\u001a9peR$\u0016.\\3UC.,g.\u0006\u0003\u0004\\\r\rD\u0003BB/\u0007s\"Baa\u0018\u0004pA!1\u0011MB2\u0019\u0001!\u0001b!\u001a\u0004V\t\u00071q\r\u0002\u0002)F!1\u0011NA\u0015!\r\t21N\u0005\u0004\u0007[\u0012\"a\u0002(pi\"Lgn\u001a\u0005\n\u0007c\u001a)\u0006\"a\u0001\u0007g\nAAY8esB)\u0011c!\u001e\u0004`%\u00191q\u000f\n\u0003\u0011q\u0012\u0017P\\1nKzBqaa\u001f\u0004V\u0001\u0007\u0011,\u0001\tue&<w-\u001a:EKR\f\u0017\u000e\\&fs\"91q\u0010\u0001\u0005\n\r\u0005\u0015a\u00044pe6\fG\u000fV5nKN$\u0018-\u001c9\u0015\u0007e\u001b\u0019\tC\u0004\u0004\u0006\u000eu\u0004\u0019A\u001f\u0002\r5LG\u000e\\5t\u0011\u001d\u0019I\t\u0001C\t\u0007\u0017\u000b1#\u001e9eCR,7\u000b^1ukNlUm]:bO\u0016$2aHBG\u0011\u001d\u0019yia\"A\u0002e\u000bq!\\3tg\u0006<W\r")
public interface ProgressReporter
extends Logging {
    public ProgressReporter$ExecutionStats$ ExecutionStats();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq(scala.collection.mutable.HashMap<String, Object> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq(Queue<StreamingQueryProgress> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq(long var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(SimpleDateFormat var1);

    public UUID id();

    public UUID runId();

    public String name();

    public Clock triggerClock();

    public LogicalPlan logicalPlan();

    public QueryExecution lastExecution();

    public scala.collection.immutable.Map<BaseStreamingSource, LogicalPlan> newData();

    public Seq<BaseStreamingSource> sources();

    public BaseStreamingSink sink();

    public OffsetSeqMetadata offsetSeqMetadata();

    public long currentBatchId();

    public SparkSession sparkSession();

    public void postEvent(StreamingQueryListener.Event var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(long var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(long var1);

    public scala.collection.immutable.Map<BaseStreamingSource, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(scala.collection.immutable.Map<BaseStreamingSource, String> var1);

    public scala.collection.immutable.Map<BaseStreamingSource, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(scala.collection.immutable.Map<BaseStreamingSource, String> var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(long var1);

    public scala.collection.mutable.HashMap<String, Object> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs();

    public boolean org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(boolean var1);

    public Queue<StreamingQueryProgress> org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(long var1);

    public SimpleDateFormat org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat();

    public StreamingQueryStatus currentStatus();

    public void currentStatus_$eq(StreamingQueryStatus var1);

    public static /* synthetic */ StreamingQueryStatus status$(ProgressReporter $this) {
        return $this.status();
    }

    default public StreamingQueryStatus status() {
        return this.currentStatus();
    }

    public static /* synthetic */ StreamingQueryProgress[] recentProgress$(ProgressReporter $this) {
        return $this.recentProgress();
    }

    default public StreamingQueryProgress[] recentProgress() {
        StreamingQueryProgress[] streamingQueryProgressArray;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgressArray = (StreamingQueryProgress[])this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
        }
        return streamingQueryProgressArray;
    }

    public static /* synthetic */ StreamingQueryProgress lastProgress$(ProgressReporter $this) {
        return $this.lastProgress();
    }

    default public StreamingQueryProgress lastProgress() {
        StreamingQueryProgress streamingQueryProgress;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgress = (StreamingQueryProgress)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().lastOption().orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQueryProgress;
    }

    public static /* synthetic */ void startTrigger$(ProgressReporter $this) {
        $this.startTrigger();
    }

    default public void startTrigger() {
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> "Starting Trigger Calculation");
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp());
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(this.triggerClock().getTimeMillis());
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$9 = true;
        String x$10 = qual$1.copy$default$1();
        boolean x$11 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$10, x$11, x$9));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().clear();
    }

    public static /* synthetic */ void recordTriggerOffsets$(ProgressReporter $this, StreamProgress from, StreamProgress to) {
        $this.recordTriggerOffsets(from, to);
    }

    default public void recordTriggerOffsets(StreamProgress from, StreamProgress to) {
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(from.mapValues((Function1 & Serializable & scala.Serializable)x$1 -> x$1.json()));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(to.mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.json()));
    }

    private void updateProgress(StreamingQueryProgress newProgress) {
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().$plus$eq((Object)newProgress);
            while (this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().length() >= this.sparkSession().sqlContext().conf().streamingProgressRetention()) {
                this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().dequeue();
            }
        }
        this.postEvent(new StreamingQueryListener.QueryProgressEvent(newProgress));
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Streaming query made progress: ").append(newProgress).toString());
    }

    public static /* synthetic */ void finishTrigger$(ProgressReporter $this, boolean hasNewData) {
        $this.finishTrigger(hasNewData);
    }

    default public void finishTrigger(boolean hasNewData) {
        Predef$.MODULE$.assert(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets() != null && this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets() != null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(this.triggerClock().getTimeMillis());
        ExecutionStats executionStats = this.extractExecutionStats(hasNewData);
        double processingTimeSec = (double)(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp()) / (double)1000;
        double inputTimeSec = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp() >= 0L ? (double)(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp()) / (double)1000 : Double.NaN;
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Execution stats: ").append(executionStats).toString());
        Seq sourceProgress = (Seq)((TraversableLike)this.sources().distinct()).map((Function1 & Serializable & scala.Serializable)source -> {
            long numRecords = BoxesRunTime.unboxToLong((Object)executionStats.inputRows().getOrElse(source, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return new SourceProgress(source.toString(), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets().get(source).orNull(Predef$.MODULE$.$conforms()), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets().get(source).orNull(Predef$.MODULE$.$conforms()), numRecords, (double)numRecords / inputTimeSec, (double)numRecords / processingTimeSec);
        }, Seq$.MODULE$.canBuildFrom());
        SinkProgress sinkProgress = new SinkProgress(this.sink().toString());
        StreamingQueryProgress newProgress = new StreamingQueryProgress(this.id(), this.runId(), this.name(), this.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp()), this.currentBatchId(), new HashMap<String, Long>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().toMap(Predef$.MODULE$.$conforms()).mapValues((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)x)))).asJava()), new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(executionStats.eventTimeStats()).asJava()), (StateOperatorProgress[])executionStats.stateOperators().toArray(ClassTag$.MODULE$.apply(StateOperatorProgress.class)), (SourceProgress[])sourceProgress.toArray(ClassTag$.MODULE$.apply(SourceProgress.class)), sinkProgress);
        if (hasNewData) {
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(Long.MIN_VALUE);
            this.updateProgress(newProgress);
        } else {
            long now = this.triggerClock().getTimeMillis();
            if (now - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval() >= this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime()) {
                this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(now);
                this.updateProgress(newProgress);
            }
        }
        StreamingQueryStatus qual$2 = this.currentStatus();
        boolean x$12 = false;
        String x$13 = qual$2.copy$default$1();
        boolean x$14 = qual$2.copy$default$2();
        this.currentStatus_$eq(qual$2.copy(x$13, x$14, x$12));
    }

    private Seq<StateOperatorProgress> extractStateOperatorMetrics(boolean hasNewData) {
        if (this.lastExecution() == null) {
            return Nil$.MODULE$;
        }
        return this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null, hasNewData){
            public static final long serialVersionUID = 0L;
            private final boolean hasNewData$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StateStoreWriter) {
                    StateOperatorProgress progress = ((StateStoreWriter)((Object)A1)).getProgress();
                    object = this.hasNewData$1 ? progress : progress.copy(0L);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof StateStoreWriter;
                return bl;
            }
            {
                this.hasNewData$1 = hasNewData$1;
            }
        });
    }

    private ExecutionStats extractExecutionStats(boolean hasNewData) {
        boolean hasEventTime = this.logicalPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                EventTimeWatermark eventTimeWatermark;
                A1 A1 = x2;
                Object object = A1 instanceof EventTimeWatermark ? (eventTimeWatermark = (EventTimeWatermark)A1) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x2) {
                LogicalPlan logicalPlan2 = x2;
                boolean bl = logicalPlan2 instanceof EventTimeWatermark;
                return bl;
            }
        }).nonEmpty();
        scala.collection.immutable.Map watermarkTimestamp = hasEventTime ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"watermark"), (Object)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(this.offsetSeqMetadata().batchWatermarkMs()))})) : Predef$.MODULE$.Map().empty();
        Seq<StateOperatorProgress> stateOperators = this.extractStateOperatorMetrics(hasNewData);
        if (!hasNewData) {
            return new ExecutionStats(this, (scala.collection.immutable.Map<BaseStreamingSource, Object>)Predef$.MODULE$.Map().empty(), stateOperators, (scala.collection.immutable.Map<String, String>)watermarkTimestamp);
        }
        scala.collection.immutable.Map<BaseStreamingSource, Object> numInputRows = this.extractSourceToNumInputRows();
        scala.collection.immutable.Map eventTimeStats = ((MapLike)this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProgressReporter $outer;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                EventTimeWatermarkExec eventTimeWatermarkExec;
                A1 A1 = x3;
                if (A1 instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)A1).eventTimeStats().value().count() > 0L) {
                    EventTimeStats stats = eventTimeWatermarkExec.eventTimeStats().value();
                    object = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max"), (Object)BoxesRunTime.boxToLong((long)stats.max())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min"), (Object)BoxesRunTime.boxToLong((long)stats.min())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avg"), (Object)BoxesRunTime.boxToLong((long)((long)stats.avg())))}))).mapValues((Function1 & Serializable & scala.Serializable)millis -> $anonfun$2.$anonfun$applyOrElse$1(this, BoxesRunTime.unboxToLong((Object)millis)));
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x3) {
                EventTimeWatermarkExec eventTimeWatermarkExec;
                SparkPlan sparkPlan = x3;
                boolean bl = sparkPlan instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)sparkPlan).eventTimeStats().value().count() > 0L;
                return bl;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$1($anonfun$2 $this, long millis) {
                return $this.$outer.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(millis);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.execution.streaming.ProgressReporter$$anonfun$2 java.lang.Object )}, serializedLambda);
            }
        }).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)watermarkTimestamp);
        return new ExecutionStats(this, numInputRows, stateOperators, (scala.collection.immutable.Map<String, String>)eventTimeStats);
    }

    private scala.collection.immutable.Map<BaseStreamingSource, Object> extractSourceToNumInputRows() {
        scala.collection.immutable.Map map;
        Seq allStreamingLeaves = this.logicalPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                StreamingExecutionRelation streamingExecutionRelation;
                A1 A1 = x4;
                Object object = A1 instanceof StreamingExecutionRelation ? (streamingExecutionRelation = (StreamingExecutionRelation)A1) : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x4) {
                LogicalPlan logicalPlan2 = x4;
                boolean bl = logicalPlan2 instanceof StreamingExecutionRelation;
                return bl;
            }
        });
        boolean onlyDataSourceV2Sources = allStreamingLeaves.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ProgressReporter.$anonfun$extractSourceToNumInputRows$4(x$6)));
        if (onlyDataSourceV2Sources) {
            IdentityHashMap uniqueStreamingExecLeavesMap = new IdentityHashMap();
            this.lastExecution().executedPlan().collectLeaves().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataSourceV2ScanExec dataSourceV2ScanExec;
                SparkPlan sparkPlan = x0$1;
                Object object = sparkPlan instanceof DataSourceV2ScanExec && (dataSourceV2ScanExec = (DataSourceV2ScanExec)sparkPlan).reader() instanceof BaseStreamingSource ? uniqueStreamingExecLeavesMap.put(dataSourceV2ScanExec, dataSourceV2ScanExec) : BoxedUnit.UNIT;
                return object;
            });
            Seq sourceToInputRowsTuples = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(uniqueStreamingExecLeavesMap.values()).asScala()).map((Function1 & Serializable & scala.Serializable)execLeaf -> {
                long numRows = BoxesRunTime.unboxToLong((Object)execLeaf.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                BaseStreamingSource source = (BaseStreamingSource)((Object)execLeaf.reader());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Source -> # input rows\n\t").append(sourceToInputRowsTuples.mkString("\n\t")).toString());
            map = ProgressReporter.sumRows$1(sourceToInputRowsTuples);
        } else {
            scala.collection.immutable.Map logicalPlanLeafToSource = (scala.collection.immutable.Map)this.newData().flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BaseStreamingSource source = (BaseStreamingSource)tuple2._1();
                LogicalPlan logicalPlan2 = (LogicalPlan)tuple2._2();
                Seq seq = (Seq)logicalPlan2.collectLeaves().map((Function1 & Serializable & scala.Serializable)leaf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(leaf), (Object)source), Seq$.MODULE$.canBuildFrom());
                return seq;
            }, Map$.MODULE$.canBuildFrom());
            Seq allLogicalPlanLeaves = this.lastExecution().logical().collectLeaves();
            Seq allExecPlanLeaves = this.lastExecution().executedPlan().collectLeaves();
            if (allLogicalPlanLeaves.size() == allExecPlanLeaves.size()) {
                Seq execLeafToSource = (Seq)((TraversableLike)allLogicalPlanLeaves.zip((GenIterable)allExecPlanLeaves, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    LogicalPlan lp = (LogicalPlan)tuple2._1();
                    SparkPlan ep = (SparkPlan)((Object)((Object)tuple2._2()));
                    Iterable iterable = Option$.MODULE$.option2Iterable(logicalPlanLeafToSource.get((Object)lp).map((Function1 & Serializable & scala.Serializable)source -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep), source)));
                    return iterable;
                }, Seq$.MODULE$.canBuildFrom());
                Seq sourceToInputRowsTuples = (Seq)execLeafToSource.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    SparkPlan execLeaf = (SparkPlan)((Object)((Object)tuple2._1()));
                    BaseStreamingSource source = (BaseStreamingSource)tuple2._2();
                    long numRows = BoxesRunTime.unboxToLong((Object)execLeaf.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
                    return tuple22;
                }, Seq$.MODULE$.canBuildFrom());
                map = ProgressReporter.sumRows$1(sourceToInputRowsTuples);
            } else {
                if (!this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged()) {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(108).append("Could not report metrics as number leaves in trigger logical plan did not match that").append(" of the execution plan:\n").append(new StringBuilder(22).append("logical plan leaves: ").append(ProgressReporter.toString$1(allLogicalPlanLeaves)).append("\n").toString()).append(new StringBuilder(24).append("execution plan leaves: ").append(ProgressReporter.toString$1(allExecPlanLeaves)).append("\n").toString()).toString());
                    this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(true);
                }
                map = Predef$.MODULE$.Map().empty();
            }
        }
        return map;
    }

    public static /* synthetic */ Object reportTimeTaken$(ProgressReporter $this, String triggerDetailKey, Function0 body) {
        return $this.reportTimeTaken(triggerDetailKey, body);
    }

    default public <T> T reportTimeTaken(String triggerDetailKey, Function0<T> body) {
        long startTime = this.triggerClock().getTimeMillis();
        Object result = body.apply();
        long endTime = this.triggerClock().getTimeMillis();
        long timeTaken = package$.MODULE$.max(endTime - startTime, 0L);
        long previousTime = BoxesRunTime.unboxToLong((Object)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().getOrElse((Object)triggerDetailKey, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().put((Object)triggerDetailKey, (Object)BoxesRunTime.boxToLong((long)(previousTime + timeTaken)));
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append(triggerDetailKey).append(" took ").append(timeTaken).append(" ms").toString());
        return (T)result;
    }

    public static /* synthetic */ String org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp$(ProgressReporter $this, long millis) {
        return $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(millis);
    }

    default public String org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(long millis) {
        return this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().format(new Date(millis));
    }

    public static /* synthetic */ void updateStatusMessage$(ProgressReporter $this, String message) {
        $this.updateStatusMessage(message);
    }

    default public void updateStatusMessage(String message) {
        StreamingQueryStatus qual$3 = this.currentStatus();
        String x$15 = message;
        boolean x$16 = qual$3.copy$default$2();
        boolean x$17 = qual$3.copy$default$3();
        this.currentStatus_$eq(qual$3.copy(x$15, x$16, x$17));
    }

    public static /* synthetic */ long $anonfun$extractSourceToNumInputRows$2(Seq x$4) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)x$4.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private static scala.collection.immutable.Map sumRows$1(Seq tuples) {
        return tuples.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> (BaseStreamingSource)x$3._1()).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)ProgressReporter.$anonfun$extractSourceToNumInputRows$2(x$4)));
    }

    public static /* synthetic */ boolean $anonfun$extractSourceToNumInputRows$4(StreamingExecutionRelation x$6) {
        return x$6.source() instanceof MicroBatchReader;
    }

    private static String toString$1(Seq seq) {
        return new StringBuilder(11).append("(size = ").append(seq.size()).append("), ").append(seq.mkString(", ")).toString();
    }

    public static void $init$(ProgressReporter $this) {
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq((scala.collection.mutable.HashMap<String, Object>)new scala.collection.mutable.HashMap());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(false);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq((Queue<StreamingQueryProgress>)new Queue());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq($this.sparkSession().sessionState().conf().streamingNoDataProgressEventInterval());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(Long.MIN_VALUE);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().setTimeZone(DateTimeUtils$.MODULE$.getTimeZone("UTC"));
        $this.currentStatus_$eq(new StreamingQueryStatus("Initializing StreamExecution", false, false));
    }

    public class ExecutionStats
    implements Product,
    scala.Serializable {
        private final scala.collection.immutable.Map<BaseStreamingSource, Object> inputRows;
        private final Seq<StateOperatorProgress> stateOperators;
        private final scala.collection.immutable.Map<String, String> eventTimeStats;
        public final /* synthetic */ ProgressReporter $outer;

        public scala.collection.immutable.Map<BaseStreamingSource, Object> inputRows() {
            return this.inputRows;
        }

        public Seq<StateOperatorProgress> stateOperators() {
            return this.stateOperators;
        }

        public scala.collection.immutable.Map<String, String> eventTimeStats() {
            return this.eventTimeStats;
        }

        public ExecutionStats copy(scala.collection.immutable.Map<BaseStreamingSource, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            return new ExecutionStats(this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer(), inputRows, stateOperators, eventTimeStats);
        }

        public scala.collection.immutable.Map<BaseStreamingSource, Object> copy$default$1() {
            return this.inputRows();
        }

        public Seq<StateOperatorProgress> copy$default$2() {
            return this.stateOperators();
        }

        public scala.collection.immutable.Map<String, String> copy$default$3() {
            return this.eventTimeStats();
        }

        public String productPrefix() {
            return "ExecutionStats";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.inputRows();
                    break;
                }
                case 1: {
                    object = this.stateOperators();
                    break;
                }
                case 2: {
                    object = this.eventTimeStats();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExecutionStats;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExecutionStats)) return false;
            if (((ExecutionStats)object).org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() != this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ExecutionStats executionStats = (ExecutionStats)x$1;
            scala.collection.immutable.Map<BaseStreamingSource, Object> map = this.inputRows();
            scala.collection.immutable.Map<BaseStreamingSource, Object> map2 = executionStats.inputRows();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Seq<StateOperatorProgress> seq = this.stateOperators();
            Seq<StateOperatorProgress> seq2 = executionStats.stateOperators();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            scala.collection.immutable.Map<String, String> map3 = this.eventTimeStats();
            scala.collection.immutable.Map<String, String> map4 = executionStats.eventTimeStats();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            if (!executionStats.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ProgressReporter org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() {
            return this.$outer;
        }

        public ExecutionStats(ProgressReporter $outer, scala.collection.immutable.Map<BaseStreamingSource, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            this.inputRows = inputRows;
            this.stateOperators = stateOperators;
            this.eventTimeStats = eventTimeStats;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

