/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.execution.streaming.Sink;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001#\t\u0001bi\u001c:fC\u000eD')\u0019;dQNKgn\u001b\u0006\u0003\u0007\u0011\tqa]8ve\u000e,7O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005Ii3c\u0001\u0001\u00147A\u0011A#G\u0007\u0002+)\u0011acF\u0001\u0005Y\u0006twMC\u0001\u0019\u0003\u0011Q\u0017M^1\n\u0005i)\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001d;5\tA!\u0003\u0002\u001f\t\t!1+\u001b8l\u0011!\u0001\u0003A!A!\u0002\u0013\t\u0013a\u00032bi\u000eDwK]5uKJ\u0004RAI\u0013(mej\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\n\rVt7\r^5p]J\u00022\u0001K\u0015,\u001b\u0005A\u0011B\u0001\u0016\t\u0005\u001d!\u0015\r^1tKR\u0004\"\u0001L\u0017\r\u0001\u0011)a\u0006\u0001b\u0001_\t\tA+\u0005\u00021gA\u0011!%M\u0005\u0003e\r\u0012qAT8uQ&tw\r\u0005\u0002#i%\u0011Qg\t\u0002\u0004\u0003:L\bC\u0001\u00128\u0013\tA4E\u0001\u0003M_:<\u0007C\u0001\u0012;\u0013\tY4E\u0001\u0003V]&$\b\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002\u000f\u0015t7m\u001c3feB\u0019q\bR\u0016\u000e\u0003\u0001S!!\u0011\"\u0002\u0011\u0015t7m\u001c3feNT!a\u0011\u0005\u0002\u0011\r\fG/\u00197zgRL!!\u0012!\u0003#\u0015C\bO]3tg&|g.\u00128d_\u0012,'\u000fC\u0003H\u0001\u0011\u0005\u0001*\u0001\u0004=S:LGO\u0010\u000b\u0004\u0013.c\u0005c\u0001&\u0001W5\t!\u0001C\u0003!\r\u0002\u0007\u0011\u0005C\u0003>\r\u0002\u0007a\bC\u0003O\u0001\u0011\u0005s*\u0001\u0005bI\u0012\u0014\u0015\r^2i)\rI\u0004K\u0015\u0005\u0006#6\u0003\rAN\u0001\bE\u0006$8\r[%e\u0011\u0015\u0019V\n1\u0001U\u0003\u0011!\u0017\r^1\u0011\u0005U\u001bgB\u0001,b\u001d\t9\u0006M\u0004\u0002Y?:\u0011\u0011L\u0018\b\u00035vk\u0011a\u0017\u0006\u00039B\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002c\u0011\u00059\u0001/Y2lC\u001e,\u0017B\u00013f\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002c\u0011!)q\r\u0001C!Q\u0006AAo\\*ue&tw\rF\u0001j!\tQgN\u0004\u0002lYB\u0011!lI\u0005\u0003[\u000e\na\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011Qn\t")
public class ForeachBatchSink<T>
implements Sink {
    private final Function2<Dataset<T>, Object, BoxedUnit> batchWriter;
    private final ExpressionEncoder<T> encoder;

    @Override
    public void addBatch(long batchId, Dataset<Row> data) {
        ExpressionEncoder resolvedEncoder = this.encoder.resolveAndBind(data.logicalPlan().output(), data.sparkSession().sessionState().analyzer());
        RDD rdd = data.queryExecution().toRdd().map((Function1 & java.io.Serializable & Serializable)row -> resolvedEncoder.fromRow(row), this.encoder.clsTag());
        Dataset<T> ds = data.sparkSession().createDataset(rdd, this.encoder);
        this.batchWriter.apply(ds, (Object)BoxesRunTime.boxToLong((long)batchId));
    }

    public String toString() {
        return "ForeachBatchSink";
    }

    public ForeachBatchSink(Function2<Dataset<T>, Object, BoxedUnit> batchWriter, ExpressionEncoder<T> encoder) {
        this.batchWriter = batchWriter;
        this.encoder = encoder;
    }
}

