/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.LongOffset$;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.sources.RateStreamMicroBatchInputPartition;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider$;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.sources.v2.reader.streaming.Offset;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u0001E\u0011!DU1uKN#(/Z1n\u001b&\u001c'o\u001c\"bi\u000eD'+Z1eKJT!a\u0001\u0003\u0002\u000fM|WO]2fg*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u00135\u0011\u0002\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\t1\fgn\u001a\u0006\u0002/\u0005!!.\u0019<b\u0013\tIBC\u0001\u0004PE*,7\r\u001e\t\u00037\tj\u0011\u0001\b\u0006\u0003\u000buQ!AH\u0010\u0002\rI,\u0017\rZ3s\u0015\t\u0001\u0013%\u0001\u0002we)\u00111\u0001C\u0005\u0003Gq\u0011\u0001#T5de>\u0014\u0015\r^2i%\u0016\fG-\u001a:\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dR\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005%2#a\u0002'pO\u001eLgn\u001a\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u00059q\u000e\u001d;j_:\u001c\bCA\u0017/\u001b\u0005y\u0012BA\u0018 \u0005E!\u0015\r^1T_V\u00148-Z(qi&|gn\u001d\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005\u00112\r[3dWB|\u0017N\u001c;M_\u000e\fG/[8o!\t\u0019DH\u0004\u00025uA\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007E\u0001\u0007yI|w\u000e\u001e \u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0002\rA\u0013X\rZ3g\u0013\tidH\u0001\u0004TiJLgn\u001a\u0006\u0003waBQ\u0001\u0011\u0001\u0005\u0002\u0005\u000ba\u0001P5oSRtDc\u0001\"E\u000bB\u00111\tA\u0007\u0002\u0005!)1f\u0010a\u0001Y!)\u0011g\u0010a\u0001e!Aq\t\u0001b\u0001\n\u0003\u0011\u0001*A\u0003dY>\u001c7.F\u0001J!\tQU*D\u0001L\u0015\ta%\"\u0001\u0003vi&d\u0017B\u0001(L\u0005\u0015\u0019En\\2l\u0011\u0019\u0001\u0006\u0001)A\u0005\u0013\u000611\r\\8dW\u0002BqA\u0015\u0001C\u0002\u0013%1+A\u0007s_^\u001c\b+\u001a:TK\u000e|g\u000eZ\u000b\u0002)B\u0011QKV\u0007\u0002q%\u0011q\u000b\u000f\u0002\u0005\u0019>tw\r\u0003\u0004Z\u0001\u0001\u0006I\u0001V\u0001\u000fe><8\u000fU3s'\u0016\u001cwN\u001c3!\u0011\u001dY\u0006A1A\u0005\nM\u000b\u0011C]1naV\u0003H+[7f'\u0016\u001cwN\u001c3t\u0011\u0019i\u0006\u0001)A\u0005)\u0006\u0011\"/Y7q+B$\u0016.\\3TK\u000e|g\u000eZ:!\u0011\u001dy\u0006A1A\u0005\nM\u000b!\"\\1y'\u0016\u001cwN\u001c3t\u0011\u0019\t\u0007\u0001)A\u0005)\u0006YQ.\u0019=TK\u000e|g\u000eZ:!\u0011!\u0019\u0007A1A\u0005\u0002\t\u0019\u0016AD2sK\u0006$\u0018n\u001c8US6,Wj\u001d\u0005\u0007K\u0002\u0001\u000b\u0011\u0002+\u0002\u001f\r\u0014X-\u0019;j_:$\u0016.\\3Ng\u0002Bqa\u001a\u0001A\u0002\u0013%1+\u0001\u0006mCN$H+[7f\u001bNDq!\u001b\u0001A\u0002\u0013%!.\u0001\bmCN$H+[7f\u001bN|F%Z9\u0015\u0005-t\u0007CA+m\u0013\ti\u0007H\u0001\u0003V]&$\bbB8i\u0003\u0003\u0005\r\u0001V\u0001\u0004q\u0012\n\u0004BB9\u0001A\u0003&A+A\u0006mCN$H+[7f\u001bN\u0004\u0003F\u00019t!\t)F/\u0003\u0002vq\tAao\u001c7bi&dW\rC\u0005x\u0001\u0001\u0007\t\u0019!C\u0005q\u0006)1\u000f^1siV\t\u0011\u0010\u0005\u0002{w6\tA!\u0003\u0002}\t\tQAj\u001c8h\u001f\u001a47/\u001a;\t\u0013y\u0004\u0001\u0019!a\u0001\n\u0013y\u0018!C:uCJ$x\fJ3r)\rY\u0017\u0011\u0001\u0005\b_v\f\t\u00111\u0001z\u0011)\t)\u0001\u0001a\u0001\u0002\u0003\u0006K!_\u0001\u0007gR\f'\u000f\u001e\u0011\t\u0015\u0005%\u0001\u00011AA\u0002\u0013%\u00010A\u0002f]\u0012D1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0010\u00059QM\u001c3`I\u0015\fHcA6\u0002\u0012!Aq.a\u0003\u0002\u0002\u0003\u0007\u0011\u0010\u0003\u0006\u0002\u0016\u0001\u0001\r\u0011!Q!\ne\fA!\u001a8eA!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0011A\u0003:fC\u0012\u001c6\r[3nCR\u0011\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u0005\u0005\u0002\u000bQL\b/Z:\n\t\u0005\u001d\u0012\u0011\u0005\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\u0016\u0001\u0011\u0005\u0013QF\u0001\u000fg\u0016$xJ\u001a4tKR\u0014\u0016M\\4f)\u0015Y\u0017qFA!\u0011\u001d9\u0018\u0011\u0006a\u0001\u0003c\u0001b!a\r\u00028\u0005mRBAA\u001b\u0015\tae#\u0003\u0003\u0002:\u0005U\"\u0001C(qi&|g.\u00197\u0011\u0007m\ti$C\u0002\u0002@q\u0011aa\u00144gg\u0016$\b\u0002CA\u0005\u0003S\u0001\r!!\r\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\u0005qq-\u001a;Ti\u0006\u0014Ho\u00144gg\u0016$HCAA\u001e\u0011\u001d\tY\u0005\u0001C!\u0003\u000f\nAbZ3u\u000b:$wJ\u001a4tKRDq!a\u0014\u0001\t\u0003\n\t&A\teKN,'/[1mSj,wJ\u001a4tKR$B!a\u000f\u0002T!9\u0011QKA'\u0001\u0004\u0011\u0014\u0001\u00026t_:Dq!!\u0017\u0001\t\u0003\nY&A\nqY\u0006t\u0017J\u001c9viB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0002^A1\u00111GA0\u0003GJA!!\u0019\u00026\t!A*[:u!\u0019\t)'a\u001a\u0002l5\tQ$C\u0002\u0002ju\u0011a\"\u00138qkR\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\t\bC\u0001\tG\u0006$\u0018\r\\=ti&!\u0011QOA8\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|\u000511m\\7nSR$2a[A?\u0011!\tI!a\u001eA\u0002\u0005m\u0002bBAA\u0001\u0011\u0005\u00131Q\u0001\u0005gR|\u0007\u000fF\u0001l\u0011\u001d\t9\t\u0001C!\u0003\u0013\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002e\u0001")
public class RateStreamMicroBatchReader
implements MicroBatchReader,
Logging {
    private final DataSourceOptions options;
    public final String org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$checkpointLocation;
    private final Clock clock;
    private final long rowsPerSecond;
    private final long rampUpTimeSeconds;
    private final long maxSeconds;
    private final long creationTimeMs;
    private volatile long lastTimeMs;
    private LongOffset start;
    private LongOffset end;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Clock clock() {
        return this.clock;
    }

    private long rowsPerSecond() {
        return this.rowsPerSecond;
    }

    private long rampUpTimeSeconds() {
        return this.rampUpTimeSeconds;
    }

    private long maxSeconds() {
        return this.maxSeconds;
    }

    public long creationTimeMs() {
        return this.creationTimeMs;
    }

    private long lastTimeMs() {
        return this.lastTimeMs;
    }

    private void lastTimeMs_$eq(long x$1) {
        this.lastTimeMs = x$1;
    }

    private LongOffset start() {
        return this.start;
    }

    private void start_$eq(LongOffset x$1) {
        this.start = x$1;
    }

    private LongOffset end() {
        return this.end;
    }

    private void end_$eq(LongOffset x$1) {
        this.end = x$1;
    }

    @Override
    public StructType readSchema() {
        return RateStreamProvider$.MODULE$.SCHEMA();
    }

    @Override
    public void setOffsetRange(Optional<Offset> start, Optional<Offset> end) {
        this.start_$eq((LongOffset)start.orElse(new LongOffset(0L)));
        long now = this.clock().getTimeMillis();
        if (this.lastTimeMs() < now) {
            this.lastTimeMs_$eq(now);
        }
        this.end_$eq((LongOffset)end.orElse(new LongOffset(TimeUnit.MILLISECONDS.toSeconds(this.lastTimeMs() - this.creationTimeMs()))));
    }

    @Override
    public Offset getStartOffset() {
        if (this.start() == null) {
            throw new IllegalStateException("start offset not set");
        }
        return this.start();
    }

    @Override
    public Offset getEndOffset() {
        if (this.end() == null) {
            throw new IllegalStateException("end offset not set");
        }
        return this.end();
    }

    @Override
    public Offset deserializeOffset(String json) {
        return new LongOffset(new StringOps(Predef$.MODULE$.augmentString(json)).toLong());
    }

    @Override
    public List<InputPartition<InternalRow>> planInputPartitions() {
        long endSeconds;
        long startSeconds = BoxesRunTime.unboxToLong((Object)LongOffset$.MODULE$.convert(this.start()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Predef$.MODULE$.assert(startSeconds <= (endSeconds = BoxesRunTime.unboxToLong((Object)LongOffset$.MODULE$.convert(this.end()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("startSeconds(").append(startSeconds).append(") > endSeconds(").append(endSeconds).append(")").toString());
        if (endSeconds > this.maxSeconds()) {
            throw new ArithmeticException(new StringBuilder(34).append("Integer overflow. Max offset with ").append(new StringBuilder(34).append(this.rowsPerSecond()).append(" rowsPerSecond is ").append(this.maxSeconds()).append(", but it's ").append(endSeconds).append(" now.").toString()).toString());
        }
        if (this.lastTimeMs() < TimeUnit.SECONDS.toMillis(endSeconds) + this.creationTimeMs()) {
            this.lastTimeMs_$eq(TimeUnit.SECONDS.toMillis(endSeconds) + this.creationTimeMs());
        }
        long rangeStart = RateStreamProvider$.MODULE$.valueAtSecond(startSeconds, this.rowsPerSecond(), this.rampUpTimeSeconds());
        long rangeEnd = RateStreamProvider$.MODULE$.valueAtSecond(endSeconds, this.rowsPerSecond(), this.rampUpTimeSeconds());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("startSeconds: ").append(startSeconds).append(", endSeconds: ").append(endSeconds).append(", ").append(new StringBuilder(24).append("rangeStart: ").append(rangeStart).append(", rangeEnd: ").append(rangeEnd).toString()).toString());
        if (rangeStart == rangeEnd) {
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava();
        }
        long localStartTimeMs = this.creationTimeMs() + TimeUnit.SECONDS.toMillis(startSeconds);
        double relativeMsPerValue = (double)TimeUnit.SECONDS.toMillis(endSeconds - startSeconds) / (double)(rangeEnd - rangeStart);
        Option<SparkSession> activeSession = SparkSession$.MODULE$.getActiveSession();
        Predef$.MODULE$.require(activeSession.isDefined());
        int numPartitions = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).orElse(null)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)RateStreamMicroBatchReader.$anonfun$planInputPartitions$7(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((SparkSession)activeSession.get()).sparkContext().defaultParallelism()));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)p -> RateStreamMicroBatchReader.$anonfun$planInputPartitions$9(rangeStart, rangeEnd, localStartTimeMs, relativeMsPerValue, numPartitions, BoxesRunTime.unboxToInt((Object)p)), IndexedSeq$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public String toString() {
        return new StringBuilder(29).append("RateStreamV2[rowsPerSecond=").append(this.rowsPerSecond()).append(", ").append(new StringBuilder(20).append("rampUpTimeSeconds=").append(this.rampUpTimeSeconds()).append(", ").toString()).append(new StringBuilder(14).append("numPartitions=").append((Object)this.options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).orElse("default")).toString()).toString();
    }

    public static final /* synthetic */ long $anonfun$rampUpTimeSeconds$1(String x$1) {
        return JavaUtils.timeStringAsSec((String)x$1);
    }

    public static final /* synthetic */ int $anonfun$planInputPartitions$7(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ InputPartition $anonfun$planInputPartitions$9(long rangeStart$1, long rangeEnd$1, long localStartTimeMs$1, double relativeMsPerValue$1, int numPartitions$1, int p) {
        return new RateStreamMicroBatchInputPartition(p, numPartitions$1, rangeStart$1, rangeEnd$1, localStartTimeMs$1, relativeMsPerValue$1);
    }

    public RateStreamMicroBatchReader(DataSourceOptions options, String checkpointLocation) {
        this.options = options;
        this.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$checkpointLocation = checkpointLocation;
        Logging.$init$((Logging)this);
        this.clock = options.getBoolean("useManualClock", false) ? new ManualClock() : new SystemClock();
        this.rowsPerSecond = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.ROWS_PER_SECOND()).orElse("1"))).toLong();
        this.rampUpTimeSeconds = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply(options.get(RateStreamProvider$.MODULE$.RAMP_UP_TIME()).orElse(null)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)RateStreamMicroBatchReader.$anonfun$rampUpTimeSeconds$1(x$1))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.maxSeconds = Long.MAX_VALUE / this.rowsPerSecond();
        if (this.rampUpTimeSeconds() > this.maxSeconds()) {
            throw new ArithmeticException(new StringBuilder(48).append("Integer overflow. Max offset with ").append(this.rowsPerSecond()).append(" rowsPerSecond").append(new StringBuilder(34).append(" is ").append(this.maxSeconds()).append(", but 'rampUpTimeSeconds' is ").append(this.rampUpTimeSeconds()).append(".").toString()).toString());
        }
        Option session = SparkSession$.MODULE$.getActiveSession().orElse((Function0 & Serializable & scala.Serializable)() -> SparkSession$.MODULE$.getDefaultSession());
        Predef$.MODULE$.require(session.isDefined());
        HDFSMetadataLog<LongOffset> metadataLog = new HDFSMetadataLog<LongOffset>(this, session){

            public void serialize(LongOffset metadata, OutputStream out) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
                writer.write(new StringBuilder(2).append("v").append(RateStreamProvider$.MODULE$.VERSION()).append("\n").toString());
                writer.write(metadata.json());
                writer.flush();
            }

            public LongOffset deserialize(InputStream in) {
                int indexOfNewLine;
                String content = IOUtils.toString((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
                Predef$.MODULE$.assert(content.length() != 0);
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(content), 0) == 'v') {
                    indexOfNewLine = content.indexOf("\n");
                    if (indexOfNewLine <= 0) {
                        throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
                    }
                } else {
                    throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
                }
                this.parseVersion(content.substring(0, indexOfNewLine), RateStreamProvider$.MODULE$.VERSION());
                return LongOffset$.MODULE$.apply(new SerializedOffset(content.substring(indexOfNewLine + 1)));
            }
        };
        this.creationTimeMs = ((LongOffset)metadataLog.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            LongOffset offset = new LongOffset(this.clock().getTimeMillis());
            metadataLog.add(0L, offset);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Start time: ").append(offset).toString());
            return var2_2;
        })).offset();
        this.lastTimeMs = this.creationTimeMs();
    }
}

