/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.util.Optional;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamContinuousReader;
import org.apache.spark.sql.execution.streaming.sources.RateStreamMicroBatchReader;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.v2.ContinuousReadSupport;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.MicroBatchReadSupport;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.types.StructType;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001E\u0011!CU1uKN#(/Z1n!J|g/\u001b3fe*\u00111\u0001B\u0001\bg>,(oY3t\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\n\u001bC\u0011:\u0003CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011a\u0017M\\4\u000b\u0003]\tAA[1wC&\u0011\u0011\u0004\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005myR\"\u0001\u000f\u000b\u0005uq\u0012A\u0001<3\u0015\t\u0019\u0001\"\u0003\u0002!9\taA)\u0019;b'>,(oY3WeA\u00111DI\u0005\u0003Gq\u0011Q#T5de>\u0014\u0015\r^2i%\u0016\fGmU;qa>\u0014H\u000f\u0005\u0002\u001cK%\u0011a\u0005\b\u0002\u0016\u0007>tG/\u001b8v_V\u001c(+Z1e'V\u0004\bo\u001c:u!\tA\u0013&D\u0001\u001f\u0013\tQcD\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\b\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0001/!\ty\u0003!D\u0001\u0003\u0011\u0015\t\u0004\u0001\"\u00113\u0003Y\u0019'/Z1uK6K7M]8CCR\u001c\u0007NU3bI\u0016\u0014H\u0003B\u001a;\u0011^\u0003\"\u0001\u000e\u001d\u000e\u0003UR!!\u0002\u001c\u000b\u0005]b\u0012A\u0002:fC\u0012,'/\u0003\u0002:k\t\u0001R*[2s_\n\u000bGo\u00195SK\u0006$WM\u001d\u0005\u0006wA\u0002\r\u0001P\u0001\u0007g\u000eDW-\\1\u0011\u0007u\u0002%)D\u0001?\u0015\tyd#\u0001\u0003vi&d\u0017BA!?\u0005!y\u0005\u000f^5p]\u0006d\u0007CA\"G\u001b\u0005!%BA#\t\u0003\u0015!\u0018\u0010]3t\u0013\t9EI\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!\u0013\u0019A\u0002)\u000b!c\u00195fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]B\u00111\n\u0016\b\u0003\u0019J\u0003\"!\u0014)\u000e\u00039S!a\u0014\t\u0002\rq\u0012xn\u001c;?\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u0003\u0006\"\u0002-1\u0001\u0004I\u0016aB8qi&|gn\u001d\t\u00037iK!a\u0017\u000f\u0003#\u0011\u000bG/Y*pkJ\u001cWm\u00149uS>t7\u000fC\u0003^\u0001\u0011\u0005c,\u0001\fde\u0016\fG/Z\"p]RLg.^8vgJ+\u0017\rZ3s)\u0011y&m\u00193\u0011\u0005Q\u0002\u0017BA16\u0005A\u0019uN\u001c;j]V|Wo\u001d*fC\u0012,'\u000fC\u0003<9\u0002\u0007A\bC\u0003J9\u0002\u0007!\nC\u0003Y9\u0002\u0007\u0011\fC\u0003g\u0001\u0011\u0005s-A\u0005tQ>\u0014HOT1nKR\t!jB\u0003j\u0005!\u0005!.\u0001\nSCR,7\u000b\u001e:fC6\u0004&o\u001c<jI\u0016\u0014\bCA\u0018l\r\u0015\t!\u0001#\u0001m'\tYW\u000e\u0005\u0002o_6\t\u0001+\u0003\u0002q!\n1\u0011I\\=SK\u001aDQ\u0001L6\u0005\u0002I$\u0012A\u001b\u0005\bi.\u0014\r\u0011\"\u0001v\u0003\u0019\u00196\tS#N\u0003V\t!\t\u0003\u0004xW\u0002\u0006IAQ\u0001\b'\u000eCU)T!!\u0011\u001dI8N1A\u0005\u0002i\fqAV#S'&{e*F\u0001|!\tqG0\u0003\u0002~!\n\u0019\u0011J\u001c;\t\r}\\\u0007\u0015!\u0003|\u0003!1VIU*J\u001f:\u0003\u0003\"CA\u0002W\n\u0007I\u0011AA\u0003\u00039qU+T0Q\u0003J#\u0016\nV%P\u001dN+\"!a\u0002\u0011\u0007M\tI!\u0003\u0002V)!A\u0011QB6!\u0002\u0013\t9!A\bO+6{\u0006+\u0011*U\u0013RKuJT*!\u0011%\t\tb\u001bb\u0001\n\u0003\t)!A\bS\u001f^\u001bv\fU#S?N+5i\u0014(E\u0011!\t)b\u001bQ\u0001\n\u0005\u001d\u0011\u0001\u0005*P/N{\u0006+\u0012*`'\u0016\u001buJ\u0014#!\u0011%\tIb\u001bb\u0001\n\u0003\t)!\u0001\u0007S\u00036\u0003v,\u0016)`)&kU\t\u0003\u0005\u0002\u001e-\u0004\u000b\u0011BA\u0004\u00035\u0011\u0016)\u0014)`+B{F+S'FA!9\u0011\u0011E6\u0005\u0002\u0005\r\u0012!\u0004<bYV,\u0017\t^*fG>tG\r\u0006\u0005\u0002&\u0005-\u0012qFA\u001a!\rq\u0017qE\u0005\u0004\u0003S\u0001&\u0001\u0002'p]\u001eD\u0001\"!\f\u0002 \u0001\u0007\u0011QE\u0001\bg\u0016\u001cwN\u001c3t\u0011!\t\t$a\bA\u0002\u0005\u0015\u0012!\u0004:poN\u0004VM]*fG>tG\r\u0003\u0005\u00026\u0005}\u0001\u0019AA\u0013\u0003E\u0011\u0018-\u001c9VaRKW.Z*fG>tGm\u001d")
public class RateStreamProvider
implements MicroBatchReadSupport,
ContinuousReadSupport,
DataSourceRegister {
    public static long valueAtSecond(long l, long l2, long l3) {
        return RateStreamProvider$.MODULE$.valueAtSecond(l, l2, l3);
    }

    public static String RAMP_UP_TIME() {
        return RateStreamProvider$.MODULE$.RAMP_UP_TIME();
    }

    public static String ROWS_PER_SECOND() {
        return RateStreamProvider$.MODULE$.ROWS_PER_SECOND();
    }

    public static String NUM_PARTITIONS() {
        return RateStreamProvider$.MODULE$.NUM_PARTITIONS();
    }

    public static int VERSION() {
        return RateStreamProvider$.MODULE$.VERSION();
    }

    public static StructType SCHEMA() {
        return RateStreamProvider$.MODULE$.SCHEMA();
    }

    @Override
    public MicroBatchReader createMicroBatchReader(Optional<StructType> schema, String checkpointLocation, DataSourceOptions options) {
        int numPartitions;
        long rampUpTimeSeconds;
        long rowsPerSecond;
        if (options.get(RateStreamProvider$.MODULE$.ROWS_PER_SECOND()).isPresent() && (rowsPerSecond = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.ROWS_PER_SECOND()).get())).toLong()) <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(61).append("Invalid value '").append(rowsPerSecond).append("'. The option 'rowsPerSecond' must be positive").toString());
        }
        if (options.get(RateStreamProvider$.MODULE$.RAMP_UP_TIME()).isPresent() && (rampUpTimeSeconds = JavaUtils.timeStringAsSec((String)options.get(RateStreamProvider$.MODULE$.RAMP_UP_TIME()).get())) < 0L) {
            throw new IllegalArgumentException(new StringBuilder(62).append("Invalid value '").append(rampUpTimeSeconds).append("'. The option 'rampUpTime' must not be negative").toString());
        }
        if (options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).isPresent() && (numPartitions = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).get())).toInt()) <= 0) {
            throw new IllegalArgumentException(new StringBuilder(61).append("Invalid value '").append(numPartitions).append("'. The option 'numPartitions' must be positive").toString());
        }
        if (schema.isPresent()) {
            throw new AnalysisException("The rate source does not support a user-specified schema.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return new RateStreamMicroBatchReader(options, checkpointLocation);
    }

    @Override
    public ContinuousReader createContinuousReader(Optional<StructType> schema, String checkpointLocation, DataSourceOptions options) {
        return new RateStreamContinuousReader(options);
    }

    @Override
    public String shortName() {
        return "rate";
    }
}

