/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.Partition;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.continuous.EpochTracker$;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001E\u0011Qb\u0015;bi\u0016\u001cFo\u001c:f%\u0012#%BA\u0002\u0005\u0003\u0015\u0019H/\u0019;f\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001)2AE\u0016\u001c'\t\u00011\u0003E\u0002\u0015/ei\u0011!\u0006\u0006\u0003-)\t1A\u001d3e\u0013\tARCA\u0002S\t\u0012\u0003\"AG\u000e\r\u0001\u0011)A\u0004\u0001b\u0001;\t\tQ+\u0005\u0002\u001fIA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t9aj\u001c;iS:<\u0007CA\u0010&\u0013\t1\u0003EA\u0002B]fD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\bI\u0006$\u0018M\u0015#E!\r!rC\u000b\t\u00035-\"Q\u0001\f\u0001C\u0002u\u0011\u0011\u0001\u0016\u0005\t]\u0001\u0011\t\u0011)A\u0005_\u0005\u00192\u000f^8sKV\u0003H-\u0019;f\rVt7\r^5p]B)q\u0004\r\u001a7\u0005&\u0011\u0011\u0007\t\u0002\n\rVt7\r^5p]J\u0002\"a\r\u001b\u000e\u0003\tI!!\u000e\u0002\u0003\u0015M#\u0018\r^3Ti>\u0014X\rE\u00028\u007f)r!\u0001O\u001f\u000f\u0005ebT\"\u0001\u001e\u000b\u0005m\u0002\u0012A\u0002\u001fs_>$h(C\u0001\"\u0013\tq\u0004%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\u000b%\u0001C%uKJ\fGo\u001c:\u000b\u0005y\u0002\u0003cA\u001c@3!AA\t\u0001B\u0001B\u0003%Q)\u0001\ndQ\u0016\u001c7\u000e]8j]RdunY1uS>t\u0007C\u0001$K\u001d\t9\u0005\n\u0005\u0002:A%\u0011\u0011\nI\u0001\u0007!J,G-\u001a4\n\u0005-c%AB*ue&twM\u0003\u0002JA!Aa\n\u0001B\u0001B\u0003%q*\u0001\u0006rk\u0016\u0014\u0018PU;o\u0013\u0012\u0004\"\u0001U+\u000e\u0003ES!AU*\u0002\tU$\u0018\u000e\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0016K\u0001\u0003V+&#\u0005\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\u0002\u0015=\u0004XM]1u_JLE\r\u0005\u0002 5&\u00111\f\t\u0002\u0005\u0019>tw\r\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003Z\u00031\u0019Ho\u001c:f-\u0016\u00148/[8o\u0011!y\u0006A!A!\u0002\u0013\u0001\u0017!C6fsN\u001b\u0007.Z7b!\t\tG-D\u0001c\u0015\t\u0019\u0007\"A\u0003usB,7/\u0003\u0002fE\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011\u001d\u0004!\u0011!Q\u0001\n\u0001\f1B^1mk\u0016\u001c6\r[3nC\"A\u0011\u000e\u0001B\u0001B\u0003%!.\u0001\u0007j]\u0012,\u0007p\u0014:eS:\fG\u000eE\u0002 W6L!\u0001\u001c\u0011\u0003\r=\u0003H/[8o!\tyb.\u0003\u0002pA\t\u0019\u0011J\u001c;\t\u0011E\u0004!\u0011!Q\u0001\nI\fAb]3tg&|gn\u0015;bi\u0016\u0004\"a\u001d<\u000e\u0003QT!!\u001e\u0005\u0002\u0011%tG/\u001a:oC2L!a\u001e;\u0003\u0019M+7o]5p]N#\u0018\r^3\t\u0011e\u0004!Q1A\u0005\ni\f\u0001c\u001d;pe\u0016\u001cun\u001c:eS:\fGo\u001c:\u0016\u0003m\u00042aH6}!\t\u0019T0\u0003\u0002\u007f\u0005\tA2\u000b^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014(+\u001a4\t\u0013\u0005\u0005\u0001A!A!\u0002\u0013Y\u0018!E:u_J,7i\\8sI&t\u0017\r^8sA!\u001aq0!\u0002\u0011\u0007}\t9!C\u0002\u0002\n\u0001\u0012\u0011\u0002\u001e:b]NLWM\u001c;\t\u0015\u00055\u0001AaA!\u0002\u0017\ty!\u0001\u0006fm&$WM\\2fIE\u0002R!!\u0005\u0002\u0018)j!!a\u0005\u000b\u0007\u0005U\u0001%A\u0004sK\u001adWm\u0019;\n\t\u0005e\u00111\u0003\u0002\t\u00072\f7o\u001d+bO\"Q\u0011Q\u0004\u0001\u0003\u0004\u0003\u0006Y!a\b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0003\u0002\u0012\u0005]\u0011\u0004C\u0004\u0002$\u0001!\t!!\n\u0002\rqJg.\u001b;?)a\t9#a\f\u00022\u0005M\u0012QGA\u001c\u0003s\tY$!\u0010\u0002@\u0005\u0005\u00131\t\u000b\u0007\u0003S\tY#!\f\u0011\tM\u0002!&\u0007\u0005\t\u0003\u001b\t\t\u0003q\u0001\u0002\u0010!A\u0011QDA\u0011\u0001\b\ty\u0002\u0003\u0004)\u0003C\u0001\r!\u000b\u0005\u0007]\u0005\u0005\u0002\u0019A\u0018\t\r\u0011\u000b\t\u00031\u0001F\u0011\u0019q\u0015\u0011\u0005a\u0001\u001f\"1\u0001,!\tA\u0002eCa!XA\u0011\u0001\u0004I\u0006BB0\u0002\"\u0001\u0007\u0001\r\u0003\u0004h\u0003C\u0001\r\u0001\u0019\u0005\u0007S\u0006\u0005\u0002\u0019\u00016\t\rE\f\t\u00031\u0001s\u0011\u0019I\u0018\u0011\u0005a\u0001w\"I\u0011q\t\u0001C\u0002\u0013%\u0011\u0011J\u0001\ngR|'/Z\"p]\u001a,\"!a\u0013\u0011\u0007M\ni%C\u0002\u0002P\t\u0011ab\u0015;bi\u0016\u001cFo\u001c:f\u0007>tg\r\u0003\u0005\u0002T\u0001\u0001\u000b\u0011BA&\u0003)\u0019Ho\u001c:f\u0007>tg\r\t\u0005\n\u0003/\u0002!\u0019!C\u0005\u00033\n1\u0003[1e_>\u00048i\u001c8g\u0005J|\u0017\rZ2bgR,\"!a\u0017\u0011\r\u0005u\u00131MA4\u001b\t\tyFC\u0002\u0002b)\t\u0011B\u0019:pC\u0012\u001c\u0017m\u001d;\n\t\u0005\u0015\u0014q\f\u0002\n\u0005J|\u0017\rZ2bgR\u0004B!!\u001b\u0002n5\u0011\u00111\u000e\u0006\u0003%*IA!a\u001c\u0002l\tI2+\u001a:jC2L'0\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0011!\t\u0019\b\u0001Q\u0001\n\u0005m\u0013\u0001\u00065bI>|\u0007oQ8oM\n\u0013x.\u00193dCN$\b\u0005C\u0004\u0002x\u0001!\t&!\u001f\u0002\u001b\u001d,G\u000fU1si&$\u0018n\u001c8t+\t\tY\bE\u0003 \u0003{\n\t)C\u0002\u0002\u0000\u0001\u0012Q!\u0011:sCf\u0004B!a!\u0002\u00066\t!\"C\u0002\u0002\b*\u0011\u0011\u0002U1si&$\u0018n\u001c8\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\u0006)r-\u001a;Qe\u00164WM\u001d:fI2{7-\u0019;j_:\u001cH\u0003BAH\u0003+\u0003BaNAI\u000b&\u0019\u00111S!\u0003\u0007M+\u0017\u000f\u0003\u0005\u0002\u0018\u0006%\u0005\u0019AAA\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u0002\u001c\u0002!\t%!(\u0002\u000f\r|W\u000e];uKR)!)a(\u0002\"\"A\u0011qSAM\u0001\u0004\t\t\t\u0003\u0005\u0002$\u0006e\u0005\u0019AAS\u0003\u0011\u0019G\u000f\u001f;\u0011\t\u0005\r\u0015qU\u0005\u0004\u0003SS!a\u0003+bg.\u001cuN\u001c;fqR\u0004")
public class StateStoreRDD<T, U>
extends RDD<U> {
    private final RDD<T> dataRDD;
    private final Function2<StateStore, Iterator<T>, Iterator<U>> storeUpdateFunction;
    private final String checkpointLocation;
    private final UUID queryRunId;
    private final long operatorId;
    private final long storeVersion;
    private final StructType keySchema;
    private final StructType valueSchema;
    private final Option<Object> indexOrdinal;
    private final transient Option<StateStoreCoordinatorRef> storeCoordinator;
    private final StateStoreConf storeConf;
    private final Broadcast<SerializableConfiguration> hadoopConfBroadcast;

    private Option<StateStoreCoordinatorRef> storeCoordinator() {
        return this.storeCoordinator;
    }

    private StateStoreConf storeConf() {
        return this.storeConf;
    }

    private Broadcast<SerializableConfiguration> hadoopConfBroadcast() {
        return this.hadoopConfBroadcast;
    }

    public Partition[] getPartitions() {
        return this.dataRDD.partitions();
    }

    public Seq<String> getPreferredLocations(Partition partition) {
        StateStoreProviderId stateStoreProviderId = new StateStoreProviderId(new StateStoreId(this.checkpointLocation, this.operatorId, partition.index(), StateStoreId$.MODULE$.apply$default$4()), this.queryRunId);
        return Option$.MODULE$.option2Iterable(this.storeCoordinator().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getLocation(stateStoreProviderId))).toSeq();
    }

    public Iterator<U> compute(Partition partition, TaskContext ctxt) {
        long l;
        StateStore store = null;
        StateStoreProviderId storeProviderId = new StateStoreProviderId(new StateStoreId(this.checkpointLocation, this.operatorId, partition.index(), StateStoreId$.MODULE$.apply$default$4()), this.queryRunId);
        boolean isContinuous = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)ctxt.getLocalProperty(StreamExecution$.MODULE$.IS_CONTINUOUS_PROCESSING())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StateStoreRDD.$anonfun$compute$1(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        if (isContinuous) {
            Option<Object> epoch = EpochTracker$.MODULE$.getCurrentEpoch();
            Predef$.MODULE$.assert(epoch.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Current epoch must be defined for continuous processing streams.");
            l = BoxesRunTime.unboxToLong((Object)epoch.get());
        } else {
            l = this.storeVersion;
        }
        long currentVersion = l;
        store = StateStore$.MODULE$.get(storeProviderId, this.keySchema, this.valueSchema, this.indexOrdinal, currentVersion, this.storeConf(), ((SerializableConfiguration)this.hadoopConfBroadcast().value()).value());
        Iterator inputIter = this.dataRDD.iterator(partition, ctxt);
        return (Iterator)this.storeUpdateFunction.apply((Object)store, (Object)inputIter);
    }

    public static final /* synthetic */ boolean $anonfun$compute$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public StateStoreRDD(RDD<T> dataRDD, Function2<StateStore, Iterator<T>, Iterator<U>> storeUpdateFunction, String checkpointLocation, UUID queryRunId, long operatorId, long storeVersion, StructType keySchema, StructType valueSchema, Option<Object> indexOrdinal, SessionState sessionState, Option<StateStoreCoordinatorRef> storeCoordinator, ClassTag<T> evidence$1, ClassTag<U> evidence$2) {
        this.dataRDD = dataRDD;
        this.storeUpdateFunction = storeUpdateFunction;
        this.checkpointLocation = checkpointLocation;
        this.queryRunId = queryRunId;
        this.operatorId = operatorId;
        this.storeVersion = storeVersion;
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.indexOrdinal = indexOrdinal;
        this.storeCoordinator = storeCoordinator;
        super(dataRDD, evidence$2);
        this.storeConf = new StateStoreConf(sessionState.conf());
        this.hadoopConfBroadcast = dataRDD.context().broadcast((Object)new SerializableConfiguration(sessionState.newHadoopConf()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
    }
}

