/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.ui;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore;
import org.apache.spark.sql.execution.ui.SQLExecutionUIData;
import org.apache.spark.sql.execution.ui.SQLTab;
import org.apache.spark.sql.execution.ui.SparkPlanGraph;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u001f\tiQ\t_3dkRLwN\u001c)bO\u0016T!a\u0001\u0003\u0002\u0005UL'BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!U\u0001\"!E\n\u000e\u0003IQ!a\u0001\u0005\n\u0005Q\u0011\"!C,fEVK\u0005+Y4f!\t1\u0012$D\u0001\u0018\u0015\tA\u0002\"\u0001\u0005j]R,'O\\1m\u0013\tQrCA\u0004M_\u001e<\u0017N\\4\t\u0011q\u0001!\u0011!Q\u0001\nu\ta\u0001]1sK:$\bC\u0001\u0010 \u001b\u0005\u0011\u0011B\u0001\u0011\u0003\u0005\u0019\u0019\u0016\u000b\u0014+bE\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005y\u0001\u0001\"\u0002\u000f\"\u0001\u0004i\u0002bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\tgFd7\u000b^8sKV\t\u0011\u0006\u0005\u0002\u001fU%\u00111F\u0001\u0002\u0012'Fc\u0015\t\u001d9Ti\u0006$Xo]*u_J,\u0007BB\u0017\u0001A\u0003%\u0011&A\u0005tc2\u001cFo\u001c:fA!)q\u0006\u0001C!a\u00051!/\u001a8eKJ$\"!M#\u0011\u0007IbtH\u0004\u00024s9\u0011AgN\u0007\u0002k)\u0011aGD\u0001\u0007yI|w\u000e\u001e \n\u0003a\nQa]2bY\u0006L!AO\u001e\u0002\u000fA\f7m[1hK*\t\u0001(\u0003\u0002>}\t\u00191+Z9\u000b\u0005iZ\u0004C\u0001!D\u001b\u0005\t%B\u0001\"<\u0003\rAX\u000e\\\u0005\u0003\t\u0006\u0013AAT8eK\")aI\fa\u0001\u000f\u00069!/Z9vKN$\bC\u0001%P\u001b\u0005I%B\u0001&L\u0003\u0011AG\u000f\u001e9\u000b\u00051k\u0015aB:feZdW\r\u001e\u0006\u0002\u001d\u0006)!.\u0019<bq&\u0011\u0001+\u0013\u0002\u0013\u0011R$\boU3sm2,GOU3rk\u0016\u001cH\u000fC\u0003S\u0001\u0011%1+\u0001\u000eqY\u0006tg+[:vC2L'0\u0019;j_:\u0014Vm]8ve\u000e,7\u000f\u0006\u00022)\")a)\u0015a\u0001\u000f\")a\u000b\u0001C\u0005/\u0006\t\u0002\u000f\\1o-&\u001cX/\u00197ju\u0006$\u0018n\u001c8\u0015\tEB\u0016L\u001b\u0005\u0006\rV\u0003\ra\u0012\u0005\u00065V\u0003\raW\u0001\b[\u0016$(/[2t!\u0011a\u0006mY4\u000f\u0005us\u0006C\u0001\u001b<\u0013\ty6(\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u00141!T1q\u0015\ty6\b\u0005\u0002eK6\t1(\u0003\u0002gw\t!Aj\u001c8h!\ta\u0006.\u0003\u0002jE\n11\u000b\u001e:j]\u001eDQa[+A\u00021\fQa\u001a:ba\"\u0004\"AH7\n\u00059\u0014!AD*qCJ\\\u0007\u000b\\1o\u000fJ\f\u0007\u000f\u001b\u0005\u0006a\u0002!I!]\u0001\u0007U>\u0014WK\u0015'\u0015\u0007\u001d\u00148\u000fC\u0003G_\u0002\u0007q\tC\u0003u_\u0002\u00071-A\u0003k_\nLE\rC\u0003w\u0001\u0011%q/A\fqQf\u001c\u0018nY1m!2\fg\u000eR3tGJL\u0007\u000f^5p]R\u0011\u0011\u0007\u001f\u0005\u0006mV\u0004\ra\u001a")
public class ExecutionPage
extends WebUIPage
implements Logging {
    private final SQLTab parent;
    private final SQLAppStatusStore sqlStore;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SQLAppStatusStore sqlStore() {
        return this.sqlStore;
    }

    public Seq<Node> render(HttpServletRequest request) {
        String parameterExecutionId = UIUtils$.MODULE$.stripXSS(request.getParameter("id"));
        Predef$.MODULE$.require(parameterExecutionId != null && new StringOps(Predef$.MODULE$.augmentString(parameterExecutionId)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Missing execution id parameter");
        long executionId = new StringOps(Predef$.MODULE$.augmentString(parameterExecutionId)).toLong();
        NodeSeq content = (NodeSeq)this.sqlStore().execution(executionId).map((Function1 & Serializable & scala.Serializable)executionUIData -> {
            long currentTime = System.currentTimeMillis();
            long duration = BoxesRunTime.unboxToLong((Object)executionUIData.completionTime().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> currentTime)) - executionUIData.submissionTime();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("Submitted Time: "));
            $buf3.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            $buf3.$amp$plus((Object)UIUtils$.MODULE$.formatDate(executionUIData.submissionTime()));
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            $buf2.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("Duration: "));
            $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
            $buf5.$amp$plus((Object)UIUtils$.MODULE$.formatDuration(duration));
            $buf5.$amp$plus((Object)new Text("\n            "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
            $buf2.$amp$plus((Object)new Text("\n            "));
            $buf2.$amp$plus((Object)this.jobLinks$1(JobExecutionStatus.RUNNING, "Running Jobs:", request, (SQLExecutionUIData)executionUIData));
            $buf2.$amp$plus((Object)new Text("\n            "));
            $buf2.$amp$plus((Object)this.jobLinks$1(JobExecutionStatus.SUCCEEDED, "Succeeded Jobs:", request, (SQLExecutionUIData)executionUIData));
            $buf2.$amp$plus((Object)new Text("\n            "));
            $buf2.$amp$plus((Object)this.jobLinks$1(JobExecutionStatus.FAILED, "Failed Jobs:", request, (SQLExecutionUIData)executionUIData));
            $buf2.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n        "));
            Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            Map<Object, String> metrics = this.sqlStore().executionMetrics(executionId);
            SparkPlanGraph graph = this.sqlStore().planGraph(executionId);
            return (NodeSeq)((TraversableLike)summary.$plus$plus(this.planVisualization(request, metrics, graph), NodeSeq$.MODULE$.canBuildFrom())).$plus$plus(this.physicalPlanDescription(executionUIData.physicalPlanDescription()), NodeSeq$.MODULE$.canBuildFrom());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var2_1;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("No information to display for query "));
            $buf.$amp$plus((Object)BoxesRunTime.boxToLong((long)executionId));
            return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_1);
        });
        return UIUtils$.MODULE$.headerSparkPage(request, new StringBuilder(18).append("Details for Query ").append(executionId).toString(), (Function0 & Serializable & scala.Serializable)() -> content, (SparkUITab)this.parent, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5000)), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7(), UIUtils$.MODULE$.headerSparkPage$default$8());
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> planVisualizationResources(HttpServletRequest request) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md);
        $md = new UnprefixedAttribute("href", UIUtils$.MODULE$.prependBaseUri(request, "/static/sql/spark-sql-viz.css", UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("src", UIUtils$.MODULE$.prependBaseUri(request, "/static/d3.min.js", UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("src", UIUtils$.MODULE$.prependBaseUri(request, "/static/dagre-d3.min.js", UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("src", UIUtils$.MODULE$.prependBaseUri(request, "/static/graphlib-dot.min.js", UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("src", UIUtils$.MODULE$.prependBaseUri(request, "/static/sql/spark-sql-viz.js", UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        return var2_2;
    }

    private Seq<Node> planVisualization(HttpServletRequest request, Map<Object, String> metrics, SparkPlanGraph graph) {
        Seq metadata = (Seq)graph.allNodes().flatMap((Function1 & Serializable & scala.Serializable)node -> {
            void var3_3;
            String nodeId = new StringBuilder(15).append("plan-meta-data-").append(node.id()).toString();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("id", nodeId, (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)node.desc());
            return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
        }, Seq$.MODULE$.canBuildFrom());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("id", (Seq)new Text("plan-viz-graph"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("style", (Seq)new Text("display:none"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("plan-viz-metadata"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("dot-file"), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)graph.makeDotFile(metrics));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("plan-viz-metadata-size"), (MetaData)$md4);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)graph.allNodes().size())).toString());
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)metadata);
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(this.planVisualizationResources(request));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("$(function() { renderPlanViz(); })"));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private String jobURL(HttpServletRequest request, long jobId) {
        return new StringOps(Predef$.MODULE$.augmentString("%s/jobs/job/?id=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), BoxesRunTime.boxToLong((long)jobId)}));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> physicalPlanDescription(String physicalPlanDescription) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onclick", (Seq)new Text("clickPhysicalPlanDetails();"), (MetaData)$md);
        $md = new UnprefixedAttribute("style", (Seq)new Text("cursor: pointer;"), (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("arrow-closed"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("physical-plan-details-arrow"), (MetaData)$md2);
        $buf3.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf3.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Details"));
        $buf3.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("display: none;"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("id", (Seq)new Text("physical-plan-details"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)physicalPlanDescription);
        $buf5.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      function clickPhysicalPlanDetails() {\n        $('#physical-plan-details').toggle();\n        $('#physical-plan-details-arrow').toggleClass('arrow-open').toggleClass('arrow-closed');\n      }\n    "));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ NodeBuffer $anonfun$render$6(ExecutionPage $this, HttpServletRequest request$1, int jobId) {
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", $this.jobURL(request$1, Predef$.MODULE$.int2Integer(jobId).intValue()), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)jobId)).toString());
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new EntityRef("nbsp"));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        return var3_3;
    }

    private final Seq jobLinks$1(JobExecutionStatus status, String label, HttpServletRequest request$1, SQLExecutionUIData executionUIData$1) {
        Nil$ nil$;
        scala.collection.immutable.Iterable jobs = (scala.collection.immutable.Iterable)executionUIData$1.jobs().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JobExecutionStatus jobStatus;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int jobId = tuple2._1$mcI$sp();
            JobExecutionStatus jobExecutionStatus = jobStatus = (JobExecutionStatus)tuple2._2();
            JobExecutionStatus jobExecutionStatus2 = status;
            Iterable iterable = !(jobExecutionStatus != null ? !jobExecutionStatus.equals(jobExecutionStatus2) : jobExecutionStatus2 != null) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToInteger((int)jobId))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom());
        if (jobs.nonEmpty()) {
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)label);
            $buf2.$amp$plus((Object)new Text(" "));
            $buf.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n            "));
            $buf.$amp$plus(((TraversableLike)jobs.toSeq().sorted((Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)jobId -> ExecutionPage.$anonfun$render$6(this, request$1, BoxesRunTime.unboxToInt((Object)jobId)), Seq$.MODULE$.canBuildFrom()));
            $buf.$amp$plus((Object)new Text("\n          "));
            Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            nil$ = elem;
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public ExecutionPage(SQLTab parent) {
        this.parent = parent;
        super("execution");
        Logging.$init$((Logging)this);
        this.sqlStore = parent.sqlStore();
    }
}

