/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalog.Column;
import org.apache.spark.sql.catalog.Database;
import org.apache.spark.sql.catalog.Function;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.DefinedByConstructorParams;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.internal.CatalogImpl$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\ra\u0001B\u0001\u0003\u00015\u00111bQ1uC2|w-S7qY*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tqaY1uC2|w-\u0003\u0002\u0014!\t91)\u0019;bY><\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!\u0001D*qCJ\\7+Z:tS>t\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e?A\u0011a\u0004A\u0007\u0002\u0005!)QC\u0007a\u0001-!)\u0011\u0005\u0001C\u0005E\u0005q1/Z:tS>t7)\u0019;bY><W#A\u0012\u0011\u0005\u0011BS\"A\u0013\u000b\u0005E1#BA\u0014\u0005\u0003!\u0019\u0017\r^1msN$\u0018BA\u0015&\u00059\u0019Vm]:j_:\u001c\u0015\r^1m_\u001eDQa\u000b\u0001\u0005\n1\nQC]3rk&\u0014X\rR1uC\n\f7/Z#ySN$8\u000f\u0006\u0002.gA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t!QK\\5u\u0011\u0015!$\u00061\u00016\u0003\u0019!'MT1nKB\u0011a'\u0010\b\u0003om\u0002\"\u0001O\u0018\u000e\u0003eR!A\u000f\u0007\u0002\rq\u0012xn\u001c;?\u0013\tat&\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f0\u0011\u0015\t\u0005\u0001\"\u0003C\u0003I\u0011X-];je\u0016$\u0016M\u00197f\u000bbL7\u000f^:\u0015\u00075\u001aE\tC\u00035\u0001\u0002\u0007Q\u0007C\u0003F\u0001\u0002\u0007Q'A\u0005uC\ndWMT1nK\")q\t\u0001C!\u0011\u0006y1-\u001e:sK:$H)\u0019;bE\u0006\u001cX-F\u00016\u0011\u0015Q\u0005\u0001\"\u0011L\u0003I\u0019X\r^\"veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\u0015\u00055b\u0005\"\u0002\u001bJ\u0001\u0004)\u0004fA%O)B\u0019afT)\n\u0005A{#A\u0002;ie><8\u000f\u0005\u0002\u0018%&\u00111\u000b\u0002\u0002\u0012\u0003:\fG._:jg\u0016C8-\u001a9uS>t\u0017%A+\u0002/\u0011\fG/\u00192bg\u0016\u0004Cm\\3tA9|G\u000fI3ySN$\b\"B,\u0001\t\u0003B\u0016!\u00047jgR$\u0015\r^1cCN,7\u000fF\u0001Z!\r9\"\fX\u0005\u00037\u0012\u0011q\u0001R1uCN,G\u000f\u0005\u0002\u0010;&\u0011a\f\u0005\u0002\t\t\u0006$\u0018MY1tK\")\u0001\r\u0001C\u0005C\u0006aQ.Y6f\t\u0006$\u0018MY1tKR\u0011AL\u0019\u0005\u0006i}\u0003\r!\u000e\u0005\u0006I\u0002!\t%Z\u0001\u000bY&\u001cH\u000fV1cY\u0016\u001cH#\u00014\u0011\u0007]Qv\r\u0005\u0002\u0010Q&\u0011\u0011\u000e\u0005\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006I\u0002!\te\u001b\u000b\u0003M2DQ\u0001\u000e6A\u0002UB3A\u001b(U\u0011\u0015y\u0007\u0001\"\u0003q\u0003%i\u0017m[3UC\ndW\r\u0006\u0002hc\")!O\u001ca\u0001g\u0006QA/\u00192mK&#WM\u001c;\u0011\u0005Q,X\"\u0001\u0014\n\u0005Y4#a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u000ba\u0004A\u0011I=\u0002\u001b1L7\u000f\u001e$v]\u000e$\u0018n\u001c8t)\u0005Q\bcA\f[wB\u0011q\u0002`\u0005\u0003{B\u0011\u0001BR;oGRLwN\u001c\u0005\u0006q\u0002!\te \u000b\u0004u\u0006\u0005\u0001\"\u0002\u001b\u007f\u0001\u0004)\u0004f\u0001@O)\"9\u0011q\u0001\u0001\u0005\n\u0005%\u0011\u0001D7bW\u00164UO\\2uS>tGcA>\u0002\f!A\u0011QBA\u0003\u0001\u0004\ty!A\u0005gk:\u001c\u0017\nZ3oiB\u0019A/!\u0005\n\u0007\u0005MaE\u0001\nGk:\u001cG/[8o\u0013\u0012,g\u000e^5gS\u0016\u0014\bbBA\f\u0001\u0011\u0005\u0013\u0011D\u0001\fY&\u001cHoQ8mk6t7\u000f\u0006\u0003\u0002\u001c\u0005\r\u0002\u0003B\f[\u0003;\u00012aDA\u0010\u0013\r\t\t\u0003\u0005\u0002\u0007\u0007>dW/\u001c8\t\r\u0015\u000b)\u00021\u00016Q\u0015\t)BTA\u0014C\t\tI#\u0001\u000buC\ndW\r\t3pKN\u0004cn\u001c;!KbL7\u000f\u001e\u0005\b\u0003/\u0001A\u0011IA\u0017)\u0019\tY\"a\f\u00022!1A'a\u000bA\u0002UBa!RA\u0016\u0001\u0004)\u0004&BA\u0016\u001d\u0006U\u0012EAA\u001c\u0003\u0001\"\u0017\r^1cCN,\u0007e\u001c:!i\u0006\u0014G.\u001a\u0011e_\u0016\u001c\bE\\8uA\u0015D\u0018n\u001d;\t\u000f\u0005]\u0001\u0001\"\u0003\u0002<Q!\u00111DA\u001f\u0011\u001d\ty$!\u000fA\u0002M\fq\u0002^1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\b\u0003\u0007\u0002A\u0011IA#\u0003-9W\r\u001e#bi\u0006\u0014\u0017m]3\u0015\u0007q\u000b9\u0005\u0003\u00045\u0003\u0003\u0002\r!\u000e\u0005\b\u0003\u0017\u0002A\u0011IA'\u0003!9W\r\u001e+bE2,GcA4\u0002P!1Q)!\u0013A\u0002UBq!a\u0013\u0001\t\u0003\n\u0019\u0006F\u0003h\u0003+\n9\u0006\u0003\u00045\u0003#\u0002\r!\u000e\u0005\u0007\u000b\u0006E\u0003\u0019A\u001b\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^\u0005Yq-\u001a;Gk:\u001cG/[8o)\rY\u0018q\f\u0005\b\u0003C\nI\u00061\u00016\u000311WO\\2uS>tg*Y7f\u0011\u001d\tY\u0006\u0001C!\u0003K\"Ra_A4\u0003SBa\u0001NA2\u0001\u0004)\u0004bBA1\u0003G\u0002\r!\u000e\u0005\b\u0003[\u0002A\u0011IA8\u00039!\u0017\r^1cCN,W\t_5tiN$B!!\u001d\u0002xA\u0019a&a\u001d\n\u0007\u0005UtFA\u0004C_>dW-\u00198\t\rQ\nY\u00071\u00016\u0011\u001d\tY\b\u0001C!\u0003{\n1\u0002^1cY\u0016,\u00050[:ugR!\u0011\u0011OA@\u0011\u0019)\u0015\u0011\u0010a\u0001k!9\u00111\u0010\u0001\u0005B\u0005\rECBA9\u0003\u000b\u000b9\t\u0003\u00045\u0003\u0003\u0003\r!\u000e\u0005\u0007\u000b\u0006\u0005\u0005\u0019A\u001b\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\u0006qa-\u001e8di&|g.\u0012=jgR\u001cH\u0003BA9\u0003\u001fCq!!\u0019\u0002\n\u0002\u0007Q\u0007C\u0004\u0002\f\u0002!\t%a%\u0015\r\u0005E\u0014QSAL\u0011\u0019!\u0014\u0011\u0013a\u0001k!9\u0011\u0011MAI\u0001\u0004)\u0004bBAN\u0001\u0011\u0005\u0013QT\u0001\fGJ,\u0017\r^3UC\ndW\r\u0006\u0004\u0002 \u0006u\u0016q\u0018\t\u0005\u0003C\u000b9L\u0004\u0003\u0002$\u0006Mf\u0002BAS\u0003csA!a*\u00020:!\u0011\u0011VAW\u001d\rA\u00141V\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0007\u0005UF!A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00161\u0018\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!.\u0005\u0011\u0019)\u0015\u0011\u0014a\u0001k!9\u0011\u0011YAM\u0001\u0004)\u0014\u0001\u00029bi\"DC!!'\u0002FB!\u0011qYAg\u001b\t\tIMC\u0002\u0002L\u001a\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty-!3\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\t\u000f\u0005m\u0005\u0001\"\u0011\u0002TRA\u0011qTAk\u0003/\fI\u000e\u0003\u0004F\u0003#\u0004\r!\u000e\u0005\b\u0003\u0003\f\t\u000e1\u00016\u0011\u001d\tY.!5A\u0002U\naa]8ve\u000e,\u0007\u0006BAi\u0003\u000bDq!a'\u0001\t\u0003\n\t\u000f\u0006\u0005\u0002 \u0006\r\u0018Q]At\u0011\u0019)\u0015q\u001ca\u0001k!9\u00111\\Ap\u0001\u0004)\u0004\u0002CAu\u0003?\u0004\r!a;\u0002\u000f=\u0004H/[8ogB)a'!<6k%\u0019\u0011q^ \u0003\u00075\u000b\u0007\u000f\u000b\u0003\u0002`\u0006\u0015\u0007bBAN\u0001\u0011\u0005\u0013Q\u001f\u000b\u000b\u0003?\u000b90!?\u0002|\n-\u0001BB#\u0002t\u0002\u0007Q\u0007C\u0004\u0002\\\u0006M\b\u0019A\u001b\t\u0011\u0005u\u00181\u001fa\u0001\u0003\u007f\faa]2iK6\f\u0007\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\u0007\t\u0015A!A\u0003usB,7/\u0003\u0003\u0003\n\t\r!AC*ueV\u001cG\u000fV=qK\"A\u0011\u0011^Az\u0001\u0004\tY\u000f\u000b\u0003\u0002t\u0006\u0015\u0007b\u0002B\t\u0001\u0011\u0005#1C\u0001\rIJ|\u0007\u000fV3naZKWm\u001e\u000b\u0005\u0003c\u0012)\u0002C\u0004\u0003\u0018\t=\u0001\u0019A\u001b\u0002\u0011YLWm\u001e(b[\u0016DqAa\u0007\u0001\t\u0003\u0012i\"\u0001\nee>\u0004x\t\\8cC2$V-\u001c9WS\u0016<H\u0003BA9\u0005?AqAa\u0006\u0003\u001a\u0001\u0007Q\u0007C\u0004\u0003$\u0001!\tE!\n\u0002#I,7m\u001c<feB\u000b'\u000f^5uS>t7\u000fF\u0002.\u0005OAa!\u0012B\u0011\u0001\u0004)\u0004b\u0002B\u0016\u0001\u0011\u0005#QF\u0001\tSN\u001c\u0015m\u00195fIR!\u0011\u0011\u000fB\u0018\u0011\u0019)%\u0011\u0006a\u0001k!9!1\u0007\u0001\u0005B\tU\u0012AC2bG\",G+\u00192mKR\u0019QFa\u000e\t\r\u0015\u0013\t\u00041\u00016\u0011\u001d\u0011\u0019\u0004\u0001C!\u0005w!R!\fB\u001f\u0005\u007fAa!\u0012B\u001d\u0001\u0004)\u0004\u0002\u0003B!\u0005s\u0001\rAa\u0011\u0002\u0019M$xN]1hK2+g/\u001a7\u0011\t\t\u0015#1J\u0007\u0003\u0005\u000fR1A!\u0013\u0007\u0003\u001d\u0019Ho\u001c:bO\u0016LAA!\u0014\u0003H\ta1\u000b^8sC\u001e,G*\u001a<fY\"9!\u0011\u000b\u0001\u0005B\tM\u0013\u0001D;oG\u0006\u001c\u0007.\u001a+bE2,GcA\u0017\u0003V!1QIa\u0014A\u0002UBqA!\u0017\u0001\t\u0003\u0012Y&\u0001\u0006dY\u0016\f'oQ1dQ\u0016$\u0012!\f\u0005\t\u0005W\u0001A\u0011\u0003\u0003\u0003`Q!\u0011\u0011\u000fB1\u0011!\u0011\u0019G!\u0018A\u0002\t\u0015\u0014!B9OC6,\u0007\u0007\u0002B4\u0005[\u0002Ba\u0006.\u0003jA!!1\u000eB7\u0019\u0001!ABa\u001c\u0003b\u0005\u0005\t\u0011!B\u0001\u0005c\u00121a\u0018\u00132#\u0011\u0011\u0019H!\u001f\u0011\u00079\u0012)(C\u0002\u0003x=\u0012qAT8uQ&tw\rE\u0002/\u0005wJ1A! 0\u0005\r\te.\u001f\u0005\b\u0005\u0003\u0003A\u0011\tBB\u00031\u0011XM\u001a:fg\"$\u0016M\u00197f)\ri#Q\u0011\u0005\u0007\u000b\n}\u0004\u0019A\u001b\t\u000f\t%\u0005\u0001\"\u0011\u0003\f\u0006i!/\u001a4sKND')\u001f)bi\"$2!\fBG\u0011\u001d\u0011yIa\"A\u0002U\nAB]3t_V\u00148-\u001a)bi\"<\u0001Ba%\u0003\u0011\u0003!!QS\u0001\f\u0007\u0006$\u0018\r\\8h\u00136\u0004H\u000eE\u0002\u001f\u0005/3q!\u0001\u0002\t\u0002\u0011\u0011Ij\u0005\u0003\u0003\u0018\nm\u0005c\u0001\u0018\u0003\u001e&\u0019!qT\u0018\u0003\r\u0005s\u0017PU3g\u0011\u001dY\"q\u0013C\u0001\u0005G#\"A!&\t\u0011\t\u001d&q\u0013C\u0001\u0005S\u000b1\"\\1lK\u0012\u000bG/Y:fiV!!1\u0016BZ)\u0019\u0011iK!=\u0004\u0002Q!!q\u0016B`!\u00119\"L!-\u0011\t\t-$1\u0017\u0003\t\u0005k\u0013)K1\u0001\u00038\n\tA+\u0005\u0003\u0003t\te\u0006c\u0001;\u0003<&\u0019!Q\u0018\u0014\u00035\u0011+g-\u001b8fI\nK8i\u001c8tiJ,8\r^8s!\u0006\u0014\u0018-\\:\t\u0015\t\u0005'QUA\u0001\u0002\b\u0011\u0019-\u0001\u0006fm&$WM\\2fIE\u0002bA!2\u0003f\nEf\u0002\u0002Bd\u0005?tAA!3\u0003\\:!!1\u001aBk\u001d\u0011\u0011iM!5\u000f\u0007a\u0012y-C\u00011\u0013\r\u0011\u0019nL\u0001\be\u00164G.Z2u\u0013\u0011\u00119N!7\u0002\u000fI,h\u000e^5nK*\u0019!1[\u0018\n\t\u0005U&Q\u001c\u0006\u0005\u0005/\u0014I.\u0003\u0003\u0003b\n\r\u0018\u0001C;oSZ,'o]3\u000b\t\u0005U&Q\\\u0005\u0005\u0005O\u0014IOA\u0004UsB,G+Y4\n\t\t-(Q\u001e\u0002\t)f\u0004X\rV1hg*!!q\u001eBm\u0003\r\t\u0007/\u001b\u0005\t\u0005g\u0014)\u000b1\u0001\u0003v\u0006!A-\u0019;b!\u0019\u00119Pa?\u00032:!!Q\u001aB}\u0013\r\t)lL\u0005\u0005\u0005{\u0014yPA\u0002TKFT1!!.0\u0011\u0019)\"Q\u0015a\u0001-\u0001")
public class CatalogImpl
extends Catalog {
    private final SparkSession sparkSession;

    public static <T extends DefinedByConstructorParams> Dataset<T> makeDataset(Seq<T> seq, SparkSession sparkSession, TypeTags.TypeTag<T> typeTag) {
        return CatalogImpl$.MODULE$.makeDataset(seq, sparkSession, typeTag);
    }

    private SessionCatalog sessionCatalog() {
        return this.sparkSession.sessionState().catalog();
    }

    private void requireDatabaseExists(String dbName) {
        if (!this.sessionCatalog().databaseExists(dbName)) {
            throw new AnalysisException(new StringBuilder(27).append("Database '").append(dbName).append("' does not exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void requireTableExists(String dbName, String tableName) {
        if (!this.sessionCatalog().tableExists(new TableIdentifier(tableName, (Option)new Some((Object)dbName)))) {
            throw new AnalysisException(new StringBuilder(39).append("Table '").append(tableName).append("' does not exist in database '").append(dbName).append("'.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    @Override
    public String currentDatabase() {
        return this.sessionCatalog().getCurrentDatabase();
    }

    @Override
    public void setCurrentDatabase(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        this.sessionCatalog().setCurrentDatabase(dbName);
    }

    @Override
    public Dataset<Database> listDatabases() {
        Seq databases = (Seq)this.sessionCatalog().listDatabases().map((Function1 & Serializable & scala.Serializable)dbName -> this.makeDatabase((String)dbName), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Database").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(databases, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(null)));
    }

    private Database makeDatabase(String dbName) {
        CatalogDatabase metadata = this.sessionCatalog().getDatabaseMetadata(dbName);
        return new Database(metadata.name(), metadata.description(), CatalogUtils$.MODULE$.URIToString(metadata.locationUri()));
    }

    @Override
    public Dataset<Table> listTables() {
        return this.listTables(this.currentDatabase());
    }

    @Override
    public Dataset<Table> listTables(String dbName) throws AnalysisException {
        Seq tables = (Seq)this.sessionCatalog().listTables(dbName).map((Function1 & Serializable & scala.Serializable)tableIdent -> this.makeTable((TableIdentifier)tableIdent), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Table").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(tables, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1(null)));
    }

    private Table makeTable(TableIdentifier tableIdent) {
        Some some;
        try {
            some = new Some((Object)this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        Some metadata = some;
        boolean isTemp = this.sessionCatalog().isTemporaryTable(tableIdent);
        return new Table(tableIdent.table(), (String)((Option)metadata.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.identifier().database()).getOrElse((Function0 & Serializable & scala.Serializable)() -> tableIdent.database())).orNull(Predef$.MODULE$.$conforms()), (String)metadata.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.comment().orNull(Predef$.MODULE$.$conforms())).orNull(Predef$.MODULE$.$conforms()), isTemp ? "TEMPORARY" : (String)metadata.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.tableType().name()).orNull(Predef$.MODULE$.$conforms()), isTemp);
    }

    @Override
    public Dataset<Function> listFunctions() {
        return this.listFunctions(this.currentDatabase());
    }

    @Override
    public Dataset<Function> listFunctions(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        Seq functions2 = (Seq)this.sessionCatalog().listFunctions(dbName).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FunctionIdentifier functIdent = (FunctionIdentifier)tuple2._1();
            Function function = this.makeFunction(functIdent);
            return function;
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Function").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(functions2, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1(null)));
    }

    private Function makeFunction(FunctionIdentifier funcIdent) {
        ExpressionInfo metadata = this.sessionCatalog().lookupFunctionInfo(funcIdent);
        return new Function(metadata.getName(), metadata.getDb(), null, metadata.getClassName(), metadata.getDb() == null);
    }

    @Override
    public Dataset<Column> listColumns(String tableName) throws AnalysisException {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.listColumns(tableIdent);
    }

    @Override
    public Dataset<Column> listColumns(String dbName, String tableName) throws AnalysisException {
        this.requireTableExists(dbName, tableName);
        return this.listColumns(new TableIdentifier(tableName, (Option)new Some((Object)dbName)));
    }

    private Dataset<Column> listColumns(TableIdentifier tableIdentifier) {
        CatalogTable tableMetadata = this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdentifier);
        Set partitionColumnNames = tableMetadata.partitionColumnNames().toSet();
        Set bucketColumnNames = ((TraversableOnce)tableMetadata.bucketSpec().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.bucketColumnNames()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).toSet();
        Seq columns = (Seq)tableMetadata.schema().map((Function1 & Serializable & scala.Serializable)c -> new Column(c.name(), (String)c.getComment().orNull(Predef$.MODULE$.$conforms()), c.dataType().catalogString(), c.nullable(), partitionColumnNames.contains((Object)c.name()), bucketColumnNames.contains((Object)c.name())), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Column").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(columns, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1(null)));
    }

    @Override
    public Database getDatabase(String dbName) {
        return this.makeDatabase(dbName);
    }

    @Override
    public Table getTable(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.getTable((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public Table getTable(String dbName, String tableName) {
        if (!this.tableExists(dbName, tableName)) {
            throw new AnalysisException(new StringBuilder(41).append("Table or view '").append(tableName).append("' not found in database '").append(dbName).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.makeTable(new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public Function getFunction(String functionName) {
        FunctionIdentifier functionIdent = this.sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.getFunction((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public Function getFunction(String dbName, String functionName) {
        return this.makeFunction(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public boolean databaseExists(String dbName) {
        return this.sessionCatalog().databaseExists(dbName);
    }

    @Override
    public boolean tableExists(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.tableExists((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public boolean tableExists(String dbName, String tableName) {
        TableIdentifier tableIdent = new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName));
        return this.sessionCatalog().isTemporaryTable(tableIdent) || this.sessionCatalog().tableExists(tableIdent);
    }

    @Override
    public boolean functionExists(String functionName) {
        FunctionIdentifier functionIdent = this.sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.functionExists((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public boolean functionExists(String dbName, String functionName) {
        return this.sessionCatalog().functionExists(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String path) {
        String dataSourceName = this.sparkSession.sessionState().conf().defaultDataSourceName();
        return this.createTable(tableName, path, dataSourceName);
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String path, String source) {
        return this.createTable(tableName, source, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)}))));
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String source, Map<String, String> options) {
        return this.createTable(tableName, source, new StructType(), options);
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String source, StructType schema, Map<String, String> options) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions(options);
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, schema, (Option)new Some((Object)source), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
        CreateTable plan = new CreateTable(tableDesc, SaveMode.ErrorIfExists, (Option<LogicalPlan>)None$.MODULE$);
        this.sparkSession.sessionState().executePlan(plan).toRdd();
        return this.sparkSession.table(tableIdent);
    }

    @Override
    public boolean dropTempView(String viewName) {
        return this.sparkSession.sessionState().catalog().getTempView(viewName).exists((Function1 & Serializable & scala.Serializable)viewDef -> BoxesRunTime.boxToBoolean((boolean)CatalogImpl.$anonfun$dropTempView$1(this, viewName, viewDef)));
    }

    @Override
    public boolean dropGlobalTempView(String viewName) {
        return this.sparkSession.sessionState().catalog().getGlobalTempView(viewName).exists((Function1 & Serializable & scala.Serializable)viewDef -> BoxesRunTime.boxToBoolean((boolean)CatalogImpl.$anonfun$dropGlobalTempView$1(this, viewName, viewDef)));
    }

    @Override
    public void recoverPartitions(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        this.sparkSession.sessionState().executePlan(new AlterTableRecoverPartitionsCommand(tableIdent, AlterTableRecoverPartitionsCommand$.MODULE$.apply$default$2())).toRdd();
    }

    @Override
    public boolean isCached(String tableName) {
        return this.sparkSession.sharedState().cacheManager().lookupCachedData(this.sparkSession.table(tableName)).nonEmpty();
    }

    @Override
    public void cacheTable(String tableName) {
        this.sparkSession.sharedState().cacheManager().cacheQuery(this.sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), this.sparkSession.sharedState().cacheManager().cacheQuery$default$3());
    }

    @Override
    public void cacheTable(String tableName, StorageLevel storageLevel) {
        this.sparkSession.sharedState().cacheManager().cacheQuery(this.sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), storageLevel);
    }

    @Override
    public void uncacheTable(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        boolean cascade = !this.sessionCatalog().isTemporaryTable(tableIdent);
        this.sparkSession.sharedState().cacheManager().uncacheQuery(this.sparkSession.table(tableName), cascade, this.sparkSession.sharedState().cacheManager().uncacheQuery$default$3());
    }

    @Override
    public void clearCache() {
        this.sparkSession.sharedState().cacheManager().clearCache();
    }

    public boolean isCached(Dataset<?> qName) {
        return this.sparkSession.sharedState().cacheManager().lookupCachedData(qName).nonEmpty();
    }

    @Override
    public void refreshTable(String tableName) {
        block2: {
            TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
            CatalogTable tableMetadata = this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent);
            Dataset<Row> table = this.sparkSession.table(tableIdent);
            CatalogTableType catalogTableType = tableMetadata.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                table.queryExecution().analyzed().refresh();
            } else {
                this.sessionCatalog().refreshTable(tableIdent);
            }
            if (!this.isCached(table)) break block2;
            this.sparkSession.sharedState().cacheManager().uncacheQuery(table, true, true);
            this.sparkSession.sharedState().cacheManager().cacheQuery(table, (Option<String>)new Some((Object)tableIdent.table()), this.sparkSession.sharedState().cacheManager().cacheQuery$default$3());
        }
    }

    @Override
    public void refreshByPath(String resourcePath) {
        this.sparkSession.sharedState().cacheManager().recacheByPath(this.sparkSession, resourcePath);
    }

    public static final /* synthetic */ boolean $anonfun$dropTempView$1(CatalogImpl $this, String viewName$1, LogicalPlan viewDef) {
        $this.sparkSession.sharedState().cacheManager().uncacheQuery($this.sparkSession, viewDef, false, true);
        return $this.sessionCatalog().dropTempView(viewName$1);
    }

    public static final /* synthetic */ boolean $anonfun$dropGlobalTempView$1(CatalogImpl $this, String viewName$2, LogicalPlan viewDef) {
        $this.sparkSession.sharedState().cacheManager().uncacheQuery($this.sparkSession, viewDef, false, true);
        return $this.sessionCatalog().dropGlobalTempView(viewName$2);
    }

    public CatalogImpl(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
    }
}

