/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.LongOffset$;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.MemoryStreamBase;
import org.apache.spark.sql.execution.streaming.MemoryStreamInputPartition;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\r-s!B\u001d;\u0011\u00039e!B%;\u0011\u0003Q\u0005\"\u0002+\u0002\t\u0003)\u0006b\u0002,\u0002\u0005\u0004%\tb\u0016\u0005\u0007I\u0006\u0001\u000b\u0011\u0002-\t\u000f\u0015\f!\u0019!C\t/\"1a-\u0001Q\u0001\naCQaZ\u0001\u0005\u0002!D\u0001bZ\u0001\u0002\u0002\u0013\u00055\u0011\u0003\u0005\n\u0007K\t\u0011\u0011!CA\u0007OA\u0011b!\u0011\u0002\u0003\u0003%Iaa\u0011\u0007\t%S\u0004i\u001b\u0005\u000b\u0003?Y!Q3A\u0005\u0002\u0005\u0005\u0002BCA\u0015\u0017\tE\t\u0015!\u0003\u0002$!Q\u00111F\u0006\u0003\u0016\u0004%\t!!\f\t\u0015\u0005]2B!E!\u0002\u0013\ty\u0003\u0003\u0006\u0002:-\u0011\u0019\u0011)A\u0006\u0003wAa\u0001V\u0006\u0005\u0002\u0005\u0005\u0003\"CA'\u0017\t\u0007I\u0011CA(\u0011!\t)g\u0003Q\u0001\n\u0005E\u0003\"CA4\u0017\t\u0007I\u0011CA5\u0011!\tyi\u0003Q\u0001\n\u0005-\u0004\"CAI\u0017\t\u0007I\u0011CAJ\u0011!\t\tl\u0003Q\u0001\n\u0005U\u0005\"CAg\u0017\u0001\u0007I\u0011CAh\u0011%\t9n\u0003a\u0001\n#\tI\u000e\u0003\u0005\u0002f.\u0001\u000b\u0015BAi\u0011%\tIo\u0003a\u0001\n#\ty\rC\u0005\u0002l.\u0001\r\u0011\"\u0005\u0002n\"A\u0011\u0011_\u0006!B\u0013\t\t\u000eC\u0005\u0002v.\u0001\r\u0011\"\u0003\u0002P\"I\u0011q_\u0006A\u0002\u0013%\u0011\u0011 \u0005\t\u0003{\\\u0001\u0015)\u0003\u0002R\"I!\u0011A\u0006A\u0002\u0013E\u0011q\u001a\u0005\n\u0005\u0007Y\u0001\u0019!C\t\u0005\u000bA\u0001B!\u0003\fA\u0003&\u0011\u0011\u001b\u0005\b\u0005\u001bYA\u0011\u0001B\b\u0011\u001d\u0011\tc\u0003C!\u0005GAqA!\u000e\f\t\u0003\u00129\u0004C\u0004\u0003N-!\tEa\u0014\t\u000f\tU3\u0002\"\u0011\u0003X!9!\u0011L\u0006\u0005B\t]\u0003b\u0002B.\u0017\u0011\u0005#Q\f\u0005\b\u0005kZA\u0011\u0002B<\u0011\u001d\u00119i\u0003C!\u0005\u0013CqA!$\f\t\u0003\u0012y\tC\u0004\u0003\u0012.!\tAa$\t\u0013\tM5\"!A\u0005\u0002\tU\u0005\"\u0003BU\u0017E\u0005I\u0011\u0001BV\u0011%\u0011\u0019mCI\u0001\n\u0003\u0011)\rC\u0005\u0003N.\t\t\u0011\"\u0011\u0003P\"I!1\\\u0006\u0002\u0002\u0013\u0005\u0011\u0011\u0005\u0005\n\u0005;\\\u0011\u0011!C\u0001\u0005?D\u0011Ba9\f\u0003\u0003%\tE!:\t\u0013\t=8\"!A\u0005\u0002\tE\b\"\u0003B~\u0017\u0005\u0005I\u0011\tB\u007f\u0011%\u0011ypCA\u0001\n\u0003\u001a\t!\u0001\u0007NK6|'/_*ue\u0016\fWN\u0003\u0002<y\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003{y\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005}\u0002\u0015aA:rY*\u0011\u0011IQ\u0001\u0006gB\f'o\u001b\u0006\u0003\u0007\u0012\u000ba!\u00199bG\",'\"A#\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005!\u000bQ\"\u0001\u001e\u0003\u00195+Wn\u001c:z'R\u0014X-Y7\u0014\u0007\u0005Y\u0015\u000b\u0005\u0002M\u001f6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJ\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0019JK!aU'\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u00059\u0015AD2veJ,g\u000e\u001e\"m_\u000e\\\u0017\nZ\u000b\u00021B\u0011\u0011LY\u0007\u00025*\u00111\fX\u0001\u0007CR|W.[2\u000b\u0005us\u0016AC2p]\u000e,(O]3oi*\u0011q\fY\u0001\u0005kRLGNC\u0001b\u0003\u0011Q\u0017M^1\n\u0005\rT&!D!u_6L7-\u00138uK\u001e,'/A\bdkJ\u0014XM\u001c;CY>\u001c7.\u00133!\u00039iW-\\8ssN#(/Z1n\u0013\u0012\fq\"\\3n_JL8\u000b\u001e:fC6LE\rI\u0001\u0006CB\u0004H._\u000b\u0004S\u000e\u001dA#\u00026\u0004\n\r=\u0001\u0003\u0002%\f\u0007\u000b)\"\u0001\u001c:\u0014\u0011-i70!\u0004\u0002\u001aE\u00032\u0001\u00138q\u0013\ty'H\u0001\tNK6|'/_*ue\u0016\fWNQ1tKB\u0011\u0011O\u001d\u0007\u0001\t\u0015\u00198B1\u0001u\u0005\u0005\t\u0015CA;y!\tae/\u0003\u0002x\u001b\n9aj\u001c;iS:<\u0007C\u0001'z\u0013\tQXJA\u0002B]f\u00042\u0001`A\u0005\u001b\u0005i(BA\u001e\u007f\u0015\ry\u0018\u0011A\u0001\u0007e\u0016\fG-\u001a:\u000b\t\u0005\r\u0011QA\u0001\u0003mJR1!a\u0002?\u0003\u001d\u0019x.\u001e:dKNL1!a\u0003~\u0005Ai\u0015n\u0019:p\u0005\u0006$8\r\u001b*fC\u0012,'\u000f\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019\u0002Q\u0001\tS:$XM\u001d8bY&!\u0011qCA\t\u0005\u001daunZ4j]\u001e\u00042\u0001TA\u000e\u0013\r\ti\"\u0014\u0002\b!J|G-^2u\u0003\tIG-\u0006\u0002\u0002$A\u0019A*!\n\n\u0007\u0005\u001dRJA\u0002J]R\f1!\u001b3!\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010^\u000b\u0003\u0003_\u0001B!!\r\u000245\ta(C\u0002\u00026y\u0012!bU)M\u0007>tG/\u001a=u\u0003-\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\u0011\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007E\u0003\u00022\u0005u\u0002/C\u0002\u0002@y\u0012q!\u00128d_\u0012,'\u000f\u0006\u0004\u0002D\u0005%\u00131\n\u000b\u0005\u0003\u000b\n9\u0005E\u0002I\u0017ADq!!\u000f\u0012\u0001\b\tY\u0004C\u0004\u0002 E\u0001\r!a\t\t\u000f\u0005-\u0012\u00031\u0001\u00020\u0005YAn\\4jG\u0006d\u0007\u000b\\1o+\t\t\t\u0006\u0005\u0003\u0002T\u0005\u0005TBAA+\u0015\u0011\t9&!\u0017\u0002\u000f1|w-[2bY*!\u00111LA/\u0003\u0015\u0001H.\u00198t\u0015\r\tyFP\u0001\tG\u0006$\u0018\r\\=ti&!\u00111MA+\u0005-aunZ5dC2\u0004F.\u00198\u0002\u00191|w-[2bYBc\u0017M\u001c\u0011\u0002\r=,H\u000f];u+\t\tY\u0007\u0005\u0004\u0002n\u0005u\u00141\u0011\b\u0005\u0003_\nIH\u0004\u0003\u0002r\u0005]TBAA:\u0015\r\t)HR\u0001\u0007yI|w\u000e\u001e \n\u00039K1!a\u001fN\u0003\u001d\u0001\u0018mY6bO\u0016LA!a \u0002\u0002\n\u00191+Z9\u000b\u0007\u0005mT\n\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\u0011\tI)!\u0018\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003\u001b\u000b9IA\u0005BiR\u0014\u0018NY;uK\u00069q.\u001e;qkR\u0004\u0013a\u00022bi\u000eDWm]\u000b\u0003\u0003+\u0003b!a&\u0002\"\u0006\u0015VBAAM\u0015\u0011\tY*!(\u0002\u000f5,H/\u00192mK*\u0019\u0011qT'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002$\u0006e%A\u0003'jgR\u0014UO\u001a4feB)A*a*\u0002,&\u0019\u0011\u0011V'\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\u0015\u0015QV\u0005\u0005\u0003_\u000b9IA\u0005V]N\fg-\u001a*po\u0006A!-\u0019;dQ\u0016\u001c\b\u0005K\u0004\u0018\u0003k\u000b9-!3\u0011\t\u0005]\u00161Y\u0007\u0003\u0003sS1!XA^\u0015\u0011\ti,a0\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u0002B\u0006)!.\u0019<bq&!\u0011QYA]\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-\t\u0002\u0002L\u0006!A\u000f[5t\u00035\u0019WO\u001d:f]R|eMZ:fiV\u0011\u0011\u0011\u001b\t\u0004\u0011\u0006M\u0017bAAku\tQAj\u001c8h\u001f\u001a47/\u001a;\u0002#\r,(O]3oi>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0002\\\u0006\u0005\bc\u0001'\u0002^&\u0019\u0011q\\'\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003GL\u0012\u0011!a\u0001\u0003#\f1\u0001\u001f\u00132\u00039\u0019WO\u001d:f]R|eMZ:fi\u0002BsAGA[\u0003\u000f\fI-A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\u0018aD:uCJ$xJ\u001a4tKR|F%Z9\u0015\t\u0005m\u0017q\u001e\u0005\n\u0003Gd\u0012\u0011!a\u0001\u0003#\fAb\u001d;beR|eMZ:fi\u0002Bs!HA[\u0003\u000f\fI-A\u0005f]\u0012|eMZ:fi\u0006iQM\u001c3PM\u001a\u001cX\r^0%KF$B!a7\u0002|\"I\u00111]\u0010\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\u000bK:$wJ\u001a4tKR\u0004\u0003f\u0002\u0011\u00026\u0006\u001d\u0017\u0011Z\u0001\u0014Y\u0006\u001cHo\u00144gg\u0016$8i\\7nSR$X\rZ\u0001\u0018Y\u0006\u001cHo\u00144gg\u0016$8i\\7nSR$X\rZ0%KF$B!a7\u0003\b!I\u00111\u001d\u0012\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\u0015Y\u0006\u001cHo\u00144gg\u0016$8i\\7nSR$X\r\u001a\u0011)\u000f\r\n),a2\u0002J\u00069\u0011\r\u001a3ECR\fG\u0003\u0002B\t\u0005/\u00012\u0001\u0013B\n\u0013\r\u0011)B\u000f\u0002\u0007\u001f\u001a47/\u001a;\t\u000f\teA\u00051\u0001\u0003\u001c\u0005!A-\u0019;b!\u0015\tiG!\bq\u0013\u0011\u0011y\"!!\u0003\u001fQ\u0013\u0018M^3sg\u0006\u0014G.Z(oG\u0016\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005K\u0001BAa\n\u000309!!\u0011\u0006B\u0016!\r\t\t(T\u0005\u0004\u0005[i\u0015A\u0002)sK\u0012,g-\u0003\u0003\u00032\tM\"AB*ue&twMC\u0002\u0003.5\u000bab]3u\u001f\u001a47/\u001a;SC:<W\r\u0006\u0004\u0002\\\ne\"\u0011\n\u0005\b\u0005w1\u0003\u0019\u0001B\u001f\u0003\u0015\u0019H/\u0019:u!\u0019\u0011yD!\u0011\u0003F5\ta,C\u0002\u0003Dy\u0013\u0001b\u00149uS>t\u0017\r\u001c\t\u0004y\n\u001d\u0013b\u0001B\u000b{\"9!1\n\u0014A\u0002\tu\u0012aA3oI\u0006\tB-Z:fe&\fG.\u001b>f\u001f\u001a47/\u001a;\u0015\t\t\u0015#\u0011\u000b\u0005\b\u0005':\u0003\u0019\u0001B\u0013\u0003\u0011Q7o\u001c8\u0002\u001d\u001d,Go\u0015;beR|eMZ:fiR\u0011!QI\u0001\rO\u0016$XI\u001c3PM\u001a\u001cX\r^\u0001\u0014a2\fg.\u00138qkR\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0005?\u0002bAa\u0010\u0003b\t\u0015\u0014b\u0001B2=\n!A*[:u!\u0019\u00119G!\u001b\u0003n5\ta0C\u0002\u0003ly\u0014a\"\u00138qkR\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003p\tETBAA/\u0013\u0011\u0011\u0019(!\u0018\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0014O\u0016tWM]1uK\u0012+'-^4TiJLgn\u001a\u000b\t\u0005K\u0011IHa \u0003\u0004\"9!1P\u0016A\u0002\tu\u0014\u0001\u0002:poN\u0004b!!\u001c\u0002~\u0005-\u0006b\u0002BAW\u0001\u0007\u00111E\u0001\rgR\f'\u000f^(sI&t\u0017\r\u001c\u0005\b\u0005\u000b[\u0003\u0019AA\u0012\u0003))g\u000eZ(sI&t\u0017\r\\\u0001\u0007G>lW.\u001b;\u0015\t\u0005m'1\u0012\u0005\b\u0005\u0017b\u0003\u0019\u0001B#\u0003\u0011\u0019Ho\u001c9\u0015\u0005\u0005m\u0017!\u0002:fg\u0016$\u0018\u0001B2paf,BAa&\u0003 R1!\u0011\u0014BS\u0005O#BAa'\u0003\"B!\u0001j\u0003BO!\r\t(q\u0014\u0003\u0006g>\u0012\r\u0001\u001e\u0005\b\u0003sy\u00039\u0001BR!\u0019\t\t$!\u0010\u0003\u001e\"I\u0011qD\u0018\u0011\u0002\u0003\u0007\u00111\u0005\u0005\n\u0003Wy\u0003\u0013!a\u0001\u0003_\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0003.\n\u0005WC\u0001BXU\u0011\t\u0019C!-,\u0005\tM\u0006\u0003\u0002B[\u0005{k!Aa.\u000b\t\te&1X\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!0N\u0013\u0011\u0011yLa.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003ta\t\u0007A/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\t\t\u001d'1Z\u000b\u0003\u0005\u0013TC!a\f\u00032\u0012)1/\rb\u0001i\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!5\u0011\t\tM'\u0011\\\u0007\u0003\u0005+T1Aa6a\u0003\u0011a\u0017M\\4\n\t\tE\"Q[\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rA(\u0011\u001d\u0005\n\u0003G$\u0014\u0011!a\u0001\u0003G\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005O\u0004RA!;\u0003lbl!!!(\n\t\t5\u0018Q\u0014\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003t\ne\bc\u0001'\u0003v&\u0019!q_'\u0003\u000f\t{w\u000e\\3b]\"A\u00111\u001d\u001c\u0002\u0002\u0003\u0007\u00010\u0001\u0005iCND7i\u001c3f)\t\t\u0019#\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005g\u001c\u0019\u0001\u0003\u0005\u0002db\n\t\u00111\u0001y!\r\t8q\u0001\u0003\u0006g\u001e\u0011\r\u0001\u001e\u0005\n\u0007\u00179\u0011\u0011!a\u0002\u0007\u001b\t!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\t\t$!\u0010\u0004\u0006!9\u00111F\u0004A\u0004\u0005=R\u0003BB\n\u00077!ba!\u0006\u0004\"\r\rB\u0003BB\f\u0007;\u0001B\u0001S\u0006\u0004\u001aA\u0019\u0011oa\u0007\u0005\u000bMD!\u0019\u0001;\t\u000f\u0005e\u0002\u0002q\u0001\u0004 A1\u0011\u0011GA\u001f\u00073Aq!a\b\t\u0001\u0004\t\u0019\u0003C\u0004\u0002,!\u0001\r!a\f\u0002\u000fUt\u0017\r\u001d9msV!1\u0011FB )\u0011\u0019Yca\u000e\u0011\u000b1\u001bic!\r\n\u0007\r=RJ\u0001\u0004PaRLwN\u001c\t\b\u0019\u000eM\u00121EA\u0018\u0013\r\u0019)$\u0014\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\re\u0012\"!AA\u0002\rm\u0012a\u0001=%aA!\u0001jCB\u001f!\r\t8q\b\u0003\u0006g&\u0011\r\u0001^\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004FA!!1[B$\u0013\u0011\u0019IE!6\u0003\r=\u0013'.Z2u\u0001")
public class MemoryStream<A>
extends MemoryStreamBase<A>
implements MicroBatchReader,
Logging,
Product,
scala.Serializable {
    private final int id;
    private final SQLContext sqlContext;
    private final LogicalPlan logicalPlan;
    private final Seq<Attribute> output;
    @GuardedBy(value="this")
    private final ListBuffer<UnsafeRow[]> batches;
    @GuardedBy(value="this")
    private LongOffset currentOffset;
    @GuardedBy(value="this")
    private LongOffset startOffset;
    @GuardedBy(value="this")
    private LongOffset endOffset;
    @GuardedBy(value="this")
    private LongOffset lastOffsetCommitted;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <A> Option<Tuple2<Object, SQLContext>> unapply(MemoryStream<A> memoryStream) {
        return MemoryStream$.MODULE$.unapply(memoryStream);
    }

    public static <A> MemoryStream<A> apply(int n, SQLContext sQLContext, Encoder<A> encoder) {
        return MemoryStream$.MODULE$.apply(n, sQLContext, encoder);
    }

    public static <A> MemoryStream<A> apply(Encoder<A> encoder, SQLContext sQLContext) {
        return MemoryStream$.MODULE$.apply(encoder, sQLContext);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int id() {
        return this.id;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public LogicalPlan logicalPlan() {
        return this.logicalPlan;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public ListBuffer<UnsafeRow[]> batches() {
        return this.batches;
    }

    public LongOffset currentOffset() {
        return this.currentOffset;
    }

    public void currentOffset_$eq(LongOffset x$1) {
        this.currentOffset = x$1;
    }

    public LongOffset startOffset() {
        return this.startOffset;
    }

    public void startOffset_$eq(LongOffset x$1) {
        this.startOffset = x$1;
    }

    private LongOffset endOffset() {
        return this.endOffset;
    }

    private void endOffset_$eq(LongOffset x$1) {
        this.endOffset = x$1;
    }

    public LongOffset lastOffsetCommitted() {
        return this.lastOffsetCommitted;
    }

    public void lastOffsetCommitted_$eq(LongOffset x$1) {
        this.lastOffsetCommitted = x$1;
    }

    @Override
    public Offset addData(TraversableOnce<A> data) {
        LongOffset longOffset;
        Seq objects = data.toSeq();
        UnsafeRow[] rows = (UnsafeRow[])objects.iterator().map((Function1 & Serializable & scala.Serializable)d -> (UnsafeRow)this.encoder().toRow(d).copy()).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Adding: ").append(objects).toString());
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            this.currentOffset_$eq(this.currentOffset().$plus(1L));
            this.batches().$plus$eq((Object)rows);
            longOffset = this.currentOffset();
        }
        return longOffset;
    }

    public String toString() {
        return new StringBuilder(14).append("MemoryStream[").append(Utils$.MODULE$.truncatedString(this.output(), ",")).append("]").toString();
    }

    @Override
    public synchronized void setOffsetRange(Optional<org.apache.spark.sql.sources.v2.reader.streaming.Offset> start, Optional<org.apache.spark.sql.sources.v2.reader.streaming.Offset> end) {
        this.startOffset_$eq((LongOffset)start.orElse(new LongOffset(-1L)));
        this.endOffset_$eq((LongOffset)end.orElse(this.currentOffset()));
    }

    @Override
    public org.apache.spark.sql.sources.v2.reader.streaming.Offset deserializeOffset(String json) {
        return new LongOffset(new StringOps(Predef$.MODULE$.augmentString(json)).toLong());
    }

    @Override
    public synchronized org.apache.spark.sql.sources.v2.reader.streaming.Offset getStartOffset() {
        return this.startOffset().offset() == -1L ? null : this.startOffset();
    }

    @Override
    public synchronized org.apache.spark.sql.sources.v2.reader.streaming.Offset getEndOffset() {
        return this.endOffset().offset() == -1L ? null : this.endOffset();
    }

    @Override
    public synchronized List<InputPartition<InternalRow>> planInputPartitions() {
        ListBuffer listBuffer;
        int startOrdinal = (int)this.startOffset().offset() + 1;
        int endOrdinal = (int)this.endOffset().offset() + 1;
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            int sliceStart = startOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
            int sliceEnd = endOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
            Predef$.MODULE$.assert(sliceStart <= sliceEnd, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("sliceStart: ").append(sliceStart).append(" sliceEnd: ").append(sliceEnd).toString());
            listBuffer = (ListBuffer)this.batches().slice(sliceStart, sliceEnd);
        }
        ListBuffer newBlocks = listBuffer;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.generateDebugString((Seq<UnsafeRow>)((Seq)newBlocks.flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))), startOrdinal, endOrdinal));
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)newBlocks.map((Function1 & Serializable & scala.Serializable)block -> new MemoryStreamInputPartition((UnsafeRow[])block), ListBuffer$.MODULE$.canBuildFrom())).asJava();
    }

    private String generateDebugString(Seq<UnsafeRow> rows, int startOrdinal, int endOrdinal) {
        ExpressionEncoder expressionEncoder = this.encoder().resolveAndBind(this.encoder().resolveAndBind$default$1(), this.encoder().resolveAndBind$default$2());
        Function1 & Serializable & scala.Serializable fromRow = (Function1 & Serializable & scala.Serializable)row -> expressionEncoder.fromRow(row);
        return new StringBuilder(18).append("MemoryBatch [").append(startOrdinal).append(", ").append(endOrdinal).append("]: ").append(String.valueOf(((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> fromRow.apply(row), Seq$.MODULE$.canBuildFrom())).mkString(", "))).toString();
    }

    @Override
    public synchronized void commit(org.apache.spark.sql.sources.v2.reader.streaming.Offset end) {
        Option<LongOffset> option = LongOffset$.MODULE$.convert(end);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw package$.MODULE$.error(new StringBuilder(97).append("MemoryStream.commit() received an offset (").append(end).append(") ").append("that did not originate with an instance of this class").toString());
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        LongOffset lo = (LongOffset)some.value();
        this.check$1(lo, end);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public void stop() {
    }

    public synchronized void reset() {
        this.batches().clear();
        this.startOffset_$eq(new LongOffset(-1L));
        this.endOffset_$eq(new LongOffset(-1L));
        this.currentOffset_$eq(new LongOffset(-1L));
        this.lastOffsetCommitted_$eq(new LongOffset(-1L));
    }

    public <A> MemoryStream<A> copy(int id, SQLContext sqlContext, Encoder<A> evidence$3) {
        return new MemoryStream<A>(id, sqlContext, evidence$3);
    }

    public <A> int copy$default$1() {
        return this.id();
    }

    public <A> SQLContext copy$default$2() {
        return this.sqlContext();
    }

    public String productPrefix() {
        return "MemoryStream";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.id());
                break;
            }
            case 1: {
                object = this.sqlContext();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MemoryStream;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.id());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sqlContext()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MemoryStream)) return false;
        boolean bl = true;
        if (!bl) return false;
        MemoryStream memoryStream = (MemoryStream)x$1;
        if (this.id() != memoryStream.id()) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = memoryStream.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        if (!memoryStream.canEqual(this)) return false;
        return true;
    }

    private final void check$1(LongOffset newOffset, org.apache.spark.sql.sources.v2.reader.streaming.Offset end$1) {
        int offsetDiff = (int)(newOffset.offset() - this.lastOffsetCommitted().offset());
        if (offsetDiff < 0) {
            throw package$.MODULE$.error(new StringBuilder(45).append("Offsets committed out of order: ").append(this.lastOffsetCommitted()).append(" followed by ").append(end$1).toString());
        }
        this.batches().trimStart(offsetDiff);
        this.lastOffsetCommitted_$eq(newOffset);
    }

    public MemoryStream(int id, SQLContext sqlContext, Encoder<A> evidence$3) {
        this.id = id;
        this.sqlContext = sqlContext;
        super(sqlContext, evidence$3);
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.logicalPlan = new StreamingExecutionRelation(this, this.attributes(), sqlContext.sparkSession());
        this.output = this.logicalPlan().output();
        this.batches = new ListBuffer();
        this.currentOffset = new LongOffset(-1L);
        this.startOffset = new LongOffset(-1L);
        this.endOffset = new LongOffset(-1L);
        this.lastOffsetCommitted = new LongOffset(-1L);
    }
}

