/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.UUID;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.BaseStreamingSink;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.sources.v2.StreamWriteSupport;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Evolving
@ScalaSignature(bytes="\u0006\u0001\t5f\u0001\u0002\u0011\"\u00011B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0007}\u0001!\taI \t\u0011\r\u0003!\u0019!C\u0001G\u0011CaA\u0014\u0001!\u0002\u0013)\u0005bB(\u0001\u0005\u0004%I\u0001\u0015\u0005\u0007+\u0002\u0001\u000b\u0011B)\t\u000fY\u0003!\u0019!C\u0005/\"11\u000e\u0001Q\u0001\naCq!\u001f\u0001C\u0002\u0013%!\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011B>\t\u0011\u0005\u0015\u0001A1A\u0005\niDq!a\u0002\u0001A\u0003%1\u0010C\u0005\u0002\n\u0001\u0001\r\u0011\"\u0003\u0002\f!I\u0011Q\u0002\u0001A\u0002\u0013%\u0011q\u0002\u0005\b\u00037\u0001\u0001\u0015)\u0003i\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002,\u0001!\t!a\r\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u0011Q\n\u0001\u0005\u0002\u0005U\u0005bBAZ\u0001\u0011\u0005\u0011q\n\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000bD\u0001\"!3\u0001\t\u0003\u0019\u00131\u001a\u0005\b\u0003?\u0004A\u0011BAq\u0011!\u0011)\u0006\u0001C\u0001G\t]\u0003B\u0003B7\u0001E\u0005I\u0011A\u0012\u0003p!Q!1\u0011\u0001\u0012\u0002\u0013\u00051Ea\u001c\t\u0015\t\u0015\u0005!%A\u0005\u0002\r\u00129\t\u0003\u0006\u0003\f\u0002\t\n\u0011\"\u0001$\u0005\u001bC\u0001B!%\u0001\t\u0003\u0019#1\u0013\u0002\u0016'R\u0014X-Y7j]\u001e\fV/\u001a:z\u001b\u0006t\u0017mZ3s\u0015\t\u00113%A\u0005tiJ,\u0017-\\5oO*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!t'D\u00016\u0015\t1T%\u0001\u0005j]R,'O\\1m\u0013\tATGA\u0004M_\u001e<\u0017N\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005mbT\"A\u0012\n\u0005u\u001a#\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002A\u0005B\u0011\u0011\tA\u0007\u0002C!)\u0011H\u0001a\u0001u\u0005)2\u000f^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014X#A#\u0011\u0005\u0019cU\"A$\u000b\u0005!K\u0015!B:uCR,'B\u0001\u0012K\u0015\tY5%A\u0005fq\u0016\u001cW\u000f^5p]&\u0011Qj\u0012\u0002\u0019'R\fG/Z*u_J,7i\\8sI&t\u0017\r^8s%\u00164\u0017AF:uCR,7\u000b^8sK\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002\u00171L7\u000f^3oKJ\u0014Uo]\u000b\u0002#B\u0011!kU\u0007\u0002\u0013&\u0011A+\u0013\u0002\u001a'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe\n+8/\u0001\u0007mSN$XM\\3s\u0005V\u001c\b%A\u0007bGRLg/Z)vKJLWm]\u000b\u00021B!\u0011L\u00181i\u001b\u0005Q&BA.]\u0003\u001diW\u000f^1cY\u0016T!!X\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002`5\n9\u0001*Y:i\u001b\u0006\u0004\bCA1g\u001b\u0005\u0011'BA2e\u0003\u0011)H/\u001b7\u000b\u0003\u0015\fAA[1wC&\u0011qM\u0019\u0002\u0005+VKE\t\u0005\u0002BS&\u0011!.\t\u0002\u000f'R\u0014X-Y7j]\u001e\fV/\u001a:z\u00039\t7\r^5wKF+XM]5fg\u0002BC\u0001C7xqB\u0011a.^\u0007\u0002_*\u0011\u0001/]\u0001\u000bG>t7-\u001e:sK:$(B\u0001:t\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002i\u0006)!.\u0019<bq&\u0011ao\u001c\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f\u0013!_\u0001\u0012C\u000e$\u0018N^3Rk\u0016\u0014\u0018.Z:M_\u000e\\W#A>\u0011\u0005q|X\"A?\u000b\u0005y$\u0017\u0001\u00027b]\u001eL1!!\u0001~\u0005\u0019y%M[3di\u0006\u0011\u0012m\u0019;jm\u0016\fV/\u001a:jKNdunY6!\u0003Q\tw/Y5u)\u0016\u0014X.\u001b8bi&|g\u000eT8dW\u0006)\u0012m^1jiR+'/\\5oCRLwN\u001c'pG.\u0004\u0013a\u00057bgR$VM]7j]\u0006$X\rZ)vKJLX#\u00015\u0002/1\f7\u000f\u001e+fe6Lg.\u0019;fIF+XM]=`I\u0015\fH\u0003BA\t\u0003/\u00012ALA\n\u0013\r\t)b\f\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u001a9\t\t\u00111\u0001i\u0003\rAH%M\u0001\u0015Y\u0006\u001cH\u000fV3s[&t\u0017\r^3e#V,'/\u001f\u0011)\u000b=iw/a\b\"\u0005\u0005\u0015\u0011AB1di&4X-\u0006\u0002\u0002&A!a&a\ni\u0013\r\tIc\f\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0004O\u0016$Hc\u00015\u00020!1\u0011\u0011G\tA\u0002\u0001\f!!\u001b3\u0015\u0007!\f)\u0004C\u0004\u00022I\u0001\r!a\u000e\u0011\t\u0005e\u0012q\t\b\u0005\u0003w\t\u0019\u0005E\u0002\u0002>=j!!a\u0010\u000b\u0007\u0005\u00053&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000bz\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002J\u0005-#AB*ue&twMC\u0002\u0002F=\n1#Y<bSR\fe.\u001f+fe6Lg.\u0019;j_:$\"!!\u0005)\u000bM\t\u0019&a\u0018\u0011\u000b9\n)&!\u0017\n\u0007\u0005]sF\u0001\u0004uQJ|wo\u001d\t\u0004\u0003\u0006m\u0013bAA/C\t92\u000b\u001e:fC6LgnZ)vKJLX\t_2faRLwN\\\u0019\b=\u0005]\u0012\u0011MAJc%\u0019\u00131MA6\u0003\u0013\u000bi'\u0006\u0003\u0002f\u0005\u001dTCAA\u001c\t\u001d\tIg\u000bb\u0001\u0003g\u0012\u0011\u0001V\u0005\u0005\u0003[\ny'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003cz\u0013A\u0002;ie><8/\u0005\u0003\u0002v\u0005m\u0004c\u0001\u0018\u0002x%\u0019\u0011\u0011P\u0018\u0003\u000f9{G\u000f[5oOB!\u0011QPAB\u001d\rq\u0013qP\u0005\u0004\u0003\u0003{\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\u000b9IA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011Q\u00182\u0013\r\nY)!$\u0002\u0010\u0006Edb\u0001\u0018\u0002\u000e&\u0019\u0011\u0011O\u00182\u000b\trs&!%\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\nI\u0006\u0006\u0003\u0002\u0018\u0006u\u0005c\u0001\u0018\u0002\u001a&\u0019\u00111T\u0018\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u0014\u000bA\u0002\u0005\u0005\u0016!\u0003;j[\u0016|W\u000f^'t!\rq\u00131U\u0005\u0004\u0003K{#\u0001\u0002'p]\u001eDS\u0001FA*\u0003S\u000btAHA\u001c\u0003W\u000b\t,M\u0005$\u0003G\nY'!,\u0002nEJ1%a#\u0002\u000e\u0006=\u0016\u0011O\u0019\u0006E9z\u0013\u0011S\u0019\u0004M\u0005e\u0013a\u0004:fg\u0016$H+\u001a:nS:\fG/\u001a3\u0002\u0017\u0005$G\rT5ti\u0016tWM\u001d\u000b\u0005\u0003#\tI\fC\u0004\u0002<Z\u0001\r!!0\u0002\u00111L7\u000f^3oKJ\u00042!QA`\u0013\r\t\t-\t\u0002\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe\u0006q!/Z7pm\u0016d\u0015n\u001d;f]\u0016\u0014H\u0003BA\t\u0003\u000fDq!a/\u0018\u0001\u0004\ti,A\tq_N$H*[:uK:,'/\u0012<f]R$B!!\u0005\u0002N\"9\u0011q\u001a\rA\u0002\u0005E\u0017!B3wK:$\b\u0003BAj\u00033t1!QAk\u0013\r\t9.I\u0001\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe&!\u00111\\Ao\u0005\u0015)e/\u001a8u\u0015\r\t9.I\u0001\fGJ,\u0017\r^3Rk\u0016\u0014\u0018\u0010\u0006\f\u0002d\u0006%\u00181_A|\u0005/\u0011\tCa\u000b\u00036\te\"Q\bB$!\r\u0011\u0016Q]\u0005\u0004\u0003OL%!F*ue\u0016\fW.\u001b8h#V,'/_,sCB\u0004XM\u001d\u0005\b\u0003WL\u0002\u0019AAw\u0003E)8/\u001a:Ta\u0016\u001c\u0017NZ5fI:\u000bW.\u001a\t\u0006]\u0005=\u0018qG\u0005\u0004\u0003c|#AB(qi&|g\u000eC\u0004\u0002vf\u0001\r!!<\u0002?U\u001cXM]*qK\u000eLg-[3e\u0007\",7m\u001b9pS:$Hj\\2bi&|g\u000eC\u0004\u0002zf\u0001\r!a?\u0002\u0005\u00114\u0007\u0003BA\u007f\u0005#qA!a@\u0003\u00109!!\u0011\u0001B\u0007\u001d\u0011\u0011\u0019Aa\u0003\u000f\t\t\u0015!\u0011\u0002\b\u0005\u0003{\u00119!C\u0001+\u0013\tA\u0013&\u0003\u0002'O%\u0011A%J\u0005\u0004\u0003\u0003\u001b\u0013\u0002\u0002B\n\u0005+\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005\u00055\u0005C\u0004\u0003\u001ae\u0001\rAa\u0007\u0002\u0019\u0015DHO]1PaRLwN\\:\u0011\u0011\u0005e\"QDA\u001c\u0003oIAAa\b\u0002L\t\u0019Q*\u00199\t\u000f\t\r\u0012\u00041\u0001\u0003&\u0005!1/\u001b8l!\r\u0011&qE\u0005\u0004\u0005SI%!\u0005\"bg\u0016\u001cFO]3b[&twmU5oW\"9!QF\rA\u0002\t=\u0012AC8viB,H/T8eKB\u0019\u0011I!\r\n\u0007\tM\u0012E\u0001\u0006PkR\u0004X\u000f^'pI\u0016DqAa\u000e\u001a\u0001\u0004\t9*A\rvg\u0016$V-\u001c9DQ\u0016\u001c7\u000e]8j]RdunY1uS>t\u0007b\u0002B\u001e3\u0001\u0007\u0011qS\u0001\u001ee\u0016\u001cwN^3s\rJ|Wn\u00115fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]\"9!qH\rA\u0002\t\u0005\u0013a\u0002;sS\u001e<WM\u001d\t\u0004\u0003\n\r\u0013b\u0001B#C\t9AK]5hO\u0016\u0014\bb\u0002B%3\u0001\u0007!1J\u0001\riJLwmZ3s\u00072|7m\u001b\t\u0005\u0005\u001b\u0012\t&\u0004\u0002\u0003P)\u00111-J\u0005\u0005\u0005'\u0012yEA\u0003DY>\u001c7.\u0001\u0006ti\u0006\u0014H/U;fef$R\u0003\u001bB-\u00057\u0012iFa\u0018\u0003b\t\r$Q\rB4\u0005S\u0012Y\u0007C\u0004\u0002lj\u0001\r!!<\t\u000f\u0005U(\u00041\u0001\u0002n\"9\u0011\u0011 \u000eA\u0002\u0005m\bb\u0002B\r5\u0001\u0007!1\u0004\u0005\b\u0005GQ\u0002\u0019\u0001B\u0013\u0011\u001d\u0011iC\u0007a\u0001\u0005_A\u0011Ba\u000e\u001b!\u0003\u0005\r!a&\t\u0013\tm\"\u0004%AA\u0002\u0005]\u0005\"\u0003B 5A\u0005\t\u0019\u0001B!\u0011%\u0011IE\u0007I\u0001\u0002\u0004\u0011Y%\u0001\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$HeN\u000b\u0003\u0005cRC!a&\u0003t-\u0012!Q\u000f\t\u0005\u0005o\u0012y(\u0004\u0002\u0003z)!!1\u0010B?\u0003%)hn\u00195fG.,GM\u0003\u0002s_%!!\u0011\u0011B=\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0015gR\f'\u000f^)vKJLH\u0005Z3gCVdG\u000f\n\u001d\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0011II\u000b\u0003\u0003B\tM\u0014!F:uCJ$\u0018+^3ss\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005\u001fSCAa\u0013\u0003t\u00051bn\u001c;jMf\fV/\u001a:z)\u0016\u0014X.\u001b8bi&|g\u000e\u0006\u0003\u0002\u0012\tU\u0005B\u0002BL?\u0001\u0007\u0001.A\buKJl\u0017N\\1uK\u0012\fV/\u001a:zQ\r\u0001!1\u0014\t\u0005\u0005;\u00139K\u0004\u0003\u0003 \n\rVB\u0001BQ\u0015\t\u0011X%\u0003\u0003\u0003&\n\u0005\u0016AE%oi\u0016\u0014h-Y2f'R\f'-\u001b7jifLAA!+\u0003,\nAQI^8mm&twM\u0003\u0003\u0003&\n\u0005\u0006")
public class StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private StreamingQuery lastTerminatedQuery;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesLock() {
        return this.activeQueriesLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private StreamingQuery lastTerminatedQuery() {
        return this.lastTerminatedQuery;
    }

    private void lastTerminatedQuery_$eq(StreamingQuery x$1) {
        this.lastTerminatedQuery = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.currentTimeMillis();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(startTime, timeoutMs) && this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
            bl = this.lastTerminatedQuery() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQuery_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, BaseStreamingSink sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        Tuple2 tuple2;
        Path checkpointPath;
        FileSystem fs;
        BooleanRef deleteCheckpointOnStop = BooleanRef.create((boolean)false);
        String checkpointLocation = (String)userSpecifiedCheckpointLocation.map((Function1 & Serializable & scala.Serializable)userSpecified -> new Path(userSpecified).toUri().toString()).orElse((Function0 & Serializable & scala.Serializable)() -> df.sparkSession().sessionState().conf().checkpointLocation().map((Function1 & Serializable & scala.Serializable)location -> new Path(location, (String)userSpecifiedName.getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())).toUri().toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (!useTempCheckpointLocation) {
                throw new AnalysisException(new StringBuilder(89).append("checkpointLocation must be specified either through option(\"checkpointLocation\", ...) or ").append(new StringBuilder(30).append("SparkSession.conf.set(\"").append(SQLConf$.MODULE$.CHECKPOINT_LOCATION().key()).append("\", ...)").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            deleteCheckpointOnStop$1.elem = true;
            String x$1 = "temporary";
            String x$2 = Utils$.MODULE$.createTempDir$default$1();
            return Utils$.MODULE$.createTempDir(x$2, x$1).getCanonicalPath();
        });
        if (!recoverFromCheckpointLocation && (fs = (checkpointPath = new Path(checkpointLocation, "offsets")).getFileSystem(df.sparkSession().sessionState().newHadoopConf())).exists(checkpointPath)) {
            throw new AnalysisException(new StringBuilder(65).append("This query does not support recovering from checkpoint location. ").append(new StringBuilder(22).append("Delete ").append(checkpointPath).append(" to start over.").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        if (this.sparkSession.sessionState().conf().isUnsupportedOperationCheckEnabled()) {
            UnsupportedOperationChecker$.MODULE$.checkForStreaming(analyzedPlan, outputMode);
        }
        if (this.sparkSession.sessionState().conf().adaptiveExecutionEnabled()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append(SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()).append(" ").append("is not supported in streaming DataFrames/Datasets and will be disabled.").toString());
        }
        if ((tuple2 = new Tuple2((Object)sink, (Object)trigger)) == null) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        BaseStreamingSink v2Sink = (BaseStreamingSink)tuple2._1();
        Trigger trigger2 = (Trigger)tuple2._2();
        if (!(v2Sink instanceof StreamWriteSupport)) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        StreamWriteSupport streamWriteSupport = (StreamWriteSupport)v2Sink;
        if (!(trigger2 instanceof ContinuousTrigger)) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
        if (!this.sparkSession.sessionState().conf().isUnsupportedOperationCheckEnabled()) return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, streamWriteSupport, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        UnsupportedOperationChecker$.MODULE$.checkForContinuous(analyzedPlan, outputMode);
        return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, streamWriteSupport, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
    }

    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, BaseStreamingSink sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock);
        Object object = this.activeQueriesLock();
        synchronized (object) {
            userSpecifiedName.foreach((Function1 & Serializable & scala.Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            if (this.activeQueries().values().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$3(query, x$2)))) {
                throw new IllegalStateException(new StringBuilder(162).append("Cannot start query with id ").append(query.id()).append(" as another query with same id is ").append("already active. Perhaps you are attempting to restart a query from checkpoint ").append("that is already active.").toString());
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
        }
        catch (Throwable e) {
            Object object2 = this.activeQueriesLock();
            synchronized (object2) {
                this.activeQueries().$minus$eq((Object)query.id());
            }
            throw e;
        }
        return query;
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return new ProcessingTime(0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        Object object = this.activeQueriesLock();
        synchronized (object) {
            this.activeQueries().$minus$eq((Object)terminatedQuery.id());
        }
        Object object2 = this.awaitTerminationLock();
        synchronized (object2) {
            if (this.lastTerminatedQuery() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQuery_$eq(terminatedQuery);
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    public static final /* synthetic */ void $anonfun$new$2(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Registered listener ").append(listener.getClass().getName()).toString());
    }

    public static final /* synthetic */ void $anonfun$new$1(StreamingQueryManager $this, Seq classNames) {
        Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, $this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable & scala.Serializable)listener -> {
            StreamingQueryManager.$anonfun$new$2($this, listener);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean isTimedout$1(long startTime$1, long timeoutMs$1) {
        return System.currentTimeMillis() - startTime$1 >= timeoutMs$1;
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$1)))) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot start query with name ").append(name).append(" as a query with that name is already active").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$3(StreamingQueryWrapper query$1, StreamingQuery x$2) {
        UUID uUID = x$2.id();
        UUID uUID2 = query$1.id();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public StreamingQueryManager(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env());
        this.listenerBus = new StreamingQueryListenerBus(sparkSession.sparkContext().listenerBus());
        this.activeQueries = new HashMap();
        this.activeQueriesLock = new Object();
        this.awaitTerminationLock = new Object();
        this.lastTerminatedQuery = null;
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable & scala.Serializable)classNames -> {
                StreamingQueryManager.$anonfun$new$1(this, classNames);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw new SparkException("Exception when registering StreamingQueryListener", (Throwable)e);
        }
    }
}

