/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.streaming.RateStreamOffset;
import org.apache.spark.sql.execution.streaming.ValueRunTimeMsPair;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamContinuousInputPartition;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamPartitionOffset;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider$;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.sources.v2.reader.streaming.Offset;
import org.apache.spark.sql.sources.v2.reader.streaming.PartitionOffset;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\r\u001b\u0001%B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b\u000f\u0002\u0011\r\u0011b\u0001I\u0011\u0019y\u0005\u0001)A\u0005\u0013\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006B\u0002-\u0001A\u0003%!\u000bC\u0004Z\u0001\t\u0007I\u0011\u0001.\t\ry\u0003\u0001\u0015!\u0003\\\u0011\u001dy\u0006A1A\u0005\u0002ECa\u0001\u0019\u0001!\u0002\u0013\u0011\u0006bB1\u0001\u0005\u0004%\tA\u0019\u0005\u0007M\u0002\u0001\u000b\u0011B2\t\u000b\u001d\u0004A\u0011\t5\t\u000bQ\u0004A\u0011I;\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!Y\u0011q\u0003\u0001A\u0002\u0003\u0007I\u0011BA\r\u0011-\tY\u0002\u0001a\u0001\u0002\u0004%I!!\b\t\u0015\u0005%\u0002\u00011A\u0001B\u0003&\u0011\u000eC\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u0011\u0011\t\u0001\u0005B\u0005\r\u0003bBA0\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003O\u0002A\u0011IA5\u0011\u001d\tY\u0007\u0001C\u0005\u0003[\u0012!DU1uKN#(/Z1n\u0007>tG/\u001b8v_V\u001c(+Z1eKJT!a\u0007\u000f\u0002\u0015\r|g\u000e^5ok>,8O\u0003\u0002\u001e=\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003?\u0001\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q#\u0007\u0005\u0002,a5\tAF\u0003\u0002.]\u0005!A.\u00198h\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\r=\u0013'.Z2u!\t\u00194(D\u00015\u0015\tiRG\u0003\u00027o\u00051!/Z1eKJT!\u0001O\u001d\u0002\u0005Y\u0014$B\u0001\u001e!\u0003\u001d\u0019x.\u001e:dKNL!\u0001\u0010\u001b\u0003!\r{g\u000e^5ok>,8OU3bI\u0016\u0014\u0018aB8qi&|gn\u001d\t\u0003\u007f\u0001k\u0011aN\u0005\u0003\u0003^\u0012\u0011\u0003R1uCN{WO]2f\u001fB$\u0018n\u001c8t\u0003\u0019a\u0014N\\5u}Q\u0011AI\u0012\t\u0003\u000b\u0002i\u0011A\u0007\u0005\u0006{\t\u0001\rAP\u0001\u000fI\u00164\u0017-\u001e7u\r>\u0014X.\u0019;t+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001''\u0003\u0019Q7o\u001c85g&\u0011aj\u0013\u0002\u000f\t\u00164\u0017-\u001e7u\r>\u0014X.\u0019;t\u0003=!WMZ1vYR4uN]7biN\u0004\u0013\u0001D2sK\u0006$\u0018n\u001c8US6,W#\u0001*\u0011\u0005M3V\"\u0001+\u000b\u0003U\u000bQa]2bY\u0006L!a\u0016+\u0003\t1{gnZ\u0001\u000eGJ,\u0017\r^5p]RKW.\u001a\u0011\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\u0005Y\u0006CA*]\u0013\tiFKA\u0002J]R\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0007s_^\u001c\b+\u001a:TK\u000e|g\u000eZ\u0001\u000fe><8\u000fU3s'\u0016\u001cwN\u001c3!\u0003A\u0001XM\u001d)beRLG/[8o%\u0006$X-F\u0001d!\t\u0019F-\u0003\u0002f)\n1Ai\\;cY\u0016\f\u0011\u0003]3s!\u0006\u0014H/\u001b;j_:\u0014\u0016\r^3!\u00031iWM]4f\u001f\u001a47/\u001a;t)\tIG\u000e\u0005\u00024U&\u00111\u000e\u000e\u0002\u0007\u001f\u001a47/\u001a;\t\u000b5l\u0001\u0019\u00018\u0002\u000f=4gm]3ugB\u00191k\\9\n\u0005A$&!B!se\u0006L\bCA\u001as\u0013\t\u0019HGA\bQCJ$\u0018\u000e^5p]>3gm]3u\u0003E!Wm]3sS\u0006d\u0017N_3PM\u001a\u001cX\r\u001e\u000b\u0003SZDQa\u001e\bA\u0002a\fAA[:p]B\u0019\u00110!\u0001\u000f\u0005it\bCA>U\u001b\u0005a(BA?)\u0003\u0019a$o\\8u}%\u0011q\u0010V\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}$\u0016A\u0003:fC\u0012\u001c6\r[3nCR\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\u0011\u0002\u000bQL\b/Z:\n\t\u0005U\u0011q\u0002\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017AB8gMN,G/F\u0001j\u0003)ygMZ:fi~#S-\u001d\u000b\u0005\u0003?\t)\u0003E\u0002T\u0003CI1!a\tU\u0005\u0011)f.\u001b;\t\u0011\u0005\u001d\u0012#!AA\u0002%\f1\u0001\u001f\u00132\u0003\u001dygMZ:fi\u0002\nab]3u'R\f'\u000f^(gMN,G\u000f\u0006\u0003\u0002 \u0005=\u0002bBA\f'\u0001\u0007\u0011\u0011\u0007\t\u0006\u0003g\tI$[\u0007\u0003\u0003kQ1!a\u000e/\u0003\u0011)H/\u001b7\n\t\u0005m\u0012Q\u0007\u0002\t\u001fB$\u0018n\u001c8bY\u0006qq-\u001a;Ti\u0006\u0014Ho\u00144gg\u0016$H#A5\u0002'Ad\u0017M\\%oaV$\b+\u0019:uSRLwN\\:\u0015\u0005\u0005\u0015\u0003CBA\u001a\u0003\u000f\nY%\u0003\u0003\u0002J\u0005U\"\u0001\u0002'jgR\u0004b!!\u0014\u0002P\u0005MS\"A\u001b\n\u0007\u0005ESG\u0001\bJ]B,H\u000fU1si&$\u0018n\u001c8\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017!\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA/\u0003/\u00121\"\u00138uKJt\u0017\r\u001c*po\u000611m\\7nSR$B!a\b\u0002d!1\u0011Q\r\fA\u0002%\f1!\u001a8e\u0003\u0011\u0019Ho\u001c9\u0015\u0005\u0005}\u0011aE2sK\u0006$X-\u00138ji&\fGn\u00144gg\u0016$HCBA8\u0003o\nI\b\u0005\u0003\u0002r\u0005MT\"\u0001\u000f\n\u0007\u0005UDD\u0001\tSCR,7\u000b\u001e:fC6|eMZ:fi\")\u0011\f\u0007a\u00017\"1\u00111\u0010\rA\u0002I\u000bab\u0019:fCRLwN\u001c+j[\u0016l5\u000f")
public class RateStreamContinuousReader
implements ContinuousReader {
    private final DefaultFormats defaultFormats = DefaultFormats$.MODULE$;
    private final long creationTime = System.currentTimeMillis();
    private final int numPartitions;
    private final long rowsPerSecond;
    private final double perPartitionRate;
    private Offset offset;

    @Override
    public boolean needsReconfiguration() {
        return ContinuousReader.super.needsReconfiguration();
    }

    public DefaultFormats defaultFormats() {
        return this.defaultFormats;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public long rowsPerSecond() {
        return this.rowsPerSecond;
    }

    public double perPartitionRate() {
        return this.perPartitionRate;
    }

    @Override
    public Offset mergeOffsets(PartitionOffset[] offsets) {
        Predef$.MODULE$.assert(offsets.length == this.numPartitions());
        Tuple2[] tuples = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])offsets)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PartitionOffset partitionOffset = x0$1;
            if (!(partitionOffset instanceof RateStreamPartitionOffset)) {
                throw new MatchError((Object)partitionOffset);
            }
            RateStreamPartitionOffset rateStreamPartitionOffset = (RateStreamPartitionOffset)partitionOffset;
            int i = rateStreamPartitionOffset.partition();
            long currVal = rateStreamPartitionOffset.currentValue();
            long nextRead = rateStreamPartitionOffset.currentTimeMs();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new ValueRunTimeMsPair(currVal, nextRead));
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuples))));
    }

    @Override
    public Offset deserializeOffset(String json) {
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((Map)Serialization$.MODULE$.read(json, (Formats)this.defaultFormats(), ManifestFactory$.MODULE$.classType(Map.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(ValueRunTimeMsPair.class)})))));
    }

    @Override
    public StructType readSchema() {
        return RateStreamProvider$.MODULE$.SCHEMA();
    }

    private Offset offset() {
        return this.offset;
    }

    private void offset_$eq(Offset x$1) {
        this.offset = x$1;
    }

    @Override
    public void setStartOffset(Optional<Offset> offset) {
        this.offset_$eq(offset.orElse(this.createInitialOffset(this.numPartitions(), this.creationTime())));
    }

    @Override
    public Offset getStartOffset() {
        return this.offset();
    }

    @Override
    public List<InputPartition<InternalRow>> planInputPartitions() {
        Offset offset = this.offset();
        if (!(offset instanceof RateStreamOffset)) {
            throw new IllegalArgumentException(new StringBuilder(45).append("invalid offset type ").append(offset.getClass()).append(" for ContinuousRateSource").toString());
        }
        RateStreamOffset rateStreamOffset = (RateStreamOffset)offset;
        Map<Object, ValueRunTimeMsPair> map = rateStreamOffset.partitionToValueAndRunTimeMs();
        Map<Object, ValueRunTimeMsPair> partitionStartMap = map;
        if (partitionStartMap.keySet().size() != this.numPartitions()) {
            throw new IllegalArgumentException(new StringBuilder(62).append("The previous run contained ").append(partitionStartMap.keySet().size()).append(" partitions, but").append(new StringBuilder(63).append(" ").append(this.numPartitions()).append(" partitions are currently configured. The numPartitions option").toString()).append(" cannot be changed.").toString());
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Range().apply(0, this.numPartitions()).map((Function1 & Serializable & scala.Serializable)i -> RateStreamContinuousReader.$anonfun$planInputPartitions$1(this, partitionStartMap, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).asJava();
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    private RateStreamOffset createInitialOffset(int numPartitions, long creationTimeMs) {
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((TraversableOnce)package$.MODULE$.Range().apply(0, numPartitions).map((Function1 & Serializable & scala.Serializable)i -> RateStreamContinuousReader.$anonfun$createInitialOffset$1(numPartitions, creationTimeMs, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ InputPartition $anonfun$planInputPartitions$1(RateStreamContinuousReader $this, Map partitionStartMap$1, int i) {
        ValueRunTimeMsPair start = (ValueRunTimeMsPair)partitionStartMap$1.apply((Object)BoxesRunTime.boxToInteger((int)i));
        return new RateStreamContinuousInputPartition(start.value(), start.runTimeMs(), i, $this.numPartitions(), $this.perPartitionRate());
    }

    public static final /* synthetic */ Tuple2 $anonfun$createInitialOffset$1(int numPartitions$1, long creationTimeMs$1, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new ValueRunTimeMsPair(i - numPartitions$1, creationTimeMs$1));
    }

    public RateStreamContinuousReader(DataSourceOptions options) {
        this.numPartitions = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).orElse("5"))).toInt();
        this.rowsPerSecond = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.ROWS_PER_SECOND()).orElse("6"))).toLong();
        this.perPartitionRate = (double)this.rowsPerSecond() / (double)this.numPartitions();
    }
}

