/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001\u0002\r\u001a\u0001\u0011BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013%a\u0007\u0003\u0004C\u0001\u0001\u0006Ia\u000e\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u0019\t\u0006\u0001)A\u0005\u0013\")1\u000b\u0001C\u0005)\")a\r\u0001C\u0005O\")Q\u000e\u0001C\u0001]\")!\u000f\u0001C\u0001g\")q\u000f\u0001C\u0001q\"I\u0011q\u0007\u0001\u0012\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003\u001f\u0002\u0011\u0013!C\u0001\u0003#Bq!!\u0016\u0001\t\u0003\t9\u0006C\u0005\u0002n\u0001\t\n\u0011\"\u0001\u0002p!9\u0011Q\u000b\u0001\u0005\u0002\u0005M\u0004bBAM\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003C\u0003A\u0011BAR\u0011%\t\u0019\fAI\u0001\n\u0013\ty\u0007C\u0004\u00026\u0002!\t!a.\t\u000f\u0005U\u0006\u0001\"\u0001\u0002H\"9\u00111\u001a\u0001\u0005\u0002\u00055\u0007bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u00037\u0004A\u0011BAo\u00051\u0019\u0015m\u00195f\u001b\u0006t\u0017mZ3s\u0015\tQ2$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011A$H\u0001\u0004gFd'B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g!\tas&D\u0001.\u0015\tqS$\u0001\u0005j]R,'O\\1m\u0013\t\u0001TFA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0019\u0004C\u0001\u001b\u0001\u001b\u0005I\u0012AC2bG\",G\rR1uCV\tq\u0007E\u00029{}j\u0011!\u000f\u0006\u0003um\nA!\u001e;jY*\tA(\u0001\u0003kCZ\f\u0017B\u0001 :\u0005)a\u0015N\\6fI2K7\u000f\u001e\t\u0003i\u0001K!!Q\r\u0003\u0015\r\u000b7\r[3e\t\u0006$\u0018-A\u0006dC\u000eDW\r\u001a#bi\u0006\u0004\u0003FA\u0002E!\t1S)\u0003\u0002GO\tIAO]1og&,g\u000e^\u0001\nG\u0006\u001c\u0007.\u001a'pG.,\u0012!\u0013\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bQ\u0001\\8dWNT!AT\u001d\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002Q\u0017\n1\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7.\u0001\u0006dC\u000eDW\rT8dW\u0002B#!\u0002#\u0002\u0011I,\u0017\r\u001a'pG.,\"!\u0016-\u0015\u0005Y\u000b\u0007CA,Y\u0019\u0001!Q!\u0017\u0004C\u0002i\u0013\u0011!Q\t\u00037z\u0003\"A\n/\n\u0005u;#a\u0002(pi\"Lgn\u001a\t\u0003M}K!\u0001Y\u0014\u0003\u0007\u0005s\u0017\u0010\u0003\u0004c\r\u0011\u0005\raY\u0001\u0002MB\u0019a\u0005\u001a,\n\u0005\u0015<#\u0001\u0003\u001fcs:\fW.\u001a \u0002\u0013]\u0014\u0018\u000e^3M_\u000e\\WC\u00015k)\tI7\u000e\u0005\u0002XU\u0012)\u0011l\u0002b\u00015\"1!m\u0002CA\u00021\u00042A\n3j\u0003)\u0019G.Z1s\u0007\u0006\u001c\u0007.\u001a\u000b\u0002_B\u0011a\u0005]\u0005\u0003c\u001e\u0012A!\u00168ji\u00069\u0011n]#naRLX#\u0001;\u0011\u0005\u0019*\u0018B\u0001<(\u0005\u001d\u0011un\u001c7fC:\f!bY1dQ\u0016\fV/\u001a:z)\u0019y\u00170a\u0002\u0002(!)!P\u0003a\u0001w\u0006)\u0011/^3ssB\u001aA0a\u0001\u0011\tut\u0018\u0011A\u0007\u00027%\u0011qp\u0007\u0002\b\t\u0006$\u0018m]3u!\r9\u00161\u0001\u0003\u000b\u0003\u000bI\u0018\u0011!A\u0001\u0006\u0003Q&aA0%c!I\u0011\u0011\u0002\u0006\u0011\u0002\u0003\u0007\u00111B\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004RAJA\u0007\u0003#I1!a\u0004(\u0005\u0019y\u0005\u000f^5p]B!\u00111CA\u0011\u001d\u0011\t)\"!\b\u0011\u0007\u0005]q%\u0004\u0002\u0002\u001a)\u0019\u00111D\u0012\u0002\rq\u0012xn\u001c;?\u0013\r\tybJ\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0012Q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}q\u0005C\u0005\u0002*)\u0001\n\u00111\u0001\u0002,\u0005a1\u000f^8sC\u001e,G*\u001a<fYB!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022u\tqa\u001d;pe\u0006<W-\u0003\u0003\u00026\u0005=\"\u0001D*u_J\fw-\u001a'fm\u0016d\u0017\u0001F2bG\",\u0017+^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0002<)\"\u00111BA\u001fW\t\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA%O\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00131\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F2bG\",\u0017+^3ss\u0012\"WMZ1vYR$3'\u0006\u0002\u0002T)\"\u00111FA\u001f\u00031)hnY1dQ\u0016\fV/\u001a:z)\u001dy\u0017\u0011LA3\u0003SBaA_\u0007A\u0002\u0005m\u0003\u0007BA/\u0003C\u0002B! @\u0002`A\u0019q+!\u0019\u0005\u0017\u0005\r\u0014\u0011LA\u0001\u0002\u0003\u0015\tA\u0017\u0002\u0004?\u0012\u0012\u0004BBA4\u001b\u0001\u0007A/A\u0004dCN\u001c\u0017\rZ3\t\u0011\u0005-T\u0002%AA\u0002Q\f\u0001B\u00197pG.LgnZ\u0001\u0017k:\u001c\u0017m\u00195f#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u000f\u0016\u0004i\u0006uB#C8\u0002v\u0005u\u0014QSAL\u0011\u0019qr\u00021\u0001\u0002xA\u0019Q0!\u001f\n\u0007\u0005m4D\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004\u0002\u0000=\u0001\r!!!\u0002\tAd\u0017M\u001c\t\u0005\u0003\u0007\u000b\t*\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003\u001dawnZ5dC2TA!a#\u0002\u000e\u0006)\u0001\u000f\\1og*\u0019\u0011qR\u000e\u0002\u0011\r\fG/\u00197zgRLA!a%\u0002\u0006\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u0019\t9g\u0004a\u0001i\"1\u00111N\bA\u0002Q\fQB]3dC\u000eDWMQ=QY\u0006tG#B8\u0002\u001e\u0006}\u0005B\u0002\u0010\u0011\u0001\u0004\t9\bC\u0004\u0002\u0000A\u0001\r!!!\u0002%I,7-Y2iK\nK8i\u001c8eSRLwN\u001c\u000b\b_\u0006\u0015\u0016qUAY\u0011\u0019q\u0012\u00031\u0001\u0002x!9\u0011\u0011V\tA\u0002\u0005-\u0016!C2p]\u0012LG/[8o!\u00191\u0013QVAAi&\u0019\u0011qV\u0014\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bB7\u0012!\u0003\u0005\r\u0001^\u0001\u001de\u0016\u001c\u0017m\u00195f\u0005f\u001cuN\u001c3ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003Aawn\\6va\u000e\u000b7\r[3e\t\u0006$\u0018\r\u0006\u0003\u0002:\u0006m\u0006\u0003\u0002\u0014\u0002\u000e}BaA_\nA\u0002\u0005u\u0006\u0007BA`\u0003\u0007\u0004B! @\u0002BB\u0019q+a1\u0005\u0017\u0005\u0015\u00171XA\u0001\u0002\u0003\u0015\tA\u0017\u0002\u0004?\u0012\u001aD\u0003BA]\u0003\u0013Dq!a \u0015\u0001\u0004\t\t)A\u0007vg\u0016\u001c\u0015m\u00195fI\u0012\u000bG/\u0019\u000b\u0005\u0003\u0003\u000by\rC\u0004\u0002\u0000U\u0001\r!!!\u0002\u001bI,7-Y2iK\nK\b+\u0019;i)\u0015y\u0017Q[Al\u0011\u0019qb\u00031\u0001\u0002x!9\u0011\u0011\u001c\fA\u0002\u0005E\u0011\u0001\u0004:fg>,(oY3QCRD\u0017\u0001\u00057p_.,\b/\u00118e%\u00164'/Z:i)\u001d!\u0018q\\Aq\u0003gDq!a \u0018\u0001\u0004\t\t\tC\u0004\u0002d^\u0001\r!!:\u0002\u0005\u0019\u001c\b\u0003BAt\u0003_l!!!;\u000b\t\u0005\r\u00181\u001e\u0006\u0004\u0003[|\u0012A\u00025bI>|\u0007/\u0003\u0003\u0002r\u0006%(A\u0003$jY\u0016\u001c\u0016p\u001d;f[\"9\u0011Q_\fA\u0002\u0005]\u0018!D9vC2Lg-[3e!\u0006$\b\u000e\u0005\u0003\u0002h\u0006e\u0018\u0002BA~\u0003S\u0014A\u0001U1uQ\u0002")
public class CacheManager
implements Logging {
    private final transient LinkedList<CachedData> cachedData;
    private final transient ReentrantReadWriteLock cacheLock;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LinkedList<CachedData> cachedData() {
        return this.cachedData;
    }

    private ReentrantReadWriteLock cacheLock() {
        return this.cacheLock;
    }

    private <A> A readLock(Function0<A> f) {
        Object object;
        ReentrantReadWriteLock.ReadLock lock = this.cacheLock().readLock();
        lock.lock();
        try {
            object = f.apply();
        }
        finally {
            lock.unlock();
        }
        return (A)object;
    }

    private <A> A writeLock(Function0<A> f) {
        Object object;
        ReentrantReadWriteLock.WriteLock lock = this.cacheLock().writeLock();
        lock.lock();
        try {
            object = f.apply();
        }
        finally {
            lock.unlock();
        }
        return (A)object;
    }

    public void clearCache() {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.cachedData()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                CacheManager.$anonfun$clearCache$2(x$1);
                return BoxedUnit.UNIT;
            });
            this.cachedData().clear();
        });
    }

    public boolean isEmpty() {
        return BoxesRunTime.unboxToBoolean(this.readLock((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.cachedData().isEmpty()));
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        this.writeLock((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            LogicalPlan planToCache = query.logicalPlan();
            if (this.lookupCachedData(planToCache).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asked to cache already cached data.");
                object = BoxedUnit.UNIT;
            } else {
                SparkSession sparkSession = query.sparkSession();
                InMemoryRelation inMemoryRelation = InMemoryRelation$.MODULE$.apply(sparkSession.sessionState().conf().useCompression(), sparkSession.sessionState().conf().columnBatchSize(), storageLevel, sparkSession.sessionState().executePlan(planToCache).executedPlan(), tableName, planToCache);
                object = BoxesRunTime.boxToBoolean((boolean)this.cachedData().add(new CachedData(planToCache, inMemoryRelation)));
            }
            return object;
        });
    }

    public Option<String> cacheQuery$default$2() {
        return None$.MODULE$;
    }

    public StorageLevel cacheQuery$default$3() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade, boolean blocking) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.uncacheQuery(query.sparkSession(), query.logicalPlan(), cascade, blocking));
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                Function1 & Serializable & scala.Serializable shouldRemove = cascade ? (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$3(plan, x$2)) : (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.sameResult((QueryPlan)plan));
                Iterator it = this.cachedData().iterator();
                while (it.hasNext()) {
                    CachedData cd = (CachedData)it.next();
                    if (!BoxesRunTime.unboxToBoolean((Object)shouldRemove.apply((Object)cd.plan()))) continue;
                    cd.cachedRepresentation().cacheBuilder().clearCache(blocking);
                    it.remove();
                }
                if (cascade) break block1;
                this.recacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$6(plan, x$5)), false);
            }
        });
    }

    public boolean uncacheQuery$default$3() {
        return true;
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.recacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$2(plan, x$7)), this.recacheByCondition$default$3()));
    }

    private void recacheByCondition(SparkSession spark, Function1<LogicalPlan, Object> condition, boolean clearCache) {
        Iterator it = this.cachedData().iterator();
        ArrayBuffer needToRecache = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (it.hasNext()) {
            BoxedUnit boxedUnit;
            boolean buildNewPlan;
            CachedData cd = (CachedData)it.next();
            boolean bl = buildNewPlan = clearCache || !cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
            if (BoxesRunTime.unboxToBoolean((Object)condition.apply((Object)cd.plan())) && buildNewPlan) {
                InMemoryRelation newCache;
                SparkPlan plan;
                cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
                it.remove();
                SparkPlan x$12 = plan = spark.sessionState().executePlan(cd.plan()).executedPlan();
                boolean x$2 = cd.cachedRepresentation().cacheBuilder().copy$default$1();
                int x$3 = cd.cachedRepresentation().cacheBuilder().copy$default$2();
                StorageLevel x$4 = cd.cachedRepresentation().cacheBuilder().copy$default$3();
                Option<String> x$5 = cd.cachedRepresentation().cacheBuilder().copy$default$5();
                Object x$6 = null;
                InMemoryRelation x$7 = newCache = InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder().copy(x$2, x$3, x$4, x$12, x$5, null), cd.plan());
                LogicalPlan x$8 = cd.copy$default$1();
                boxedUnit = needToRecache.$plus$eq((Object)cd.copy(x$8, x$7));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        needToRecache.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$1(this, x$1)));
    }

    private boolean recacheByCondition$default$3() {
        return true;
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return (Option)this.readLock((Function0 & Serializable & scala.Serializable)() -> this.lookupCachedData(query.logicalPlan()));
    }

    public Option<CachedData> lookupCachedData(LogicalPlan plan) {
        return (Option)this.readLock((Function0 & Serializable & scala.Serializable)() -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.cachedData()).asScala()).find((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan()))));
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = plan.transformDown((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ResolvedHint resolvedHint;
                A1 A1 = x1;
                Object object = A1 instanceof ResolvedHint ? (resolvedHint = (ResolvedHint)A1) : this.$outer.lookupCachedData(A1).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.cachedRepresentation().withOutput((Seq<Attribute>)A1.output())).getOrElse((Function0 & Serializable & scala.Serializable)() -> A1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof ResolvedHint ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        return newPlan.transformAllExpressions((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    object = subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof SubqueryExpression;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path path = new Path(resourcePath);
            FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
            Tuple2 tuple2 = new Tuple2((Object)fs, (Object)fs.makeQualified(path));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FileSystem fs2 = (FileSystem)tuple2._1();
            Path qualifiedPath = (Path)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)fs2, (Object)qualifiedPath);
            Tuple2 tuple23 = tuple22;
            FileSystem fs3 = (FileSystem)tuple23._1();
            Path qualifiedPath2 = (Path)tuple23._2();
            this.recacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$2(this, fs3, qualifiedPath2, x$11)), this.recacheByCondition$default$3());
        });
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        boolean bl;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            boolean bl2;
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                String prefixToInvalidate = qualifiedPath.toString();
                boolean invalidate = ((IterableLike)hadoopFsRelation.location().rootPaths().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.startsWith(prefixToInvalidate)));
                if (invalidate) {
                    hadoopFsRelation.location().refresh();
                }
                bl2 = invalidate;
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$clearCache$2(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$3(LogicalPlan plan$1, LogicalPlan x$2) {
        return x$2.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.sameResult((QueryPlan)plan$1))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$6(LogicalPlan plan$1, LogicalPlan x$5) {
        return x$5.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.sameResult((QueryPlan)plan$1))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$2(LogicalPlan plan$2, LogicalPlan x$7) {
        return x$7.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.sameResult((QueryPlan)plan$2))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$1(CacheManager $this, CachedData x$1) {
        return $this.cachedData().add(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$2(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, LogicalPlan x$11) {
        return x$11.find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$12, fs$1, qualifiedPath$1))).isDefined();
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        this.cachedData = new LinkedList();
        this.cacheLock = new ReentrantReadWriteLock();
    }
}

