/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.net.URI;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$FileTypes$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetLogRedirector;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rEb\u0001\u0002\u001b6\u0001\u0011CQA\u0018\u0001\u0005\u0002}CqA\u0019\u0001C\u0002\u0013%1\r\u0003\u0004h\u0001\u0001\u0006I\u0001\u001a\u0005\u0006Q\u0002!\t%\u001b\u0005\u0006k\u0002!\t%\u001b\u0005\u0006m\u0002!\te\u001e\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\ty\u0005\u0001C!\u0003#2a!!!\u0001\u0001\u0006\r\u0005BCAF\u0015\tU\r\u0011\"\u0001\u0002\u000e\"Q\u0011q\u0012\u0006\u0003\u0012\u0003\u0006I!a\u0019\t\u0015\u0005E%B!f\u0001\n\u0003\ti\t\u0003\u0006\u0002\u0014*\u0011\t\u0012)A\u0005\u0003GB!\"!&\u000b\u0005+\u0007I\u0011AAG\u0011)\t9J\u0003B\tB\u0003%\u00111\r\u0005\u0007=*!\t!!'\t\u0013\u0005\u0015&\"!A\u0005\u0002\u0005\u001d\u0006\"CAX\u0015E\u0005I\u0011AAY\u0011%\t9MCI\u0001\n\u0003\t\t\fC\u0005\u0002J*\t\n\u0011\"\u0001\u00022\"I\u00111\u001a\u0006\u0002\u0002\u0013\u0005\u0013Q\u001a\u0005\n\u0003;T\u0011\u0011!C\u0001\u0003?D\u0011\"!9\u000b\u0003\u0003%\t!a9\t\u0013\u0005%(\"!A\u0005B\u0005-\b\"CA}\u0015\u0005\u0005I\u0011AA~\u0011\u001d1(\"!A\u0005B]D\u0001\"\u001e\u0006\u0002\u0002\u0013\u0005\u0013q \u0005\tw*\t\t\u0011\"\u0011\u0003\u0002\u001dI!Q\u0001\u0001\u0002\u0002#\u0005!q\u0001\u0004\n\u0003\u0003\u0003\u0011\u0011!E\u0001\u0005\u0013AaAX\u0010\u0005\u0002\t]\u0001\u0002C; \u0003\u0003%)%a@\t\u0013\teq$!A\u0005\u0002\nm\u0001\"\u0003B\u0012?\u0005\u0005I\u0011\u0011B\u0013\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003J\u0001!\tEa\u0013\t\u000f\tM\u0003\u0001\"\u0011\u0003V!9!\u0011\u000f\u0001\u0005B\tM\u0004b\u0002B?\u0001\u0011\u0005#q\u0010\u0005\b\u0005\u0007\u0004A\u0011\tBc\u000f\u001d\u0011).\u000eE\u0001\u0005/4a\u0001N\u001b\t\u0002\te\u0007B\u00020-\t\u0003\u0011Y\u000e\u0003\u0005\u0003^2\"\t!\u000eBp\u0011!\u0011)\u0010\fC\u0001k\t]\bbBB\u0002Y\u0011\u00051Q\u0001\u0005\b\u0007\u001baC\u0011AB\b\u0011\u001d\u0019y\u0002\fC\u0005\u0007CA\u0011ba\n-\u0003\u0003%Ia!\u000b\u0003#A\u000b'/];fi\u001aKG.\u001a$pe6\fGO\u0003\u00027o\u00059\u0001/\u0019:rk\u0016$(B\u0001\u001d:\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005iZ\u0014!C3yK\u000e,H/[8o\u0015\taT(A\u0002tc2T!AP \u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\u000b\u0015AB1qC\u000eDWMC\u0001C\u0003\ry'oZ\u0002\u0001'\u0019\u0001QiS(V7B\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n1\u0011I\\=SK\u001a\u0004\"\u0001T'\u000e\u0003]J!AT\u001c\u0003\u0015\u0019KG.\u001a$pe6\fG\u000f\u0005\u0002Q'6\t\u0011K\u0003\u0002Sw\u000591o\\;sG\u0016\u001c\u0018B\u0001+R\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0011\u0005YKV\"A,\u000b\u0005ak\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005i;&a\u0002'pO\u001eLgn\u001a\t\u0003\rrK!!X$\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005\u0001\u0007CA1\u0001\u001b\u0005)\u0014\u0001\u00069beF,X\r\u001e'pOJ+G-\u001b:fGR|'/F\u0001e!\t\tW-\u0003\u0002gk\t!\u0002+\u0019:rk\u0016$Hj\\4SK\u0012L'/Z2u_J\fQ\u0003]1scV,G\u000fT8h%\u0016$\u0017N]3di>\u0014\b%A\u0005tQ>\u0014HOT1nKR\t!\u000e\u0005\u0002le:\u0011A\u000e\u001d\t\u0003[\u001ek\u0011A\u001c\u0006\u0003_\u000e\u000ba\u0001\u0010:p_Rt\u0014BA9H\u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E<\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001\u001f\t\u0003\rfL!A_$\u0003\u0007%sG/\u0001\u0004fcV\fGn\u001d\u000b\u0004{\u0006\u0005\u0001C\u0001$\u007f\u0013\tyxIA\u0004C_>dW-\u00198\t\u000f\u0005\rq\u00011\u0001\u0002\u0006\u0005)q\u000e\u001e5feB\u0019a)a\u0002\n\u0007\u0005%qIA\u0002B]f\fA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$\"\"a\u0004\u0002\u0016\u0005\u0005\u0012QGA !\ra\u0015\u0011C\u0005\u0004\u0003'9$aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\bbBA\f\u0011\u0001\u0007\u0011\u0011D\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u00037\ti\"D\u0001<\u0013\r\tyb\u000f\u0002\r'B\f'o[*fgNLwN\u001c\u0005\b\u0003GA\u0001\u0019AA\u0013\u0003\rQwN\u0019\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003%i\u0017\r\u001d:fIV\u001cWMC\u0002\u00020}\na\u0001[1e_>\u0004\u0018\u0002BA\u001a\u0003S\u00111AS8c\u0011\u001d\t9\u0004\u0003a\u0001\u0003s\tqa\u001c9uS>t7\u000fE\u0003l\u0003wQ'.C\u0002\u0002>Q\u00141!T1q\u0011\u001d\t\t\u0005\u0003a\u0001\u0003\u0007\n!\u0002Z1uCN\u001b\u0007.Z7b!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%w\u0005)A/\u001f9fg&!\u0011QJA$\u0005)\u0019FO];diRK\b/Z\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0005\u0002T\u0005e\u00131LA0!\u00151\u0015QKA\"\u0013\r\t9f\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005]\u0011\u00021\u0001\u0002\u001a!9\u0011QL\u0005A\u0002\u0005e\u0012A\u00039be\u0006lW\r^3sg\"9\u0011\u0011M\u0005A\u0002\u0005\r\u0014!\u00024jY\u0016\u001c\bCBA3\u0003_\n)H\u0004\u0003\u0002h\u0005-dbA7\u0002j%\t\u0001*C\u0002\u0002n\u001d\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002r\u0005M$aA*fc*\u0019\u0011QN$\u0011\t\u0005]\u0014QP\u0007\u0003\u0003sRA!a\u001f\u0002.\u0005\u0011am]\u0005\u0005\u0003\u007f\nIH\u0001\u0006GS2,7\u000b^1ukN\u0014\u0011BR5mKRK\b/Z:\u0014\u000b))\u0015QQ.\u0011\u0007\u0019\u000b9)C\u0002\u0002\n\u001e\u0013q\u0001\u0015:pIV\u001cG/\u0001\u0003eCR\fWCAA2\u0003\u0015!\u0017\r^1!\u0003!iW\r^1eCR\f\u0017!C7fi\u0006$\u0017\r^1!\u00039\u0019w.\\7p]6+G/\u00193bi\u0006\fqbY8n[>tW*\u001a;bI\u0006$\u0018\r\t\u000b\t\u00037\u000by*!)\u0002$B\u0019\u0011Q\u0014\u0006\u000e\u0003\u0001Aq!a#\u0012\u0001\u0004\t\u0019\u0007C\u0004\u0002\u0012F\u0001\r!a\u0019\t\u000f\u0005U\u0015\u00031\u0001\u0002d\u0005!1m\u001c9z)!\tY*!+\u0002,\u00065\u0006\"CAF%A\u0005\t\u0019AA2\u0011%\t\tJ\u0005I\u0001\u0002\u0004\t\u0019\u0007C\u0005\u0002\u0016J\u0001\n\u00111\u0001\u0002d\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAZU\u0011\t\u0019'!.,\u0005\u0005]\u0006\u0003BA]\u0003\u0007l!!a/\u000b\t\u0005u\u0016qX\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!1H\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\fYLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\r\u0005\u0003\u0002R\u0006mWBAAj\u0015\u0011\t).a6\u0002\t1\fgn\u001a\u0006\u0003\u00033\fAA[1wC&\u00191/a5\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003a\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0006\u0005\u0015\b\u0002CAt1\u0005\u0005\t\u0019\u0001=\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u000f\u0005\u0004\u0002p\u0006U\u0018QA\u0007\u0003\u0003cT1!a=H\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003o\f\tP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA?\u0002~\"I\u0011q\u001d\u000e\u0002\u0002\u0003\u0007\u0011Q\u0001\u000b\u0003\u0003\u001f$2! B\u0002\u0011%\t9/HA\u0001\u0002\u0004\t)!A\u0005GS2,G+\u001f9fgB\u0019\u0011QT\u0010\u0014\t}\u0011Ya\u0017\t\r\u0005\u001b\u0011\u0019\"a\u0019\u0002d\u0005\r\u00141T\u0007\u0003\u0005\u001fQ1A!\u0005H\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0006\u0003\u0010\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\t\u001d\u0011!B1qa2LH\u0003CAN\u0005;\u0011yB!\t\t\u000f\u0005-%\u00051\u0001\u0002d!9\u0011\u0011\u0013\u0012A\u0002\u0005\r\u0004bBAKE\u0001\u0007\u00111M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00119Ca\f\u0011\u000b\u0019\u000b)F!\u000b\u0011\u0013\u0019\u0013Y#a\u0019\u0002d\u0005\r\u0014b\u0001B\u0017\u000f\n1A+\u001e9mKNB\u0011B!\r$\u0003\u0003\u0005\r!a'\u0002\u0007a$\u0003'\u0001\u0006ta2LGOR5mKN$B!a'\u00038!9!\u0011\b\u0013A\u0002\u0005\r\u0014\u0001C1mY\u001aKG.Z:\u0002\u001b%\u001c8+^7nCJLh)\u001b7f)\ri(q\b\u0005\b\u0005\u0003*\u0003\u0019\u0001B\"\u0003\u00111\u0017\u000e\\3\u0011\t\u0005]$QI\u0005\u0005\u0005\u000f\nIH\u0001\u0003QCRD\u0017\u0001D:vaB|'\u000f\u001e\"bi\u000eDG#B?\u0003N\t=\u0003bBA\fM\u0001\u0007\u0011\u0011\u0004\u0005\b\u0005#2\u0003\u0019AA\"\u0003\u0019\u00198\r[3nC\u0006Ya/Z2u_J$\u0016\u0010]3t)!\u00119Fa\u0017\u0003`\t\r\u0004#\u0002$\u0002V\te\u0003#BA3\u0003_R\u0007b\u0002B/O\u0001\u0007\u00111I\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011\u001d\u0011\tg\na\u0001\u0003\u0007\nq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\b\u0005K:\u0003\u0019\u0001B4\u0003\u001d\u0019\u0018\u000f\\\"p]\u001a\u0004BA!\u001b\u0003n5\u0011!1\u000e\u0006\u00031nJAAa\u001c\u0003l\t91+\u0015'D_:4\u0017aC5t'Bd\u0017\u000e^1cY\u0016$r! B;\u0005o\u0012I\bC\u0004\u0002\u0018!\u0002\r!!\u0007\t\u000f\u0005]\u0002\u00061\u0001\u0002:!9!1\u0010\u0015A\u0002\t\r\u0013\u0001\u00029bi\"\faDY;jY\u0012\u0014V-\u00193fe^KG\u000f\u001b)beRLG/[8o-\u0006dW/Z:\u0015!\t\u0005%Q\u0014BP\u0005C\u0013\u0019K!*\u00032\nM\u0006c\u0002$\u0003\u0004\n\u001d%QR\u0005\u0004\u0005\u000b;%!\u0003$v]\u000e$\u0018n\u001c82!\ra%\u0011R\u0005\u0004\u0005\u0017;$a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\r\u0005\u0015$q\u0012BI\u0013\u0011\t90a\u001d\u0011\t\tM%\u0011T\u0007\u0003\u0005+S1Aa&<\u0003!\u0019\u0017\r^1msN$\u0018\u0002\u0002BN\u0005+\u00131\"\u00138uKJt\u0017\r\u001c*po\"9\u0011qC\u0015A\u0002\u0005e\u0001bBA!S\u0001\u0007\u00111\t\u0005\b\u0005CJ\u0003\u0019AA\"\u0011\u001d\u0011i&\u000ba\u0001\u0003\u0007BqAa**\u0001\u0004\u0011I+A\u0004gS2$XM]:\u0011\r\u0005\u0015\u0014q\u000eBV!\r\u0001&QV\u0005\u0004\u0005_\u000b&A\u0002$jYR,'\u000fC\u0004\u00028%\u0002\r!!\u000f\t\u000f\tU\u0016\u00061\u0001\u00038\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\te&qX\u0007\u0003\u0005wSAA!0\u0002.\u0005!1m\u001c8g\u0013\u0011\u0011\tMa/\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003=\u0019X\u000f\u001d9peR$\u0015\r^1UsB,G#B?\u0003H\nE\u0007b\u0002BeU\u0001\u0007!1Z\u0001\tI\u0006$\u0018\rV=qKB!\u0011Q\tBg\u0013\u0011\u0011y-a\u0012\u0003\u0011\u0011\u000bG/\u0019+za\u0016DaAa5+\u0001\u0004i\u0018AC5t%\u0016\fG\rU1uQ\u0006\t\u0002+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;\u0011\u0005\u0005d3\u0003\u0002\u0017F+n#\"Aa6\u0002\u0015I,\u0017\rZ*dQ\u0016l\u0017\r\u0006\u0004\u0002T\t\u0005(1\u001f\u0005\b\u0005Gt\u0003\u0019\u0001Bs\u0003\u001d1wn\u001c;feN\u0004b!!\u001a\u0002p\t\u001d\b\u0003\u0002Bu\u0005_l!Aa;\u000b\t\u0005=\"Q\u001e\u0006\u0003m}JAA!=\u0003l\n1ai\\8uKJDq!a\u0006/\u0001\u0004\tI\"\u0001\u000fsK\u0006$\u0007+\u0019:rk\u0016$hi\\8uKJ\u001c\u0018J\u001c)be\u0006dG.\u001a7\u0015\u0011\t\u0015(\u0011 B~\u0005\u007fDqA!00\u0001\u0004\u00119\fC\u0004\u0003~>\u0002\r!a\u0019\u0002\u0013A\f'\u000f\u001e$jY\u0016\u001c\bBBB\u0001_\u0001\u0007Q0\u0001\njO:|'/Z\"peJ,\b\u000f\u001e$jY\u0016\u001c\u0018AF7fe\u001e,7k\u00195f[\u0006\u001c\u0018J\u001c)be\u0006dG.\u001a7\u0015\r\u0005M3qAB\u0006\u0011\u001d\u0019I\u0001\ra\u0001\u0003G\nABZ5mKN$v\u000eV8vG\"Dq!a\u00061\u0001\u0004\tI\"\u0001\u000bsK\u0006$7k\u00195f[\u00064%o\\7G_>$XM\u001d\u000b\u0007\u0003\u0007\u001a\tb!\u0006\t\u000f\rM\u0011\u00071\u0001\u0003h\u00061am\\8uKJDqaa\u00062\u0001\u0004\u0019I\"A\u0005d_:4XM\u001d;feB\u0019\u0011ma\u0007\n\u0007\ruQGA\u000fQCJ\fX/\u001a;U_N\u0003\u0018M]6TG\",W.Y\"p]Z,'\u000f^3s\u0003]!Wm]3sS\u0006d\u0017N_3TG\",W.Y*ue&tw\r\u0006\u0003\u0002T\r\r\u0002BBB\u0013e\u0001\u0007!.\u0001\u0007tG\",W.Y*ue&tw-A\u0006sK\u0006$'+Z:pYZ,GCAB\u0016!\u0011\t\tn!\f\n\t\r=\u00121\u001b\u0002\u0007\u001f\nTWm\u0019;")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
scala.Serializable {
    private volatile ParquetFileFormat$FileTypes$ FileTypes$module;
    private final ParquetLogRedirector parquetLogRedirector;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter parquetToSparkSchemaConverter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, parquetToSparkSchemaConverter);
    }

    public static Option<StructType> mergeSchemasInParallel(Seq<FileStatus> seq, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(seq, sparkSession);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    public ParquetFileFormat$FileTypes$ FileTypes() {
        if (this.FileTypes$module == null) {
            this.FileTypes$lzycompute$1();
        }
        return this.FileTypes$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ParquetLogRedirector parquetLogRedirector() {
        return this.parquetLogRedirector;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().writeLegacyParquetFormat())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sparkSession.sessionState().conf().parquetOutputTimestampType().toString());
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append(new StringBuilder(58).append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString()).toString());
        }
        return new OutputWriterFactory(null){
            private final ParquetLogRedirector parquetLogRedirector;

            private ParquetLogRedirector parquetLogRedirector() {
                return this.parquetLogRedirector;
            }

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
            {
                this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
            }
        };
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        Seq seq;
        ParquetOptions parquetOptions = new ParquetOptions(parameters, sparkSession.sessionState().conf());
        boolean shouldMergeSchemas = parquetOptions.mergeSchema();
        boolean mergeRespectSummaries = sparkSession.sessionState().conf().isParquetSchemaRespectSummaries();
        FileTypes filesByType = this.splitFiles(files);
        if (shouldMergeSchemas) {
            Seq needMerged = mergeRespectSummaries ? (Seq)Seq$.MODULE$.empty() : filesByType.data();
            seq = (Seq)((TraversableLike)needMerged.$plus$plus(filesByType.metadata(), Seq$.MODULE$.canBuildFrom())).$plus$plus(filesByType.commonMetadata(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(filesByType.commonMetadata().headOption().orElse((Function0 & Serializable & scala.Serializable)() -> filesByType.metadata().headOption()).orElse((Function0 & Serializable & scala.Serializable)() -> filesByType.data().headOption())).toSeq();
        }
        Seq filesToTouch = seq;
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel((Seq<FileStatus>)filesToTouch, sparkSession);
    }

    private FileTypes splitFiles(Seq<FileStatus> allFiles) {
        FileStatus[] leaves = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().toString(), (Ordering)Ordering.String$.MODULE$);
        return new FileTypes(this, (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.isSummaryFile(f.getPath())))), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$splitFiles$3(x$2)))), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$splitFiles$4(x$3)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSummaryFile(Path file) {
        String string = file.getName();
        String string2 = "_common_metadata";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = file.getName();
        String string4 = "_metadata";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.parquetVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema.length() <= conf.wholeStageMaxNumFields() && schema.forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$supportBatch$1(x$4)));
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply((Object)Seq$.MODULE$.fill(requiredSchema.fields().length + partitionSchema.fields().length, (Function0 & Serializable & scala.Serializable)() -> !sqlConf.offHeapColumnVectorEnabled() ? OnHeapColumnVector.class.getName() : OffHeapColumnVector.class.getName()));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        ParquetWriteSupport$.MODULE$.setSchema(requiredSchema, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$5)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        int capacity = sqlConf.parquetVectorizedReaderBatchSize();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        return (Function1 & Serializable & scala.Serializable)file -> {
            RecordReaderIterator<Object> recordReaderIterator;
            None$ none$;
            LazyRef footerFileMetaData$lzy = new LazyRef();
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            FileSplit fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Path filePath = fileSplit.getPath();
            ParquetInputSplit split = new ParquetInputSplit(filePath, fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength(), fileSplit.getLength(), fileSplit.getLocations(), null);
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringStartWith, pushDownInFilterThreshold, isCaseSensitive);
                none$ = ((TraversableOnce)filters.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter(parquetSchema, (Filter)x$6)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !ParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData$lzy, sharedConf, filePath) ? new Some((Object)DateTimeUtils$.MODULE$.getTimeZone(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((TimeZone)convertTz.orNull(Predef$.MODULE$.$conforms()), enableOffHeapColumnVector && taskContext.isDefined(), capacity);
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
                taskContext.foreach((Function1 & Serializable & scala.Serializable)x$7 -> x$7.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$8 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Appending ").append(partitionSchema).append(" ").append(file.partitionValues()).toString());
                vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                if (returningBatch) {
                    vectorizedReader.enableReturningBatches();
                }
                recordReaderIterator = iter;
            } else {
                ParquetRecordReader parquetRecordReader;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
                if (pushed.isDefined() && enableRecordFilter) {
                    FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport((Option<TimeZone>)convertTz), parquetFilter);
                } else {
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport((Option<TimeZone>)convertTz));
                }
                ParquetRecordReader reader = parquetRecordReader;
                RecordReaderIterator iter = new RecordReaderIterator(reader);
                taskContext.foreach((Function1 & Serializable & scala.Serializable)x$9 -> x$9.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$10 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((GenTraversableOnce)partitionSchema.toAttributes(), Seq$.MODULE$.canBuildFrom());
                JoinedRow joinedRow = new JoinedRow();
                UnsafeProjection appendPartitionColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                recordReaderIterator = partitionSchema.length() == 0 ? iter : iter.map((Function1 & Serializable & scala.Serializable)d -> appendPartitionColumns.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
            }
            return recordReaderIterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType(), isReadPath)));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType, isReadPath);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType, isReadPath) && this.supportDataType(valueType, isReadPath);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType(), isReadPath);
        } else {
            bl = false;
        }
        return bl;
    }

    private final void FileTypes$lzycompute$1() {
        ParquetFileFormat parquetFileFormat = this;
        synchronized (parquetFileFormat) {
            if (this.FileTypes$module == null) {
                this.FileTypes$module = new ParquetFileFormat$FileTypes$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$3(FileStatus x$2) {
        String string = x$2.getPath().getName();
        String string2 = "_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$splitFiles$4(FileStatus x$3) {
        String string = x$3.getPath().getName();
        String string2 = "_common_metadata";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$supportBatch$1(StructField x$4) {
        return x$4.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$5) {
        return x$5.dataType() instanceof AtomicType;
    }

    private static final /* synthetic */ FileMetaData footerFileMetaData$lzycompute$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        FileMetaData fileMetaData;
        LazyRef lazyRef = footerFileMetaData$lzy$1;
        synchronized (lazyRef) {
            fileMetaData = footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : (FileMetaData)footerFileMetaData$lzy$1.initialize((Object)ParquetFileReader.readFooter((Configuration)sharedConf$1, (Path)filePath$1, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData());
        }
        return fileMetaData;
    }

    private static final FileMetaData footerFileMetaData$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : ParquetFileFormat.footerFileMetaData$lzycompute$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1);
    }

    private static final boolean isCreatedByParquetMr$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1).getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetFileFormat() {
        FileFormat.$init$(this);
        Logging.$init$((Logging)this);
        this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
    }

    public class FileTypes
    implements Product,
    scala.Serializable {
        private final Seq<FileStatus> data;
        private final Seq<FileStatus> metadata;
        private final Seq<FileStatus> commonMetadata;
        public final /* synthetic */ ParquetFileFormat $outer;

        public Seq<FileStatus> data() {
            return this.data;
        }

        public Seq<FileStatus> metadata() {
            return this.metadata;
        }

        public Seq<FileStatus> commonMetadata() {
            return this.commonMetadata;
        }

        public FileTypes copy(Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            return new FileTypes(this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer(), data, metadata, commonMetadata);
        }

        public Seq<FileStatus> copy$default$1() {
            return this.data();
        }

        public Seq<FileStatus> copy$default$2() {
            return this.metadata();
        }

        public Seq<FileStatus> copy$default$3() {
            return this.commonMetadata();
        }

        public String productPrefix() {
            return "FileTypes";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<FileStatus> seq;
            int n = x$1;
            switch (n) {
                case 0: {
                    seq = this.data();
                    break;
                }
                case 1: {
                    seq = this.metadata();
                    break;
                }
                case 2: {
                    seq = this.commonMetadata();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileTypes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileTypes)) return false;
            if (((FileTypes)object).org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() != this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FileTypes fileTypes = (FileTypes)x$1;
            Seq<FileStatus> seq = this.data();
            Seq<FileStatus> seq2 = fileTypes.data();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<FileStatus> seq3 = this.metadata();
            Seq<FileStatus> seq4 = fileTypes.metadata();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            Seq<FileStatus> seq5 = this.commonMetadata();
            Seq<FileStatus> seq6 = fileTypes.commonMetadata();
            if (seq5 == null) {
                if (seq6 != null) {
                    return false;
                }
            } else if (!seq5.equals(seq6)) return false;
            if (!fileTypes.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ParquetFileFormat org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() {
            return this.$outer;
        }

        public FileTypes(ParquetFileFormat $outer, Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            this.data = data;
            this.metadata = metadata;
            this.commonMetadata = commonMetadata;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

