/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeExec$;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.joins.HashedRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SparkFatalException;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005}!A\u0011\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005P\u0001\tE\t\u0015!\u0003L\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011!)\u0006\u0001#b\u0001\n\u00032\u0006\"B7\u0001\t\u0003r\u0007\"\u0002:\u0001\t\u0003\u001a\bb\u0002;\u0001\u0005\u0004%I!\u001e\u0005\u0007}\u0002\u0001\u000b\u0011\u0002<\t\u0015\u0005\u001d\u0001\u0001#b\u0001\n\u0013\tI\u0001C\u0004\u0002(\u0001!\t&!\u000b\t\u000f\u0005E\u0002\u0001\"\u0015\u00024!A\u0011\u0011\n\u0001\u0005R\u0015\nY\u0005C\u0005\u0002b\u0001\t\t\u0011\"\u0001\u0002d!I\u0011\u0011\u000e\u0001\u0012\u0002\u0013\u0005\u00111\u000e\u0005\n\u0003\u0003\u0003\u0011\u0013!C\u0001\u0003\u0007C\u0011\"a\"\u0001\u0003\u0003%\t%!#\t\u0013\u0005-\u0005!!A\u0005\u0002\u00055\u0005\"CAK\u0001\u0005\u0005I\u0011AAL\u0011%\ti\nAA\u0001\n\u0003\ny\nC\u0005\u0002*\u0002\t\t\u0011\"\u0001\u0002,\"I\u0011Q\u0017\u0001\u0002\u0002\u0013\u0005\u0013qW\u0004\b\u0003w\u000b\u0003\u0012AA_\r\u0019\u0001\u0013\u0005#\u0001\u0002@\"1\u0001+\u0007C\u0001\u0003\u000fD!\"!3\u001a\u0005\u0004%\taIAf\u0011!\t\u0019.\u0007Q\u0001\n\u00055\u0007\"CAk3\u0005\u0005I\u0011QAl\u0011%\ti.GA\u0001\n\u0003\u000by\u000eC\u0005\u0002rf\t\t\u0011\"\u0003\u0002t\n)\"I]8bI\u000e\f7\u000f^#yG\"\fgnZ3Fq\u0016\u001c'B\u0001\u0012$\u0003!)\u0007p\u00195b]\u001e,'B\u0001\u0013&\u0003%)\u00070Z2vi&|gN\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001_MJ\u0004C\u0001\u00192\u001b\u0005\t\u0013B\u0001\u001a\"\u0005!)\u0005p\u00195b]\u001e,\u0007C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$a\u0002)s_\u0012,8\r\u001e\t\u0003iiJ!aO\u001b\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t5|G-Z\u000b\u0002}A\u0011qHR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\ta\"L8/[2bY*\u00111\tR\u0001\u0006a2\fgn\u001d\u0006\u0003\u000b\u0016\n\u0001bY1uC2L8\u000f^\u0005\u0003\u000f\u0002\u0013QB\u0011:pC\u0012\u001c\u0017m\u001d;N_\u0012,\u0017!B7pI\u0016\u0004\u0013!B2iS2$W#A&\u0011\u00051kU\"A\u0012\n\u00059\u001b#!C*qCJ\\\u0007\u000b\\1o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"2AU*U!\t\u0001\u0004\u0001C\u0003=\u000b\u0001\u0007a\bC\u0003J\u000b\u0001\u00071*A\u0004nKR\u0014\u0018nY:\u0016\u0003]\u0003B\u0001W/`O6\t\u0011L\u0003\u0002[7\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u00039V\n!bY8mY\u0016\u001cG/[8o\u0013\tq\u0016LA\u0002NCB\u0004\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\t1\fgn\u001a\u0006\u0002I\u0006!!.\u0019<b\u0013\t1\u0017M\u0001\u0004TiJLgn\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u000e\na!\\3ue&\u001c\u0017B\u00017j\u0005%\u0019\u0016\u000bT'fiJL7-\u0001\npkR\u0004X\u000f\u001e)beRLG/[8oS:<W#A8\u0011\u0005}\u0002\u0018BA9A\u00051\u0001\u0016M\u001d;ji&|g.\u001b8h\u00039!wnQ1o_:L7-\u00197ju\u0016$\u0012aS\u0001\bi&lWm\\;u+\u00051\bCA<}\u001b\u0005A(BA={\u0003!!WO]1uS>t'BA>6\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003{b\u0014\u0001\u0002R;sCRLwN\\\u0001\ti&lWm\\;uA!\u001a!\"!\u0001\u0011\u0007Q\n\u0019!C\u0002\u0002\u0006U\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001dI,G.\u0019;j_:4U\u000f^;sKV\u0011\u00111\u0002\t\u0007\u0003\u001b\ty!a\u0005\u000e\u0003iL1!!\u0005{\u0005\u00191U\u000f^;sKB1\u0011QCA\u000e\u0003?i!!a\u0006\u000b\u0007\u0005eq%A\u0005ce>\fGmY1ti&!\u0011QDA\f\u0005%\u0011%o\\1eG\u0006\u001cH\u000fE\u00025\u0003CI1!a\t6\u0005\r\te.\u001f\u0015\u0004\u0017\u0005\u0005\u0011!\u00033p!J,\u0007/\u0019:f)\t\tY\u0003E\u00025\u0003[I1!a\f6\u0005\u0011)f.\u001b;\u0002\u0013\u0011|W\t_3dkR,GCAA\u001b!\u0019\t9$!\u0010\u0002B5\u0011\u0011\u0011\b\u0006\u0004\u0003w9\u0013a\u0001:eI&!\u0011qHA\u001d\u0005\r\u0011F\t\u0012\t\u0005\u0003\u0007\n)%D\u0001E\u0013\r\t9\u0005\u0012\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\ne_\u0016CXmY;uK\n\u0013x.\u00193dCN$X\u0003BA'\u0003+\"\"!a\u0014\u0011\r\u0005U\u00111DA)!\u0011\t\u0019&!\u0016\r\u0001\u00119\u0011q\u000b\bC\u0002\u0005e#!\u0001+\u0012\t\u0005m\u0013q\u0004\t\u0004i\u0005u\u0013bAA0k\t9aj\u001c;iS:<\u0017\u0001B2paf$RAUA3\u0003OBq\u0001P\b\u0011\u0002\u0003\u0007a\bC\u0004J\u001fA\u0005\t\u0019A&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u000e\u0016\u0004}\u0005=4FAA9!\u0011\t\u0019(! \u000e\u0005\u0005U$\u0002BA<\u0003s\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mT'\u0001\u0006b]:|G/\u0019;j_:LA!a \u0002v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0011\u0016\u0004\u0017\u0006=\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001`\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\tE\u00025\u0003#K1!a%6\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty\"!'\t\u0013\u0005mE#!AA\u0002\u0005=\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\"B1\u00111UAS\u0003?i\u0011aW\u0005\u0004\u0003O[&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!,\u00024B\u0019A'a,\n\u0007\u0005EVGA\u0004C_>dW-\u00198\t\u0013\u0005me#!AA\u0002\u0005}\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002.\u0006e\u0006\"CAN/\u0005\u0005\t\u0019AA\u0010\u0003U\u0011%o\\1eG\u0006\u001cH/\u0012=dQ\u0006tw-Z#yK\u000e\u0004\"\u0001M\r\u0014\te\t\t-\u000f\t\u0004i\u0005\r\u0017bAAck\t1\u0011I\\=SK\u001a$\"!!0\u0002!\u0015DXmY;uS>t7i\u001c8uKb$XCAAg!\u0011\ti!a4\n\u0007\u0005E'PA\u0010Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0011\u0016\u0011\\An\u0011\u0015aT\u00041\u0001?\u0011\u0015IU\u00041\u0001L\u0003\u001d)h.\u00199qYf$B!!9\u0002nB)A'a9\u0002h&\u0019\u0011Q]\u001b\u0003\r=\u0003H/[8o!\u0015!\u0014\u0011\u001e L\u0013\r\tY/\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005=h$!AA\u0002I\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\bc\u00011\u0002x&\u0019\u0011\u0011`1\u0003\r=\u0013'.Z2u\u0001")
public class BroadcastExchangeExec
extends Exchange {
    private Map<String, SQLMetric> metrics;
    private transient Future<Broadcast<Object>> relationFuture;
    private final BroadcastMode mode;
    private final SparkPlan child;
    private final transient Duration timeout;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<BroadcastMode, SparkPlan>> unapply(BroadcastExchangeExec broadcastExchangeExec) {
        return BroadcastExchangeExec$.MODULE$.unapply(broadcastExchangeExec);
    }

    public BroadcastMode mode() {
        return this.mode;
    }

    @Override
    public SparkPlan child() {
        return this.child;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataSize"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "data size (bytes)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collectTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to collect (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buildTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to build (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broadcastTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to broadcast (ms)"))}));
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    @Override
    public Partitioning outputPartitioning() {
        return new BroadcastPartitioning(this.mode());
    }

    public SparkPlan doCanonicalize() {
        return new BroadcastExchangeExec(this.mode().canonicalized(), (SparkPlan)this.child().canonicalized());
    }

    private Duration timeout() {
        return this.timeout;
    }

    private Future<Broadcast<Object>> relationFuture$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$trans$0) {
                String executionId = this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
                this.relationFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Broadcast)SQLExecution$.MODULE$.withExecutionId(this.sqlContext().sparkSession(), executionId, (Function0 & Serializable & scala.Serializable)() -> {
                    Broadcast broadcast;
                    try {
                        long l;
                        Object relation;
                        long beforeCollect = System.nanoTime();
                        Tuple2<Object, Iterator<InternalRow>> tuple2 = this.child().executeCollectIterator();
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        long numRows = tuple2._1$mcJ$sp();
                        Iterator input = (Iterator)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numRows), (Object)input);
                        Tuple2 tuple23 = tuple22;
                        long numRows2 = tuple23._1$mcJ$sp();
                        Iterator input2 = (Iterator)tuple23._2();
                        if (numRows2 >= 512000000L) {
                            throw new SparkException(new StringBuilder(66).append("Cannot broadcast the table with more than 512 millions rows: ").append(numRows2).append(" rows").toString());
                        }
                        long beforeBuild = System.nanoTime();
                        this.longMetric("collectTime").$plus$eq((beforeBuild - beforeCollect) / 1000000L);
                        Object object = relation = this.mode().transform(input2, (Option)new Some((Object)BoxesRunTime.boxToLong((long)numRows2)));
                        if (object instanceof HashedRelation) {
                            HashedRelation hashedRelation = (HashedRelation)object;
                            l = hashedRelation.estimatedSize();
                        } else if (object instanceof InternalRow[]) {
                            InternalRow[] internalRowArray = (InternalRow[])object;
                            l = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])internalRowArray)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)BroadcastExchangeExec.$anonfun$relationFuture$3(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                        } else {
                            throw new SparkException(new StringBuilder(56).append("[BUG] BroadcastMode.transform returned unexpected type: ").append(relation.getClass().getName()).toString());
                        }
                        long dataSize = l;
                        this.longMetric("dataSize").$plus$eq(dataSize);
                        if (dataSize >= 0x200000000L) {
                            throw new SparkException(new StringBuilder(55).append("Cannot broadcast the table that is larger than 8GB: ").append(dataSize >> 30).append(" GB").toString());
                        }
                        long beforeBroadcast = System.nanoTime();
                        this.longMetric("buildTime").$plus$eq((beforeBroadcast - beforeBuild) / 1000000L);
                        Broadcast broadcasted = this.sparkContext().broadcast(relation, ClassTag$.MODULE$.Any());
                        this.longMetric("broadcastTime").$plus$eq((System.nanoTime() - beforeBroadcast) / 1000000L);
                        SQLMetrics$.MODULE$.postDriverMetricUpdates(this.sparkContext(), executionId, (Seq<SQLMetric>)this.metrics().values().toSeq());
                        broadcast = broadcasted;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new SparkFatalException(new OutOfMemoryError(new StringBuilder(133).append("Not enough memory to build and broadcast the table to ").append("all worker nodes. As a workaround, you can either disable broadcast by setting ").append(new StringBuilder(36).append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append(" to -1 or increase the spark driver ").toString()).append(new StringBuilder(55).append("memory by setting ").append("spark.driver.memory").append(" to a higher value").toString()).toString()).initCause(outOfMemoryError.getCause()));
                    }
                    catch (Throwable throwable) {
                        if (!NonFatal$.MODULE$.apply(throwable)) {
                            throw new SparkFatalException(throwable);
                        }
                        throw throwable;
                    }
                    return broadcast;
                }), (ExecutionContext)BroadcastExchangeExec$.MODULE$.executionContext());
                this.bitmap$trans$0 = true;
            }
        }
        return this.relationFuture;
    }

    private Future<Broadcast<Object>> relationFuture() {
        return !this.bitmap$trans$0 ? this.relationFuture$lzycompute() : this.relationFuture;
    }

    @Override
    public void doPrepare() {
        this.relationFuture();
    }

    @Override
    public RDD<InternalRow> doExecute() {
        throw new UnsupportedOperationException("BroadcastExchange does not support the execute() code path.");
    }

    @Override
    public <T> Broadcast<T> doExecuteBroadcast() {
        Broadcast broadcast;
        try {
            broadcast = (Broadcast)ThreadUtils$.MODULE$.awaitResult(this.relationFuture(), this.timeout());
        }
        catch (TimeoutException ex) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Could not execute broadcast in ").append(this.timeout().toSeconds()).append(" secs.").toString(), ex);
            throw new SparkException(new StringBuilder(38).append("Could not execute broadcast in ").append(this.timeout().toSeconds()).append(" secs. ").append(new StringBuilder(52).append("You can increase the timeout for broadcasts via ").append(SQLConf$.MODULE$.BROADCAST_TIMEOUT().key()).append(" or ").toString()).append(new StringBuilder(40).append("disable broadcast join by setting ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append(" to -1").toString()).toString(), (Throwable)ex);
        }
        return broadcast;
    }

    public BroadcastExchangeExec copy(BroadcastMode mode, SparkPlan child) {
        return new BroadcastExchangeExec(mode, child);
    }

    public BroadcastMode copy$default$1() {
        return this.mode();
    }

    public SparkPlan copy$default$2() {
        return this.child();
    }

    public String productPrefix() {
        return "BroadcastExchangeExec";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.mode();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BroadcastExchangeExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BroadcastExchangeExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        BroadcastExchangeExec broadcastExchangeExec = (BroadcastExchangeExec)x$1;
        BroadcastMode broadcastMode = this.mode();
        BroadcastMode broadcastMode2 = broadcastExchangeExec.mode();
        if (broadcastMode == null) {
            if (broadcastMode2 != null) {
                return false;
            }
        } else if (!broadcastMode.equals(broadcastMode2)) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = broadcastExchangeExec.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        if (!broadcastExchangeExec.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$relationFuture$3(InternalRow x$2) {
        return ((UnsafeRow)x$2).getSizeInBytes();
    }

    public BroadcastExchangeExec(BroadcastMode mode, SparkPlan child) {
        this.mode = mode;
        this.child = child;
        long timeoutValue = this.sqlContext().conf().broadcastTimeout();
        this.timeout = timeoutValue < 0L ? Duration$.MODULE$.Inf() : new package.DurationLong(package$.MODULE$.DurationLong(timeoutValue)).seconds();
    }
}

