/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\b\u0011\u0001uA\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\")A\u000b\u0001C\u0001+\"9\u0001\n\u0001b\u0001\n#I\u0006BB/\u0001A\u0003%!\fC\u0003_\u0001\u0011\u0005s\fC\u0003m\u0001\u0011\u0005S\u000eC\u0003s\u0001\u0011\u00053\u000fC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003_\u0001A\u0011IA\u0019\u0005\u00112\u0015\u000e\\3TsN$X-\u001c\"bg\u0016$7\t[3dWB|\u0017N\u001c;GS2,W*\u00198bO\u0016\u0014(BA\t\u0013\u0003%\u0019HO]3b[&twM\u0003\u0002\u0014)\u0005IQ\r_3dkRLwN\u001c\u0006\u0003+Y\t1a]9m\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0006\u0001y!\u0003F\u0010\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00152S\"\u0001\t\n\u0005\u001d\u0002\"!F\"iK\u000e\\\u0007o\\5oi\u001aKG.Z'b]\u0006<WM\u001d\t\u0003Smr!AK\u001d\u000f\u0005-BdB\u0001\u00178\u001d\ticG\u0004\u0002/k9\u0011q\u0006\u000e\b\u0003aMj\u0011!\r\u0006\u0003eq\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005eQ\u0012BA\f\u0019\u0013\t)b#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003uA\tQc\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'/\u0003\u0002={\t\u0019\"+\u001a8b[\u0016DU\r\u001c9fe6+G\u000f[8eg*\u0011!\b\u0005\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003Z\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0007\u0002\u0013q\u0001T8hO&tw-\u0001\u0003qCRD\u0007C\u0001$L\u001b\u00059%B\u0001%J\u0003\t17O\u0003\u0002K1\u00051\u0001.\u00193p_BL!\u0001T$\u0003\tA\u000bG\u000f[\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007CA(S\u001b\u0005\u0001&BA)J\u0003\u0011\u0019wN\u001c4\n\u0005M\u0003&!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004-^C\u0006CA\u0013\u0001\u0011\u0015!5\u00011\u0001F\u0011\u0015i5\u00011\u0001O+\u0005Q\u0006C\u0001$\\\u0013\tavI\u0001\u0006GS2,7+_:uK6\f1AZ:!\u0003\u0011a\u0017n\u001d;\u0015\u0007\u00014w\rE\u0002 C\u000eL!A\u0019\u0011\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0019#\u0017BA3H\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0006\t\u001a\u0001\r!\u0012\u0005\u0006Q\u001a\u0001\r![\u0001\u0007M&dG/\u001a:\u0011\u0005\u0019S\u0017BA6H\u0005)\u0001\u0016\r\u001e5GS2$XM]\u0001\u0007[.$\u0017N]:\u0015\u00059\f\bCA\u0010p\u0013\t\u0001\bE\u0001\u0003V]&$\b\"\u0002#\b\u0001\u0004)\u0015AD2sK\u0006$X\rV3na\u001aKG.\u001a\u000b\u0003i^\u0004\"AR;\n\u0005Y<%A\u0005$T\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6DQ\u0001\u0012\u0005A\u0002\u0015\u000bAb\u0019:fCR,\u0017\t^8nS\u000e$2A\u001f@\u0000!\tYHP\u0004\u0002&s%\u0011Q0\u0010\u0002\u001e\u0007\u0006t7-\u001a7mC\ndWMR*ECR\fw*\u001e;qkR\u001cFO]3b[\")A)\u0003a\u0001\u000b\"9\u0011\u0011A\u0005A\u0002\u0005\r\u0011aE8wKJ<(/\u001b;f\u0013\u001a\u0004vn]:jE2,\u0007cA\u0010\u0002\u0006%\u0019\u0011q\u0001\u0011\u0003\u000f\t{w\u000e\\3b]\u0006!q\u000e]3o)\u0011\ti!a\u0005\u0011\u0007\u0019\u000by!C\u0002\u0002\u0012\u001d\u0013\u0011CR*ECR\f\u0017J\u001c9viN#(/Z1n\u0011\u0015!%\u00021\u0001F\u0003\u0019)\u00070[:ugR!\u00111AA\r\u0011\u0015!5\u00021\u0001F\u00039\u0011XM\\1nKR+W\u000e\u001d$jY\u0016$rA\\A\u0010\u0003G\t9\u0003\u0003\u0004\u0002\"1\u0001\r!R\u0001\bgJ\u001c\u0007+\u0019;i\u0011\u0019\t)\u0003\u0004a\u0001\u000b\u00069Am\u001d;QCRD\u0007bBA\u0001\u0019\u0001\u0007\u00111A\u0001\u0007I\u0016dW\r^3\u0015\u00079\fi\u0003C\u0003E\u001b\u0001\u0007Q)A\u0004jg2{7-\u00197\u0016\u0005\u0005\r\u0001")
public class FileSystemBasedCheckpointFileManager
implements CheckpointFileManager,
CheckpointFileManager.RenameHelperMethods,
Logging {
    private final FileSystem fs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public FileStatus[] list(Path path) {
        return CheckpointFileManager.list$(this, path);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public FileSystem fs() {
        return this.fs;
    }

    @Override
    public FileStatus[] list(Path path, PathFilter filter) {
        return this.fs().listStatus(path, filter);
    }

    @Override
    public void mkdirs(Path path) {
        this.fs().mkdirs(path, FsPermission.getDirDefault());
    }

    @Override
    public FSDataOutputStream createTempFile(Path path) {
        return this.fs().create(path, true);
    }

    @Override
    public CheckpointFileManager.CancellableFSDataOutputStream createAtomic(Path path, boolean overwriteIfPossible) {
        return new CheckpointFileManager.RenameBasedFSDataOutputStream(this, path, overwriteIfPossible);
    }

    @Override
    public FSDataInputStream open(Path path) {
        return this.fs().open(path);
    }

    @Override
    public boolean exists(Path path) {
        try {
            return this.fs().getFileStatus(path) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public void renameTempFile(Path srcPath, Path dstPath, boolean overwriteIfPossible) {
        if (!overwriteIfPossible && this.fs().exists(dstPath)) {
            throw new FileAlreadyExistsException(new StringBuilder(51).append("Failed to rename ").append(srcPath).append(" to ").append(dstPath).append(" as destination already exists").toString());
        }
        if (!this.fs().rename(srcPath, dstPath)) {
            if (this.fs().exists(dstPath)) {
                if (!overwriteIfPossible) {
                    throw new FileAlreadyExistsException(new StringBuilder(35).append("Failed to rename as ").append(dstPath).append(" already exists").toString());
                }
            } else {
                if (!this.fs().exists(srcPath)) {
                    throw new FileNotFoundException(new StringBuilder(34).append("Failed to rename as ").append(srcPath).append(" was not found").toString());
                }
                String msg = new StringBuilder(56).append("Failed to rename temp file ").append(srcPath).append(" to ").append(dstPath).append(" as rename returned false").toString();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new IOException(msg);
            }
        }
    }

    @Override
    public void delete(Path path) {
        try {
            this.fs().delete(path, true);
        }
        catch (FileNotFoundException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Failed to delete ").append(path).append(" as it does not exist").toString());
        }
    }

    @Override
    public boolean isLocal() {
        FileSystem fileSystem = this.fs();
        boolean bl = fileSystem instanceof LocalFileSystem ? true : fileSystem instanceof RawLocalFileSystem;
        boolean bl2 = bl;
        return bl2;
    }

    public FileSystemBasedCheckpointFileManager(Path path, Configuration hadoopConf) {
        CheckpointFileManager.$init$(this);
        CheckpointFileManager.RenameHelperMethods.$init$(this);
        Logging.$init$((Logging)this);
        this.fs = path.getFileSystem(hadoopConf);
    }
}

