/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous.shuffle;

import java.io.Serializable;
import org.apache.spark.Partitioner;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.continuous.shuffle.ContinuousShuffleWriter;
import org.apache.spark.sql.execution.streaming.continuous.shuffle.ReceiverEpochMarker;
import org.apache.spark.sql.execution.streaming.continuous.shuffle.ReceiverRow;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]3AAB\u0004\u00011!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0011!a\u0003A!A!\u0002\u0013i\u0003\"\u0002\u001c\u0001\t\u00039\u0004\"\u0002\u001f\u0001\t\u0003i$A\u0007*Q\u0007\u000e{g\u000e^5ok>,8o\u00155vM\u001adWm\u0016:ji\u0016\u0014(B\u0001\u0005\n\u0003\u001d\u0019\b.\u001e4gY\u0016T!AC\u0006\u0002\u0015\r|g\u000e^5ok>,8O\u0003\u0002\r\u001b\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u001d=\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005A\t\u0012aA:rY*\u0011!cE\u0001\u0006gB\f'o\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0005j\u0011aB\u0005\u0003E\u001d\u0011qcQ8oi&tWo\\;t'\",hM\u001a7f/JLG/\u001a:\u0002\u0011]\u0014\u0018\u000e^3s\u0013\u0012\u0004\"AG\u0013\n\u0005\u0019Z\"aA%oi\u0006\tr.\u001e;qkR\u0004\u0016M\u001d;ji&|g.\u001a:\u0011\u0005%RS\"A\t\n\u0005-\n\"a\u0003)beRLG/[8oKJ\f\u0011\"\u001a8ea>Lg\u000e^:\u0011\u0007iq\u0003'\u0003\u000207\t)\u0011I\u001d:bsB\u0011\u0011\u0007N\u0007\u0002e)\u00111'E\u0001\u0004eB\u001c\u0017BA\u001b3\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a\fa\u0001P5oSRtD\u0003\u0002\u001d:um\u0002\"\u0001\t\u0001\t\u000b\r\"\u0001\u0019\u0001\u0013\t\u000b\u001d\"\u0001\u0019\u0001\u0015\t\u000b1\"\u0001\u0019A\u0017\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005y\n\u0005C\u0001\u000e@\u0013\t\u00015D\u0001\u0003V]&$\b\"\u0002\"\u0006\u0001\u0004\u0019\u0015!B3q_\u000eD\u0007c\u0001#M\u001f:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u0011^\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005-[\u0012a\u00029bG.\fw-Z\u0005\u0003\u001b:\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003\u0017n\u0001\"\u0001U+\u000e\u0003ES!AU*\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003)>\t\u0001bY1uC2L8\u000f^\u0005\u0003-F\u0013\u0011\"\u00168tC\u001a,'k\\<")
public class RPCContinuousShuffleWriter
implements ContinuousShuffleWriter {
    private final int writerId;
    private final Partitioner outputPartitioner;
    private final RpcEndpointRef[] endpoints;

    @Override
    public void write(Iterator<UnsafeRow> epoch) {
        while (epoch.hasNext()) {
            UnsafeRow row = (UnsafeRow)epoch.next();
            this.endpoints[this.outputPartitioner.getPartition((Object)row)].askSync((Object)new ReceiverRow(this.writerId, row), ClassTag$.MODULE$.Unit());
        }
        Seq futures = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.endpoints)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.ask((Object)new ReceiverEpochMarker($this.writerId), ClassTag$.MODULE$.Unit()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Future.class))))).toSeq();
        ExecutionContextExecutor ec = ThreadUtils$.MODULE$.sameThread();
        ThreadUtils$.MODULE$.awaitResult((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)ec), (Duration)Duration$.MODULE$.Inf());
    }

    public RPCContinuousShuffleWriter(int writerId, Partitioner outputPartitioner, RpcEndpointRef[] endpoints) {
        this.writerId = writerId;
        this.outputPartitioner = outputPartitioner;
        this.endpoints = endpoints;
        if (outputPartitioner.numPartitions() != 1) {
            throw new IllegalArgumentException("multiple readers not yet supported");
        }
        if (outputPartitioner.numPartitions() != endpoints.length) {
            throw new IllegalArgumentException(new StringBuilder(22).append("partitioner size ").append(outputPartitioner.numPartitions()).append(" did ").append(new StringBuilder(25).append("not match endpoint count ").append(endpoints.length).toString()).toString());
        }
    }
}

