/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.util.UUID;
import org.apache.spark.SparkEnv;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.execution.streaming.state.DeactivateInstances;
import org.apache.spark.sql.execution.streaming.state.GetLocation;
import org.apache.spark.sql.execution.streaming.state.ReportActiveInstance;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StopCoordinator$;
import org.apache.spark.sql.execution.streaming.state.VerifyIfInstanceActive;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dq!B\b\u0011\u0011\u0003yb!B\u0011\u0011\u0011\u0003\u0011\u0003\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0005\u0004%IA\r\u0005\u0007w\u0005\u0001\u000b\u0011B\u001a\t\u000bq\nA\u0011A\u001f\t\u000f\u0005\u0005\u0011\u0001\"\u0001\u0002\u0004\u0019!\u0011\u0005\u0005\u0001@\u0011!\u0001uA!A!\u0002\u0013\t\u0005\"B\u0018\b\t\u00139\u0005BB%\b\t\u00031\"\n\u0003\u0004b\u000f\u0011\u0005aC\u0019\u0005\u0007Q\u001e!\tAF5\t\r9<A\u0011\u0001\fp\u0011\u0019Ax\u0001\"\u0001\u0011s\u0006A2\u000b^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014(+\u001a4\u000b\u0005E\u0011\u0012!B:uCR,'BA\n\u0015\u0003%\u0019HO]3b[&twM\u0003\u0002\u0016-\u0005IQ\r_3dkRLwN\u001c\u0006\u0003/a\t1a]9m\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0001\u0001\t\u0003A\u0005i\u0011\u0001\u0005\u0002\u0019'R\fG/Z*u_J,7i\\8sI&t\u0017\r^8s%\u001647cA\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\r\u0002\u0011%tG/\u001a:oC2L!AL\u0016\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012aH\u0001\rK:$\u0007o\\5oi:\u000bW.Z\u000b\u0002gA\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0005Y\u0006twMC\u00019\u0003\u0011Q\u0017M^1\n\u0005i*$AB*ue&tw-A\u0007f]\u0012\u0004x.\u001b8u\u001d\u0006lW\rI\u0001\nM>\u0014HI]5wKJ$\"A\u0010>\u0011\u0005\u0001:1CA\u0004$\u00039\u0011\boY#oIB|\u0017N\u001c;SK\u001a\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\r\u0002\u0007I\u00048-\u0003\u0002G\u0007\nq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164GC\u0001 I\u0011\u0015\u0001\u0015\u00021\u0001B\u0003Q\u0011X\r]8si\u0006\u001bG/\u001b<f\u0013:\u001cH/\u00198dKR!1JT*`!\t!C*\u0003\u0002NK\t!QK\\5u\u0011\u0015y%\u00021\u0001Q\u0003Q\u0019H/\u0019;f'R|'/\u001a)s_ZLG-\u001a:JIB\u0011\u0001%U\u0005\u0003%B\u0011Ac\u0015;bi\u0016\u001cFo\u001c:f!J|g/\u001b3fe&#\u0007\"\u0002+\u000b\u0001\u0004)\u0016\u0001\u00025pgR\u0004\"AV/\u000f\u0005][\u0006C\u0001-&\u001b\u0005I&B\u0001.\u001f\u0003\u0019a$o\\8u}%\u0011A,J\u0001\u0007!J,G-\u001a4\n\u0005ir&B\u0001/&\u0011\u0015\u0001'\u00021\u0001V\u0003))\u00070Z2vi>\u0014\u0018\nZ\u0001\u0017m\u0016\u0014\u0018NZ=JM&s7\u000f^1oG\u0016\f5\r^5wKR\u00191MZ4\u0011\u0005\u0011\"\u0017BA3&\u0005\u001d\u0011un\u001c7fC:DQaT\u0006A\u0002ACQ\u0001Y\u0006A\u0002U\u000b1bZ3u\u0019>\u001c\u0017\r^5p]R\u0011!.\u001c\t\u0004I-,\u0016B\u00017&\u0005\u0019y\u0005\u000f^5p]\")q\n\u0004a\u0001!\u0006\u0019B-Z1di&4\u0018\r^3J]N$\u0018M\\2fgR\u00111\n\u001d\u0005\u0006c6\u0001\rA]\u0001\u0006eVt\u0017\n\u001a\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k^\nA!\u001e;jY&\u0011q\u000f\u001e\u0002\u0005+VKE)\u0001\u0003ti>\u0004H#A&\t\u000bm,\u0001\u0019\u0001?\u0002\u0007\u0015tg\u000f\u0005\u0002~}6\t\u0001$\u0003\u0002\u00001\tA1\u000b]1sW\u0016sg/A\u0006g_J,\u00050Z2vi>\u0014Hc\u0001 \u0002\u0006!)1P\u0002a\u0001y\u0002")
public class StateStoreCoordinatorRef {
    private final RpcEndpointRef rpcEndpointRef;

    public static StateStoreCoordinatorRef forExecutor(SparkEnv sparkEnv) {
        return StateStoreCoordinatorRef$.MODULE$.forExecutor(sparkEnv);
    }

    public static StateStoreCoordinatorRef forDriver(SparkEnv sparkEnv) {
        return StateStoreCoordinatorRef$.MODULE$.forDriver(sparkEnv);
    }

    public void reportActiveInstance(StateStoreProviderId stateStoreProviderId, String host, String executorId) {
        this.rpcEndpointRef.send((Object)new ReportActiveInstance(stateStoreProviderId, host, executorId));
    }

    public boolean verifyIfInstanceActive(StateStoreProviderId stateStoreProviderId, String executorId) {
        return BoxesRunTime.unboxToBoolean((Object)this.rpcEndpointRef.askSync((Object)new VerifyIfInstanceActive(stateStoreProviderId, executorId), ClassTag$.MODULE$.Boolean()));
    }

    public Option<String> getLocation(StateStoreProviderId stateStoreProviderId) {
        return (Option)this.rpcEndpointRef.askSync((Object)new GetLocation(stateStoreProviderId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void deactivateInstances(UUID runId) {
        this.rpcEndpointRef.askSync((Object)new DeactivateInstances(runId), ClassTag$.MODULE$.Boolean());
    }

    public void stop() {
        this.rpcEndpointRef.askSync((Object)StopCoordinator$.MODULE$, ClassTag$.MODULE$.Boolean());
    }

    public StateStoreCoordinatorRef(RpcEndpointRef rpcEndpointRef) {
        this.rpcEndpointRef = rpcEndpointRef;
    }
}

