/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Equality$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.CodegenSupport;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.FileSourceStrategy$$anonfun$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.collection.BitSet;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction1;

public final class FileSourceStrategy$
extends SparkStrategy {
    public static FileSourceStrategy$ MODULE$;

    static {
        new FileSourceStrategy$();
    }

    private boolean shouldPruneBuckets(Option<BucketSpec> bucketSpec) {
        boolean bl;
        Option<BucketSpec> option = bucketSpec;
        if (option instanceof Some) {
            Some some = (Some)option;
            BucketSpec spec = (BucketSpec)some.value();
            bl = spec.bucketColumnNames().length() == 1 && spec.numBuckets() > 1;
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BitSet getExpressionBuckets(Expression expr, String bucketColumnName, int numBuckets) {
        IsNull isNull;
        Expression a;
        BinaryComparison binaryComparison;
        Option option;
        Expression expression = expr;
        if (expression instanceof BinaryComparison && !(option = Equality$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
            Expression a2 = (Expression)((Tuple2)option.get())._1();
            Expression expression2 = (Expression)((Tuple2)option.get())._2();
            if (a2 instanceof Attribute) {
                Attribute attribute = (Attribute)a2;
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    Object v = literal.value();
                    String string = attribute.name();
                    String string2 = bucketColumnName;
                    if (string == null) {
                        if (string2 == null) return FileSourceStrategy$.getBucketSetFromValue$1(attribute, v, numBuckets);
                    } else if (string.equals(string2)) {
                        return FileSourceStrategy$.getBucketSetFromValue$1(attribute, v, numBuckets);
                    }
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression a3 = in.value();
            Seq list = in.list();
            if (a3 instanceof Attribute) {
                Attribute attribute = (Attribute)a3;
                if (list.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileSourceStrategy$.$anonfun$getExpressionBuckets$3(x$1)))) {
                    String string = attribute.name();
                    String string3 = bucketColumnName;
                    if (string == null) {
                        if (string3 == null) return FileSourceStrategy$.getBucketSetFromIterable$1(attribute, (Iterable)list.map((Function1 & Serializable & scala.Serializable)e -> e.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom()), numBuckets);
                    } else if (string.equals(string3)) {
                        return FileSourceStrategy$.getBucketSetFromIterable$1(attribute, (Iterable)list.map((Function1 & Serializable & scala.Serializable)e -> e.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom()), numBuckets);
                    }
                }
            }
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression a4 = inSet.child();
            Set hset = inSet.hset();
            if (a4 instanceof Attribute) {
                Attribute attribute = (Attribute)a4;
                String string = attribute.name();
                String string4 = bucketColumnName;
                if (string == null) {
                    if (string4 == null) return FileSourceStrategy$.getBucketSetFromIterable$1(attribute, (Iterable)hset, numBuckets);
                } else if (string.equals(string4)) {
                    return FileSourceStrategy$.getBucketSetFromIterable$1(attribute, (Iterable)hset, numBuckets);
                }
            }
        }
        if (expression instanceof IsNull && (a = (isNull = (IsNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)a;
            String string = attribute.name();
            String string5 = bucketColumnName;
            if (string == null) {
                if (string5 == null) return FileSourceStrategy$.getBucketSetFromValue$1(attribute, null, numBuckets);
            } else if (string.equals(string5)) {
                return FileSourceStrategy$.getBucketSetFromValue$1(attribute, null, numBuckets);
            }
        }
        if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            return this.getExpressionBuckets(left, bucketColumnName, numBuckets).$amp(this.getExpressionBuckets(right, bucketColumnName, numBuckets));
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return this.getExpressionBuckets(left, bucketColumnName, numBuckets).$bar(this.getExpressionBuckets(right, bucketColumnName, numBuckets));
        }
        BitSet matchedBuckets = new BitSet(numBuckets);
        matchedBuckets.setUntil(numBuckets);
        return matchedBuckets;
    }

    private Option<BitSet> genBucketSet(Seq<Expression> normalizedFilters, BucketSpec bucketSpec) {
        if (normalizedFilters.isEmpty()) {
            return None$.MODULE$;
        }
        String bucketColumnName = (String)bucketSpec.bucketColumnNames().head();
        int numBuckets = bucketSpec.numBuckets();
        Expression normalizedFiltersAndExpr = (Expression)normalizedFilters.reduce((Function2)And$.MODULE$);
        BitSet matchedBuckets = this.getExpressionBuckets(normalizedFiltersAndExpr, bucketColumnName, numBuckets);
        int numBucketsSelected = matchedBuckets.cardinality();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Pruned ").append(numBuckets - numBucketsSelected).append(" out of ").append(numBuckets).append(" buckets.").toString());
        return numBucketsSelected == numBuckets ? None$.MODULE$ : new Some((Object)matchedBuckets);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<SparkPlan> apply(LogicalPlan plan) {
        CodegenSupport withProjections;
        LogicalPlan logicalPlan2 = plan;
        Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan2);
        if (option.isEmpty()) return Nil$.MODULE$;
        Seq projects = (Seq)((Tuple3)option.get())._1();
        Seq filters = (Seq)((Tuple3)option.get())._2();
        LogicalPlan l = (LogicalPlan)((Tuple3)option.get())._3();
        if (!(l instanceof LogicalRelation)) return Nil$.MODULE$;
        LogicalRelation logicalRelation = (LogicalRelation)l;
        BaseRelation fsRelation = logicalRelation.relation();
        Option<CatalogTable> table = logicalRelation.catalogTable();
        if (!(fsRelation instanceof HadoopFsRelation)) return Nil$.MODULE$;
        HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsRelation;
        ExpressionSet filterSet = ExpressionSet$.MODULE$.apply((TraversableOnce)filters);
        Seq normalizedFilters = (Seq)filters.map((Function1 & Serializable & scala.Serializable)e -> (Expression)e.transform((PartialFunction)new scala.Serializable(logicalRelation){
            public static final long serialVersionUID = 0L;
            private final LogicalRelation x3$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    object = attributeReference.withName(((AttributeReference)this.x3$1.output().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$apply$1$1.$anonfun$applyOrElse$1(attributeReference, x$2))).get()).name());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof AttributeReference;
                return bl;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(AttributeReference x2$1, AttributeReference x$2) {
                return x$2.semanticEquals((Expression)x2$1);
            }
            {
                this.x3$1 = x3$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.AttributeReference org.apache.spark.sql.catalyst.expressions.AttributeReference )}, serializedLambda);
            }
        }), Seq$.MODULE$.canBuildFrom());
        Seq partitionColumns = logicalRelation.resolve(hadoopFsRelation.partitionSchema(), hadoopFsRelation.sparkSession().sessionState().analyzer().resolver());
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply((Iterable)partitionColumns);
        ExpressionSet partitionKeyFilters = ExpressionSet$.MODULE$.apply((TraversableOnce)((TraversableLike)normalizedFilters.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SubqueryExpression$.MODULE$.hasSubquery(x$3)))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FileSourceStrategy$.$anonfun$apply$3(partitionSet, x$4))));
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Pruning directories with: ").append(partitionKeyFilters.mkString(",")).toString());
        Option<BucketSpec> bucketSpec = hadoopFsRelation.bucketSpec();
        Option<BitSet> bucketSet = this.shouldPruneBuckets(bucketSpec) ? this.genBucketSet((Seq<Expression>)normalizedFilters, (BucketSpec)bucketSpec.get()) : None$.MODULE$;
        Seq dataColumns = logicalRelation.resolve(hadoopFsRelation.dataSchema(), hadoopFsRelation.sparkSession().sessionState().analyzer().resolver());
        Seq dataFilters = (Seq)normalizedFilters.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FileSourceStrategy$.$anonfun$apply$5(partitionSet, x$5)));
        Set afterScanFilters = (Set)filterSet.$minus$minus((GenTraversableOnce)partitionKeyFilters.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)FileSourceStrategy$.$anonfun$apply$6(x$6))));
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Post-Scan Filters: ").append(afterScanFilters.mkString(",")).toString());
        AttributeSet filterAttributes = AttributeSet$.MODULE$.apply((Iterable)afterScanFilters);
        Seq requiredExpressions = (Seq)filterAttributes.toSeq().$plus$plus((GenTraversableOnce)projects, Seq$.MODULE$.canBuildFrom());
        AttributeSet requiredAttributes = AttributeSet$.MODULE$.apply((Iterable)requiredExpressions);
        Seq readDataColumns = (Seq)((TraversableLike)dataColumns.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)requiredAttributes.contains(elem)))).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionColumns.contains(elem)));
        StructType outputSchema = package$.MODULE$.AttributeSeq(readDataColumns).toStructType();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Output Data Schema: ").append(outputSchema.simpleString(5)).toString());
        Seq outputAttributes = (Seq)readDataColumns.$plus$plus((GenTraversableOnce)partitionColumns, Seq$.MODULE$.canBuildFrom());
        FileSourceScanExec scan = new FileSourceScanExec(hadoopFsRelation, (Seq<Attribute>)outputAttributes, outputSchema, (Seq<Expression>)partitionKeyFilters.toSeq(), bucketSet, (Seq<Expression>)dataFilters, (Option<TableIdentifier>)table.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.identifier()));
        Option afterScanFilter = afterScanFilters.toSeq().reduceOption((Function2)And$.MODULE$);
        CodegenSupport withFilter = (CodegenSupport)afterScanFilter.map((Function1 & Serializable & scala.Serializable)x$8 -> new FilterExec((Expression)x$8, scan)).getOrElse((Function0 & Serializable & scala.Serializable)() -> scan);
        Seq seq = projects;
        Seq seq2 = ((QueryPlan)withFilter).output();
        CodegenSupport codegenSupport = withProjections = !(seq != null ? !seq.equals(seq2) : seq2 != null) ? withFilter : new ProjectExec((Seq<NamedExpression>)projects, (SparkPlan)((Object)withFilter));
        return Nil$.MODULE$.$colon$colon((Object)codegenSupport);
    }

    private static final int getBucketNumber$1(Attribute attr, Object v, int numBuckets$1) {
        return BucketingUtils$.MODULE$.getBucketIdFromValue(attr, numBuckets$1, v);
    }

    /*
     * WARNING - void declaration
     */
    private static final BitSet getBucketSetFromIterable$1(Attribute attr, Iterable iter, int numBuckets$1) {
        void var3_3;
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        ((IterableLike)iter.map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)FileSourceStrategy$.getBucketNumber$1(attr, v, numBuckets$1)), Iterable$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bucketNum -> matchedBuckets.set(bucketNum));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final BitSet getBucketSetFromValue$1(Attribute attr, Object v, int numBuckets$1) {
        void var3_3;
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        matchedBuckets.set(FileSourceStrategy$.getBucketNumber$1(attr, v, numBuckets$1));
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$getExpressionBuckets$3(Expression x$1) {
        return x$1 instanceof Literal;
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(AttributeSet partitionSet$1, Expression x$4) {
        return x$4.references().subsetOf(partitionSet$1);
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(AttributeSet partitionSet$1, Expression x$5) {
        return x$5.references().intersect(partitionSet$1).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(Expression x$6) {
        return x$6.references().nonEmpty();
    }

    private FileSourceStrategy$() {
        MODULE$ = this;
    }
}

