/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog$;
import org.apache.spark.sql.execution.streaming.ManifestFileCommitProtocol;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\r\u001b\u0011\u00039c!B\u0015\u001b\u0011\u0003Q\u0003\"B\u001c\u0002\t\u0003A\u0004bB\u001d\u0002\u0005\u0004%\tA\u000f\u0005\u0007\u0007\u0006\u0001\u000b\u0011B\u001e\t\u000b\u0011\u000bA\u0011A#\t\u000b!\fA\u0011A5\u0007\t%R\u0002A\u001d\u0005\ts\u001e\u0011\t\u0011)A\u0005u\"A!j\u0002B\u0001B\u0003%q\u000b\u0003\u0005\u007f\u000f\t\u0005\t\u0015!\u0003\u0000\u0011%\tYa\u0002B\u0001B\u0003%1\n\u0003\u0006\u0002\u000e\u001d\u0011\t\u0011)A\u0005\u0003\u001fAaaN\u0004\u0005\u0002\u0005U\u0001\"CA\u0012\u000f\t\u0007I\u0011BA\u0013\u0011\u001d\t9c\u0002Q\u0001\n-D\u0011\"!\u000b\b\u0005\u0004%I!!\n\t\u000f\u0005-r\u0001)A\u0005W\"I\u0011QF\u0004C\u0002\u0013%\u0011q\u0006\u0005\t\u0003o9\u0001\u0015!\u0003\u00022!Aql\u0002b\u0001\n\u0013\tI\u0004C\u0004\u0002<\u001d\u0001\u000b\u0011\u00021\t\u000f\u0005ur\u0001\"\u0003\u0002@!9\u0011qI\u0004\u0005B\u0005%\u0003bBA>\u000f\u0011\u0005\u0013QP\u0001\u000f\r&dWm\u0015;sK\u0006l7+\u001b8l\u0015\tYB$A\u0005tiJ,\u0017-\\5oO*\u0011QDH\u0001\nKb,7-\u001e;j_:T!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0001\"\u0001K\u0001\u000e\u0003i\u0011aBR5mKN#(/Z1n'&t7nE\u0002\u0002WE\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0007C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b!\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001c4\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0014\u0002\u00175,G/\u00193bi\u0006$\u0015N]\u000b\u0002wA\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005Y\u0006twMC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$AB*ue&tw-\u0001\u0007nKR\fG-\u0019;b\t&\u0014\b%A\u0006iCNlU\r^1eCR\fGc\u0001$J=B\u0011AfR\u0005\u0003\u00116\u0012qAQ8pY\u0016\fg\u000eC\u0003K\u000b\u0001\u00071*\u0001\u0003qCRD\u0007c\u0001'U/:\u0011QJ\u0015\b\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u001a\na\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u0005Mk\u0013a\u00029bG.\fw-Z\u0005\u0003+Z\u00131aU3r\u0015\t\u0019V\u0006\u0005\u0002Y9:\u0011\u0011L\u0017\t\u0003\u001d6J!aW\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u0011UL\u0003\u0002\\[!)q,\u0002a\u0001A\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017\u0001B2p]\u001aT!!\u001a\u0012\u0002\r!\fGm\\8q\u0013\t9'MA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u001cC:\u001cWm\u001d;pe&\u001bX*\u001a;bI\u0006$\u0018\rR5sK\u000e$xN]=\u0015\u0007\u0019S\u0017\u000fC\u0003K\r\u0001\u00071\u000e\u0005\u0002m_6\tQN\u0003\u0002oI\u0006\u0011am]\u0005\u0003a6\u0014A\u0001U1uQ\")qL\u0002a\u0001AN!qa\u001d<2!\taD/\u0003\u0002v{\t1qJ\u00196fGR\u0004\"\u0001K<\n\u0005aT\"\u0001B*j].\fAb\u001d9be.\u001cVm]:j_:\u0004\"a\u001f?\u000e\u0003yI!! \u0010\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0015\u0019LG.\u001a$pe6\fG\u000f\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001H\u0001\fI\u0006$\u0018m]8ve\u000e,7/\u0003\u0003\u0002\n\u0005\r!A\u0003$jY\u00164uN]7bi\u0006!\u0002/\u0019:uSRLwN\\\"pYVlgNT1nKN\fqa\u001c9uS>t7\u000fE\u0003Y\u0003#9v+C\u0002\u0002\u0014u\u00131!T1q)1\t9\"!\u0007\u0002\u001c\u0005u\u0011qDA\u0011!\tAs\u0001C\u0003z\u001b\u0001\u0007!\u0010C\u0003K\u001b\u0001\u0007q\u000bC\u0003\u007f\u001b\u0001\u0007q\u0010\u0003\u0004\u0002\f5\u0001\ra\u0013\u0005\b\u0003\u001bi\u0001\u0019AA\b\u0003!\u0011\u0017m]3QCRDW#A6\u0002\u0013\t\f7/\u001a)bi\"\u0004\u0013a\u00027pOB\u000bG\u000f[\u0001\tY><\u0007+\u0019;iA\u00059a-\u001b7f\u0019><WCAA\u0019!\rA\u00131G\u0005\u0004\u0003kQ\"!\u0005$jY\u0016\u001cFO]3b[NKgn\u001b'pO\u0006Aa-\u001b7f\u0019><\u0007%F\u0001a\u0003-A\u0017\rZ8pa\u000e{gN\u001a\u0011\u00023\t\f7/[2Xe&$XMS8c'R\fGo\u001d+sC\u000e\\WM]\u000b\u0003\u0003\u0003\u0002B!!\u0001\u0002D%!\u0011QIA\u0002\u0005e\u0011\u0015m]5d/JLG/\u001a&pEN#\u0018\r^:Ue\u0006\u001c7.\u001a:\u0002\u0011\u0005$GMQ1uG\"$b!a\u0013\u0002R\u0005m\u0003c\u0001\u0017\u0002N%\u0019\u0011qJ\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003':\u0002\u0019AA+\u0003\u001d\u0011\u0017\r^2i\u0013\u0012\u00042\u0001LA,\u0013\r\tI&\f\u0002\u0005\u0019>tw\rC\u0004\u0002^]\u0001\r!a\u0018\u0002\t\u0011\fG/\u0019\t\u0005\u0003C\n)H\u0004\u0003\u0002d\u0005Md\u0002BA3\u0003crA!a\u001a\u0002p9!\u0011\u0011NA7\u001d\rq\u00151N\u0005\u0002K%\u00111\u0005J\u0005\u0003C\tJ!a\b\u0011\n\u0005Ms\u0012\u0002BA<\u0003s\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005Ms\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003]\u0003")
public class FileStreamSink
implements Sink,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final FileFormat fileFormat;
    private final Seq<String> partitionColumnNames;
    private final Map<String, String> options;
    private final Path basePath;
    private final Path logPath;
    private final FileStreamSinkLog fileLog;
    private final Configuration hadoopConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean ancestorIsMetadataDirectory(Path path, Configuration configuration) {
        return FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(path, configuration);
    }

    public static boolean hasMetadata(Seq<String> seq, Configuration configuration) {
        return FileStreamSink$.MODULE$.hasMetadata(seq, configuration);
    }

    public static String metadataDir() {
        return FileStreamSink$.MODULE$.metadataDir();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Path basePath() {
        return this.basePath;
    }

    private Path logPath() {
        return this.logPath;
    }

    private FileStreamSinkLog fileLog() {
        return this.fileLog;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private BasicWriteJobStatsTracker basicWriteJobStatsTracker() {
        SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.hadoopConf());
        return new BasicWriteJobStatsTracker(serializableHadoopConf, BasicWriteJobStatsTracker$.MODULE$.metrics());
    }

    @Override
    public void addBatch(long batchId, Dataset<Row> data) {
        if (batchId <= BoxesRunTime.unboxToLong((Object)this.fileLog().getLatest().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Skipping already committed batch ").append(batchId).toString());
        } else {
            FileCommitProtocol committer = FileCommitProtocol$.MODULE$.instantiate(this.sparkSession.sessionState().conf().streamingFileCommitProtocolClass(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString(), this.path, FileCommitProtocol$.MODULE$.instantiate$default$4());
            FileCommitProtocol fileCommitProtocol = committer;
            if (fileCommitProtocol instanceof ManifestFileCommitProtocol) {
                ManifestFileCommitProtocol manifestFileCommitProtocol = (ManifestFileCommitProtocol)fileCommitProtocol;
                manifestFileCommitProtocol.setupManifestOptions(this.fileLog(), batchId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Seq partitionColumns = (Seq)this.partitionColumnNames.map((Function1 & Serializable & scala.Serializable)col -> {
                Function2 nameEquality = data.sparkSession().sessionState().conf().resolver();
                return (Attribute)data.logicalPlan().output().find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink.$anonfun$addBatch$5(nameEquality, col, f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(38).append("Partition column ").append((String)col).append(" not found in schema ").append(data.schema()).toString());
                });
            }, Seq$.MODULE$.canBuildFrom());
            QueryExecution qe = data.queryExecution();
            FileFormatWriter$.MODULE$.write(this.sparkSession, qe.executedPlan(), this.fileFormat, committer, new FileFormatWriter.OutputSpec(this.path, (Map<Map<String, String>, String>)Predef$.MODULE$.Map().empty(), (Seq<Attribute>)qe.analyzed().output()), this.hadoopConf(), (Seq<Attribute>)partitionColumns, (Option<BucketSpec>)None$.MODULE$, (Seq<WriteJobStatsTracker>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BasicWriteJobStatsTracker[]{this.basicWriteJobStatsTracker()}))), this.options);
        }
    }

    public String toString() {
        return new StringBuilder(10).append("FileSink[").append(this.path).append("]").toString();
    }

    public static final /* synthetic */ boolean $anonfun$addBatch$5(Function2 nameEquality$1, String col$1, Attribute f) {
        return BoxesRunTime.unboxToBoolean((Object)nameEquality$1.apply((Object)f.name(), (Object)col$1));
    }

    public FileStreamSink(SparkSession sparkSession, String path, FileFormat fileFormat, Seq<String> partitionColumnNames, Map<String, String> options) {
        this.sparkSession = sparkSession;
        this.path = path;
        this.fileFormat = fileFormat;
        this.partitionColumnNames = partitionColumnNames;
        this.options = options;
        Logging.$init$((Logging)this);
        this.basePath = new Path(path);
        this.logPath = new Path(this.basePath(), FileStreamSink$.MODULE$.metadataDir());
        this.fileLog = new FileStreamSinkLog(FileStreamSinkLog$.MODULE$.VERSION(), sparkSession, this.logPath().toUri().toString());
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
    }
}

