/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive.rule;

import java.io.Serializable;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.LocalShuffleReaderExec;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.adaptive.ReusedQueryStageExec;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec$;
import org.apache.spark.sql.execution.adaptive.rule.CoalescedShuffleReaderExec;
import org.apache.spark.sql.execution.adaptive.rule.ReduceNumShufflePartitions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\f\u0019\u0001\u001eB\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u007f!)a\t\u0001C\u0001\u000f\")1\n\u0001C!\u0019\"1q\n\u0001C\u0001=ACqA\u0018\u0001\u0002\u0002\u0013\u0005q\fC\u0004b\u0001E\u0005I\u0011\u00012\t\u000f5\u0004\u0011\u0011!C!]\"9q\u000fAA\u0001\n\u0003A\bbB=\u0001\u0003\u0003%\tA\u001f\u0005\n\u0003\u0003\u0001\u0011\u0011!C!\u0003\u0007A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005u\u0001!!A\u0005B\u0005}\u0001\"CA\u0011\u0001\u0005\u0005I\u0011IA\u0012\u0011%\t)\u0003AA\u0001\n\u0003\n9cB\u0005\u0002,a\t\t\u0011#\u0001\u0002.\u0019Aq\u0003GA\u0001\u0012\u0003\ty\u0003\u0003\u0004G#\u0011\u0005\u0011Q\b\u0005\n\u0003C\t\u0012\u0011!C#\u0003GA\u0001bS\t\u0002\u0002\u0013\u0005\u0015q\b\u0005\n\u0003\u0007\n\u0012\u0011!CA\u0003\u000bB\u0011\"!\u0015\u0012\u0003\u0003%I!a\u0015\u00035I+G-^2f\u001dVl7\u000b[;gM2,\u0007+\u0019:uSRLwN\\:\u000b\u0005eQ\u0012\u0001\u0002:vY\u0016T!a\u0007\u000f\u0002\u0011\u0005$\u0017\r\u001d;jm\u0016T!!\b\u0010\u0002\u0013\u0015DXmY;uS>t'BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011\u0003\u0002\u0001)ii\u00022!\u000b\u00181\u001b\u0005Q#BA\u0016-\u0003\u0015\u0011X\u000f\\3t\u0015\tic$\u0001\u0005dCR\fG._:u\u0013\ty#F\u0001\u0003Sk2,\u0007CA\u00193\u001b\u0005a\u0012BA\u001a\u001d\u0005%\u0019\u0006/\u0019:l!2\fg\u000e\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdGA\u0004Qe>$Wo\u0019;\u0011\u0005UZ\u0014B\u0001\u001f7\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011\u0019wN\u001c4\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0010\u0002\u0011%tG/\u001a:oC2L!\u0001R!\u0003\u000fM\u000bFjQ8oM\u0006)1m\u001c8gA\u00051A(\u001b8jiz\"\"\u0001\u0013&\u0011\u0005%\u0003Q\"\u0001\r\t\u000bu\u001a\u0001\u0019A \u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005Aj\u0005\"\u0002(\u0005\u0001\u0004\u0001\u0014\u0001\u00029mC:\fQ$Z:uS6\fG/\u001a)beRLG/[8o'R\f'\u000f^%oI&\u001cWm\u001d\u000b\u0003#^\u00032!\u000e*U\u0013\t\u0019fGA\u0003BeJ\f\u0017\u0010\u0005\u00026+&\u0011aK\u000e\u0002\u0004\u0013:$\b\"\u0002-\u0006\u0001\u0004I\u0016aE7ba>+H\u000f];u'R\fG/[:uS\u000e\u001c\bcA\u001bS5B\u00111\fX\u0007\u0002A%\u0011Q\f\t\u0002\u0014\u001b\u0006\u0004x*\u001e;qkR\u001cF/\u0019;jgRL7m]\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002IA\"9QH\u0002I\u0001\u0002\u0004y\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002G*\u0012q\bZ\u0016\u0002KB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\u001b\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002mO\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005y\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003\u0011a\u0017M\\4\u000b\u0003Q\fAA[1wC&\u0011a/\u001d\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003Q\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002|}B\u0011Q\u0007`\u0005\u0003{Z\u00121!\u00118z\u0011\u001dy(\"!AA\u0002Q\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0003!\u0015\t9!!\u0004|\u001b\t\tIAC\u0002\u0002\fY\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty!!\u0003\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003+\tY\u0002E\u00026\u0003/I1!!\u00077\u0005\u001d\u0011un\u001c7fC:Dqa \u0007\u0002\u0002\u0003\u000710\u0001\u0005iCND7i\u001c3f)\u0005!\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003=\fa!Z9vC2\u001cH\u0003BA\u000b\u0003SAqa`\b\u0002\u0002\u0003\u000710\u0001\u000eSK\u0012,8-\u001a(v[NCWO\u001a4mKB\u000b'\u000f^5uS>t7\u000f\u0005\u0002J#M!\u0011#!\r;!\u0019\t\u0019$!\u000f@\u00116\u0011\u0011Q\u0007\u0006\u0004\u0003o1\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003w\t)DA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!!\f\u0015\u0007!\u000b\t\u0005C\u0003>)\u0001\u0007q(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u001d\u0013Q\n\t\u0005k\u0005%s(C\u0002\u0002LY\u0012aa\u00149uS>t\u0007\u0002CA(+\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAA+!\r\u0001\u0018qK\u0005\u0004\u00033\n(AB(cU\u0016\u001cG\u000f")
public class ReduceNumShufflePartitions
extends Rule<SparkPlan>
implements Product,
scala.Serializable {
    private final SQLConf conf;

    public static Option<SQLConf> unapply(ReduceNumShufflePartitions reduceNumShufflePartitions) {
        return ReduceNumShufflePartitions$.MODULE$.unapply(reduceNumShufflePartitions);
    }

    public static <A> Function1<SQLConf, A> andThen(Function1<ReduceNumShufflePartitions, A> function1) {
        return ReduceNumShufflePartitions$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ReduceNumShufflePartitions> compose(Function1<A, SQLConf> function1) {
        return ReduceNumShufflePartitions$.MODULE$.compose(function1);
    }

    public SQLConf conf() {
        return this.conf;
    }

    public SparkPlan apply(SparkPlan plan) {
        SparkPlan sparkPlan;
        if (!this.conf().reducePostShufflePartitionsEnabled()) {
            return plan;
        }
        if (!plan.collectLeaves().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReduceNumShufflePartitions.$anonfun$apply$1(x$1)))) {
            return plan;
        }
        Seq shuffleStages = ReduceNumShufflePartitions.collectShuffleStages$1(plan);
        if (!shuffleStages.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReduceNumShufflePartitions.$anonfun$apply$3(x$2)))) {
            sparkPlan = plan;
        } else {
            Seq shuffleMetrics = (Seq)shuffleStages.map((Function1 & Serializable & scala.Serializable)stage -> {
                Future<MapOutputStatistics> metricsFuture = stage.mapOutputStatisticsFuture();
                Predef$.MODULE$.assert(metricsFuture.isCompleted(), (Function0 & Serializable & scala.Serializable)() -> "ShuffleQueryStageExec should already be ready");
                return (MapOutputStatistics)ThreadUtils$.MODULE$.awaitResult(metricsFuture, (Duration)Duration$.MODULE$.Zero());
            }, Seq$.MODULE$.canBuildFrom());
            Seq validMetrics = (Seq)shuffleMetrics.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReduceNumShufflePartitions.$anonfun$apply$6(x$3)));
            Seq distinctNumPreShufflePartitions = (Seq)((SeqLike)validMetrics.map((Function1 & Serializable & scala.Serializable)stats -> BoxesRunTime.boxToInteger((int)ReduceNumShufflePartitions.$anonfun$apply$7(stats)), Seq$.MODULE$.canBuildFrom())).distinct();
            if (validMetrics.nonEmpty() && distinctNumPreShufflePartitions.length() == 1) {
                int[] partitionStartIndices = this.estimatePartitionStartIndices((MapOutputStatistics[])validMetrics.toArray(ClassTag$.MODULE$.apply(MapOutputStatistics.class)));
                sparkPlan = (SparkPlan)plan.transformUp((PartialFunction)new scala.Serializable(null, partitionStartIndices){
                    public static final long serialVersionUID = 0L;
                    private final int[] partitionStartIndices$1;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        QueryStageExec queryStageExec;
                        A1 A1 = x1;
                        Object object = A1 instanceof QueryStageExec && ShuffleQueryStageExec$.MODULE$.isShuffleQueryStageExec(queryStageExec = (QueryStageExec)A1) ? new CoalescedShuffleReaderExec(queryStageExec, this.partitionStartIndices$1) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x1) {
                        QueryStageExec queryStageExec;
                        SparkPlan sparkPlan = x1;
                        boolean bl = sparkPlan instanceof QueryStageExec && ShuffleQueryStageExec$.MODULE$.isShuffleQueryStageExec(queryStageExec = (QueryStageExec)sparkPlan);
                        return bl;
                    }
                    {
                        this.partitionStartIndices$1 = partitionStartIndices$1;
                    }
                });
            } else {
                sparkPlan = plan;
            }
        }
        return sparkPlan;
    }

    public int[] estimatePartitionStartIndices(MapOutputStatistics[] mapOutputStatistics) {
        int minNumPostShufflePartitions = this.conf().minNumPostShufflePartitions();
        long advisoryTargetPostShuffleInputSize = this.conf().targetPostShuffleInputSize();
        long totalPostShuffleInputSize = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapOutputStatistics)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)ReduceNumShufflePartitions.$anonfun$estimatePartitionStartIndices$1(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long maxPostShuffleInputSize = package$.MODULE$.max((long)package$.MODULE$.ceil((double)totalPostShuffleInputSize / (double)minNumPostShufflePartitions), 16L);
        long targetPostShuffleInputSize = package$.MODULE$.min(maxPostShuffleInputSize, advisoryTargetPostShuffleInputSize);
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("advisoryTargetPostShuffleInputSize: ").append(advisoryTargetPostShuffleInputSize).append(", ").append("targetPostShuffleInputSize ").append(targetPostShuffleInputSize).append(".").toString());
        int[] distinctNumPreShufflePartitions = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapOutputStatistics)).map((Function1 & Serializable & scala.Serializable)stats -> BoxesRunTime.boxToInteger((int)ReduceNumShufflePartitions.$anonfun$estimatePartitionStartIndices$3(stats)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).distinct();
        Predef$.MODULE$.assert(distinctNumPreShufflePartitions.length == 1, (Function0 & Serializable & scala.Serializable)() -> "There should be only one distinct value of the number pre-shuffle partitions among registered Exchange operator.");
        int numPreShufflePartitions = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(distinctNumPreShufflePartitions)).head());
        ArrayBuffer partitionStartIndices = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        long postShuffleInputSize = 0L;
        for (int i = 0; i < numPreShufflePartitions; ++i) {
            long nextShuffleInputSize = 0L;
            for (int j = 0; j < mapOutputStatistics.length; ++j) {
                nextShuffleInputSize += mapOutputStatistics[j].bytesByPartitionId()[i];
            }
            if (i > 0 && postShuffleInputSize + nextShuffleInputSize > targetPostShuffleInputSize) {
                partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                postShuffleInputSize = nextShuffleInputSize;
                continue;
            }
            postShuffleInputSize += nextShuffleInputSize;
        }
        return (int[])partitionStartIndices.toArray(ClassTag$.MODULE$.Int());
    }

    public ReduceNumShufflePartitions copy(SQLConf conf) {
        return new ReduceNumShufflePartitions(conf);
    }

    public SQLConf copy$default$1() {
        return this.conf();
    }

    public String productPrefix() {
        return "ReduceNumShufflePartitions";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.conf();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ReduceNumShufflePartitions;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ReduceNumShufflePartitions)) return false;
        boolean bl = true;
        if (!bl) return false;
        ReduceNumShufflePartitions reduceNumShufflePartitions = (ReduceNumShufflePartitions)((Object)x$1);
        SQLConf sQLConf = this.conf();
        SQLConf sQLConf2 = reduceNumShufflePartitions.conf();
        if (sQLConf == null) {
            if (sQLConf2 != null) {
                return false;
            }
        } else if (!sQLConf.equals(sQLConf2)) return false;
        if (!reduceNumShufflePartitions.canEqual((Object)this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(SparkPlan x$1) {
        return x$1 instanceof QueryStageExec;
    }

    private static final Seq collectShuffleStages$1(SparkPlan plan2) {
        ReusedQueryStageExec reusedQueryStageExec;
        QueryStageExec stage;
        Nil$ nil$;
        SparkPlan sparkPlan = plan2;
        if (sparkPlan instanceof LocalShuffleReaderExec) {
            nil$ = Nil$.MODULE$;
        } else if (sparkPlan instanceof ShuffleQueryStageExec) {
            ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan;
            nil$ = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ShuffleQueryStageExec[]{shuffleQueryStageExec}));
        } else if (sparkPlan instanceof ReusedQueryStageExec && (stage = (reusedQueryStageExec = (ReusedQueryStageExec)sparkPlan).plan()) instanceof ShuffleQueryStageExec) {
            ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)stage;
            nil$ = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ShuffleQueryStageExec[]{shuffleQueryStageExec}));
        } else {
            nil$ = (Seq)plan2.children().flatMap((Function1 & Serializable & scala.Serializable)plan -> ReduceNumShufflePartitions.collectShuffleStages$1(plan), Seq$.MODULE$.canBuildFrom());
        }
        return nil$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(ShuffleQueryStageExec x$2) {
        return x$2.plan().canChangeNumPartitions();
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(MapOutputStatistics x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ int $anonfun$apply$7(MapOutputStatistics stats) {
        return stats.bytesByPartitionId().length;
    }

    public static final /* synthetic */ long $anonfun$estimatePartitionStartIndices$1(MapOutputStatistics x$4) {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$4.bytesByPartitionId())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$estimatePartitionStartIndices$3(MapOutputStatistics stats) {
        return stats.bytesByPartitionId().length;
    }

    public ReduceNumShufflePartitions(SQLConf conf) {
        this.conf = conf;
        Product.$init$((Product)this);
    }
}

