/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.CreateDataSourceTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\f\u0019\u0001\u0016B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u007f!Aa\t\u0001BK\u0002\u0013\u0005q\t\u0003\u0005L\u0001\tE\t\u0015!\u0003I\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u001dA\u0007!!A\u0005\u0002%Dq\u0001\u001c\u0001\u0012\u0002\u0013\u0005Q\u000eC\u0004y\u0001E\u0005I\u0011A=\t\u000fm\u0004\u0011\u0011!C!y\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"a\t\u0001\u0003\u0003%\t%!\n\t\u0013\u0005M\u0002!!A\u0005\u0002\u0005U\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u000f%\ty\u0004GA\u0001\u0012\u0003\t\tE\u0002\u0005\u00181\u0005\u0005\t\u0012AA\"\u0011\u0019a\u0015\u0003\"\u0001\u0002R!I\u00111K\t\u0002\u0002\u0013\u0015\u0013Q\u000b\u0005\n\u0003/\n\u0012\u0011!CA\u00033B\u0011\"a\u0018\u0012\u0003\u0003%\t)!\u0019\t\u0013\u0005M\u0014#!A\u0005\n\u0005U$\u0001H\"sK\u0006$X\rR1uCN{WO]2f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\u0006\u00033i\tqaY8n[\u0006tGM\u0003\u0002\u001c9\u0005IQ\r_3dkRLwN\u001c\u0006\u0003;y\t1a]9m\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0019\u0002DG\u000f\t\u0003O9j\u0011\u0001\u000b\u0006\u0003S)\nq\u0001\\8hS\u000e\fGN\u0003\u0002,Y\u0005)\u0001\u000f\\1og*\u0011Q\u0006H\u0001\tG\u0006$\u0018\r\\=ti&\u0011q\u0006\u000b\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u00022e5\t\u0001$\u0003\u000241\ty!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdGA\u0004Qe>$Wo\u0019;\u0011\u0005UZ\u0014B\u0001\u001f7\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015!\u0018M\u00197f+\u0005y\u0004C\u0001!D\u001b\u0005\t%B\u0001\"-\u0003\u001d\u0019\u0017\r^1m_\u001eL!\u0001R!\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\u0002\rQ\f'\r\\3!\u00039IwM\\8sK&3W\t_5tiN,\u0012\u0001\u0013\t\u0003k%K!A\u0013\u001c\u0003\u000f\t{w\u000e\\3b]\u0006y\u0011n\u001a8pe\u0016Le-\u0012=jgR\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u001d>\u0003\u0006CA\u0019\u0001\u0011\u0015iT\u00011\u0001@\u0011\u00151U\u00011\u0001I\u0003\r\u0011XO\u001c\u000b\u0003'\u000e\u00042\u0001\u0016/`\u001d\t)&L\u0004\u0002W36\tqK\u0003\u0002YI\u00051AH]8pizJ\u0011aN\u0005\u00037Z\nq\u0001]1dW\u0006<W-\u0003\u0002^=\n\u00191+Z9\u000b\u0005m3\u0004C\u00011b\u001b\u0005a\u0012B\u00012\u001d\u0005\r\u0011vn\u001e\u0005\u0006I\u001a\u0001\r!Z\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003A\u001aL!a\u001a\u000f\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\t\r|\u0007/\u001f\u000b\u0004\u001d*\\\u0007bB\u001f\b!\u0003\u0005\ra\u0010\u0005\b\r\u001e\u0001\n\u00111\u0001I\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A\u001c\u0016\u0003\u007f=\\\u0013\u0001\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003gR\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005U4\u0014AC1o]>$\u0018\r^5p]&\u0011qO\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0002u*\u0012\u0001j\\\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tA\u0001\\1oO*\u0011\u0011QA\u0001\u0005U\u00064\u0018-C\u0002\u0002\n}\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\b!\r)\u0014\u0011C\u0005\u0004\u0003'1$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\r\u0003?\u00012!NA\u000e\u0013\r\tiB\u000e\u0002\u0004\u0003:L\b\"CA\u0011\u0019\u0005\u0005\t\u0019AA\b\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0005\t\u0007\u0003S\ty#!\u0007\u000e\u0005\u0005-\"bAA\u0017m\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00121\u0006\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002I\u0003oA\u0011\"!\t\u000f\u0003\u0003\u0005\r!!\u0007\u0002\r\u0015\fX/\u00197t)\rA\u0015Q\b\u0005\n\u0003Cy\u0011\u0011!a\u0001\u00033\tAd\u0011:fCR,G)\u0019;b'>,(oY3UC\ndWmQ8n[\u0006tG\r\u0005\u00022#M!\u0011#!\u0012;!\u001d\t9%!\u0014@\u0011:k!!!\u0013\u000b\u0007\u0005-c'A\u0004sk:$\u0018.\\3\n\t\u0005=\u0013\u0011\n\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA!\u0003!!xn\u0015;sS:<G#A?\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b9\u000bY&!\u0018\t\u000bu\"\u0002\u0019A \t\u000b\u0019#\u0002\u0019\u0001%\u0002\u000fUt\u0017\r\u001d9msR!\u00111MA8!\u0015)\u0014QMA5\u0013\r\t9G\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bU\nYg\u0010%\n\u0007\u00055dG\u0001\u0004UkBdWM\r\u0005\t\u0003c*\u0012\u0011!a\u0001\u001d\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003o\u00022A`A=\u0013\r\tYh \u0002\u0007\u001f\nTWm\u0019;")
public class CreateDataSourceTableCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final CatalogTable table;
    private final boolean ignoreIfExists;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<CatalogTable, Object>> unapply(CreateDataSourceTableCommand createDataSourceTableCommand) {
        return CreateDataSourceTableCommand$.MODULE$.unapply(createDataSourceTableCommand);
    }

    public static Function1<Tuple2<CatalogTable, Object>, CreateDataSourceTableCommand> tupled() {
        return CreateDataSourceTableCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<Object, CreateDataSourceTableCommand>> curried() {
        return CreateDataSourceTableCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        CreateDataSourceTableCommand createDataSourceTableCommand = this;
        synchronized (createDataSourceTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public CatalogTable table() {
        return this.table;
    }

    public boolean ignoreIfExists() {
        return this.ignoreIfExists;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        CatalogTable catalogTable;
        HadoopFsRelation hadoopFsRelation;
        Seq seq;
        CatalogTableType catalogTableType = this.table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        Predef$.MODULE$.assert(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2));
        Predef$.MODULE$.assert(this.table().provider().isDefined());
        SessionState sessionState = sparkSession.sessionState();
        if (sessionState.catalog().tableExists(this.table().identifier())) {
            if (this.ignoreIfExists()) {
                return (Seq)Seq$.MODULE$.empty();
            }
            throw new AnalysisException(new StringBuilder(22).append("Table ").append(this.table().identifier().unquotedString()).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Option pathOption = this.table().storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)CatalogUtils$.MODULE$.URIToString(x$1)));
        Some x$12 = new Some(this.table().identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> sessionState.catalog().getCurrentDatabase()));
        String x$2 = this.table().identifier().copy$default$1();
        TableIdentifier x$3 = this.table().identifier().copy(x$2, (Option)x$12);
        boolean x$4 = sessionState.conf().manageFilesourcePartitions();
        CatalogTableType x$5 = this.table().copy$default$2();
        CatalogStorageFormat x$6 = this.table().copy$default$3();
        StructType x$7 = this.table().copy$default$4();
        Option x$8 = this.table().copy$default$5();
        Seq x$9 = this.table().copy$default$6();
        Option x$10 = this.table().copy$default$7();
        String x$11 = this.table().copy$default$8();
        long x$122 = this.table().copy$default$9();
        long x$13 = this.table().copy$default$10();
        String x$14 = this.table().copy$default$11();
        Map x$15 = this.table().copy$default$12();
        Option x$16 = this.table().copy$default$13();
        Option x$17 = this.table().copy$default$14();
        Option x$18 = this.table().copy$default$15();
        Seq x$19 = this.table().copy$default$16();
        boolean x$20 = this.table().copy$default$18();
        Map x$21 = this.table().copy$default$19();
        Option x$22 = this.table().copy$default$20();
        CatalogTable tableWithDefaultOptions = this.table().copy(x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$4, x$20, x$21, x$22);
        SparkSession x$23 = sparkSession;
        None$ x$24 = this.table().schema().isEmpty() ? None$.MODULE$ : new Some((Object)this.table().schema());
        Seq x$25 = this.table().partitionColumnNames();
        String x$26 = (String)this.table().provider().get();
        Option x$27 = this.table().bucketSpec();
        Map x$28 = this.table().storage().properties().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(pathOption));
        Some x$29 = new Some((Object)tableWithDefaultOptions);
        Seq<String> x$30 = DataSource$.MODULE$.apply$default$3();
        BaseRelation dataSource = new DataSource(x$23, x$26, x$30, (Option<StructType>)x$24, (Seq<String>)x$25, (Option<BucketSpec>)x$27, (Map<String, String>)x$28, (Option<CatalogTable>)x$29).resolveRelation(false);
        if (this.table().schema().nonEmpty()) {
            seq = this.table().partitionColumnNames();
        } else {
            Nil$ nil$;
            Predef$.MODULE$.assert(this.table().partitionColumnNames().isEmpty());
            BaseRelation baseRelation = dataSource;
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation2 = (HadoopFsRelation)baseRelation;
                nil$ = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hadoopFsRelation2.partitionSchema().fieldNames())).toSeq();
            } else {
                nil$ = Nil$.MODULE$;
            }
            seq = nil$;
        }
        Seq partitionColumnNames = seq;
        BaseRelation baseRelation = dataSource;
        if (baseRelation instanceof HadoopFsRelation && (hadoopFsRelation = (HadoopFsRelation)baseRelation).overlappedPartCols().nonEmpty()) {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "It is not recommended to create a table with overlapped data and partition columns, as Spark cannot store a valid table schema and has to infer it at runtime, which hurts performance. Please check your data files and remove the partition columns in it.");
            StructType x$31 = new StructType();
            Nil$ x$32 = Nil$.MODULE$;
            TableIdentifier x$33 = this.table().copy$default$1();
            CatalogTableType x$34 = this.table().copy$default$2();
            CatalogStorageFormat x$35 = this.table().copy$default$3();
            Option x$36 = this.table().copy$default$5();
            Option x$37 = this.table().copy$default$7();
            String x$38 = this.table().copy$default$8();
            long x$39 = this.table().copy$default$9();
            long x$40 = this.table().copy$default$10();
            String x$41 = this.table().copy$default$11();
            Map x$42 = this.table().copy$default$12();
            Option x$43 = this.table().copy$default$13();
            Option x$44 = this.table().copy$default$14();
            Option x$45 = this.table().copy$default$15();
            Seq x$46 = this.table().copy$default$16();
            boolean x$47 = this.table().copy$default$17();
            boolean x$48 = this.table().copy$default$18();
            Map x$49 = this.table().copy$default$19();
            Option x$50 = this.table().copy$default$20();
            catalogTable = this.table().copy(x$33, x$34, x$35, x$31, x$36, (Seq)x$32, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50);
        } else {
            StructType x$51 = dataSource.schema();
            Seq x$52 = partitionColumnNames;
            boolean x$53 = partitionColumnNames.nonEmpty() && sessionState.conf().manageFilesourcePartitions();
            TableIdentifier x$54 = this.table().copy$default$1();
            CatalogTableType x$55 = this.table().copy$default$2();
            CatalogStorageFormat x$56 = this.table().copy$default$3();
            Option x$57 = this.table().copy$default$5();
            Option x$58 = this.table().copy$default$7();
            String x$59 = this.table().copy$default$8();
            long x$60 = this.table().copy$default$9();
            long x$61 = this.table().copy$default$10();
            String x$62 = this.table().copy$default$11();
            Map x$63 = this.table().copy$default$12();
            Option x$64 = this.table().copy$default$13();
            Option x$65 = this.table().copy$default$14();
            Option x$66 = this.table().copy$default$15();
            Seq x$67 = this.table().copy$default$16();
            boolean x$68 = this.table().copy$default$18();
            Map x$69 = this.table().copy$default$19();
            Option x$70 = this.table().copy$default$20();
            catalogTable = this.table().copy(x$54, x$55, x$56, x$51, x$57, x$52, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$53, x$68, x$69, x$70);
        }
        CatalogTable newTable = catalogTable;
        sessionState.catalog().createTable(newTable, false, sessionState.catalog().createTable$default$3());
        return (Seq)Seq$.MODULE$.empty();
    }

    public CreateDataSourceTableCommand copy(CatalogTable table, boolean ignoreIfExists) {
        return new CreateDataSourceTableCommand(table, ignoreIfExists);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public boolean copy$default$2() {
        return this.ignoreIfExists();
    }

    public String productPrefix() {
        return "CreateDataSourceTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreIfExists());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateDataSourceTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateDataSourceTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateDataSourceTableCommand createDataSourceTableCommand = (CreateDataSourceTableCommand)x$1;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = createDataSourceTableCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        if (this.ignoreIfExists() != createDataSourceTableCommand.ignoreIfExists()) return false;
        if (!createDataSourceTableCommand.canEqual(this)) return false;
        return true;
    }

    public CreateDataSourceTableCommand(CatalogTable table, boolean ignoreIfExists) {
        this.table = table;
        this.ignoreIfExists = ignoreIfExists;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

