/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LoadDataCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001\u0002\u0011\"\u0001:B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0011\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005[\u0001\tE\t\u0015!\u0003P\u0011!Y\u0006A!f\u0001\n\u0003a\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011B/\t\u0011\u0005\u0004!Q3A\u0005\u0002qC\u0001B\u0019\u0001\u0003\u0012\u0003\u0006I!\u0018\u0005\tG\u0002\u0011)\u001a!C\u0001I\"AQ\u0010\u0001B\tB\u0003%Q\rC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002\u000e\u0001!\t%a\u0004\t\u0013\u0005U\u0002!!A\u0005\u0002\u0005]\u0002\"CA\"\u0001E\u0005I\u0011AA#\u0011%\tY\u0006AI\u0001\n\u0003\ti\u0006C\u0005\u0002b\u0001\t\n\u0011\"\u0001\u0002d!I\u0011q\r\u0001\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003S\u0002\u0011\u0013!C\u0001\u0003WB\u0011\"a\u001c\u0001\u0003\u0003%\t%!\u001d\t\u0013\u0005\u0005\u0005!!A\u0005\u0002\u0005\r\u0005\"CAF\u0001\u0005\u0005I\u0011AAG\u0011%\tI\nAA\u0001\n\u0003\nY\nC\u0005\u0002*\u0002\t\t\u0011\"\u0001\u0002,\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0013\u0011W\u0004\b\u0003k\u000b\u0003\u0012AA\\\r\u0019\u0001\u0013\u0005#\u0001\u0002:\"1aP\u0007C\u0001\u0003\u0003D\u0001\"a1\u001b\t\u0003)\u0013Q\u0019\u0005\n\u0003[T\u0012\u0011!CA\u0003_D\u0011\"a?\u001b\u0003\u0003%\t)!@\t\u0013\t-!$!A\u0005\n\t5!a\u0004'pC\u0012$\u0015\r^1D_6l\u0017M\u001c3\u000b\u0005\t\u001a\u0013aB2p[6\fg\u000e\u001a\u0006\u0003I\u0015\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001y\u0013(P\"\u0011\u0005A:T\"A\u0019\u000b\u0005I\u001a\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003iU\nQ\u0001\u001d7b]NT!AN\u0013\u0002\u0011\r\fG/\u00197zgRL!\u0001O\u0019\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003umj\u0011!I\u0005\u0003y\u0005\u0012qBU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\b!J|G-^2u!\tqD)\u0003\u0002F\u007f\ta1+\u001a:jC2L'0\u00192mK\u0006)A/\u00192mKV\t\u0001\n\u0005\u0002J\u00156\tQ'\u0003\u0002Lk\tyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u0004uC\ndW\rI\u0001\u0005a\u0006$\b.F\u0001P!\t\u0001vK\u0004\u0002R+B\u0011!kP\u0007\u0002'*\u0011A+L\u0001\u0007yI|w\u000e\u001e \n\u0005Y{\u0014A\u0002)sK\u0012,g-\u0003\u0002Y3\n11\u000b\u001e:j]\u001eT!AV \u0002\u000bA\fG\u000f\u001b\u0011\u0002\u000f%\u001cHj\\2bYV\tQ\f\u0005\u0002?=&\u0011ql\u0010\u0002\b\u0005>|G.Z1o\u0003!I7\u000fT8dC2\u0004\u0013aC5t\u001fZ,'o\u001e:ji\u0016\fA\"[:Pm\u0016\u0014xO]5uK\u0002\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003\u0015\u00042A\u00104i\u0013\t9wH\u0001\u0004PaRLwN\u001c\t\u0003Sjt!A[<\u000f\u0005-,hB\u00017u\u001d\ti7O\u0004\u0002oe:\u0011q.\u001d\b\u0003%BL\u0011\u0001L\u0005\u0003U-J!\u0001K\u0015\n\u0005\u0019:\u0013B\u0001\u001c&\u0013\t1X'A\u0004dCR\fGn\\4\n\u0005aL\u0018\u0001D\"bi\u0006dwn\u001a+za\u0016\u001c(B\u0001<6\u0013\tYHP\u0001\nUC\ndW\rU1si&$\u0018n\u001c8Ta\u0016\u001c'B\u0001=z\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u0005\u0005\u00111AA\u0003\u0003\u000f\tI!a\u0003\u0011\u0005i\u0002\u0001\"\u0002$\f\u0001\u0004A\u0005\"B'\f\u0001\u0004y\u0005\"B.\f\u0001\u0004i\u0006\"B1\f\u0001\u0004i\u0006\"B2\f\u0001\u0004)\u0017a\u0001:v]R!\u0011\u0011CA\u0016!\u0019\t\u0019\"!\b\u0002$9!\u0011QCA\r\u001d\r\u0011\u0016qC\u0005\u0002\u0001&\u0019\u00111D \u0002\u000fA\f7m[1hK&!\u0011qDA\u0011\u0005\r\u0019V-\u001d\u0006\u0004\u00037y\u0004\u0003BA\u0013\u0003Oi\u0011!J\u0005\u0004\u0003S)#a\u0001*po\"9\u0011Q\u0006\u0007A\u0002\u0005=\u0012\u0001D:qCJ\\7+Z:tS>t\u0007\u0003BA\u0013\u0003cI1!a\r&\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u0019\u0005\u0005\u0011\u0011HA\u001e\u0003{\ty$!\u0011\t\u000f\u0019k\u0001\u0013!a\u0001\u0011\"9Q*\u0004I\u0001\u0002\u0004y\u0005bB.\u000e!\u0003\u0005\r!\u0018\u0005\bC6\u0001\n\u00111\u0001^\u0011\u001d\u0019W\u0002%AA\u0002\u0015\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002H)\u001a\u0001*!\u0013,\u0005\u0005-\u0003\u0003BA'\u0003/j!!a\u0014\u000b\t\u0005E\u00131K\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0016@\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\nyEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002`)\u001aq*!\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\r\u0016\u0004;\u0006%\u0013AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\tiGK\u0002f\u0003\u0013\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA:!\u0011\t)(a \u000e\u0005\u0005]$\u0002BA=\u0003w\nA\u0001\\1oO*\u0011\u0011QP\u0001\u0005U\u00064\u0018-C\u0002Y\u0003o\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\"\u0011\u0007y\n9)C\u0002\u0002\n~\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a$\u0002\u0016B\u0019a(!%\n\u0007\u0005MuHA\u0002B]fD\u0011\"a&\u0016\u0003\u0003\u0005\r!!\"\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\n\u0005\u0004\u0002 \u0006\u0015\u0016qR\u0007\u0003\u0003CS1!a)@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\u000b\tK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA/\u0002.\"I\u0011qS\f\u0002\u0002\u0003\u0007\u0011qR\u0001\u0007KF,\u0018\r\\:\u0015\u0007u\u000b\u0019\fC\u0005\u0002\u0018b\t\t\u00111\u0001\u0002\u0010\u0006yAj\\1e\t\u0006$\u0018mQ8n[\u0006tG\r\u0005\u0002;5M!!$a/D!\rq\u0014QX\u0005\u0004\u0003\u007f{$AB!osJ+g\r\u0006\u0002\u00028\u0006iQ.Y6f#V\fG.\u001b4jK\u0012$\u0002\"a2\u0002X\u0006\u001d\u00181\u001e\t\u0005\u0003\u0013\f\u0019.\u0004\u0002\u0002L*!\u0011QZAh\u0003\t17OC\u0002\u0002R&\na\u0001[1e_>\u0004\u0018\u0002BAk\u0003\u0017\u0014A\u0001U1uQ\"9\u0011\u0011\u001c\u000fA\u0002\u0005m\u0017A\u00033fM\u0006,H\u000e^+sSB!\u0011Q\\Ar\u001b\t\tyN\u0003\u0003\u0002b\u0006m\u0014a\u00018fi&!\u0011Q]Ap\u0005\r)&+\u0013\u0005\b\u0003Sd\u0002\u0019AAd\u0003)9xN]6j]\u001e$\u0015N\u001d\u0005\u0007\u001br\u0001\r!a2\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\u0005\u0005\u0011\u0011_Az\u0003k\f90!?\t\u000b\u0019k\u0002\u0019\u0001%\t\u000b5k\u0002\u0019A(\t\u000bmk\u0002\u0019A/\t\u000b\u0005l\u0002\u0019A/\t\u000b\rl\u0002\u0019A3\u0002\u000fUt\u0017\r\u001d9msR!\u0011q B\u0004!\u0011qdM!\u0001\u0011\u0011y\u0012\u0019\u0001S(^;\u0016L1A!\u0002@\u0005\u0019!V\u000f\u001d7fk!I!\u0011\u0002\u0010\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0004\u0011\t\u0005U$\u0011C\u0005\u0005\u0005'\t9H\u0001\u0004PE*,7\r\u001e")
public class LoadDataCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier table;
    private final String path;
    private final boolean isLocal;
    private final boolean isOverwrite;
    private final Option<Map<String, String>> partition;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple5<TableIdentifier, String, Object, Object, Option<Map<String, String>>>> unapply(LoadDataCommand loadDataCommand) {
        return LoadDataCommand$.MODULE$.unapply(loadDataCommand);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        LoadDataCommand loadDataCommand = this;
        synchronized (loadDataCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public String path() {
        return this.path;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isOverwrite() {
        return this.isOverwrite;
    }

    public Option<Map<String, String>> partition() {
        return this.partition;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Path path;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable targetTable = catalog.getTableMetadata(this.table());
        String tableIdentwithDB = targetTable.identifier().quotedString();
        Option normalizedSpec = this.partition().map((Function1 & Serializable & scala.Serializable)spec -> PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, (Seq<String>)targetTable.partitionColumnNames(), tableIdentwithDB, (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver()));
        CatalogTableType catalogTableType = targetTable.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringBuilder(44).append("Target table in LOAD DATA cannot be a view: ").append(tableIdentwithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (DDLUtils$.MODULE$.isDatasourceTable(targetTable)) {
            throw new AnalysisException(new StringBuilder(50).append("LOAD DATA is not supported for datasource tables: ").append(tableIdentwithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (targetTable.partitionColumnNames().nonEmpty()) {
            if (this.partition().isEmpty()) {
                throw new AnalysisException(new StringBuilder(73).append("LOAD DATA target table ").append(tableIdentwithDB).append(" is partitioned, ").append("but no partition spec is provided").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            if (targetTable.partitionColumnNames().size() != ((TraversableOnce)this.partition().get()).size()) {
                throw new AnalysisException(new StringBuilder(146).append("LOAD DATA target table ").append(tableIdentwithDB).append(" is partitioned, ").append("but number of columns in provided partition spec (").append(((TraversableOnce)this.partition().get()).size()).append(") ").append("do not match number of partitioned columns in table ").append("(").append(targetTable.partitionColumnNames().size()).append(")").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        } else if (this.partition().nonEmpty()) {
            throw new AnalysisException(new StringBuilder(78).append("LOAD DATA target table ").append(tableIdentwithDB).append(" is not ").append("partitioned, but a partition spec was provided.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.isLocal()) {
            FileContext localFS = FileContext.getLocalFSFileContext();
            path = LoadDataCommand$.MODULE$.makeQualified(FsConstants.LOCAL_FS_URI, localFS.getWorkingDirectory(), new Path(this.path()));
        } else {
            Path loadPath = new Path(this.path());
            String defaultFSConf = sparkSession.sessionState().newHadoopConf().get("fs.defaultFS");
            URI defaultFS = defaultFSConf == null ? new URI("") : new URI(defaultFSConf);
            Path uriPath = new Path(new StringBuilder(7).append("/user/").append(System.getProperty("user.name")).append("/").toString());
            path = LoadDataCommand$.MODULE$.makeQualified(defaultFS, uriPath, loadPath);
        }
        Path loadPath = path;
        FileSystem fs = loadPath.getFileSystem(sparkSession.sessionState().newHadoopConf());
        try {
            FileStatus[] fileStatus = fs.globStatus(loadPath);
            if (fileStatus == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatus)).isEmpty()) {
                throw new AnalysisException(new StringBuilder(37).append("LOAD DATA input path does not exist: ").append(this.path()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        catch (IllegalArgumentException e) {
            this.log().warn(new StringBuilder(42).append("Exception while validating the load path ").append(this.path()).append(" ").toString(), (Throwable)e);
            throw new AnalysisException(new StringBuilder(37).append("LOAD DATA input path does not exist: ").append(this.path()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.partition().nonEmpty()) {
            catalog.loadPartition(targetTable.identifier(), loadPath.toString(), (Map)normalizedSpec.get(), this.isOverwrite(), true, this.isLocal());
        } else {
            catalog.loadTable(targetTable.identifier(), loadPath.toString(), this.isOverwrite(), this.isLocal());
        }
        catalog.refreshTable(targetTable.identifier());
        CommandUtils$.MODULE$.updateTableStats(sparkSession, targetTable);
        return (Seq)Seq$.MODULE$.empty();
    }

    public LoadDataCommand copy(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        return new LoadDataCommand(table, path, isLocal, isOverwrite, partition);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.path();
    }

    public boolean copy$default$3() {
        return this.isLocal();
    }

    public boolean copy$default$4() {
        return this.isOverwrite();
    }

    public Option<Map<String, String>> copy$default$5() {
        return this.partition();
    }

    public String productPrefix() {
        return "LoadDataCommand";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.path();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isLocal());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isOverwrite());
                break;
            }
            case 4: {
                object = this.partition();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LoadDataCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LoadDataCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        LoadDataCommand loadDataCommand = (LoadDataCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = loadDataCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.path();
        String string2 = loadDataCommand.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.isLocal() != loadDataCommand.isLocal()) return false;
        if (this.isOverwrite() != loadDataCommand.isOverwrite()) return false;
        Option<Map<String, String>> option = this.partition();
        Option<Map<String, String>> option2 = loadDataCommand.partition();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!loadDataCommand.canEqual(this)) return false;
        return true;
    }

    public LoadDataCommand(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        this.table = table;
        this.path = path;
        this.isLocal = isLocal;
        this.isOverwrite = isOverwrite;
        this.partition = partition;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

