/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverWrapper;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.SchemaUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class JdbcUtils$
implements Logging {
    public static JdbcUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new JdbcUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Function0<Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return (Function0 & Serializable & scala.Serializable)() -> {
            void var3_3;
            DriverRegistry$.MODULE$.register(driverClass);
            Driver driver = (Driver)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).collectFirst((PartialFunction)new scala.Serializable(driverClass){
                public static final long serialVersionUID = 0L;
                private final String driverClass$1;

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Driver, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var3_9;
                    A1 A1 = x1;
                    if (A1 instanceof DriverWrapper) {
                        DriverWrapper driverWrapper = (DriverWrapper)A1;
                        String string = driverWrapper.wrapped().getClass().getCanonicalName();
                        String string2 = this.driverClass$1;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            DriverWrapper driverWrapper2 = driverWrapper;
                            return var3_9;
                        }
                    }
                    String string = A1.getClass().getCanonicalName();
                    String string3 = this.driverClass$1;
                    if (!(string != null ? !string.equals(string3) : string3 != null)) {
                        A1 A12 = A1;
                        return var3_9;
                    }
                    Object object = function1.apply(x1);
                    return var3_9;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Driver x1) {
                    Driver driver = x1;
                    if (driver instanceof DriverWrapper) {
                        DriverWrapper driverWrapper = (DriverWrapper)driver;
                        String string = driverWrapper.wrapped().getClass().getCanonicalName();
                        String string2 = this.driverClass$1;
                        if (string == null) {
                            if (string2 == null) return true;
                        } else if (string.equals(string2)) {
                            return true;
                        }
                    }
                    String string = driver.getClass().getCanonicalName();
                    String string3 = this.driverClass$1;
                    if (string != null) {
                        if (!string.equals(string3)) return false;
                        return true;
                    }
                    if (string3 == null) return true;
                    return false;
                }
                {
                    this.driverClass$1 = driverClass$1;
                }
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new java.lang.StringBuilder(42).append("Did not find registered driver with class ").append(driverClass).toString());
            });
            Connection connection = driver.connect(options.url(), options.asConnectionProperties());
            Predef$.MODULE$.require(connection != null, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(60).append("The driver could not open a JDBC connection. Check the URL: ").append(options.url()).toString());
            return var3_3;
        };
    }

    public boolean tableExists(Connection conn, JdbcOptionsInWrite options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ResultSet resultSet;
            try (PreparedStatement statement = conn.prepareStatement(dialect.getTableExistsQuery(options.table()));){
                statement.setQueryTimeout(options.queryTimeout());
                resultSet = statement.executeQuery();
            }
            return resultSet;
        }).isSuccess();
    }

    public void dropTable(Connection conn, String table, JDBCOptions options) {
        try (Statement statement = conn.createStatement();){
            statement.setQueryTimeout(options.queryTimeout());
            statement.executeUpdate(new java.lang.StringBuilder(11).append("DROP TABLE ").append(table).toString());
        }
    }

    public void truncateTable(Connection conn, JdbcOptionsInWrite options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        try (Statement statement = conn.createStatement();){
            statement.setQueryTimeout(options.queryTimeout());
            String truncateQuery = options.isCascadeTruncate().isDefined() ? dialect.getTruncateQuery(options.table(), options.isCascadeTruncate()) : dialect.getTruncateQuery(options.table());
            statement.executeUpdate(truncateQuery);
        }
    }

    public Option<Object> isCascadingTruncateTable(String url) {
        return JdbcDialects$.MODULE$.get(url).isCascadingTruncateTable();
    }

    public String getInsertStatement(String table, StructType rddSchema, Option<StructType> tableSchema, boolean isCaseSensitive, JdbcDialect dialect) {
        String string;
        if (tableSchema.isEmpty()) {
            string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields())).map((Function1 & Serializable & scala.Serializable)x -> dialect.quoteIdentifier(x.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
        } else {
            Function2 columnNameEquality = isCaseSensitive ? package$.MODULE$.caseSensitiveResolution() : package$.MODULE$.caseInsensitiveResolution();
            String[] tableColumnNames = ((StructType)tableSchema.get()).fieldNames();
            string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields())).map((Function1 & Serializable & scala.Serializable)col -> {
                String normalizedName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableColumnNames)).find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.$anonfun$getInsertStatement$3(columnNameEquality, col, f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new AnalysisException(new java.lang.StringBuilder(30).append("Column \"").append(col.name()).append("\" not found in schema ").append(tableSchema).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                });
                return dialect.quoteIdentifier(normalizedName);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
        }
        String columns = string;
        String placeholders = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> "?", Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
        return new java.lang.StringBuilder(25).append("INSERT INTO ").append(table).append(" (").append(columns).append(") VALUES (").append(placeholders).append(")").toString();
    }

    public Option<JdbcType> getCommonJDBCType(DataType dt) {
        Option option;
        DataType dataType = dt;
        if (IntegerType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 4));
        } else if (LongType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BIGINT", -5));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("DOUBLE PRECISION", 8));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("REAL", 6));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 5));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BYTE", -6));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BIT(1)", -7));
        } else if (StringType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("TEXT", 2005));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BLOB", 2004));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("TIMESTAMP", 93));
        } else if (DateType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("DATE", 91));
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            option = Option$.MODULE$.apply((Object)new JdbcType(new java.lang.StringBuilder(10).append("DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString(), 3));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private JdbcType getJdbcType(DataType dt, JdbcDialect dialect) {
        return (JdbcType)dialect.getJDBCType(dt).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getCommonJDBCType(dt)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new java.lang.StringBuilder(24).append("Can't get JDBC type for ").append(dt.catalogString()).toString());
        });
    }

    private DataType getCatalystType(int sqlType, int precision, int scale, boolean signed) {
        BinaryType$ binaryType$;
        int n = sqlType;
        switch (n) {
            case 2003: {
                binaryType$ = null;
                break;
            }
            case -5: {
                if (signed) {
                    binaryType$ = LongType$.MODULE$;
                    break;
                }
                binaryType$ = new DecimalType(20, 0);
                break;
            }
            case -2: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 16: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                binaryType$ = null;
                break;
            }
            case 91: {
                binaryType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                if (precision != 0 || scale != 0) {
                    binaryType$ = DecimalType$.MODULE$.bounded(precision, scale);
                    break;
                }
                binaryType$ = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                break;
            }
            case 2001: {
                binaryType$ = null;
                break;
            }
            case 8: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                binaryType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    binaryType$ = IntegerType$.MODULE$;
                    break;
                }
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                binaryType$ = null;
                break;
            }
            case -16: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                binaryType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    binaryType$ = DecimalType$.MODULE$.bounded(precision, scale);
                    break;
                }
                binaryType$ = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                break;
            }
            case -9: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                binaryType$ = null;
                break;
            }
            case 7: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2012: {
                binaryType$ = null;
                break;
            }
            case -8: {
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 5: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2002: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                binaryType$ = TimestampType$.MODULE$;
                break;
            }
            case 2013: {
                binaryType$ = null;
                break;
            }
            case 93: {
                binaryType$ = TimestampType$.MODULE$;
                break;
            }
            case 2014: {
                binaryType$ = null;
                break;
            }
            case -6: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case -3: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 12: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            default: {
                throw new SQLException(new java.lang.StringBuilder(22).append("Unrecognized SQL type ").append(sqlType).toString());
            }
        }
        BinaryType$ answer = binaryType$;
        if (answer == null) {
            throw new SQLException(new java.lang.StringBuilder(17).append("Unsupported type ").append(JDBCType.valueOf(sqlType).getName()).toString());
        }
        return answer;
    }

    public Option<StructType> getSchemaOption(Connection conn, JDBCOptions options) {
        None$ none$;
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        try (PreparedStatement statement = conn.prepareStatement(dialect.getSchemaQuery(options.tableOrQuery()));){
            try {
                statement.setQueryTimeout(options.queryTimeout());
                none$ = new Some((Object)this.getSchema(statement.executeQuery(), dialect, this.getSchema$default$3()));
            }
            catch (SQLException sQLException) {
                none$ = None$.MODULE$;
            }
        }
        catch (SQLException sQLException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public StructType getSchema(ResultSet resultSet, JdbcDialect dialect, boolean alwaysNullable) {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int ncols = rsmd.getColumnCount();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            boolean isSigned;
            boolean bl;
            String columnName = rsmd.getColumnLabel(i + 1);
            int dataType = rsmd.getColumnType(i + 1);
            String typeName = rsmd.getColumnTypeName(i + 1);
            int fieldSize = rsmd.getPrecision(i + 1);
            int fieldScale = rsmd.getScale(i + 1);
            try {
                bl = rsmd.isSigned(i + 1);
            }
            catch (Throwable throwable) {
                block6: {
                    block5: {
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof SQLException)) break block5;
                        SQLException sQLException = (SQLException)throwable2;
                        String string = sQLException.getMessage();
                        String string2 = "Method not supported";
                        if (string != null ? !string.equals(string2) : string2 != null) break block5;
                        String string3 = rsmd.getClass().getName();
                        String string4 = "org.apache.hive.jdbc.HiveResultSetMetaData";
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) break block6;
                    }
                    throw throwable;
                }
                boolean bl2 = true;
                bl = isSigned = bl2;
            }
            boolean nullable = alwaysNullable ? true : rsmd.isNullable(i + 1) != 0;
            MetadataBuilder metadata = new MetadataBuilder().putLong("scale", (long)fieldScale);
            DataType columnType = (DataType)dialect.getCatalystType(dataType, typeName, fieldSize, metadata).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getCatalystType(dataType, fieldSize, fieldScale, isSigned));
            fields[i] = new StructField(columnName, columnType, nullable, StructField$.MODULE$.apply$default$4());
        }
        return new StructType(fields);
    }

    public boolean getSchema$default$3() {
        return false;
    }

    public Iterator<Row> resultSetToRows(ResultSet resultSet, StructType schema) {
        InputMetrics inputMetrics = (InputMetrics)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.taskMetrics().inputMetrics()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new InputMetrics());
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(schema);
        Seq x$1 = qual$1.resolveAndBind$default$1();
        Analyzer x$22 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder encoder = qual$1.resolveAndBind(x$1, x$22);
        Iterator<InternalRow> internalRows = this.resultSetToSparkInternalRows(resultSet, schema, inputMetrics);
        return internalRows.map((Function1 & Serializable & scala.Serializable)row -> (Row)encoder.fromRow(row));
    }

    public Iterator<InternalRow> resultSetToSparkInternalRows(ResultSet resultSet, StructType schema, InputMetrics inputMetrics) {
        return new NextIterator<InternalRow>(resultSet, schema, inputMetrics){
            private final ResultSet rs;
            private final Function3<ResultSet, InternalRow, Object, BoxedUnit>[] getters;
            private final SpecificInternalRow mutableRow;
            private final InputMetrics inputMetrics$1;

            public void close() {
                try {
                    this.rs.close();
                }
                catch (Exception e) {
                    JdbcUtils$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception closing resultset", e);
                }
            }

            public InternalRow getNext() {
                SpecificInternalRow specificInternalRow;
                if (this.rs.next()) {
                    this.inputMetrics$1.incRecordsRead(1L);
                    for (int i = 0; i < this.getters.length; ++i) {
                        this.getters[i].apply((Object)this.rs, (Object)this.mutableRow, (Object)BoxesRunTime.boxToInteger((int)i));
                        if (!this.rs.wasNull()) continue;
                        this.mutableRow.setNullAt(i);
                    }
                    specificInternalRow = this.mutableRow;
                } else {
                    this.finished_$eq(true);
                    specificInternalRow = null;
                }
                return specificInternalRow;
            }
            {
                this.inputMetrics$1 = inputMetrics$1;
                this.rs = resultSet$1;
                this.getters = JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetters(schema$1);
                this.mutableRow = new SpecificInternalRow((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema$1.fields())).map((Function1 & Serializable & scala.Serializable)x -> x.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$close$1(), $anonfun$mutableRow$1(org.apache.spark.sql.types.StructField )}, serializedLambda);
            }
        };
    }

    public Function3<ResultSet, InternalRow, Object, BoxedUnit>[] org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetters(StructType schema) {
        return (Function3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)sf -> MODULE$.makeGetter(sf.dataType(), sf.metadata()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function3.class)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function3<ResultSet, InternalRow, Object, BoxedUnit> makeGetter(DataType dt, Metadata metadata) {
        Function1 & Serializable & scala.Serializable intersect;
        DecimalType decimalType;
        Option option;
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = dt;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                row.setBoolean(BoxesRunTime.unboxToInt((Object)pos), rs.getBoolean(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                JdbcUtils$.$anonfun$makeGetter$2(rs, row, BoxesRunTime.unboxToInt((Object)pos));
                return BoxedUnit.UNIT;
            };
        }
        if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
            int p = ((Tuple2)option.get())._1$mcI$sp();
            int s = ((Tuple2)option.get())._2$mcI$sp();
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                JdbcUtils$.$anonfun$makeGetter$3(p, s, rs, row, BoxesRunTime.unboxToInt((Object)pos));
                return BoxedUnit.UNIT;
            };
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                row.setDouble(BoxesRunTime.unboxToInt((Object)pos), rs.getDouble(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                row.setFloat(BoxesRunTime.unboxToInt((Object)pos), rs.getFloat(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                row.setInt(BoxesRunTime.unboxToInt((Object)pos), rs.getInt(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (metadata.contains("binarylong")) {
                return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                    JdbcUtils$.$anonfun$makeGetter$8(rs, row, BoxesRunTime.unboxToInt((Object)pos));
                    return BoxedUnit.UNIT;
                };
            }
        }
        if (bl) {
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                row.setLong(BoxesRunTime.unboxToInt((Object)pos), rs.getLong(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                row.setShort(BoxesRunTime.unboxToInt((Object)pos), rs.getShort(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                row.update(BoxesRunTime.unboxToInt((Object)pos), (Object)BoxesRunTime.boxToByte((byte)rs.getByte(BoxesRunTime.unboxToInt((Object)pos) + 1)));
                return BoxedUnit.UNIT;
            };
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                row.update(BoxesRunTime.unboxToInt((Object)pos), (Object)UTF8String.fromString((String)rs.getString(BoxesRunTime.unboxToInt((Object)pos) + 1)));
                return BoxedUnit.UNIT;
            };
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                JdbcUtils$.$anonfun$makeGetter$13(rs, row, BoxesRunTime.unboxToInt((Object)pos));
                return BoxedUnit.UNIT;
            };
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
                row.update(BoxesRunTime.unboxToInt((Object)pos), (Object)rs.getBytes(BoxesRunTime.unboxToInt((Object)pos) + 1));
                return BoxedUnit.UNIT;
            };
        }
        if (!(dataType2 instanceof ArrayType)) throw new IllegalArgumentException(new java.lang.StringBuilder(17).append("Unsupported type ").append(dt.catalogString()).toString());
        ArrayType arrayType = (ArrayType)dataType2;
        DataType et = arrayType.elementType();
        DataType dataType3 = et;
        if (TimestampType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)array -> (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Timestamp[])array))).map((Function1 & Serializable & scala.Serializable)timestamp -> MODULE$.nullSafeConvert(timestamp, (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(t))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        } else if (StringType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)array -> (UTF8String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])array)).map((Function1 & Serializable & scala.Serializable)obj -> obj == null ? null : UTF8String.fromString((String)obj.toString()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(UTF8String.class)));
        } else if (DateType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)array -> (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Date[])array))).map((Function1 & Serializable & scala.Serializable)date2 -> MODULE$.nullSafeConvert(date2, (Function1 & Serializable & scala.Serializable)date -> BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(date))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        } else if (dataType3 instanceof DecimalType) {
            DecimalType decimalType2 = (DecimalType)dataType3;
            intersect = (Function1 & Serializable & scala.Serializable)array -> (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((BigDecimal[])array))).map((Function1 & Serializable & scala.Serializable)decimal -> MODULE$.nullSafeConvert(decimal, (Function1 & Serializable & scala.Serializable)d -> Decimal$.MODULE$.apply(d, decimalType2.precision(), decimalType2.scale())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        } else {
            if (LongType$.MODULE$.equals(dataType3) && metadata.contains("binarylong")) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(47).append("Unsupported array element ").append("type ").append(dt.catalogString()).append(" based on binary").toString());
            }
            if (dataType3 instanceof ArrayType) {
                throw new IllegalArgumentException("Nested arrays unsupported");
            }
            intersect = (Function1 & Serializable & scala.Serializable)array -> (Object[])array;
        }
        Function1 & Serializable & scala.Serializable elementConversion = intersect;
        return (Function3 & Serializable & scala.Serializable)(rs, row, pos) -> {
            JdbcUtils$.$anonfun$makeGetter$27(elementConversion, rs, row, BoxesRunTime.unboxToInt((Object)pos));
            return BoxedUnit.UNIT;
        };
    }

    private <T> Object nullSafeConvert(T input, Function1<T, Object> f) {
        return input == null ? null : f.apply(input);
    }

    private Function3<PreparedStatement, Row, Object, BoxedUnit> makeSetter(Connection conn, JdbcDialect dialect, DataType dataType) {
        Function3 & Serializable & scala.Serializable intersect;
        DataType dataType2 = dataType;
        if (IntegerType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setInt(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getInt(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (LongType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setLong(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getLong(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setDouble(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getDouble(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setFloat(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getFloat(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setInt(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getShort(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setInt(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getByte(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setBoolean(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getBoolean(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (StringType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setString(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getString(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setBytes(BoxesRunTime.unboxToInt((Object)pos) + 1, (byte[])row.getAs(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setTimestamp(BoxesRunTime.unboxToInt((Object)pos) + 1, (Timestamp)row.getAs(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (DateType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setDate(BoxesRunTime.unboxToInt((Object)pos) + 1, (Date)row.getAs(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (dataType2 instanceof DecimalType) {
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                stmt.setBigDecimal(BoxesRunTime.unboxToInt((Object)pos) + 1, row.getDecimal(BoxesRunTime.unboxToInt((Object)pos)));
                return BoxedUnit.UNIT;
            };
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType et = arrayType.elementType();
            String typeName = this.getJdbcType(et, dialect).databaseTypeDefinition().toLowerCase(Locale.ROOT).split("\\(")[0];
            intersect = (Function3 & Serializable & scala.Serializable)(stmt, row, pos) -> {
                JdbcUtils$.$anonfun$makeSetter$13(conn, typeName, stmt, row, BoxesRunTime.unboxToInt((Object)pos));
                return BoxedUnit.UNIT;
            };
        } else {
            intersect = (Function3 & Serializable & scala.Serializable)(x$3, x$4, pos) -> JdbcUtils$.$anonfun$makeSetter$14(x$3, x$4, BoxesRunTime.unboxToInt((Object)pos));
        }
        return intersect;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void savePartition(Function0<Connection> getConnection, String table, Iterator<Row> iterator, StructType rddSchema, String insertStmt, int batchSize, JdbcDialect dialect, int isolationLevel, JDBCOptions options) {
        outMetrics = TaskContext$.MODULE$.get().taskMetrics().outputMetrics();
        conn = (Connection)getConnection.apply();
        committed = false;
        finalIsolationLevel = 0;
        if (isolationLevel != 0) {
            try {
                metadata = conn.getMetaData();
                if (metadata.supportsTransactions()) {
                    finalIsolationLevel = defaultIsolation = metadata.getDefaultTransactionIsolation();
                    if (metadata.supportsTransactionIsolationLevel(isolationLevel)) {
                        finalIsolationLevel = isolationLevel;
                    } else {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$savePartition$1(int int ), ()Ljava/lang/String;)((int)isolationLevel, (int)defaultIsolation));
                    }
                } else {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$savePartition$2(int ), ()Ljava/lang/String;)((int)isolationLevel));
                }
            }
            catch (Throwable var17_16) {
                var18_17 = var17_16;
                var19_18 = NonFatal$.MODULE$.unapply(var18_17);
                if (!var19_18.isEmpty()) {
                    e = (Throwable)var19_18.get();
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$savePartition$3(), ()Ljava/lang/String;)(), e);
                    var10_20 = BoxedUnit.UNIT;
                }
                throw var17_16;
            }
        }
        supportsTransactions = finalIsolationLevel != 0;
        totalRowCount = 0;
        try {
            try {
                if (supportsTransactions) {
                    conn.setAutoCommit(false);
                    conn.setTransactionIsolation(finalIsolationLevel);
                }
                stmt = conn.prepareStatement(insertStmt);
                setters = (Function3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$savePartition$4(java.sql.Connection org.apache.spark.sql.jdbc.JdbcDialect org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Lscala/Function3;)((Connection)conn, (JdbcDialect)dialect), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function3.class)));
                nullTypes = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$savePartition$5$adapted(org.apache.spark.sql.jdbc.JdbcDialect org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/Object;)((JdbcDialect)dialect), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                numFields = rddSchema.fields().length;
                try {
                    rowCount = 0;
                    stmt.setQueryTimeout(options.queryTimeout());
                    while (iterator.hasNext()) {
                        row = (Row)iterator.next();
                        for (i = 0; i < numFields; ++i) {
                            if (row.isNullAt(i)) {
                                stmt.setNull(i + 1, nullTypes[i]);
                                v0 = BoxedUnit.UNIT;
                                continue;
                            }
                            v0 = setters[i].apply((Object)stmt, (Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                        }
                        stmt.addBatch();
                        ++totalRowCount;
                        if (++rowCount % batchSize != 0) continue;
                        stmt.executeBatch();
                        rowCount = 0;
                    }
                    v1 = rowCount > 0 ? (Object)stmt.executeBatch() : BoxedUnit.UNIT;
                }
                finally {
                    stmt.close();
                }
                if (supportsTransactions) {
                    conn.commit();
                }
                committed = true;
            }
            catch (SQLException e) {
                cause = e.getNextException();
                if (cause == null) ** GOTO lbl-1000
                v2 = e.getCause();
                var33_33 = cause;
                if (v2 == null ? var33_33 != null : v2.equals(var33_33) == false) {
                    if (e.getCause() == null) {
                        try {
                            v3 /* !! */  = e.initCause(cause);
                        }
                        catch (IllegalStateException v4) {
                            e.addSuppressed(cause);
                            v3 /* !! */  = BoxedUnit.UNIT;
                        }
                    } else {
                        e.addSuppressed(cause);
                        v3 /* !! */  = BoxedUnit.UNIT;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    v3 /* !! */  = BoxedUnit.UNIT;
                }
                throw e;
            }
        }
        finally {
            if (!committed) {
                if (supportsTransactions) {
                    conn.rollback();
                } else {
                    outMetrics.setRecordsWritten((long)totalRowCount);
                }
                conn.close();
            } else {
                outMetrics.setRecordsWritten((long)totalRowCount);
                try {
                    conn.close();
                }
                catch (Exception e) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$savePartition$6(), ()Ljava/lang/String;)(), e);
                }
            }
        }
    }

    public String schemaString(Dataset<Row> df, String url, Option<String> createTableColumnTypes) {
        StringBuilder sb = new StringBuilder();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        Map userSpecifiedColTypesMap = (Map)createTableColumnTypes.map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.parseUserSpecifiedCreateTableColumnTypes(df, (String)x$5)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
            String name = dialect.quoteIdentifier(field.name());
            String typ = (String)userSpecifiedColTypesMap.getOrElse((Object)field.name(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.getJdbcType(field.dataType(), dialect).databaseTypeDefinition());
            String nullable = field.nullable() ? "" : "NOT NULL";
            return sb.append(new java.lang.StringBuilder(4).append(", ").append(name).append(" ").append(typ).append(" ").append(nullable).toString());
        });
        return sb.length() < 2 ? "" : sb.substring(2);
    }

    public Option<String> schemaString$default$3() {
        return None$.MODULE$;
    }

    private Map<String, String> parseUserSpecifiedCreateTableColumnTypes(Dataset<Row> df, String createTableColumnTypes) {
        StructType userSchema = CatalystSqlParser$.MODULE$.parseTableSchema(createTableColumnTypes);
        Function2 nameEquality = df.sparkSession().sessionState().conf().resolver();
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)userSchema.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Seq$.MODULE$.canBuildFrom()), "in the createTableColumnTypes option value", nameEquality);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])userSchema.fieldNames())).foreach((Function1 & Serializable & scala.Serializable)col -> (StructField)df.schema().find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.$anonfun$parseUserSpecifiedCreateTableColumnTypes$3(nameEquality, col, f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AnalysisException(new java.lang.StringBuilder(58).append("createTableColumnTypes option column ").append((String)col).append(" not found in schema ").append(df.schema().catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }));
        Map userSchemaMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])userSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)JdbcUtils$.typeName$2(f)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        boolean isCaseSensitive = df.sparkSession().sessionState().conf().caseSensitiveAnalysis();
        return isCaseSensitive ? userSchemaMap : CaseInsensitiveMap$.MODULE$.apply(userSchemaMap);
    }

    public StructType getCustomSchema(StructType tableSchema, String customSchema, Function2<String, String, Object> nameEquality) {
        StructType structType;
        if (customSchema != null && new StringOps(Predef$.MODULE$.augmentString(customSchema)).nonEmpty()) {
            StructType userSchema = CatalystSqlParser$.MODULE$.parseTableSchema(customSchema);
            SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)userSchema.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Seq$.MODULE$.canBuildFrom()), "in the customSchema option value", nameEquality);
            Seq newSchema = (Seq)tableSchema.map((Function1 & Serializable & scala.Serializable)col -> {
                StructField structField;
                Option option = userSchema.find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.$anonfun$getCustomSchema$3(nameEquality, col, f)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    StructField c = (StructField)some.value();
                    DataType x$1 = c.dataType();
                    String x$2 = col.copy$default$1();
                    boolean x$3 = col.copy$default$3();
                    Metadata x$4 = col.copy$default$4();
                    structField = col.copy(x$2, x$1, x$3, x$4);
                } else if (None$.MODULE$.equals(option)) {
                    structField = col;
                } else {
                    throw new MatchError((Object)option);
                }
                return structField;
            }, Seq$.MODULE$.canBuildFrom());
            structType = StructType$.MODULE$.apply(newSchema);
        } else {
            structType = tableSchema;
        }
        return structType;
    }

    public void saveTable(Dataset<Row> df, Option<StructType> tableSchema, boolean isCaseSensitive, JdbcOptionsInWrite options) {
        int n;
        String url = options.url();
        String table = options.table();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        StructType rddSchema = df.schema();
        Function0<Connection> getConnection = this.createConnectionFactory(options);
        int batchSize = options.batchSize();
        int isolationLevel = options.isolationLevel();
        String insertStmt = this.getInsertStatement(table, rddSchema, tableSchema, isCaseSensitive, dialect);
        boolean bl = false;
        Some some = null;
        Option<Object> option = options.numPartitions();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int n2 = BoxesRunTime.unboxToInt((Object)some.value());
            if (n2 <= 0) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(84).append("Invalid value `").append(n2).append("` for parameter `").append(JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()).append("` in table writing ").append("via JDBC. The minimum value is 1.").toString());
            }
        }
        Dataset<Row> dataset = bl && (n = BoxesRunTime.unboxToInt((Object)some.value())) < df.rdd().getNumPartitions() ? df.coalesce(n) : df;
        Dataset<Row> repartitionedDF = dataset;
        repartitionedDF.rdd().foreachPartition((Function1 & Serializable & scala.Serializable)iterator -> {
            JdbcUtils$.MODULE$.savePartition((Function0<Connection>)getConnection, table, (Iterator<Row>)iterator, rddSchema, insertStmt, batchSize, dialect, isolationLevel, options);
            return BoxedUnit.UNIT;
        });
    }

    public void createTable(Connection conn, Dataset<Row> df, JdbcOptionsInWrite options) {
        String strSchema = this.schemaString(df, options.url(), options.createTableColumnTypes());
        String table = options.table();
        String createTableOptions = options.createTableOptions();
        String sql = new java.lang.StringBuilder(17).append("CREATE TABLE ").append(table).append(" (").append(strSchema).append(") ").append(createTableOptions).toString();
        try (Statement statement = conn.createStatement();){
            statement.setQueryTimeout(options.queryTimeout());
            statement.executeUpdate(sql);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getInsertStatement$3(Function2 columnNameEquality$1, StructField col$1, String f) {
        return BoxesRunTime.unboxToBoolean((Object)columnNameEquality$1.apply((Object)f, (Object)col$1.name()));
    }

    public static final /* synthetic */ void $anonfun$makeGetter$2(ResultSet rs, InternalRow row, int pos) {
        Date dateVal = rs.getDate(pos + 1);
        if (dateVal != null) {
            row.setInt(pos, DateTimeUtils$.MODULE$.fromJavaDate(dateVal));
        } else {
            row.update(pos, null);
        }
    }

    public static final /* synthetic */ void $anonfun$makeGetter$3(int p$1, int s$1, ResultSet rs, InternalRow row, int pos) {
        Object decimal = MODULE$.nullSafeConvert(rs.getBigDecimal(pos + 1), (Function1 & Serializable & scala.Serializable)d -> Decimal$.MODULE$.apply(d, p$1, s$1));
        row.update(pos, decimal);
    }

    public static final /* synthetic */ void $anonfun$makeGetter$8(ResultSet rs, InternalRow row, int pos) {
        byte[] bytes = rs.getBytes(pos + 1);
        long ans = 0L;
        for (int j = 0; j < bytes.length; ++j) {
            ans = 256L * ans + (long)(0xFF & bytes[j]);
        }
        row.setLong(pos, ans);
    }

    public static final /* synthetic */ void $anonfun$makeGetter$13(ResultSet rs, InternalRow row, int pos) {
        Timestamp t = rs.getTimestamp(pos + 1);
        if (t != null) {
            row.setLong(pos, DateTimeUtils$.MODULE$.fromJavaTimestamp(t));
        } else {
            row.update(pos, null);
        }
    }

    public static final /* synthetic */ void $anonfun$makeGetter$27(Function1 elementConversion$1, ResultSet rs, InternalRow row, int pos) {
        Object array2 = MODULE$.nullSafeConvert(rs.getArray(pos + 1), (Function1 & Serializable & scala.Serializable)array -> new GenericArrayData(elementConversion$1.apply(array.getArray())));
        row.update(pos, array2);
    }

    public static final /* synthetic */ void $anonfun$makeSetter$13(Connection conn$2, String typeName$1, PreparedStatement stmt, Row row, int pos) {
        Array array = conn$2.createArrayOf(typeName$1, (Object[])row.getSeq(pos).toArray(ClassTag$.MODULE$.AnyRef()));
        stmt.setArray(pos + 1, array);
    }

    public static final /* synthetic */ Nothing$ $anonfun$makeSetter$14(PreparedStatement x$3, Row x$4, int pos) {
        throw new IllegalArgumentException(new java.lang.StringBuilder(41).append("Can't translate non-null value for field ").append(pos).toString());
    }

    public static final /* synthetic */ String $anonfun$savePartition$1(int isolationLevel$1, int defaultIsolation$1) {
        return new java.lang.StringBuilder(85).append("Requested isolation level ").append(isolationLevel$1).append(" is not supported; ").append("falling back to default isolation level ").append(defaultIsolation$1).toString();
    }

    public static final /* synthetic */ String $anonfun$savePartition$2(int isolationLevel$1) {
        return new java.lang.StringBuilder(60).append("Requested isolation level ").append(isolationLevel$1).append(", but transactions are unsupported").toString();
    }

    public static final /* synthetic */ String $anonfun$savePartition$3() {
        return "Exception while detecting transaction support";
    }

    public static final /* synthetic */ Function3 $anonfun$savePartition$4(Connection conn$3, JdbcDialect dialect$3, StructField f) {
        return MODULE$.makeSetter(conn$3, dialect$3, f.dataType());
    }

    public static final /* synthetic */ int $anonfun$savePartition$5(JdbcDialect dialect$3, StructField f) {
        return MODULE$.getJdbcType(f.dataType(), dialect$3).jdbcNullType();
    }

    public static final /* synthetic */ String $anonfun$savePartition$6() {
        return "Transaction succeeded, but closing failed";
    }

    private static final String typeName$2(StructField f) {
        return f.metadata().contains(org.apache.spark.sql.types.package$.MODULE$.HIVE_TYPE_STRING()) ? f.metadata().getString(org.apache.spark.sql.types.package$.MODULE$.HIVE_TYPE_STRING()) : f.dataType().catalogString();
    }

    public static final /* synthetic */ boolean $anonfun$parseUserSpecifiedCreateTableColumnTypes$3(Function2 nameEquality$1, String col$2, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)nameEquality$1.apply((Object)f.name(), (Object)col$2));
    }

    public static final /* synthetic */ boolean $anonfun$getCustomSchema$3(Function2 nameEquality$2, StructField col$3, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)nameEquality$2.apply((Object)f.name(), (Object)col$3.name()));
    }

    private JdbcUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }

    public static final /* synthetic */ Object $anonfun$savePartition$5$adapted(JdbcDialect dialect$3, StructField f) {
        return BoxesRunTime.boxToInteger((int)JdbcUtils$.$anonfun$savePartition$5(dialect$3, f));
    }
}

