/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.orc;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.orc.OrcConf;
import org.apache.orc.mapred.OrcOutputFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcOutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.execution.datasources.v2.FileWriteBuilder;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001Q4Aa\u0002\u0005\u00013!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!a\u0004A!A!\u0002\u0013!\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u000b-\u0003A\u0011\u0001'\t\u000bM\u0003A\u0011\t+\u0003\u001f=\u00138m\u0016:ji\u0016\u0014U/\u001b7eKJT!!\u0003\u0006\u0002\u0007=\u00148M\u0003\u0002\f\u0019\u0005\u0011aO\r\u0006\u0003\u001b9\t1\u0002Z1uCN|WO]2fg*\u0011q\u0002E\u0001\nKb,7-\u001e;j_:T!!\u0005\n\u0002\u0007M\fHN\u0003\u0002\u0014)\u0005)1\u000f]1sW*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005maR\"\u0001\u0006\n\u0005uQ!\u0001\u0005$jY\u0016<&/\u001b;f\u0005VLG\u000eZ3s\u0003\u001dy\u0007\u000f^5p]N\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\t\u0002\tU$\u0018\u000e\\\u0005\u0003I\u0005\u0012\u0001dQ1tK&s7/\u001a8tSRLg/Z*ue&tw-T1q\u0003\u0015\u0001\u0018\r\u001e5t!\r9\u0013\u0007\u000e\b\u0003Q9r!!\u000b\u0017\u000e\u0003)R!a\u000b\r\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0013!B:dC2\f\u0017BA\u00181\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!L\u0005\u0003eM\u00121aU3r\u0015\ty\u0003\u0007\u0005\u00026s9\u0011ag\u000e\t\u0003SAJ!\u0001\u000f\u0019\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qA\n!BZ8s[\u0006$h*Y7f\u0003A\u0019X\u000f\u001d9peR\u001cH)\u0019;b)f\u0004X\r\u0005\u0003@\u0001\nCU\"\u0001\u0019\n\u0005\u0005\u0003$!\u0003$v]\u000e$\u0018n\u001c82!\t\u0019e)D\u0001E\u0015\t)\u0005#A\u0003usB,7/\u0003\u0002H\t\nAA)\u0019;b)f\u0004X\r\u0005\u0002@\u0013&\u0011!\n\r\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q)Qj\u0014)R%B\u0011a\nA\u0007\u0002\u0011!)a$\u0002a\u0001?!)Q%\u0002a\u0001M!)A(\u0002a\u0001i!)Q(\u0002a\u0001}\u0005a\u0001O]3qCJ,wK]5uKR)Q+W1l_B\u0011akV\u0007\u0002\u0019%\u0011\u0001\f\u0004\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u00065\u001a\u0001\raW\u0001\bgFd7i\u001c8g!\tav,D\u0001^\u0015\tq\u0006#\u0001\u0005j]R,'O\\1m\u0013\t\u0001WLA\u0004T#2\u001buN\u001c4\t\u000b\t4\u0001\u0019A2\u0002\u0007)|'\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0003QR\ta\u0001[1e_>\u0004\u0018B\u00016f\u0005\rQuN\u0019\u0005\u0006=\u0019\u0001\r\u0001\u001c\t\u0005k5$D'\u0003\u0002ow\t\u0019Q*\u00199\t\u000bA4\u0001\u0019A9\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017\r\u0005\u0002De&\u00111\u000f\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007")
public class OrcWriteBuilder
extends FileWriteBuilder {
    @Override
    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sqlConf);
        Configuration conf = job.getConfiguration();
        conf.set(OrcConf.MAPRED_OUTPUT_SCHEMA.getAttribute(), OrcFileFormat$.MODULE$.getQuotedSchemaString((DataType)dataSchema));
        conf.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        ((JobConf)conf).setOutputFormat(OrcOutputFormat.class);
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcUtils$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> "");
                return new StringBuilder(4).append(compressionExtension).append(".orc").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFileExtension$1()}, serializedLambda);
            }
        };
    }

    public OrcWriteBuilder(CaseInsensitiveStringMap options, Seq<String> paths, String formatName, Function1<DataType, Object> supportsDataType) {
        super(options, paths, formatName, supportsDataType);
    }
}

