/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.text;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.text.TextOptions;
import org.apache.spark.sql.execution.datasources.text.TextOutputWriter;
import org.apache.spark.sql.execution.datasources.v2.FileWriteBuilder;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001q4A\u0001C\u0005\u00015!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011!i\u0004A!A!\u0002\u0013)\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u000b1\u0003A\u0011A'\t\u000bQ\u0003A\u0011B+\t\u000by\u0003A\u0011I0\u0003!Q+\u0007\u0010^,sSR,')^5mI\u0016\u0014(B\u0001\u0006\f\u0003\u0011!X\r\u001f;\u000b\u00051i\u0011A\u0001<3\u0015\tqq\"A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\t\u0012\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0013'\u0005\u00191/\u001d7\u000b\u0005Q)\u0012!B:qCJ\\'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00017A\u0011A$H\u0007\u0002\u0017%\u0011ad\u0003\u0002\u0011\r&dWm\u0016:ji\u0016\u0014U/\u001b7eKJ\fqa\u001c9uS>t7\u000f\u0005\u0002\"I5\t!E\u0003\u0002$#\u0005!Q\u000f^5m\u0013\t)#E\u0001\rDCN,\u0017J\\:f]NLG/\u001b<f'R\u0014\u0018N\\4NCB\fQ\u0001]1uQN\u00042\u0001\u000b\u001a6\u001d\tIsF\u0004\u0002+[5\t1F\u0003\u0002-3\u00051AH]8pizJ\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003aE\nq\u0001]1dW\u0006<WMC\u0001/\u0013\t\u0019DGA\u0002TKFT!\u0001M\u0019\u0011\u0005YRdBA\u001c9!\tQ\u0013'\u0003\u0002:c\u00051\u0001K]3eK\u001aL!a\u000f\u001f\u0003\rM#(/\u001b8h\u0015\tI\u0014'\u0001\u0006g_Jl\u0017\r\u001e(b[\u0016\f\u0001c];qa>\u0014Ho\u001d#bi\u0006$\u0016\u0010]3\u0011\t\u0001\u000b5)S\u0007\u0002c%\u0011!)\r\u0002\n\rVt7\r^5p]F\u0002\"\u0001R$\u000e\u0003\u0015S!AR\t\u0002\u000bQL\b/Z:\n\u0005!+%\u0001\u0003#bi\u0006$\u0016\u0010]3\u0011\u0005\u0001S\u0015BA&2\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD#\u0002(Q#J\u001b\u0006CA(\u0001\u001b\u0005I\u0001\"B\u0010\u0006\u0001\u0004\u0001\u0003\"\u0002\u0014\u0006\u0001\u00049\u0003\"B\u001f\u0006\u0001\u0004)\u0004\"\u0002 \u0006\u0001\u0004y\u0014\u0001\u0004<fe&4\u0017pU2iK6\fGC\u0001,Z!\t\u0001u+\u0003\u0002Yc\t!QK\\5u\u0011\u0015Qf\u00011\u0001\\\u0003\u0019\u00198\r[3nCB\u0011A\tX\u0005\u0003;\u0016\u0013!b\u0015;sk\u000e$H+\u001f9f\u00031\u0001(/\u001a9be\u0016<&/\u001b;f)\u0015\u0001G\r\u001c<{!\t\t'-D\u0001\u000e\u0013\t\u0019WBA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003f\u000f\u0001\u0007a-A\u0004tc2\u001cuN\u001c4\u0011\u0005\u001dTW\"\u00015\u000b\u0005%\f\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005-D'aB*R\u0019\u000e{gN\u001a\u0005\u0006[\u001e\u0001\rA\\\u0001\u0004U>\u0014\u0007CA8u\u001b\u0005\u0001(BA9s\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002t+\u00051\u0001.\u00193p_BL!!\u001e9\u0003\u0007){'\rC\u0003 \u000f\u0001\u0007q\u000f\u0005\u00037qV*\u0014BA==\u0005\ri\u0015\r\u001d\u0005\u0006w\u001e\u0001\raW\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007")
public class TextWriteBuilder
extends FileWriteBuilder {
    private void verifySchema(StructType schema) {
        if (schema.size() != 1) {
            throw new AnalysisException(new StringBuilder(70).append("Text data source supports only a single column, and you have ").append(schema.size()).append(" columns.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    @Override
    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        TextOptions textOptions = new TextOptions(options);
        Configuration conf = job.getConfiguration();
        textOptions.compressionCodec().foreach((Function1 & Serializable & scala.Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, textOptions){
            private final TextOptions textOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new TextOutputWriter(path, dataSchema, this.textOptions$1.lineSeparatorInWrite(), context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(4).append(".txt").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.textOptions$1 = textOptions$1;
            }
        };
    }

    public TextWriteBuilder(CaseInsensitiveStringMap options, Seq<String> paths, String formatName, Function1<DataType, Object> supportsDataType) {
        super(options, paths, formatName, supportsDataType);
    }
}

