/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.MicroBatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.StreamWriterCommitProgress;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.EventTimeStats;
import org.apache.spark.sql.execution.streaming.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.ProgressReporter$;
import org.apache.spark.sql.execution.streaming.ProgressReporter$ExecutionStats$;
import org.apache.spark.sql.execution.streaming.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.streaming.SinkProgress;
import org.apache.spark.sql.streaming.SinkProgress$;
import org.apache.spark.sql.streaming.SourceProgress;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.util.Clock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rmfaB&M!\u0003\r\t!\u0017\u0005\u0006M\u0002!\ta\u001a\u0004\u0005W\u0002\u0001E\u000e\u0003\u0005t\u0005\tU\r\u0011\"\u0001u\u0011%\tIB\u0001B\tB\u0003%Q\u000f\u0003\u0006\u0002\u001c\t\u0011)\u001a!C\u0001\u0003;A!\"a\u000f\u0003\u0005#\u0005\u000b\u0011BA\u0010\u0011)\tiD\u0001BK\u0002\u0013\u0005\u0011q\b\u0005\u000b\u0003\u0013\u0012!\u0011#Q\u0001\n\u0005\u0005\u0003bBA&\u0005\u0011\u0005\u0011Q\n\u0005\n\u00033\u0012\u0011\u0011!C\u0001\u00037B\u0011\"a\u0019\u0003#\u0003%\t!!\u001a\t\u0013\u0005m$!%A\u0005\u0002\u0005u\u0004\"CAA\u0005E\u0005I\u0011AAB\u0011%\t9IAA\u0001\n\u0003\nI\tC\u0005\u0002\u001a\n\t\t\u0011\"\u0001\u0002\u001c\"I\u00111\u0015\u0002\u0002\u0002\u0013\u0005\u0011Q\u0015\u0005\n\u0003c\u0013\u0011\u0011!C!\u0003gC\u0011\"!1\u0003\u0003\u0003%\t!a1\t\u0013\u00055'!!A\u0005B\u0005=\u0007\"CAi\u0005\u0005\u0005I\u0011IAj\u0011%\t)NAA\u0001\n\u0003\n9nB\u0005\u0002\\\u0002\t\t\u0011#\u0001\u0002^\u001aA1\u000eAA\u0001\u0012\u0003\ty\u000eC\u0004\u0002L]!\t!!<\t\u0013\u0005Ew#!A\u0005F\u0005M\u0007\"CAx/\u0005\u0005I\u0011QAy\u0011%\tIpFA\u0001\n\u0003\u000bY\u0010C\u0004\u0003\u000e\u00011\tBa\u0004\t\u000f\tu\u0001A\"\u0005\u0003\u0010!9!q\u0004\u0001\u0007\u0012\t\u0005\u0002b\u0002B\u0012\u0001\u0019E!Q\u0005\u0005\b\u0005c\u0001a\u0011\u0003B\u001a\u0011\u001d\u0011I\u0005\u0001D\t\u0005\u0017BqA!\u0016\u0001\r#\u00119\u0006C\u0004\u0003\\\u00011\tB!\u0018\t\u000f\tE\u0004A\"\u0005\u0003t!9!q\u000f\u0001\u0007\u0012\te\u0004b\u0002BD\u0001\u0019E!\u0011\u0012\u0005\b\u0005'\u0003a\u0011\u0003BK\u0011\u001d\u00119\n\u0001D\t\u00053CqAa)\u0001\r#\u0011)\u000bC\u0005\u0003:\u0002\u0001\r\u0011\"\u0003\u0003\u0016\"I!1\u0018\u0001A\u0002\u0013%!Q\u0018\u0005\n\u0005\u0003\u0004\u0001\u0019!C\u0005\u0005+C\u0011Ba1\u0001\u0001\u0004%IA!2\t\u0017\t%\u0007\u00011AA\u0002\u0013%!1\u001a\u0005\f\u0005\u001f\u0004\u0001\u0019!a\u0001\n\u0013\u0011\t\u000eC\u0006\u0003V\u0002\u0001\r\u00111A\u0005\n\t-\u0007b\u0003Bl\u0001\u0001\u0007\t\u0019!C\u0005\u00053D\u0011B!8\u0001\u0001\u0004%IA!&\t\u0013\t}\u0007\u00011A\u0005\n\t\u0005\b\"\u0003Bs\u0001\t\u0007I\u0011\u0002Bt\u0011%\u0011)\u0010\u0001a\u0001\n\u0013\u00119\u0010C\u0005\u0003z\u0002\u0001\r\u0011\"\u0003\u0003|\"I!q \u0001C\u0002\u0013%1\u0011\u0001\u0005\n\u0007\u001f\u0001!\u0019!C\u0005\u0005+C\u0011b!\u0005\u0001\u0001\u0004%IA!&\t\u0013\rM\u0001\u00011A\u0005\n\rU\u0001\"CB\r\u0001\t\u0007I\u0011BB\u000e\u0011%\u0019I\u0003\u0001a\u0001\n#\u0019Y\u0003C\u0005\u0004<\u0001\u0001\r\u0011\"\u0005\u0004>!91\u0011\t\u0001\u0005\u0002\r-\u0002bBB\"\u0001\u0011\u00051Q\t\u0005\b\u0007\u001b\u0002A\u0011AB(\u0011\u0019\u0019\t\u0006\u0001C\tO\"911\u000b\u0001\u0005\u0012\rU\u0003bBB3\u0001\u0011%1q\r\u0005\b\u0007[\u0002A\u0011CB8\u0011\u001d\u0019)\b\u0001C\u0005\u0007oBqaa\u001f\u0001\t\u0013\u0019i\bC\u0004\u0004\u0002\u0002!Iaa!\t\u000f\r\u0015\u0005\u0001\"\u0005\u0004\b\"911\u0016\u0001\u0005\n\r5\u0006bBBZ\u0001\u0011E1Q\u0017\u0002\u0011!J|wM]3tgJ+\u0007o\u001c:uKJT!!\u0014(\u0002\u0013M$(/Z1nS:<'BA(Q\u0003%)\u00070Z2vi&|gN\u0003\u0002R%\u0006\u00191/\u001d7\u000b\u0005M#\u0016!B:qCJ\\'BA+W\u0003\u0019\t\u0007/Y2iK*\tq+A\u0002pe\u001e\u001c\u0001aE\u0002\u00015\u0002\u0004\"a\u00170\u000e\u0003qS\u0011!X\u0001\u0006g\u000e\fG.Y\u0005\u0003?r\u0013a!\u00118z%\u00164\u0007CA1e\u001b\u0005\u0011'BA2S\u0003!Ig\u000e^3s]\u0006d\u0017BA3c\u0005\u001daunZ4j]\u001e\fa\u0001J5oSR$C#\u00015\u0011\u0005mK\u0017B\u00016]\u0005\u0011)f.\u001b;\u0003\u001d\u0015CXmY;uS>t7\u000b^1ugN!!AW7q!\tYf.\u0003\u0002p9\n9\u0001K]8ek\u000e$\bCA.r\u0013\t\u0011HL\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0005j]B,HOU8xgV\tQ\u000f\u0005\u0004w{\u0006\u0005\u00111\u0003\b\u0003on\u0004\"\u0001\u001f/\u000e\u0003eT!A\u001f-\u0002\rq\u0012xn\u001c;?\u0013\taH,\u0001\u0004Qe\u0016$WMZ\u0005\u0003}~\u00141!T1q\u0015\taH\f\u0005\u0003\u0002\u0004\u0005=QBAA\u0003\u0015\ri\u0015q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003sK\u0006$'bAA\u0007!\u0006I1m\u001c8oK\u000e$xN]\u0005\u0005\u0003#\t)AA\bTa\u0006\u00148\u000eR1uCN#(/Z1n!\rY\u0016QC\u0005\u0004\u0003/a&\u0001\u0002'p]\u001e\f!\"\u001b8qkR\u0014vn^:!\u00039\u0019H/\u0019;f\u001fB,'/\u0019;peN,\"!a\b\u0011\r\u0005\u0005\u00121FA\u0019\u001d\u0011\t\u0019#a\n\u000f\u0007a\f)#C\u0001^\u0013\r\tI\u0003X\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti#a\f\u0003\u0007M+\u0017OC\u0002\u0002*q\u0003B!a\r\u000285\u0011\u0011Q\u0007\u0006\u0003\u001bBKA!!\u000f\u00026\t)2\u000b^1uK>\u0003XM]1u_J\u0004&o\\4sKN\u001c\u0018aD:uCR,w\n]3sCR|'o\u001d\u0011\u0002\u001d\u00154XM\u001c;US6,7\u000b^1ugV\u0011\u0011\u0011\t\t\u0007mv\f\u0019%a\u0011\u0011\u0007Y\f)%C\u0002\u0002H}\u0014aa\u0015;sS:<\u0017aD3wK:$H+[7f'R\fGo\u001d\u0011\u0002\rqJg.\u001b;?)!\ty%a\u0015\u0002V\u0005]\u0003cAA)\u00055\t\u0001\u0001C\u0003t\u0013\u0001\u0007Q\u000fC\u0004\u0002\u001c%\u0001\r!a\b\t\u000f\u0005u\u0012\u00021\u0001\u0002B\u0005!1m\u001c9z)!\ty%!\u0018\u0002`\u0005\u0005\u0004bB:\u000b!\u0003\u0005\r!\u001e\u0005\n\u00037Q\u0001\u0013!a\u0001\u0003?A\u0011\"!\u0010\u000b!\u0003\u0005\r!!\u0011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\r\u0016\u0004k\u0006%4FAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005UD,\u0001\u0006b]:|G/\u0019;j_:LA!!\u001f\u0002p\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0010\u0016\u0005\u0003?\tI'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0015%\u0006BA!\u0003S\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAF!\u0011\ti)a&\u000e\u0005\u0005=%\u0002BAI\u0003'\u000bA\u0001\\1oO*\u0011\u0011QS\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002H\u0005=\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAO!\rY\u0016qT\u0005\u0004\u0003Cc&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAT\u0003[\u00032aWAU\u0013\r\tY\u000b\u0018\u0002\u0004\u0003:L\b\"CAX!\u0005\u0005\t\u0019AAO\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0017\t\u0007\u0003o\u000bi,a*\u000e\u0005\u0005e&bAA^9\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0016\u0011\u0018\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002F\u0006-\u0007cA.\u0002H&\u0019\u0011\u0011\u001a/\u0003\u000f\t{w\u000e\\3b]\"I\u0011q\u0016\n\u0002\u0002\u0003\u0007\u0011qU\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QT\u0001\ti>\u001cFO]5oOR\u0011\u00111R\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015\u0017\u0011\u001c\u0005\n\u0003_+\u0012\u0011!a\u0001\u0003O\u000ba\"\u0012=fGV$\u0018n\u001c8Ti\u0006$8\u000fE\u0002\u0002R]\u0019BaFAqaBY\u00111]Auk\u0006}\u0011\u0011IA(\u001b\t\t)OC\u0002\u0002hr\u000bqA];oi&lW-\u0003\u0003\u0002l\u0006\u0015(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011Q\\\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003\u001f\n\u00190!>\u0002x\")1O\u0007a\u0001k\"9\u00111\u0004\u000eA\u0002\u0005}\u0001bBA\u001f5\u0001\u0007\u0011\u0011I\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tiP!\u0003\u0011\u000bm\u000byPa\u0001\n\u0007\t\u0005AL\u0001\u0004PaRLwN\u001c\t\t7\n\u0015Q/a\b\u0002B%\u0019!q\u0001/\u0003\rQ+\b\u000f\\34\u0011%\u0011YaGA\u0001\u0002\u0004\ty%A\u0002yIA\n!!\u001b3\u0016\u0005\tE\u0001\u0003\u0002B\n\u00053i!A!\u0006\u000b\t\t]\u00111S\u0001\u0005kRLG.\u0003\u0003\u0003\u001c\tU!\u0001B+V\u0013\u0012\u000bQA];o\u0013\u0012\fAA\\1nKV\u0011\u00111I\u0001\riJLwmZ3s\u00072|7m[\u000b\u0003\u0005O\u0001BA!\u000b\u0003.5\u0011!1\u0006\u0006\u0004\u0005/\u0011\u0016\u0002\u0002B\u0018\u0005W\u0011Qa\u00117pG.\f1\u0002\\8hS\u000e\fG\u000e\u00157b]V\u0011!Q\u0007\t\u0005\u0005o\u0011)%\u0004\u0002\u0003:)!!1\bB\u001f\u0003\u001dawnZ5dC2TAAa\u0010\u0003B\u0005)\u0001\u000f\\1og*\u0019!1\t)\u0002\u0011\r\fG/\u00197zgRLAAa\u0012\u0003:\tYAj\\4jG\u0006d\u0007\u000b\\1o\u00035a\u0017m\u001d;Fq\u0016\u001cW\u000f^5p]V\u0011!Q\n\t\u0005\u0005\u001f\u0012\t&D\u0001O\u0013\r\u0011\u0019F\u0014\u0002\u000f#V,'/_#yK\u000e,H/[8o\u0003\u001dqWm\u001e#bi\u0006,\"A!\u0017\u0011\rYl\u0018\u0011\u0001B\u001b\u0003I\u0019\u0018N\\6D_6l\u0017\u000e\u001e)s_\u001e\u0014Xm]:\u0016\u0005\t}\u0003#B.\u0002\u0000\n\u0005\u0004\u0003\u0002B2\u0005[j!A!\u001a\u000b\t\t\u001d$\u0011N\u0001\u0003mJR1Aa\u001bO\u0003-!\u0017\r^1t_V\u00148-Z:\n\t\t=$Q\r\u0002\u001b'R\u0014X-Y7Xe&$XM]\"p[6LG\u000f\u0015:pOJ,7o]\u0001\bg>,(oY3t+\t\u0011)\b\u0005\u0004\u0002\"\u0005-\u0012\u0011A\u0001\u0005g&t7.\u0006\u0002\u0003|A!!Q\u0010BB\u001b\t\u0011yH\u0003\u0003\u0003\u0002\u0006-\u0011aB2bi\u0006dwnZ\u0005\u0005\u0005\u000b\u0013yHA\u0003UC\ndW-A\tpM\u001a\u001cX\r^*fc6+G/\u00193bi\u0006,\"Aa#\u0011\t\t5%qR\u0007\u0002\u0019&\u0019!\u0011\u0013'\u0003#=3gm]3u'\u0016\fX*\u001a;bI\u0006$\u0018-\u0001\bdkJ\u0014XM\u001c;CCR\u001c\u0007.\u00133\u0016\u0005\u0005M\u0011\u0001D:qCJ\\7+Z:tS>tWC\u0001BN!\u0011\u0011iJa(\u000e\u0003AK1A!)Q\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003%\u0001xn\u001d;Fm\u0016tG\u000fF\u0002i\u0005OCqA!+*\u0001\u0004\u0011Y+A\u0003fm\u0016tG\u000f\u0005\u0003\u0003.\nMf\u0002BA\u001a\u0005_KAA!-\u00026\u000512\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'/\u0003\u0003\u00036\n]&!B#wK:$(\u0002\u0002BY\u0003k\tAdY;se\u0016tG\u000f\u0016:jO\u001e,'o\u0015;beR$\u0016.\\3ti\u0006l\u0007/\u0001\u0011dkJ\u0014XM\u001c;Ue&<w-\u001a:Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9`I\u0015\fHc\u00015\u0003@\"I\u0011qV\u0016\u0002\u0002\u0003\u0007\u00111C\u0001\u001bGV\u0014(/\u001a8u)JLwmZ3s\u000b:$G+[7fgR\fW\u000e]\u0001\u001fGV\u0014(/\u001a8u)JLwmZ3s\u000b:$G+[7fgR\fW\u000e]0%KF$2\u0001\u001bBd\u0011%\ty+LA\u0001\u0002\u0004\t\u0019\"\u0001\u000edkJ\u0014XM\u001c;Ue&<w-\u001a:Ti\u0006\u0014Ho\u00144gg\u0016$8/\u0006\u0002\u0003NB1a/`A\u0001\u0003\u0007\nadY;se\u0016tG\u000f\u0016:jO\u001e,'o\u0015;beR|eMZ:fiN|F%Z9\u0015\u0007!\u0014\u0019\u000eC\u0005\u00020>\n\t\u00111\u0001\u0003N\u0006A2-\u001e:sK:$HK]5hO\u0016\u0014XI\u001c3PM\u001a\u001cX\r^:\u00029\r,(O]3oiR\u0013\u0018nZ4fe\u0016sGm\u00144gg\u0016$8o\u0018\u0013fcR\u0019\u0001Na7\t\u0013\u0005=\u0016'!AA\u0002\t5\u0017!\u00077bgR$&/[4hKJ\u001cF/\u0019:u)&lWm\u001d;b[B\fQ\u0004\\1tiR\u0013\u0018nZ4feN#\u0018M\u001d;US6,7\u000f^1na~#S-\u001d\u000b\u0004Q\n\r\b\"CAXg\u0005\u0005\t\u0019AA\n\u0003I\u0019WO\u001d:f]R$UO]1uS>t7/T:\u0016\u0005\t%\b\u0003\u0003Bv\u0005c\f\u0019%a\u0005\u000e\u0005\t5(\u0002\u0002Bx\u0003s\u000bq!\\;uC\ndW-\u0003\u0003\u0003t\n5(a\u0002%bg\"l\u0015\r]\u0001\u0014[\u0016$(/[2XCJt\u0017N\\4M_\u001e<W\rZ\u000b\u0003\u0003\u000b\fq#\\3ue&\u001cw+\u0019:oS:<Gj\\4hK\u0012|F%Z9\u0015\u0007!\u0014i\u0010C\u0005\u00020Z\n\t\u00111\u0001\u0002F\u0006q\u0001O]8he\u0016\u001c8OQ;gM\u0016\u0014XCAB\u0002!\u0019\u0011Yo!\u0002\u0004\n%!1q\u0001Bw\u0005\u0015\tV/Z;f!\u0011\t\u0019da\u0003\n\t\r5\u0011Q\u0007\u0002\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z!J|wM]3tg\u0006Ybn\u001c#bi\u0006\u0004&o\\4sKN\u001cXI^3oi&sG/\u001a:wC2\f1\u0004\\1ti:{G)\u0019;b!J|wM]3tg\u00163XM\u001c;US6,\u0017a\b7bgRtu\u000eR1uCB\u0013xn\u001a:fgN,e/\u001a8u)&lWm\u0018\u0013fcR\u0019\u0001na\u0006\t\u0013\u0005=&(!AA\u0002\u0005M\u0011a\u0004;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;\u0016\u0005\ru\u0001\u0003BB\u0010\u0007Ki!a!\t\u000b\t\r\r\u00121S\u0001\u0005i\u0016DH/\u0003\u0003\u0004(\r\u0005\"\u0001E*j[BdW\rR1uK\u001a{'/\\1u\u00035\u0019WO\u001d:f]R\u001cF/\u0019;vgV\u00111Q\u0006\t\u0005\u0003g\u0019y#\u0003\u0003\u00042\u0005U\"\u0001F*ue\u0016\fW.\u001b8h#V,'/_*uCR,8\u000fK\u0002=\u0007k\u00012aWB\u001c\u0013\r\u0019I\u0004\u0018\u0002\tm>d\u0017\r^5mK\u0006\t2-\u001e:sK:$8\u000b^1ukN|F%Z9\u0015\u0007!\u001cy\u0004C\u0005\u00020v\n\t\u00111\u0001\u0004.\u000511\u000f^1ukN\faB]3dK:$\bK]8he\u0016\u001c8/\u0006\u0002\u0004HA)1l!\u0013\u0004\n%\u001911\n/\u0003\u000b\u0005\u0013(/Y=\u0002\u00191\f7\u000f\u001e)s_\u001e\u0014Xm]:\u0016\u0005\r%\u0011\u0001D:uCJ$HK]5hO\u0016\u0014\u0018\u0001\u0006:fG>\u0014H\r\u0016:jO\u001e,'o\u00144gg\u0016$8\u000fF\u0003i\u0007/\u001a\t\u0007C\u0004\u0004Z\t\u0003\raa\u0017\u0002\t\u0019\u0014x.\u001c\t\u0005\u0005\u001b\u001bi&C\u0002\u0004`1\u0013ab\u0015;sK\u0006l\u0007K]8he\u0016\u001c8\u000fC\u0004\u0004d\t\u0003\raa\u0017\u0002\u0005Q|\u0017AD;qI\u0006$X\r\u0015:pOJ,7o\u001d\u000b\u0004Q\u000e%\u0004bBB6\u0007\u0002\u00071\u0011B\u0001\f]\u0016<\bK]8he\u0016\u001c8/A\u0007gS:L7\u000f\u001b+sS\u001e<WM\u001d\u000b\u0004Q\u000eE\u0004bBB:\t\u0002\u0007\u0011QY\u0001\u000bQ\u0006\u001ch*Z<ECR\f\u0017aG3yiJ\f7\r^*uCR,w\n]3sCR|'/T3ue&\u001c7\u000f\u0006\u0003\u0002 \re\u0004bBB:\u000b\u0002\u0007\u0011QY\u0001\u0016Kb$(/Y2u\u000bb,7-\u001e;j_:\u001cF/\u0019;t)\u0011\tyea \t\u000f\rMd\t1\u0001\u0002F\u0006YR\r\u001f;sC\u000e$8k\\;sG\u0016$vNT;n\u0013:\u0004X\u000f\u001e*poN$\u0012!^\u0001\u0010e\u0016\u0004xN\u001d;US6,G+Y6f]V!1\u0011RBI)\u0011\u0019Yia*\u0015\t\r55Q\u0014\t\u0005\u0007\u001f\u001b\t\n\u0004\u0001\u0005\u000f\rM\u0005J1\u0001\u0004\u0016\n\tA+\u0005\u0003\u0004\u0018\u0006\u001d\u0006cA.\u0004\u001a&\u001911\u0014/\u0003\u000f9{G\u000f[5oO\"A1q\u0014%\u0005\u0002\u0004\u0019\t+\u0001\u0003c_\u0012L\b#B.\u0004$\u000e5\u0015bABS9\nAAHY=oC6,g\bC\u0004\u0004*\"\u0003\r!a\u0011\u0002!Q\u0014\u0018nZ4fe\u0012+G/Y5m\u0017\u0016L\u0018a\u00044pe6\fG\u000fV5nKN$\u0018-\u001c9\u0015\t\u0005\r3q\u0016\u0005\b\u0007cK\u0005\u0019AA\n\u0003\u0019i\u0017\u000e\u001c7jg\u0006\u0019R\u000f\u001d3bi\u0016\u001cF/\u0019;vg6+7o]1hKR\u0019\u0001na.\t\u000f\re&\n1\u0001\u0002D\u00059Q.Z:tC\u001e,\u0007")
public interface ProgressReporter
extends Logging {
    public ProgressReporter$ExecutionStats$ ExecutionStats();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq(scala.collection.mutable.HashMap<String, Object> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq(Queue<StreamingQueryProgress> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq(long var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(SimpleDateFormat var1);

    public UUID id();

    public UUID runId();

    public String name();

    public Clock triggerClock();

    public LogicalPlan logicalPlan();

    public QueryExecution lastExecution();

    public scala.collection.immutable.Map<SparkDataStream, LogicalPlan> newData();

    public Option<StreamWriterCommitProgress> sinkCommitProgress();

    public Seq<SparkDataStream> sources();

    public Table sink();

    public OffsetSeqMetadata offsetSeqMetadata();

    public long currentBatchId();

    public SparkSession sparkSession();

    public void postEvent(StreamingQueryListener.Event var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(long var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(long var1);

    public scala.collection.immutable.Map<SparkDataStream, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(scala.collection.immutable.Map<SparkDataStream, String> var1);

    public scala.collection.immutable.Map<SparkDataStream, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(scala.collection.immutable.Map<SparkDataStream, String> var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(long var1);

    public scala.collection.mutable.HashMap<String, Object> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs();

    public boolean org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(boolean var1);

    public Queue<StreamingQueryProgress> org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(long var1);

    public SimpleDateFormat org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat();

    public StreamingQueryStatus currentStatus();

    public void currentStatus_$eq(StreamingQueryStatus var1);

    public static /* synthetic */ StreamingQueryStatus status$(ProgressReporter $this) {
        return $this.status();
    }

    default public StreamingQueryStatus status() {
        return this.currentStatus();
    }

    public static /* synthetic */ StreamingQueryProgress[] recentProgress$(ProgressReporter $this) {
        return $this.recentProgress();
    }

    default public StreamingQueryProgress[] recentProgress() {
        StreamingQueryProgress[] streamingQueryProgressArray;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgressArray = (StreamingQueryProgress[])this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
        }
        return streamingQueryProgressArray;
    }

    public static /* synthetic */ StreamingQueryProgress lastProgress$(ProgressReporter $this) {
        return $this.lastProgress();
    }

    default public StreamingQueryProgress lastProgress() {
        StreamingQueryProgress streamingQueryProgress;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgress = (StreamingQueryProgress)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().lastOption().orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQueryProgress;
    }

    public static /* synthetic */ void startTrigger$(ProgressReporter $this) {
        $this.startTrigger();
    }

    default public void startTrigger() {
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> "Starting Trigger Calculation");
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp());
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(this.triggerClock().getTimeMillis());
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().clear();
    }

    public static /* synthetic */ void recordTriggerOffsets$(ProgressReporter $this, StreamProgress from, StreamProgress to) {
        $this.recordTriggerOffsets(from, to);
    }

    default public void recordTriggerOffsets(StreamProgress from, StreamProgress to) {
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(from.mapValues((Function1 & Serializable & scala.Serializable)x$1 -> x$1.json()));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(to.mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.json()));
    }

    private void updateProgress(StreamingQueryProgress newProgress) {
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().$plus$eq((Object)newProgress);
            while (this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().length() >= this.sparkSession().sqlContext().conf().streamingProgressRetention()) {
                this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().dequeue();
            }
        }
        this.postEvent(new StreamingQueryListener.QueryProgressEvent(newProgress));
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Streaming query made progress: ").append(newProgress).toString());
    }

    public static /* synthetic */ void finishTrigger$(ProgressReporter $this, boolean hasNewData) {
        $this.finishTrigger(hasNewData);
    }

    default public void finishTrigger(boolean hasNewData) {
        Predef$.MODULE$.assert(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets() != null && this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets() != null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(this.triggerClock().getTimeMillis());
        ExecutionStats executionStats = this.extractExecutionStats(hasNewData);
        double processingTimeSec = (double)(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp()) / (double)DateTimeUtils$.MODULE$.MILLIS_PER_SECOND();
        double inputTimeSec = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp() >= 0L ? (double)(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp()) / (double)DateTimeUtils$.MODULE$.MILLIS_PER_SECOND() : Double.NaN;
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Execution stats: ").append(executionStats).toString());
        Seq sourceProgress = (Seq)((TraversableLike)this.sources().distinct()).map((Function1 & Serializable & scala.Serializable)source -> {
            long numRecords = BoxesRunTime.unboxToLong((Object)executionStats.inputRows().getOrElse(source, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return new SourceProgress(source.toString(), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets().get(source).orNull(Predef$.MODULE$.$conforms()), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets().get(source).orNull(Predef$.MODULE$.$conforms()), numRecords, (double)numRecords / inputTimeSec, (double)numRecords / processingTimeSec);
        }, Seq$.MODULE$.canBuildFrom());
        SinkProgress sinkProgress = SinkProgress$.MODULE$.apply(this.sink().toString(), (Option<Object>)this.sinkCommitProgress().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.numOutputRows())));
        StreamingQueryProgress newProgress = new StreamingQueryProgress(this.id(), this.runId(), this.name(), this.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp()), this.currentBatchId(), new HashMap<String, Long>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().toMap(Predef$.MODULE$.$conforms()).mapValues((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)x)))).asJava()), new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(executionStats.eventTimeStats()).asJava()), (StateOperatorProgress[])executionStats.stateOperators().toArray(ClassTag$.MODULE$.apply(StateOperatorProgress.class)), (SourceProgress[])sourceProgress.toArray(ClassTag$.MODULE$.apply(SourceProgress.class)), sinkProgress);
        if (hasNewData) {
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(Long.MIN_VALUE);
            this.updateProgress(newProgress);
        } else {
            long now = this.triggerClock().getTimeMillis();
            if (now - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval() >= this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime()) {
                this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(now);
                this.updateProgress(newProgress);
            }
        }
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$1 = false;
        String x$2 = qual$1.copy$default$1();
        boolean x$32 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$2, x$32, x$1));
    }

    private Seq<StateOperatorProgress> extractStateOperatorMetrics(boolean hasNewData) {
        if (this.lastExecution() == null) {
            return Nil$.MODULE$;
        }
        return this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null, hasNewData){
            public static final long serialVersionUID = 0L;
            private final boolean hasNewData$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StateStoreWriter) {
                    StateOperatorProgress progress = ((StateStoreWriter)((Object)A1)).getProgress();
                    object = this.hasNewData$1 ? progress : progress.copy(0L);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof StateStoreWriter;
                return bl;
            }
            {
                this.hasNewData$1 = hasNewData$1;
            }
        });
    }

    private ExecutionStats extractExecutionStats(boolean hasNewData) {
        boolean hasEventTime = this.logicalPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                EventTimeWatermark eventTimeWatermark;
                A1 A1 = x1;
                Object object = A1 instanceof EventTimeWatermark ? (eventTimeWatermark = (EventTimeWatermark)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof EventTimeWatermark;
                return bl;
            }
        }).nonEmpty();
        scala.collection.immutable.Map watermarkTimestamp = hasEventTime ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"watermark"), (Object)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(this.offsetSeqMetadata().batchWatermarkMs()))})) : Predef$.MODULE$.Map().empty();
        Seq<StateOperatorProgress> stateOperators = this.extractStateOperatorMetrics(hasNewData);
        if (!hasNewData) {
            return new ExecutionStats(this, (scala.collection.immutable.Map<SparkDataStream, Object>)Predef$.MODULE$.Map().empty(), stateOperators, (scala.collection.immutable.Map<String, String>)watermarkTimestamp);
        }
        scala.collection.immutable.Map<SparkDataStream, Object> numInputRows = this.extractSourceToNumInputRows();
        scala.collection.immutable.Map eventTimeStats = ((MapLike)this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProgressReporter $outer;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                EventTimeWatermarkExec eventTimeWatermarkExec;
                A1 A1 = x2;
                if (A1 instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)A1).eventTimeStats().value().count() > 0L) {
                    EventTimeStats stats = eventTimeWatermarkExec.eventTimeStats().value();
                    object = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max"), (Object)BoxesRunTime.boxToLong((long)stats.max())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min"), (Object)BoxesRunTime.boxToLong((long)stats.min())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avg"), (Object)BoxesRunTime.boxToLong((long)((long)stats.avg())))}))).mapValues((Function1 & Serializable & scala.Serializable)millis -> $anonfun$2.$anonfun$applyOrElse$1(this, BoxesRunTime.unboxToLong((Object)millis)));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                EventTimeWatermarkExec eventTimeWatermarkExec;
                SparkPlan sparkPlan = x2;
                boolean bl = sparkPlan instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)sparkPlan).eventTimeStats().value().count() > 0L;
                return bl;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$1($anonfun$2 $this, long millis) {
                return $this.$outer.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(millis);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.execution.streaming.ProgressReporter$$anonfun$2 java.lang.Object )}, serializedLambda);
            }
        }).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)watermarkTimestamp);
        return new ExecutionStats(this, numInputRows, stateOperators, (scala.collection.immutable.Map<String, String>)eventTimeStats);
    }

    private scala.collection.immutable.Map<SparkDataStream, Object> extractSourceToNumInputRows() {
        scala.collection.immutable.Map map;
        Seq allStreamingLeaves = this.logicalPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StreamingDataSourceV2Relation) {
                    StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                    object = BoxesRunTime.boxToBoolean((boolean)(streamingDataSourceV2Relation.stream() instanceof MicroBatchStream));
                } else {
                    object = A1 instanceof StreamingExecutionRelation ? BoxesRunTime.boxToBoolean((boolean)false) : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof StreamingDataSourceV2Relation ? true : logicalPlan2 instanceof StreamingExecutionRelation;
                return bl;
            }
        });
        boolean onlyDataSourceV2Sources = allStreamingLeaves.forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ProgressReporter.$anonfun$extractSourceToNumInputRows$4(BoxesRunTime.unboxToBoolean((Object)x$7))));
        if (onlyDataSourceV2Sources) {
            Seq sourceToInputRowsTuples = this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof MicroBatchScanExec) {
                        MicroBatchScanExec microBatchScanExec = (MicroBatchScanExec)A1;
                        long numRows = BoxesRunTime.unboxToLong((Object)microBatchScanExec.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)$anonfun$4.$anonfun$applyOrElse$2(x$8))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                        MicroBatchStream source = microBatchScanExec.stream();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x2) {
                    SparkPlan sparkPlan = x2;
                    boolean bl = sparkPlan instanceof MicroBatchScanExec;
                    return bl;
                }

                public static final /* synthetic */ long $anonfun$applyOrElse$2(SQLMetric x$8) {
                    return x$8.value();
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2$adapted(org.apache.spark.sql.execution.metric.SQLMetric ), $anonfun$applyOrElse$3()}, serializedLambda);
                }
            });
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Source -> # input rows\n\t").append(sourceToInputRowsTuples.mkString("\n\t")).toString());
            map = ProgressReporter.sumRows$1(sourceToInputRowsTuples);
        } else {
            scala.collection.immutable.Map logicalPlanLeafToSource = (scala.collection.immutable.Map)this.newData().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SparkDataStream source = (SparkDataStream)tuple2._1();
                LogicalPlan logicalPlan2 = (LogicalPlan)tuple2._2();
                Seq seq = (Seq)logicalPlan2.collectLeaves().map((Function1 & Serializable & scala.Serializable)leaf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(leaf), (Object)source), Seq$.MODULE$.canBuildFrom());
                return seq;
            }, Map$.MODULE$.canBuildFrom());
            Seq allLogicalPlanLeaves = this.lastExecution().logical().collectLeaves();
            Seq allExecPlanLeaves = this.lastExecution().executedPlan().collectLeaves();
            if (allLogicalPlanLeaves.size() == allExecPlanLeaves.size()) {
                Seq execLeafToSource = (Seq)((TraversableLike)allLogicalPlanLeaves.zip((GenIterable)allExecPlanLeaves, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    LogicalPlan lp = (LogicalPlan)tuple2._1();
                    SparkPlan ep = (SparkPlan)((Object)((Object)tuple2._2()));
                    Iterable iterable = Option$.MODULE$.option2Iterable(logicalPlanLeafToSource.get((Object)lp).map((Function1 & Serializable & scala.Serializable)source -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep), source)));
                    return iterable;
                }, Seq$.MODULE$.canBuildFrom());
                Seq sourceToInputRowsTuples = (Seq)execLeafToSource.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    SparkPlan execLeaf = (SparkPlan)((Object)((Object)tuple2._1()));
                    SparkDataStream source = (SparkDataStream)tuple2._2();
                    long numRows = BoxesRunTime.unboxToLong((Object)execLeaf.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
                    return tuple22;
                }, Seq$.MODULE$.canBuildFrom());
                map = ProgressReporter.sumRows$1(sourceToInputRowsTuples);
            } else {
                if (!this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged()) {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(154).append("Could not report metrics as number leaves in trigger logical plan did not match that").append(" of the execution plan:\n").append("logical plan leaves: ").append(ProgressReporter.toString$1(allLogicalPlanLeaves)).append("\n").append("execution plan leaves: ").append(ProgressReporter.toString$1(allExecPlanLeaves)).append("\n").toString());
                    this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(true);
                }
                map = Predef$.MODULE$.Map().empty();
            }
        }
        return map;
    }

    public static /* synthetic */ Object reportTimeTaken$(ProgressReporter $this, String triggerDetailKey, Function0 body) {
        return $this.reportTimeTaken(triggerDetailKey, body);
    }

    default public <T> T reportTimeTaken(String triggerDetailKey, Function0<T> body) {
        long startTime = this.triggerClock().getTimeMillis();
        Object result = body.apply();
        long endTime = this.triggerClock().getTimeMillis();
        long timeTaken = package$.MODULE$.max(endTime - startTime, 0L);
        long previousTime = BoxesRunTime.unboxToLong((Object)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().getOrElse((Object)triggerDetailKey, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().put((Object)triggerDetailKey, (Object)BoxesRunTime.boxToLong((long)(previousTime + timeTaken)));
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append(triggerDetailKey).append(" took ").append(timeTaken).append(" ms").toString());
        return (T)result;
    }

    public static /* synthetic */ String org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp$(ProgressReporter $this, long millis) {
        return $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(millis);
    }

    default public String org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(long millis) {
        return this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().format(new Date(millis));
    }

    public static /* synthetic */ void updateStatusMessage$(ProgressReporter $this, String message) {
        $this.updateStatusMessage(message);
    }

    default public void updateStatusMessage(String message) {
        StreamingQueryStatus qual$1 = this.currentStatus();
        String x$1 = message;
        boolean x$2 = qual$1.copy$default$2();
        boolean x$3 = qual$1.copy$default$3();
        this.currentStatus_$eq(qual$1.copy(x$1, x$2, x$3));
    }

    public static /* synthetic */ long $anonfun$extractSourceToNumInputRows$2(Seq x$5) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)x$5.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private static scala.collection.immutable.Map sumRows$1(Seq tuples) {
        return tuples.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> (SparkDataStream)x$4._1()).mapValues((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)ProgressReporter.$anonfun$extractSourceToNumInputRows$2(x$5)));
    }

    public static /* synthetic */ boolean $anonfun$extractSourceToNumInputRows$4(boolean x$7) {
        return x$7;
    }

    private static String toString$1(Seq seq) {
        return new StringBuilder(11).append("(size = ").append(seq.size()).append("), ").append(seq.mkString(", ")).toString();
    }

    public static void $init$(ProgressReporter $this) {
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq((scala.collection.mutable.HashMap<String, Object>)new scala.collection.mutable.HashMap());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(false);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq((Queue<StreamingQueryProgress>)new Queue());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq($this.sparkSession().sessionState().conf().streamingNoDataProgressEventInterval());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(Long.MIN_VALUE);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().setTimeZone(DateTimeUtils$.MODULE$.getTimeZone("UTC"));
        $this.currentStatus_$eq(new StreamingQueryStatus("Initializing StreamExecution", false, false));
    }

    public class ExecutionStats
    implements Product,
    scala.Serializable {
        private final scala.collection.immutable.Map<SparkDataStream, Object> inputRows;
        private final Seq<StateOperatorProgress> stateOperators;
        private final scala.collection.immutable.Map<String, String> eventTimeStats;
        public final /* synthetic */ ProgressReporter $outer;

        public scala.collection.immutable.Map<SparkDataStream, Object> inputRows() {
            return this.inputRows;
        }

        public Seq<StateOperatorProgress> stateOperators() {
            return this.stateOperators;
        }

        public scala.collection.immutable.Map<String, String> eventTimeStats() {
            return this.eventTimeStats;
        }

        public ExecutionStats copy(scala.collection.immutable.Map<SparkDataStream, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            return new ExecutionStats(this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer(), inputRows, stateOperators, eventTimeStats);
        }

        public scala.collection.immutable.Map<SparkDataStream, Object> copy$default$1() {
            return this.inputRows();
        }

        public Seq<StateOperatorProgress> copy$default$2() {
            return this.stateOperators();
        }

        public scala.collection.immutable.Map<String, String> copy$default$3() {
            return this.eventTimeStats();
        }

        public String productPrefix() {
            return "ExecutionStats";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.inputRows();
                    break;
                }
                case 1: {
                    object = this.stateOperators();
                    break;
                }
                case 2: {
                    object = this.eventTimeStats();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExecutionStats;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExecutionStats)) return false;
            if (((ExecutionStats)object).org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() != this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ExecutionStats executionStats = (ExecutionStats)x$1;
            scala.collection.immutable.Map<SparkDataStream, Object> map = this.inputRows();
            scala.collection.immutable.Map<SparkDataStream, Object> map2 = executionStats.inputRows();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Seq<StateOperatorProgress> seq = this.stateOperators();
            Seq<StateOperatorProgress> seq2 = executionStats.stateOperators();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            scala.collection.immutable.Map<String, String> map3 = this.eventTimeStats();
            scala.collection.immutable.Map<String, String> map4 = executionStats.eventTimeStats();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            if (!executionStats.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ProgressReporter org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() {
            return this.$outer;
        }

        public ExecutionStats(ProgressReporter $outer, scala.collection.immutable.Map<SparkDataStream, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            this.inputRows = inputRows;
            this.stateOperators = stateOperators;
            this.eventTimeStats = eventTimeStats;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

