/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import org.apache.spark.SparkException;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterCommitMessage$;
import scala.Function1;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\b\u0011\u0001}A\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001dq\u0006A1A\u0005\n}Caa\u0019\u0001!\u0002\u0013\u0001\u0007b\u00023\u0001\u0001\u0004%Ia\u0018\u0005\bK\u0002\u0001\r\u0011\"\u0003g\u0011\u0019a\u0007\u0001)Q\u0005A\")A\u0006\u0001C![\")\u0001\u000f\u0001C!c\")Q\u000f\u0001C!m\")q\u000f\u0001C\u0005q\n\tbi\u001c:fC\u000eDG)\u0019;b/JLG/\u001a:\u000b\u0005E\u0011\u0012aB:pkJ\u001cWm\u001d\u0006\u0003'Q\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005U1\u0012!C3yK\u000e,H/[8o\u0015\t9\u0002$A\u0002tc2T!!\u0007\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005ma\u0012AB1qC\u000eDWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001+\t\u0001chE\u0002\u0001C%\u0002\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\t1\fgn\u001a\u0006\u0002M\u0005!!.\u0019<b\u0013\tA3E\u0001\u0004PE*,7\r\u001e\t\u0004U=\nT\"A\u0016\u000b\u00051j\u0013!B<sSR,'B\u0001\u0018\u0017\u0003%\u0019wN\u001c8fGR|'/\u0003\u00021W\tQA)\u0019;b/JLG/\u001a:\u0011\u0005I*T\"A\u001a\u000b\u0005Q2\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005Y\u001a$aC%oi\u0016\u0014h.\u00197S_^\faa\u001e:ji\u0016\u0014\bcA\u001d;y5\ta#\u0003\u0002<-\tiai\u001c:fC\u000eDwK]5uKJ\u0004\"!\u0010 \r\u0001\u0011)q\b\u0001b\u0001\u0001\n\tA+\u0005\u0002B\u000fB\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n9aj\u001c;iS:<\u0007C\u0001\"I\u0013\tI5IA\u0002B]f\fAB]8x\u0007>tg/\u001a:uKJ\u0004BA\u0011'2y%\u0011Qj\u0011\u0002\n\rVt7\r^5p]F\n1\u0002]1si&$\u0018n\u001c8JIB\u0011!\tU\u0005\u0003#\u000e\u00131!\u00138u\u0003\u001d)\u0007o\\2i\u0013\u0012\u0004\"A\u0011+\n\u0005U\u001b%\u0001\u0002'p]\u001e\fa\u0001P5oSRtD#\u0002-[7rk\u0006cA-\u0001y5\t\u0001\u0003C\u00038\u000b\u0001\u0007\u0001\bC\u0003K\u000b\u0001\u00071\nC\u0003O\u000b\u0001\u0007q\nC\u0003S\u000b\u0001\u00071+\u0001\u0004pa\u0016tW\rZ\u000b\u0002AB\u0011!)Y\u0005\u0003E\u000e\u0013qAQ8pY\u0016\fg.A\u0004pa\u0016tW\r\u001a\u0011\u0002\u0017\rdwn]3DC2dW\rZ\u0001\u0010G2|7/Z\"bY2,Gm\u0018\u0013fcR\u0011qM\u001b\t\u0003\u0005\"L!![\"\u0003\tUs\u0017\u000e\u001e\u0005\bW&\t\t\u00111\u0001a\u0003\rAH%M\u0001\rG2|7/Z\"bY2,G\r\t\u000b\u0003O:DQa\\\u0006A\u0002E\naA]3d_J$\u0017AB2p[6LG\u000fF\u0001s!\tQ3/\u0003\u0002uW\t\u0019rK]5uKJ\u001cu.\\7ji6+7o]1hK\u0006)\u0011MY8siR\tq-A\u0006dY>\u001cXm\u0016:ji\u0016\u0014HCA4z\u0011\u0015Qh\u00021\u0001|\u0003-)'O]8s\u001fJtU\u000f\u001c7\u0011\u0007q\fIAD\u0002~\u0003\u000bq1A`A\u0002\u001b\u0005y(bAA\u0001=\u00051AH]8pizJ\u0011\u0001R\u0005\u0004\u0003\u000f\u0019\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\tiAA\u0005UQJ|w/\u00192mK*\u0019\u0011qA\"")
public class ForeachDataWriter<T>
implements DataWriter<InternalRow> {
    private final ForeachWriter<T> writer;
    private final Function1<InternalRow, T> rowConverter;
    private final boolean opened;
    private boolean closeCalled;

    private boolean opened() {
        return this.opened;
    }

    private boolean closeCalled() {
        return this.closeCalled;
    }

    private void closeCalled_$eq(boolean x$1) {
        this.closeCalled = x$1;
    }

    public void write(InternalRow record) {
        if (!this.opened()) {
            return;
        }
        try {
            this.writer.process(this.rowConverter.apply((Object)record));
        }
        catch (Throwable t) {
            this.closeWriter(t);
            throw t;
        }
    }

    public WriterCommitMessage commit() {
        this.closeWriter(null);
        return ForeachWriterCommitMessage$.MODULE$;
    }

    public void abort() {
        this.closeWriter(new SparkException("Foreach writer has been aborted due to a task failure"));
    }

    private void closeWriter(Throwable errorOrNull) {
        block0: {
            if (this.closeCalled()) break block0;
            this.closeCalled_$eq(true);
            this.writer.close(errorOrNull);
        }
    }

    public ForeachDataWriter(ForeachWriter<T> writer, Function1<InternalRow, T> rowConverter, int partitionId, long epochId) {
        this.writer = writer;
        this.rowConverter = rowConverter;
        this.opened = writer.open(partitionId, epochId);
        this.closeCalled = false;
    }
}

