/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.PartitionStatistics;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenMap$;
import scala.collection.GenSeq;
import scala.collection.GenSeq$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.immutable.ParVector;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tEe\u0001B\u0012%\u0001FB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0017\"A\u0001\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003S\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u001d\u0019\u0007A1A\u0005\u0002\u0011Da\u0001\u001c\u0001!\u0002\u0013)\u0007bB7\u0001\u0005\u0004%\t\u0001\u001a\u0005\u0007]\u0002\u0001\u000b\u0011B3\t\u000f=\u0004!\u0019!C\u0001I\"1\u0001\u000f\u0001Q\u0001\n\u0015DQ!\u001d\u0001\u0005\nIDq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002.\u0001!I!a\f\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\"9\u0011q\u001c\u0001\u0005\n\u0005\u0005\b\"CA\u007f\u0001\u0005\u0005I\u0011AA\u0000\u0011%\u0011)\u0001AI\u0001\n\u0003\u00119\u0001C\u0005\u0003\u001e\u0001\t\n\u0011\"\u0001\u0003 !A!1\u0005\u0001\u0002\u0002\u0013\u0005C\rC\u0005\u0003&\u0001\t\t\u0011\"\u0001\u0003(!I!\u0011\u0006\u0001\u0002\u0002\u0013\u0005!1\u0006\u0005\n\u0005o\u0001\u0011\u0011!C!\u0005sA\u0011B!\u0011\u0001\u0003\u0003%\tAa\u0011\t\u0013\t5\u0003!!A\u0005B\t=s!\u0003B*I\u0005\u0005\t\u0012\u0001B+\r!\u0019C%!A\t\u0002\t]\u0003B\u00020\u001c\t\u0003\u0011)\u0007C\u0005\u0003hm\t\t\u0011\"\u0012\u0003j!I!1N\u000e\u0002\u0002\u0013\u0005%Q\u000e\u0005\n\u0005gZ\u0012\u0013!C\u0001\u0005?A\u0011B!\u001e\u001c\u0003\u0003%\tIa\u001e\t\u0013\t\u00155$%A\u0005\u0002\t}\u0001\"\u0003BD7\u0005\u0005I\u0011\u0002BE\u0005\t\nE\u000e^3s)\u0006\u0014G.\u001a*fG>4XM\u001d)beRLG/[8og\u000e{W.\\1oI*\u0011QEJ\u0001\bG>lW.\u00198e\u0015\t9\u0003&A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0011FK\u0001\u0004gFd'BA\u0016-\u0003\u0015\u0019\b/\u0019:l\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001M)\u0001A\r\u001fA\rB\u00111GO\u0007\u0002i)\u0011QGN\u0001\bY><\u0017nY1m\u0015\t9\u0004(A\u0003qY\u0006t7O\u0003\u0002:Q\u0005A1-\u0019;bYf\u001cH/\u0003\u0002<i\tYAj\\4jG\u0006d\u0007\u000b\\1o!\tid(D\u0001%\u0013\tyDEA\bSk:t\u0017M\u00197f\u0007>lW.\u00198e!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u001d\u0001&o\u001c3vGR\u0004\"!Q$\n\u0005!\u0013%\u0001D*fe&\fG.\u001b>bE2,\u0017!\u0003;bE2,g*Y7f+\u0005Y\u0005C\u0001'N\u001b\u0005A\u0014B\u0001(9\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018A\u0003;bE2,g*Y7fA\u0005\u00191-\u001c3\u0016\u0003I\u0003\"a\u0015.\u000f\u0005QC\u0006CA+C\u001b\u00051&BA,1\u0003\u0019a$o\\8u}%\u0011\u0011LQ\u0001\u0007!J,G-\u001a4\n\u0005mc&AB*ue&twM\u0003\u0002Z\u0005\u0006!1-\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001-\u00192\u0011\u0005u\u0002\u0001\"B%\u0006\u0001\u0004Y\u0005b\u0002)\u0006!\u0003\u0005\rAU\u0001\n\u001dVkuLR%M\u000bN+\u0012!\u001a\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\fA\u0001\\1oO*\t!.\u0001\u0003kCZ\f\u0017BA.h\u0003)qU+T0G\u00132+5\u000bI\u0001\u000b)>#\u0016\tT0T\u0013j+\u0015a\u0003+P)\u0006culU%[\u000b\u0002\n\u0001\u0002\u0012#M?RKU*R\u0001\n\t\u0012cu\fV%N\u000b\u0002\nQbZ3u!\u0006$\bNR5mi\u0016\u0014HCA:|!\t!\u00180D\u0001v\u0015\t1x/\u0001\u0002gg*\u0011\u0001\u0010L\u0001\u0007Q\u0006$wn\u001c9\n\u0005i,(A\u0003)bi\"4\u0015\u000e\u001c;fe\")A\u0010\u0004a\u0001{\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\ta^\u0001\u0005G>tg-C\u0002\u0002\u0006}\u0014QbQ8oM&<WO]1uS>t\u0017a\u0001:v]R!\u00111BA\u0013!\u0019\ti!a\u0006\u0002\u001e9!\u0011qBA\n\u001d\r)\u0016\u0011C\u0005\u0002\u0007&\u0019\u0011Q\u0003\"\u0002\u000fA\f7m[1hK&!\u0011\u0011DA\u000e\u0005\r\u0019V-\u001d\u0006\u0004\u0003+\u0011\u0005\u0003BA\u0010\u0003Ci\u0011\u0001K\u0005\u0004\u0003GA#a\u0001*po\"11&\u0004a\u0001\u0003O\u0001B!a\b\u0002*%\u0019\u00111\u0006\u0015\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u001dM\u001c\u0017M\u001c)beRLG/[8ogR!\u0012\u0011GA:\u0003k\ni(!!\u0002\u0006\u0006%\u0015qRAM\u0003c\u0003b!a\r\u0002:\u0005uRBAA\u001b\u0015\r\t9DQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001e\u0003k\u0011aaR3o'\u0016\f\bcB!\u0002@\u0005\r\u0013QN\u0005\u0004\u0003\u0003\u0012%A\u0002+va2,'\u0007\u0005\u0003\u0002F\u0005\u001dd\u0002BA$\u0003CrA!!\u0013\u0002^9!\u00111JA.\u001d\u0011\ti%!\u0017\u000f\t\u0005=\u0013q\u000b\b\u0005\u0003#\n)FD\u0002V\u0003'J\u0011aL\u0005\u0003[9J!a\u000b\u0017\n\u0005%R\u0013BA\u001d)\u0013\r\ty\u0006O\u0001\bG\u0006$\u0018\r\\8h\u0013\u0011\t\u0019'!\u001a\u0002\u0019\r\u000bG/\u00197pORK\b/Z:\u000b\u0007\u0005}\u0003(\u0003\u0003\u0002j\u0005-$A\u0005+bE2,\u0007+\u0019:uSRLwN\\*qK\u000eTA!a\u0019\u0002fA\u0019A/a\u001c\n\u0007\u0005ETO\u0001\u0003QCRD\u0007BB\u0016\u000f\u0001\u0004\t9\u0003\u0003\u0004w\u001d\u0001\u0007\u0011q\u000f\t\u0004i\u0006e\u0014bAA>k\nQa)\u001b7f'f\u001cH/Z7\t\r\u0005}d\u00021\u0001t\u0003\u00191\u0017\u000e\u001c;fe\"9\u00111\u0011\bA\u0002\u00055\u0014\u0001\u00029bi\"Dq!a\"\u000f\u0001\u0004\t\u0019%\u0001\u0003ta\u0016\u001c\u0007bBAF\u001d\u0001\u0007\u0011QR\u0001\u000fa\u0006\u0014H/\u001b;j_:t\u0015-\\3t!\u0015\ti!a\u0006S\u0011\u001d\t\tJ\u0004a\u0001\u0003'\u000b\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0011\u0007\u0005\u000b)*C\u0002\u0002\u0018\n\u00131!\u00138u\u0011\u001d\tYJ\u0004a\u0001\u0003;\u000b\u0001B]3t_24XM\u001d\t\u0005\u0003?\u000bYK\u0004\u0003\u0002\"\u0006\u001df\u0002BA%\u0003GK1!!*9\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA\u000b\u0003SS1!!*9\u0013\u0011\ti+a,\u0003\u0011I+7o\u001c7wKJTA!!\u0006\u0002*\"9\u00111\u0017\bA\u0002\u0005U\u0016aD3wC2$\u0016m]6TkB\u0004xN\u001d;\u0011\t\u0005]\u0016QX\u0007\u0003\u0003sSA!a/\u00026\u0005A\u0001/\u0019:bY2,G.\u0003\u0003\u0002@\u0006e&a\u0005$pe.Tu.\u001b8UCN\\7+\u001e9q_J$\u0018\u0001F4bi\",'\u000fU1si&$\u0018n\u001c8Ti\u0006$8\u000f\u0006\u0007\u0002F\u0006E\u00171[Al\u00033\fi\u000eE\u0004\u00024\u0005\u001d'+a3\n\t\u0005%\u0017Q\u0007\u0002\u0007\u000f\u0016tW*\u00199\u0011\u0007u\ni-C\u0002\u0002P\u0012\u00121\u0003U1si&$\u0018n\u001c8Ti\u0006$\u0018n\u001d;jGNDaaK\bA\u0002\u0005\u001d\u0002bBAk\u001f\u0001\u0007\u0011\u0011G\u0001\u0016a\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2t\u0003:$Gj\\2t\u0011\u00191x\u00021\u0001\u0002x!1\u00111\\\bA\u0002M\f!\u0002]1uQ\u001aKG\u000e^3s\u0011\u001d\t\tj\u0004a\u0001\u0003'\u000bQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cHCCAr\u0003S\fY/a>\u0002zB\u0019\u0011)!:\n\u0007\u0005\u001d(I\u0001\u0003V]&$\bBB\u0016\u0011\u0001\u0004\t9\u0003C\u0004\u0002nB\u0001\r!a<\u0002\u000bQ\f'\r\\3\u0011\t\u0005E\u00181_\u0007\u0003\u0003KJA!!>\u0002f\ta1)\u0019;bY><G+\u00192mK\"9\u0011Q\u001b\tA\u0002\u0005E\u0002bBA~!\u0001\u0007\u0011QY\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;t\u0003\u0011\u0019w\u000e]=\u0015\u000b\u0001\u0014\tAa\u0001\t\u000f%\u000b\u0002\u0013!a\u0001\u0017\"9\u0001+\u0005I\u0001\u0002\u0004\u0011\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0013Q3a\u0013B\u0006W\t\u0011i\u0001\u0005\u0003\u0003\u0010\teQB\u0001B\t\u0015\u0011\u0011\u0019B!\u0006\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\f\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tm!\u0011\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005CQ3A\u0015B\u0006\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111S\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011iCa\r\u0011\u0007\u0005\u0013y#C\u0002\u00032\t\u00131!\u00118z\u0011%\u0011)DFA\u0001\u0002\u0004\t\u0019*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005w\u0001b!a\r\u0003>\t5\u0012\u0002\u0002B \u0003k\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!Q\tB&!\r\t%qI\u0005\u0004\u0005\u0013\u0012%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005kA\u0012\u0011!a\u0001\u0005[\ta!Z9vC2\u001cH\u0003\u0002B#\u0005#B\u0011B!\u000e\u001a\u0003\u0003\u0005\rA!\f\u0002E\u0005cG/\u001a:UC\ndWMU3d_Z,'\u000fU1si&$\u0018n\u001c8t\u0007>lW.\u00198e!\ti4d\u0005\u0003\u001c\u000532\u0005c\u0002B.\u0005CZ%\u000bY\u0007\u0003\u0005;R1Aa\u0018C\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0019\u0003^\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\tU\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0015\fQ!\u00199qYf$R\u0001\u0019B8\u0005cBQ!\u0013\u0010A\u0002-Cq\u0001\u0015\u0010\u0011\u0002\u0003\u0007!+A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$BA!\u001f\u0003\u0002B)\u0011Ia\u001f\u0003\u0000%\u0019!Q\u0010\"\u0003\r=\u0003H/[8o!\u0015\t\u0015qH&S\u0011!\u0011\u0019\tIA\u0001\u0002\u0004\u0001\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1B]3bIJ+7o\u001c7wKR\u0011!1\u0012\t\u0004M\n5\u0015b\u0001BHO\n1qJ\u00196fGR\u0004")
public class AlterTableRecoverPartitionsCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final String cmd;
    private final String NUM_FILES;
    private final String TOTAL_SIZE;
    private final String DDL_TIME;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$2() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<TableIdentifier, String>> unapply(AlterTableRecoverPartitionsCommand alterTableRecoverPartitionsCommand) {
        return AlterTableRecoverPartitionsCommand$.MODULE$.unapply(alterTableRecoverPartitionsCommand);
    }

    public static String apply$default$2() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<TableIdentifier, String>, AlterTableRecoverPartitionsCommand> tupled() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, AlterTableRecoverPartitionsCommand>> curried() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableRecoverPartitionsCommand alterTableRecoverPartitionsCommand = this;
        synchronized (alterTableRecoverPartitionsCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public String cmd() {
        return this.cmd;
    }

    public String NUM_FILES() {
        return this.NUM_FILES;
    }

    public String TOTAL_SIZE() {
        return this.TOTAL_SIZE;
    }

    public String DDL_TIME() {
        return this.DDL_TIME;
    }

    private PathFilter getPathFilter(Configuration hadoopConf) {
        JobConf jobConf = new JobConf(hadoopConf, this.getClass());
        PathFilter pathFilter = FileInputFormat.getInputPathFilter((JobConf)jobConf);
        return path -> {
            String name;
            String string = name = path.getName();
            String string2 = "_SUCCESS";
            if (string == null) {
                if (string2 == null) return false;
            } else if (string.equals(string2)) return false;
            String string3 = name;
            String string4 = "_temporary";
            if (string3 == null) {
                if (string4 == null) return false;
            } else if (string3.equals(string4)) return false;
            if (name.startsWith(".")) return false;
            if (pathFilter == null) return true;
            if (!pathFilter.accept(path)) return false;
            return true;
        };
    }

    @Override
    public Seq<Row> run(SparkSession spark) {
        Seq seq;
        SessionCatalog catalog = spark.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        if (table.partitionColumnNames().isEmpty()) {
            throw new AnalysisException(new StringBuilder(58).append("Operation not allowed: ").append(this.cmd()).append(" only works on partitioned tables: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (table.storage().locationUri().isEmpty()) {
            throw new AnalysisException(new StringBuilder(68).append("Operation not allowed: ").append(this.cmd()).append(" only works on table with ").append("location provided: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Path root = new Path(table.location());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Recover all the partitions in ").append(root).toString());
        Configuration hadoopConf = spark.sessionState().newHadoopConf();
        FileSystem fs = root.getFileSystem(hadoopConf);
        int threshold = BoxesRunTime.unboxToInt((Object)spark.sparkContext().conf().get(package$.MODULE$.RDD_PARALLEL_LISTING_THRESHOLD()));
        PathFilter pathFilter = this.getPathFilter(hadoopConf);
        ForkJoinPool evalPool = ThreadUtils$.MODULE$.newForkJoinPool("AlterTableRecoverPartitionsCommand", 8);
        try {
            seq = this.scanPartitions(spark, fs, pathFilter, root, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Seq<String>)table.partitionColumnNames(), threshold, (Function2<String, String, Object>)spark.sessionState().conf().resolver(), new ForkJoinTaskSupport(evalPool)).seq();
        }
        finally {
            evalPool.shutdown();
        }
        Seq partitionSpecsAndLocs = seq;
        int total = partitionSpecsAndLocs.length();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Found ").append(total).append(" partitions in ").append(root).toString());
        GenMap<String, PartitionStatistics> partitionStats = spark.sqlContext().conf().gatherFastStats() ? this.gatherPartitionStats(spark, (GenSeq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, fs, pathFilter, threshold) : GenMap$.MODULE$.empty();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Finished to gather the fast stats for all ").append(total).append(" partitions.").toString());
        this.addPartitions(spark, table, (GenSeq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, partitionStats);
        boolean x$1 = true;
        TableIdentifier x$2 = table.copy$default$1();
        CatalogTableType x$3 = table.copy$default$2();
        CatalogStorageFormat x$4 = table.copy$default$3();
        StructType x$5 = table.copy$default$4();
        Option x$6 = table.copy$default$5();
        Seq x$7 = table.copy$default$6();
        Option x$8 = table.copy$default$7();
        String x$9 = table.copy$default$8();
        long x$10 = table.copy$default$9();
        long x$11 = table.copy$default$10();
        String x$12 = table.copy$default$11();
        Map x$13 = table.copy$default$12();
        Option x$14 = table.copy$default$13();
        Option x$15 = table.copy$default$14();
        Option x$16 = table.copy$default$15();
        Seq x$17 = table.copy$default$16();
        boolean x$18 = table.copy$default$18();
        Map x$19 = table.copy$default$19();
        Option x$20 = table.copy$default$20();
        spark.sessionState().catalog().alterTable(table.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$1, x$18, x$19, x$20));
        catalog.refreshTable(this.tableName());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Recovered all partitions (").append(total).append(").").toString());
        return (Seq)Seq$.MODULE$.empty();
    }

    private GenSeq<Tuple2<Map<String, String>, Path>> scanPartitions(SparkSession spark, FileSystem fs, PathFilter filter, Path path, Map<String, String> spec, Seq<String> partitionNames, int threshold, Function2<String, String, Object> resolver, ForkJoinTaskSupport evalTaskSupport) {
        WrappedArray wrappedArray;
        if (partitionNames.isEmpty()) {
            return (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(spec), (Object)path)}));
        }
        FileStatus[] statuses = fs.listStatus(path, filter);
        if (partitionNames.length() > 1 && statuses.length > threshold || partitionNames.length() > 2) {
            ParVector parArray = new ParVector(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).toVector());
            parArray.tasksupport_$eq((TaskSupport)evalTaskSupport);
            wrappedArray = parArray;
        } else {
            wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])statuses);
        }
        WrappedArray statusPar = wrappedArray;
        return (GenSeq)statusPar.flatMap((Function1 & Serializable & scala.Serializable)st -> {
            GenSeq<Tuple2<Map<String, String>, Path>> genSeq;
            String name = st.getPath().getName();
            if (st.isDirectory() && name.contains("=")) {
                String[] ps = name.split("=", 2);
                String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[0]);
                String value = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[1]);
                if (BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)columnName, partitionNames.head()))) {
                    genSeq = this.scanPartitions(spark, fs, filter, st.getPath(), (Map<String, String>)spec.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partitionNames.head()), (Object)value)}))), (Seq<String>)((Seq)partitionNames.drop(1)), threshold, resolver, evalTaskSupport);
                } else {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("expected partition column ").append(partitionNames.head()).append(", but got ").append(ps[0]).append(", ignoring it").toString());
                    genSeq = (GenSeq)Seq$.MODULE$.empty();
                }
            } else {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("ignore ").append(new Path(path, name)).toString());
                genSeq = (GenSeq<Tuple2<Map<String, String>, Path>>)Seq$.MODULE$.empty();
            }
            return genSeq;
        }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom());
    }

    private GenMap<String, PartitionStatistics> gatherPartitionStats(SparkSession spark, GenSeq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, FileSystem fs, PathFilter pathFilter, int threshold) {
        GenMap genMap;
        if (partitionSpecsAndLocs.length() > threshold) {
            Configuration hadoopConf = spark.sessionState().newHadoopConf();
            SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
            String[] serializedPaths = (String[])((GenTraversableOnce)partitionSpecsAndLocs.map((Function1 & Serializable & scala.Serializable)x$6 -> ((Path)x$6._2()).toString(), (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            int numParallelism = Math.min(serializedPaths.length, Math.min(spark.sparkContext().defaultParallelism(), 10000));
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Gather the fast stats in parallel using ").append(numParallelism).append(" tasks.").toString());
            RDD qual$1 = spark.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])serializedPaths), numParallelism, ClassTag$.MODULE$.apply(String.class));
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)paths -> {
                PathFilter pathFilter = this.getPathFilter(serializableConfiguration.value());
                return paths.map((Function1 & Serializable & scala.Serializable)x$7 -> new Path(x$7)).map((Function1 & Serializable & scala.Serializable)path -> {
                    FileSystem fs = path.getFileSystem(serializableConfiguration.value());
                    FileStatus[] statuses = fs.listStatus(path, pathFilter);
                    return new Tuple2((Object)path.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.getLen()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                });
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            genMap = RDD$.MODULE$.rddToPairRDDFunctions(qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PartitionStatistics.class), (Ordering)Ordering.String$.MODULE$).collectAsMap();
        } else {
            genMap = ((GenTraversableOnce)partitionSpecsAndLocs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Path location = (Path)tuple2._2();
                FileStatus[] statuses = fs.listStatus(location, pathFilter);
                Tuple2 tuple22 = new Tuple2((Object)location.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.getLen()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                return tuple22;
            }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        return genMap;
    }

    private void addPartitions(SparkSession spark, CatalogTable table, GenSeq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, GenMap<String, PartitionStatistics> partitionStats) {
        int total = partitionSpecsAndLocs.length();
        LongRef done = LongRef.create((long)0L);
        int batchSize = 100;
        partitionSpecsAndLocs.toIterator().grouped(batchSize).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            AlterTableRecoverPartitionsCommand.$anonfun$addPartitions$1(this, partitionStats, table, spark, done, total, batch);
            return BoxedUnit.UNIT;
        });
    }

    public AlterTableRecoverPartitionsCommand copy(TableIdentifier tableName, String cmd) {
        return new AlterTableRecoverPartitionsCommand(tableName, cmd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public String copy$default$2() {
        return this.cmd();
    }

    public String productPrefix() {
        return "AlterTableRecoverPartitionsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = this.cmd();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableRecoverPartitionsCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableRecoverPartitionsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableRecoverPartitionsCommand alterTableRecoverPartitionsCommand = (AlterTableRecoverPartitionsCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableRecoverPartitionsCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.cmd();
        String string2 = alterTableRecoverPartitionsCommand.cmd();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!alterTableRecoverPartitionsCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(AlterTableRecoverPartitionsCommand $this, GenMap partitionStats$1, CatalogTable table$6, SparkSession spark$2, LongRef done$1, int total$2, Seq batch) {
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        Seq parts = (Seq)batch.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map spec = (Map)tuple2._1();
            Path location = (Path)tuple2._2();
            Map params = (Map)partitionStats$1.get((Object)location.toString()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                PartitionStatistics partitionStatistics = x0$2;
                if (partitionStatistics == null) {
                    throw new MatchError((Object)partitionStatistics);
                }
                int numFiles = partitionStatistics.numFiles();
                long totalSize = partitionStatistics.totalSize();
                Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.NUM_FILES()), (Object)((Object)BoxesRunTime.boxToInteger((int)numFiles)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.TOTAL_SIZE()), (Object)((Object)BoxesRunTime.boxToLong((long)totalSize)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.DDL_TIME()), (Object)((Object)BoxesRunTime.boxToLong((long)now)).toString())}));
                return map;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            CatalogTablePartition catalogTablePartition = new CatalogTablePartition(spec, table$6.storage().copy((Option)new Some((Object)location.toUri()), table$6.storage().copy$default$2(), table$6.storage().copy$default$3(), table$6.storage().copy$default$4(), table$6.storage().copy$default$5(), table$6.storage().copy$default$6()), params, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            return catalogTablePartition;
        }, Seq$.MODULE$.canBuildFrom());
        spark$2.sessionState().catalog().createPartitions($this.tableName(), parts, true);
        done$1.elem += (long)parts.length();
        $this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Recovered ").append(parts.length()).append(" partitions (").append(done$1.elem).append("/").append(total$2).append(" so far)").toString());
    }

    public AlterTableRecoverPartitionsCommand(TableIdentifier tableName, String cmd) {
        this.tableName = tableName;
        this.cmd = cmd;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        this.NUM_FILES = "numFiles";
        this.TOTAL_SIZE = "totalSize";
        this.DDL_TIME = "transient_lastDdlTime";
    }
}

