/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SortExec$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataWriter;
import org.apache.spark.sql.execution.datasources.EmptyDirectoryDataWriter;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatDataWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.SingleDirectoryDataWriter;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.WriteTaskResult;
import org.apache.spark.sql.execution.datasources.WriteTaskStats;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class FileFormatWriter$
implements Logging {
    public static FileFormatWriter$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new FileFormatWriter$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Set<String> write(SparkSession sparkSession, SparkPlan plan, FileFormat fileFormat, FileCommitProtocol committer, FileFormatWriter.OutputSpec outputSpec, Configuration hadoopConf, Seq<Attribute> partitionColumns, Option<BucketSpec> bucketSpec, Seq<WriteJobStatsTracker> statsTrackers, Map<String, String> options) {
        Set set;
        Job job = Job.getInstance((Configuration)hadoopConf);
        job.setOutputKeyClass(Void.class);
        job.setOutputValueClass(InternalRow.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputSpec.outputPath()));
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply(partitionColumns);
        Seq dataColumns = (Seq)outputSpec.outputColumns().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionSet.contains(elem)));
        BooleanRef needConvert = BooleanRef.create((boolean)false);
        Seq projectList = (Seq)plan.output().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Attribute attribute = x0$1;
            if (!partitionSet.contains((NamedExpression)attribute)) return attribute;
            DataType dataType = attribute.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if (dataType == null) {
                if (stringType$ != null) {
                    return attribute;
                }
            } else if (!dataType.equals(stringType$)) return attribute;
            if (!attribute.nullable()) return attribute;
            needConvert$1.elem = true;
            FileFormatWriter.Empty2Null x$1 = new FileFormatWriter.Empty2Null((Expression)attribute);
            String x$2 = attribute.name();
            ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
            return new Alias((Expression)x$1, x$2, x$3, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        SparkPlan empty2NullPlan = needConvert.elem ? new ProjectExec((Seq<NamedExpression>)projectList, plan) : plan;
        Option bucketIdExpression = bucketSpec.map((Function1 & Serializable & scala.Serializable)spec -> {
            Seq bucketColumns = (Seq)spec.bucketColumnNames().map((Function1 & Serializable & scala.Serializable)c -> (Attribute)dataColumns.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileFormatWriter$.$anonfun$write$5(c, x$1))).get(), Seq$.MODULE$.canBuildFrom());
            return new HashPartitioning(bucketColumns, spec.numBuckets()).partitionIdExpression();
        });
        Seq sortColumns = (Seq)Option$.MODULE$.option2Iterable(bucketSpec).toSeq().flatMap((Function1 & Serializable & scala.Serializable)spec -> (Seq)spec.sortColumnNames().map((Function1 & Serializable & scala.Serializable)c -> (Attribute)dataColumns.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileFormatWriter$.$anonfun$write$8(c, x$2))).get(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        CaseInsensitiveMap caseInsensitiveOptions = CaseInsensitiveMap$.MODULE$.apply(options);
        StructType dataSchema = package$.MODULE$.AttributeSeq(dataColumns).toStructType();
        DataSourceUtils$.MODULE$.verifySchema(fileFormat, dataSchema);
        OutputWriterFactory outputWriterFactory = fileFormat.prepareWrite(sparkSession, job, (Map<String, String>)caseInsensitiveOptions, dataSchema);
        WriteJobDescription description = new WriteJobDescription(UUID.randomUUID().toString(), new SerializableConfiguration(job.getConfiguration()), outputWriterFactory, outputSpec.outputColumns(), (Seq<Attribute>)dataColumns, partitionColumns, (Option<Expression>)bucketIdExpression, outputSpec.outputPath(), outputSpec.customPartitionLocations(), BoxesRunTime.unboxToLong((Object)caseInsensitiveOptions.get("maxRecordsPerFile").map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)FileFormatWriter$.$anonfun$write$9(x$3))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> sparkSession.sessionState().conf().maxRecordsPerFile())), (String)caseInsensitiveOptions.get(DateTimeUtils$.MODULE$.TIMEZONE_OPTION()).getOrElse((Function0 & Serializable & scala.Serializable)() -> sparkSession.sessionState().conf().sessionLocalTimeZone()), statsTrackers);
        Seq requiredOrdering = (Seq)((TraversableLike)partitionColumns.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(bucketIdExpression), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)sortColumns, Seq$.MODULE$.canBuildFrom());
        Seq actualOrdering = (Seq)empty2NullPlan.outputOrdering().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.child(), Seq$.MODULE$.canBuildFrom());
        boolean orderingMatched = requiredOrdering.length() > actualOrdering.length() ? false : ((IterableLike)requiredOrdering.zip((GenIterable)actualOrdering, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)FileFormatWriter$.$anonfun$write$13(x0$2)));
        SQLExecution$.MODULE$.checkSQLExecutionId(sparkSession);
        committer.setupJob((JobContext)job);
        try {
            RDD rDD;
            if (orderingMatched) {
                rDD = empty2NullPlan.execute();
            } else {
                Seq orderingExpr = BindReferences$.MODULE$.bindReferences((Seq)requiredOrdering.map((Function1 & Serializable & scala.Serializable)x$5 -> SortOrder$.MODULE$.apply(x$5, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom()), package$.MODULE$.AttributeSeq(outputSpec.outputColumns()));
                rDD = new SortExec((Seq<SortOrder>)orderingExpr, false, empty2NullPlan, SortExec$.MODULE$.apply$default$4()).execute();
            }
            RDD rdd = rDD;
            RDD rddWithNonEmptyPartitions = rdd.partitions().length == 0 ? sparkSession.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class))), 1, ClassTag$.MODULE$.apply(InternalRow.class)) : rdd;
            long jobIdInstant = new Date().getTime();
            WriteTaskResult[] ret = new WriteTaskResult[rddWithNonEmptyPartitions.partitions().length];
            sparkSession.sparkContext().runJob(rddWithNonEmptyPartitions, (Function2 & Serializable & scala.Serializable)(taskContext, iter) -> MODULE$.executeTask(description, jobIdInstant, taskContext.stageId(), taskContext.partitionId(), (int)taskContext.taskAttemptId() & Integer.MAX_VALUE, committer, (Iterator<InternalRow>)iter), (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddWithNonEmptyPartitions.partitions())).indices(), (Function2 & Serializable & scala.Serializable)(index, res) -> {
                FileFormatWriter$.$anonfun$write$16(committer, ret, BoxesRunTime.unboxToInt((Object)index), res);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(WriteTaskResult.class));
            FileCommitProtocol.TaskCommitMessage[] commitMsgs = (FileCommitProtocol.TaskCommitMessage[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ret)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.commitMsg(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileCommitProtocol.TaskCommitMessage.class)));
            committer.commitJob((JobContext)job, (Seq)Predef$.MODULE$.wrapRefArray((Object[])commitMsgs));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Write Job ").append(description.uuid()).append(" committed.").toString());
            this.processStats(description.statsTrackers(), (Seq<Seq<WriteTaskStats>>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ret)).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.summary().stats(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Finished processing stats for write job ").append(description.uuid()).append(".").toString());
            set = (Set)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ret)).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.summary().updatedPartitions(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class))))).reduceOption((Function2 & Serializable & scala.Serializable)(x$9, x$10) -> (Set)x$9.$plus$plus((GenTraversableOnce)x$10)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        }
        catch (Throwable cause) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Aborting job ").append(description.uuid()).append(".").toString(), cause);
            committer.abortJob((JobContext)job);
            throw new SparkException("Job aborted.", cause);
        }
        return set;
    }

    private WriteTaskResult executeTask(WriteJobDescription description, long jobIdInstant, int sparkStageId, int sparkPartitionId, int sparkAttemptNumber, FileCommitProtocol committer, Iterator<InternalRow> iterator) {
        WriteTaskResult writeTaskResult;
        JobID jobId = SparkHadoopWriterUtils$.MODULE$.createJobID(new Date(jobIdInstant), sparkStageId);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, sparkPartitionId);
        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, sparkAttemptNumber);
        Configuration hadoopConf = description.serializableHadoopConf().value();
        hadoopConf.set("mapreduce.job.id", jobId.toString());
        hadoopConf.set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        hadoopConf.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        hadoopConf.setBoolean("mapreduce.task.ismap", true);
        hadoopConf.setInt("mapreduce.task.partition", 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(hadoopConf, taskAttemptId);
        committer.setupTask((TaskAttemptContext)taskAttemptContext);
        FileFormatDataWriter dataWriter = sparkPartitionId != 0 && !iterator.hasNext() ? new EmptyDirectoryDataWriter(description, (TaskAttemptContext)taskAttemptContext, committer) : (description.partitionColumns().isEmpty() && description.bucketIdExpression().isEmpty() ? new SingleDirectoryDataWriter(description, (TaskAttemptContext)taskAttemptContext, committer) : new DynamicPartitionDataWriter(description, (TaskAttemptContext)taskAttemptContext, committer));
        try {
            Function0 & Serializable & scala.Serializable x$1 = (Function0 & Serializable & scala.Serializable)() -> {
                while (iterator.hasNext()) {
                    dataWriter.write((InternalRow)iterator.next());
                }
                return dataWriter.commit();
            };
            JFunction0.mcV.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                dataWriter.abort();
                MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Job ").append(jobId).append(" aborted.").toString());
            };
            JFunction0.mcV.sp & Serializable & scala.Serializable x$3 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(x$1);
            writeTaskResult = (WriteTaskResult)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$1, (Function0)x$2, (Function0)x$3);
        }
        catch (FetchFailedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SparkException("Task failed while writing rows.", t);
        }
        return writeTaskResult;
    }

    public void processStats(Seq<WriteJobStatsTracker> statsTrackers, Seq<Seq<WriteTaskStats>> statsPerTask) {
        int numStatsTrackers = statsTrackers.length();
        Predef$.MODULE$.assert(statsPerTask.forall((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)FileFormatWriter$.$anonfun$processStats$1(numStatsTrackers, x$11))), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(178).append("Every WriteTask should have produced one `WriteTaskStats` object for every tracker.\n         |There are ").append(numStatsTrackers).append(" statsTrackers, but some task returned\n         |").append(((SeqLike)statsPerTask.find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)FileFormatWriter$.$anonfun$processStats$3(numStatsTrackers, x$12))).get()).length()).append(" results instead.\n       ").toString())).stripMargin());
        Seq statsPerTracker = statsPerTask.nonEmpty() ? (Seq)statsPerTask.transpose((Function1)Predef$.MODULE$.$conforms()) : (Seq)statsTrackers.map((Function1 & Serializable & scala.Serializable)x$13 -> (Seq)Seq$.MODULE$.empty(), Seq$.MODULE$.canBuildFrom());
        ((IterableLike)statsTrackers.zip((GenIterable)statsPerTracker, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FileFormatWriter$.$anonfun$processStats$5(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$write$5(String c$1, Attribute x$1) {
        String string = x$1.name();
        String string2 = c$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$write$8(String c$2, Attribute x$2) {
        String string = x$2.name();
        String string2 = c$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ long $anonfun$write$9(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$write$13(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression requiredOrder = (Expression)tuple2._1();
        Expression childOutputOrder = (Expression)tuple2._2();
        boolean bl = requiredOrder.semanticEquals(childOutputOrder);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$write$16(FileCommitProtocol committer$1, WriteTaskResult[] ret$1, int index, WriteTaskResult res) {
        committer$1.onTaskCommit(res.commitMsg());
        ret$1[index] = res;
    }

    public static final /* synthetic */ boolean $anonfun$processStats$1(int numStatsTrackers$1, Seq x$11) {
        return x$11.length() == numStatsTrackers$1;
    }

    public static final /* synthetic */ boolean $anonfun$processStats$3(int numStatsTrackers$1, Seq x$12) {
        return x$12.length() != numStatsTrackers$1;
    }

    public static final /* synthetic */ void $anonfun$processStats$5(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        WriteJobStatsTracker statsTracker = (WriteJobStatsTracker)tuple2._1();
        Seq stats = (Seq)tuple2._2();
        statsTracker.processStats((Seq<WriteTaskStats>)stats);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private FileFormatWriter$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

