/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartitioningInfo;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JDBCRelation$
implements Logging,
scala.Serializable {
    public static JDBCRelation$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new JDBCRelation$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Partition[] columnPartition(StructType schema, Function2<String, String, Object> resolver, String timeZoneId, JDBCOptions jdbcOptions) {
        long l;
        long upperBound;
        JDBCPartitioningInfo partitioning;
        JDBCPartitioningInfo jDBCPartitioningInfo;
        Option<String> partitionColumn = jdbcOptions.partitionColumn();
        Option<String> lowerBound = jdbcOptions.lowerBound();
        Option<String> upperBound2 = jdbcOptions.upperBound();
        Option<Object> numPartitions = jdbcOptions.numPartitions();
        if (partitionColumn.isEmpty()) {
            Predef$.MODULE$.assert(lowerBound.isEmpty() && upperBound2.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("When 'partitionColumn' is not ").append("specified, '").append(JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()).append("' and '").append(JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()).append("' are expected to be empty").toString());
            jDBCPartitioningInfo = null;
        } else {
            Predef$.MODULE$.assert(lowerBound.nonEmpty() && upperBound2.nonEmpty() && numPartitions.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("When 'partitionColumn' is specified, '").append(JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()).append("', '").append(JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()).append("', and ").append("'").append(JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()).append("' are also required").toString());
            Tuple2<String, DataType> tuple2 = this.verifyAndGetNormalizedPartitionColumn(schema, (String)partitionColumn.get(), resolver, jdbcOptions);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String column = (String)tuple2._1();
            DataType columnType = (DataType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)column, (Object)columnType);
            Tuple2 tuple23 = tuple22;
            String column2 = (String)tuple23._1();
            DataType columnType2 = (DataType)tuple23._2();
            long lowerBoundValue = this.toInternalBoundValue((String)lowerBound.get(), columnType2, timeZoneId);
            long upperBoundValue = this.toInternalBoundValue((String)upperBound2.get(), columnType2, timeZoneId);
            jDBCPartitioningInfo = partitioning = new JDBCPartitioningInfo(column2, columnType2, lowerBoundValue, upperBoundValue, BoxesRunTime.unboxToInt((Object)numPartitions.get()));
        }
        if (partitioning == null || partitioning.numPartitions() <= 1 || partitioning.lowerBound() == partitioning.upperBound()) {
            return (Partition[])((Object[])new Partition[]{new JDBCPartition(null, 0)});
        }
        long lowerBound2 = partitioning.lowerBound();
        Predef$.MODULE$.require(lowerBound2 <= (upperBound = partitioning.upperBound()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(122).append("Operation not allowed: the lower bound of partitioning column is larger than the upper ").append("bound. Lower bound: ").append(lowerBound2).append("; Upper bound: ").append(upperBound).toString());
        Function1 & Serializable & scala.Serializable boundValueToString = (Function1 & Serializable & scala.Serializable)x$2 -> JDBCRelation$.MODULE$.toBoundValueInWhereClause(BoxesRunTime.unboxToLong((Object)x$2), partitioning.columnType(), timeZoneId);
        if (upperBound - lowerBound2 >= (long)partitioning.numPartitions() || upperBound - lowerBound2 < 0L) {
            l = partitioning.numPartitions();
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(235).append("The number of partitions is reduced because the specified number of partitions is less than the difference between upper bound and lower bound. ").append("Updated number of partitions: ").append(upperBound - lowerBound2).append("; Input number of ").append("partitions: ").append(partitioning.numPartitions()).append("; ").append("Lower bound: ").append(boundValueToString.apply((Object)BoxesRunTime.boxToLong((long)lowerBound2))).append("; ").append("Upper bound: ").append(boundValueToString.apply((Object)BoxesRunTime.boxToLong((long)upperBound))).append(".").toString());
            l = upperBound - lowerBound2;
        }
        long numPartitions2 = l;
        long stride = upperBound / numPartitions2 - lowerBound2 / numPartitions2;
        int i = 0;
        String column = partitioning.column();
        long currentValue = lowerBound2;
        ArrayBuffer ans = new ArrayBuffer();
        while ((long)i < numPartitions2) {
            String uBound;
            String lBoundValue = (String)boundValueToString.apply((Object)BoxesRunTime.boxToLong((long)currentValue));
            String lBound = i != 0 ? new StringBuilder(4).append(column).append(" >= ").append(lBoundValue).toString() : null;
            String uBoundValue = (String)boundValueToString.apply((Object)BoxesRunTime.boxToLong((long)(currentValue += stride)));
            String string = uBound = (long)i != numPartitions2 - 1L ? new StringBuilder(3).append(column).append(" < ").append(uBoundValue).toString() : null;
            String whereClause = uBound == null ? lBound : (lBound == null ? new StringBuilder(12).append(uBound).append(" or ").append(column).append(" is null").toString() : new StringBuilder(5).append(lBound).append(" AND ").append(uBound).toString());
            ans.$plus$eq((Object)new JDBCPartition(whereClause, i));
            ++i;
        }
        Partition[] partitions = (Partition[])ans.toArray(ClassTag$.MODULE$.apply(Partition.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Number of partitions: ").append(numPartitions2).append(", WHERE clauses of these partitions: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).map((Function1 & Serializable & scala.Serializable)x$3 -> ((JDBCPartition)x$3).whereClause(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).toString());
        return partitions;
    }

    private Tuple2<String, DataType> verifyAndGetNormalizedPartitionColumn(StructType schema, String columnName, Function2<String, String, Object> resolver, JDBCOptions jdbcOptions) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(jdbcOptions.url());
        StructField column = (StructField)schema.find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)JDBCRelation$.$anonfun$verifyAndGetNormalizedPartitionColumn$1(resolver, columnName, dialect, f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            int maxNumToStringFields = SQLConf$.MODULE$.get().maxToStringFields();
            throw new AnalysisException(new StringBuilder(63).append("User-defined partition column ").append(columnName).append(" not ").append("found in the JDBC relation: ").append(schema.simpleString(maxNumToStringFields)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        });
        DataType dataType = column.dataType();
        boolean bl = dataType instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType));
        if (!bl) {
            throw new AnalysisException(new StringBuilder(52).append("Partition column type should be ").append(NumericType$.MODULE$.simpleString()).append(", ").append(DateType$.MODULE$.catalogString()).append(", or ").append(TimestampType$.MODULE$.catalogString()).append(", but ").append(column.dataType().catalogString()).append(" found.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return new Tuple2((Object)dialect.quoteIdentifier(column.name()), (Object)column.dataType());
    }

    private long toInternalBoundValue(String value, DataType columnType, String timeZoneId) {
        long l;
        DataType dataType = columnType;
        if (dataType instanceof NumericType) {
            l = new StringOps(Predef$.MODULE$.augmentString(value)).toLong();
        } else if (DateType$.MODULE$.equals(dataType)) {
            l = BoxesRunTime.unboxToInt((Object)JDBCRelation$.parse$1((Function1 & Serializable & scala.Serializable)x$4 -> DateTimeUtils$.MODULE$.stringToDate(x$4, DateTimeUtils$.MODULE$.getZoneId(timeZoneId)), value, columnType));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            l = BoxesRunTime.unboxToLong((Object)JDBCRelation$.parse$1((Function1 & Serializable & scala.Serializable)x$5 -> DateTimeUtils$.MODULE$.stringToTimestamp(x$5, DateTimeUtils$.MODULE$.getZoneId(timeZoneId)), value, columnType));
        } else {
            throw new MatchError((Object)dataType);
        }
        return l;
    }

    private String toBoundValueInWhereClause(long value, DataType columnType, String timeZoneId) {
        String string;
        DataType dataType = columnType;
        if (dataType instanceof NumericType) {
            string = ((Object)BoxesRunTime.boxToLong((long)value)).toString();
        } else {
            boolean bl = DateType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType);
            if (bl) {
                string = JDBCRelation$.dateTimeToString$1(columnType, timeZoneId, value);
            } else {
                throw new MatchError((Object)dataType);
            }
        }
        return string;
    }

    public StructType getSchema(Function2<String, String, Object> resolver, JDBCOptions jdbcOptions) {
        StructType structType;
        StructType tableSchema = JDBCRDD$.MODULE$.resolveTable(jdbcOptions);
        Option<String> option = jdbcOptions.customSchema();
        if (option instanceof Some) {
            Some some = (Some)option;
            String customSchema = (String)some.value();
            structType = JdbcUtils$.MODULE$.getCustomSchema(tableSchema, customSchema, resolver);
        } else if (None$.MODULE$.equals(option)) {
            structType = tableSchema;
        } else {
            throw new MatchError(option);
        }
        return structType;
    }

    public JDBCRelation apply(Partition[] parts, JDBCOptions jdbcOptions, SparkSession sparkSession) {
        StructType schema = this.getSchema((Function2<String, String, Object>)sparkSession.sessionState().conf().resolver(), jdbcOptions);
        return new JDBCRelation(schema, parts, jdbcOptions, sparkSession);
    }

    public JDBCRelation apply(StructType schema, Partition[] parts, JDBCOptions jdbcOptions, SparkSession sparkSession) {
        return new JDBCRelation(schema, parts, jdbcOptions, sparkSession);
    }

    public Option<Tuple3<StructType, Partition[], JDBCOptions>> unapply(JDBCRelation x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.schema(), (Object)x$0.parts(), (Object)x$0.jdbcOptions()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$verifyAndGetNormalizedPartitionColumn$1(Function2 resolver$1, String columnName$1, JdbcDialect dialect$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)columnName$1)) || BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)dialect$1.quoteIdentifier(f.name()), (Object)columnName$1));
    }

    private static final Object parse$1(Function1 f, String value$1, DataType columnType$1) {
        return ((Option)f.apply((Object)UTF8String.fromString((String)value$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(33).append("Cannot parse the bound value ").append(value$1).append(" as ").append(columnType$1.catalogString()).toString());
        });
    }

    private static final String dateTimeToString$1(DataType columnType$2, String timeZoneId$3, long value$2) {
        String string;
        DataType dataType = columnType$2;
        if (DateType$.MODULE$.equals(dataType)) {
            DateFormatter dateFormatter = DateFormatter$.MODULE$.apply(DateTimeUtils$.MODULE$.getZoneId(timeZoneId$3));
            string = dateFormatter.format((int)value$2);
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(timeZoneId$3));
            string = DateTimeUtils$.MODULE$.timestampToString(timestampFormatter, value$2);
        } else {
            throw new MatchError((Object)dataType);
        }
        String dateTimeStr = string;
        return new StringBuilder(2).append("'").append(dateTimeStr).append("'").toString();
    }

    private JDBCRelation$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

