/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import org.apache.spark.SparkException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.execution.datasources.v2.DropNamespaceExec$;
import org.apache.spark.sql.execution.datasources.v2.V2CommandExec;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001\u0002\u0010 \u0001:B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005}!Aa\t\u0001BK\u0002\u0013\u0005q\t\u0003\u0005]\u0001\tE\t\u0015!\u0003I\u0011!i\u0006A!f\u0001\n\u0003q\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011B0\t\u0011\r\u0004!Q3A\u0005\u0002yC\u0001\u0002\u001a\u0001\u0003\u0012\u0003\u0006Ia\u0018\u0005\u0006K\u0002!\tA\u001a\u0005\u0006Y\u0002!\t&\u001c\u0005\u0006k\u0002!\tE\u001e\u0005\b}\u0002\t\t\u0011\"\u0001\u0000\u0011%\tI\u0001AI\u0001\n\u0003\tY\u0001C\u0005\u0002\"\u0001\t\n\u0011\"\u0001\u0002$!I\u0011q\u0005\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0006\u0005\n\u0003[\u0001\u0011\u0013!C\u0001\u0003SA\u0011\"a\f\u0001\u0003\u0003%\t%!\r\t\u0013\u0005\u0005\u0003!!A\u0005\u0002\u0005\r\u0003\"CA&\u0001\u0005\u0005I\u0011AA'\u0011%\tI\u0006AA\u0001\n\u0003\nY\u0006C\u0005\u0002j\u0001\t\t\u0011\"\u0001\u0002l!I\u0011q\u000e\u0001\u0002\u0002\u0013\u0005\u0013\u0011O\u0004\n\u0003kz\u0012\u0011!E\u0001\u0003o2\u0001BH\u0010\u0002\u0002#\u0005\u0011\u0011\u0010\u0005\u0007Kb!\t!a\"\t\u0013\u0005%\u0005$!A\u0005F\u0005-\u0005\"CAG1\u0005\u0005I\u0011QAH\u0011%\tI\nGA\u0001\n\u0003\u000bY\nC\u0005\u0002.b\t\t\u0011\"\u0003\u00020\n\tBI]8q\u001d\u0006lWm\u001d9bG\u0016,\u00050Z2\u000b\u0005\u0001\n\u0013A\u0001<3\u0015\t\u00113%A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u0013&\u0003%)\u00070Z2vi&|gN\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001_MJ\u0004C\u0001\u00192\u001b\u0005y\u0012B\u0001\u001a \u000551&gQ8n[\u0006tG-\u0012=fGB\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t9\u0001K]8ek\u000e$\bC\u0001\u001b;\u0013\tYTG\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004dCR\fGn\\4\u0016\u0003y\u0002\"aP\"\u000e\u0003\u0001S!\u0001P!\u000b\u0005\t+\u0013!C2p]:,7\r^8s\u0013\t!\u0005I\u0001\nTkB\u0004xN\u001d;t\u001d\u0006lWm\u001d9bG\u0016\u001c\u0018\u0001C2bi\u0006dwn\u001a\u0011\u0002\u00139\fW.Z:qC\u000e,W#\u0001%\u0011\u0007%\u000bFK\u0004\u0002K\u001f:\u00111JT\u0007\u0002\u0019*\u0011Q*L\u0001\u0007yI|w\u000e\u001e \n\u0003YJ!\u0001U\u001b\u0002\u000fA\f7m[1hK&\u0011!k\u0015\u0002\u0004'\u0016\f(B\u0001)6!\t)\u0016L\u0004\u0002W/B\u00111*N\u0005\u00031V\na\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001,N\u0001\u000b]\u0006lWm\u001d9bG\u0016\u0004\u0013\u0001C5g\u000bbL7\u000f^:\u0016\u0003}\u0003\"\u0001\u000e1\n\u0005\u0005,$a\u0002\"p_2,\u0017M\\\u0001\nS\u001a,\u00050[:ug\u0002\nqaY1tG\u0006$W-\u0001\u0005dCN\u001c\u0017\rZ3!\u0003\u0019a\u0014N\\5u}Q)q\r[5kWB\u0011\u0001\u0007\u0001\u0005\u0006y%\u0001\rA\u0010\u0005\u0006\r&\u0001\r\u0001\u0013\u0005\u0006;&\u0001\ra\u0018\u0005\u0006G&\u0001\raX\u0001\u0004eVtG#\u00018\u0011\u0007%\u000bv\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002sK\u0005A1-\u0019;bYf\u001cH/\u0003\u0002uc\nY\u0011J\u001c;fe:\fGNU8x\u0003\u0019yW\u000f\u001e9viV\tq\u000fE\u0002J#b\u0004\"!\u001f?\u000e\u0003iT!a_9\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003{j\u0014\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\t\r|\u0007/\u001f\u000b\nO\u0006\u0005\u00111AA\u0003\u0003\u000fAq\u0001\u0010\u0007\u0011\u0002\u0003\u0007a\bC\u0004G\u0019A\u0005\t\u0019\u0001%\t\u000fuc\u0001\u0013!a\u0001?\"91\r\u0004I\u0001\u0002\u0004y\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001bQ3APA\bW\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u0013Ut7\r[3dW\u0016$'bAA\u000ek\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0011Q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003KQ3\u0001SA\b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a\u000b+\u0007}\u000by!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0004\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\t1\fgn\u001a\u0006\u0003\u0003{\tAA[1wC&\u0019!,a\u000e\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0003c\u0001\u001b\u0002H%\u0019\u0011\u0011J\u001b\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005=\u0013Q\u000b\t\u0004i\u0005E\u0013bAA*k\t\u0019\u0011I\\=\t\u0013\u0005]3#!AA\u0002\u0005\u0015\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002^A1\u0011qLA3\u0003\u001fj!!!\u0019\u000b\u0007\u0005\rT'\u0001\u0006d_2dWm\u0019;j_:LA!a\u001a\u0002b\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ry\u0016Q\u000e\u0005\n\u0003/*\u0012\u0011!a\u0001\u0003\u001f\na!Z9vC2\u001cHcA0\u0002t!I\u0011q\u000b\f\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0012\tJ|\u0007OT1nKN\u0004\u0018mY3Fq\u0016\u001c\u0007C\u0001\u0019\u0019'\u0011A\u00121P\u001d\u0011\u0013\u0005u\u00141\u0011 I?~;WBAA@\u0015\r\t\t)N\u0001\beVtG/[7f\u0013\u0011\t))a \u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0002x\u0005AAo\\*ue&tw\r\u0006\u0002\u00024\u0005)\u0011\r\u001d9msRIq-!%\u0002\u0014\u0006U\u0015q\u0013\u0005\u0006ym\u0001\rA\u0010\u0005\u0006\rn\u0001\r\u0001\u0013\u0005\u0006;n\u0001\ra\u0018\u0005\u0006Gn\u0001\raX\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti*!+\u0011\u000bQ\ny*a)\n\u0007\u0005\u0005VG\u0001\u0004PaRLwN\u001c\t\bi\u0005\u0015f\bS0`\u0013\r\t9+\u000e\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\u0005-F$!AA\u0002\u001d\f1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\u0006\u0003BA\u001b\u0003gKA!!.\u00028\t1qJ\u00196fGR\u0004")
public class DropNamespaceExec
extends V2CommandExec {
    private final SupportsNamespaces catalog;
    private final Seq<String> namespace;
    private final boolean ifExists;
    private final boolean cascade;

    public static Option<Tuple4<SupportsNamespaces, Seq<String>, Object, Object>> unapply(DropNamespaceExec dropNamespaceExec) {
        return DropNamespaceExec$.MODULE$.unapply(dropNamespaceExec);
    }

    public static Function1<Tuple4<SupportsNamespaces, Seq<String>, Object, Object>, DropNamespaceExec> tupled() {
        return DropNamespaceExec$.MODULE$.tupled();
    }

    public static Function1<SupportsNamespaces, Function1<Seq<String>, Function1<Object, Function1<Object, DropNamespaceExec>>>> curried() {
        return DropNamespaceExec$.MODULE$.curried();
    }

    public SupportsNamespaces catalog() {
        return this.catalog;
    }

    public Seq<String> namespace() {
        return this.namespace;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public boolean cascade() {
        return this.cascade;
    }

    @Override
    public Seq<InternalRow> run() {
        Object object;
        String[] ns = (String[])this.namespace().toArray(ClassTag$.MODULE$.apply(String.class));
        if (this.catalog().namespaceExists(ns)) {
            boolean bl;
            try {
                bl = this.catalog().dropNamespace(ns);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IllegalStateException) {
                    IllegalStateException illegalStateException = (IllegalStateException)throwable2;
                    if (this.cascade()) {
                        throw new SparkException("Cascade option for droping namespace is not supported in V2 catalog", (Throwable)illegalStateException);
                    }
                }
                throw throwable;
            }
            object = BoxesRunTime.boxToBoolean((boolean)bl);
        } else {
            if (!this.ifExists()) {
                throw new NoSuchNamespaceException(ns);
            }
            object = BoxedUnit.UNIT;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public Seq<Attribute> output() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public DropNamespaceExec copy(SupportsNamespaces catalog, Seq<String> namespace, boolean ifExists, boolean cascade) {
        return new DropNamespaceExec(catalog, namespace, ifExists, cascade);
    }

    public SupportsNamespaces copy$default$1() {
        return this.catalog();
    }

    public Seq<String> copy$default$2() {
        return this.namespace();
    }

    public boolean copy$default$3() {
        return this.ifExists();
    }

    public boolean copy$default$4() {
        return this.cascade();
    }

    public String productPrefix() {
        return "DropNamespaceExec";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.catalog();
                break;
            }
            case 1: {
                object = this.namespace();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifExists());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.cascade());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropNamespaceExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropNamespaceExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropNamespaceExec dropNamespaceExec = (DropNamespaceExec)x$1;
        SupportsNamespaces supportsNamespaces = this.catalog();
        SupportsNamespaces supportsNamespaces2 = dropNamespaceExec.catalog();
        if (supportsNamespaces == null) {
            if (supportsNamespaces2 != null) {
                return false;
            }
        } else if (!supportsNamespaces.equals(supportsNamespaces2)) return false;
        Seq<String> seq = this.namespace();
        Seq<String> seq2 = dropNamespaceExec.namespace();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.ifExists() != dropNamespaceExec.ifExists()) return false;
        if (this.cascade() != dropNamespaceExec.cascade()) return false;
        if (!dropNamespaceExec.canEqual(this)) return false;
        return true;
    }

    public DropNamespaceExec(SupportsNamespaces catalog, Seq<String> namespace, boolean ifExists, boolean cascade) {
        this.catalog = catalog;
        this.namespace = namespace;
        this.ifExists = ifExists;
        this.cascade = cascade;
    }
}

