/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.metric;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetric$;
import org.apache.spark.sql.execution.ui.SparkListenerDriverAccumUpdates;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class SQLMetrics$ {
    public static SQLMetrics$ MODULE$;
    private final String SUM_METRIC;
    private final String SIZE_METRIC;
    private final String TIMING_METRIC;
    private final String NS_TIMING_METRIC;
    private final String AVERAGE_METRIC;
    private final int baseForAvgMetric;

    static {
        new SQLMetrics$();
    }

    private String SUM_METRIC() {
        return this.SUM_METRIC;
    }

    private String SIZE_METRIC() {
        return this.SIZE_METRIC;
    }

    private String TIMING_METRIC() {
        return this.TIMING_METRIC;
    }

    private String NS_TIMING_METRIC() {
        return this.NS_TIMING_METRIC;
    }

    private String AVERAGE_METRIC() {
        return this.AVERAGE_METRIC;
    }

    private int baseForAvgMetric() {
        return this.baseForAvgMetric;
    }

    public void setDoubleForAverageMetrics(SQLMetric metric, double v) {
        String string = metric.metricType();
        String string2 = this.AVERAGE_METRIC();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Can't set a double to a metric of metrics type: ").append(metric.metricType()).toString());
        metric.set((long)(v * (double)this.baseForAvgMetric()));
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createMetric(SparkContext sc, String name) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.SUM_METRIC(), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)new Some((Object)name), false);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createSizeMetric(SparkContext sc, String name) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.SIZE_METRIC(), -1L);
        acc.register(sc, (Option)new Some((Object)new StringBuilder(22).append(name).append(" total (min, med, max)").toString()), false);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createTimingMetric(SparkContext sc, String name) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.TIMING_METRIC(), -1L);
        acc.register(sc, (Option)new Some((Object)new StringBuilder(22).append(name).append(" total (min, med, max)").toString()), false);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createNanoTimingMetric(SparkContext sc, String name) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.NS_TIMING_METRIC(), -1L);
        acc.register(sc, (Option)new Some((Object)new StringBuilder(22).append(name).append(" total (min, med, max)").toString()), false);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createAverageMetric(SparkContext sc, String name) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.AVERAGE_METRIC(), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)new Some((Object)new StringBuilder(16).append(name).append(" (min, med, max)").toString()), false);
        return var3_3;
    }

    public String stringValue(String metricsType, long[] values) {
        String string;
        String string2 = metricsType;
        String string3 = this.SUM_METRIC();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance(Locale.US);
            string = numberFormat.format(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(values)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        } else {
            String string4 = metricsType;
            String string5 = this.AVERAGE_METRIC();
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                Seq seq;
                NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
                long[] validValues = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(values)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0L);
                if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(validValues)).isEmpty()) {
                    seq = (Seq)Seq$.MODULE$.fill(3, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L);
                } else {
                    Arrays.sort(validValues);
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{validValues[0], validValues[validValues.length / 2], validValues[validValues.length - 1]}));
                }
                Seq metric = seq;
                Seq seq2 = (Seq)metric.map((Function1 & Serializable & scala.Serializable)v -> numberFormat.format((double)BoxesRunTime.unboxToLong((Object)v) / (double)SQLMetrics$.MODULE$.baseForAvgMetric()), Seq$.MODULE$.canBuildFrom());
                Some some = Seq$.MODULE$.unapplySeq(seq2);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) {
                    throw new MatchError((Object)seq2);
                }
                String min = (String)((SeqLike)some.get()).apply(0);
                String med = (String)((SeqLike)some.get()).apply(1);
                String max = (String)((SeqLike)some.get()).apply(2);
                Tuple3 tuple3 = new Tuple3((Object)min, (Object)med, (Object)max);
                Tuple3 tuple32 = tuple3;
                String min2 = (String)tuple32._1();
                String med2 = (String)tuple32._2();
                String max2 = (String)tuple32._3();
                string = new StringBuilder(7).append("\n(").append(min2).append(", ").append(med2).append(", ").append(max2).append(")").toString();
            } else {
                Seq seq;
                Function1 & Serializable & scala.Serializable intersect;
                String string6 = metricsType;
                String string7 = this.SIZE_METRIC();
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    intersect = (Function1 & Serializable & scala.Serializable)size -> Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)size));
                } else {
                    String string8 = metricsType;
                    String string9 = this.TIMING_METRIC();
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        intersect = (Function1 & Serializable & scala.Serializable)ms -> Utils$.MODULE$.msDurationToString(BoxesRunTime.unboxToLong((Object)ms));
                    } else {
                        String string10 = metricsType;
                        String string11 = this.NS_TIMING_METRIC();
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            intersect = (Function1 & Serializable & scala.Serializable)duration -> Utils$.MODULE$.msDurationToString(new package.DurationLong(package$.MODULE$.DurationLong(BoxesRunTime.unboxToLong((Object)duration))).nanos().toMillis());
                        } else {
                            throw new IllegalStateException(new StringBuilder(25).append("unexpected metrics type: ").append(metricsType).toString());
                        }
                    }
                }
                Function1 & Serializable & scala.Serializable strFormat = intersect;
                long[] validValues = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(values)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> x$3 >= 0L);
                if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(validValues)).isEmpty()) {
                    seq = (Seq)Seq$.MODULE$.fill(4, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L);
                } else {
                    Arrays.sort(validValues);
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(validValues)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), validValues[0], validValues[validValues.length / 2], validValues[validValues.length - 1]}));
                }
                Seq metric = seq;
                Seq seq3 = (Seq)metric.map((Function1)strFormat, Seq$.MODULE$.canBuildFrom());
                Some some = Seq$.MODULE$.unapplySeq(seq3);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) {
                    throw new MatchError((Object)seq3);
                }
                String sum = (String)((SeqLike)some.get()).apply(0);
                String min = (String)((SeqLike)some.get()).apply(1);
                String med = (String)((SeqLike)some.get()).apply(2);
                String max = (String)((SeqLike)some.get()).apply(3);
                Tuple4 tuple4 = new Tuple4((Object)sum, (Object)min, (Object)med, (Object)max);
                Tuple4 tuple42 = tuple4;
                String sum2 = (String)tuple42._1();
                String min3 = (String)tuple42._2();
                String med3 = (String)tuple42._3();
                String max3 = (String)tuple42._4();
                string = new StringBuilder(8).append("\n").append(sum2).append(" (").append(min3).append(", ").append(med3).append(", ").append(max3).append(")").toString();
            }
        }
        return string;
    }

    public void postDriverMetricUpdates(SparkContext sc, String executionId, Seq<SQLMetric> metrics) {
        block0: {
            if (executionId == null) break block0;
            sc.listenerBus().post((SparkListenerEvent)new SparkListenerDriverAccumUpdates(new StringOps(Predef$.MODULE$.augmentString(executionId)).toLong(), (Seq<Tuple2<Object, Object>>)((Seq)metrics.map((Function1 & Serializable & scala.Serializable)m -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)m.id())), (Object)BoxesRunTime.boxToLong((long)m.value())), Seq$.MODULE$.canBuildFrom()))));
        }
    }

    private SQLMetrics$() {
        MODULE$ = this;
        this.SUM_METRIC = "sum";
        this.SIZE_METRIC = "size";
        this.TIMING_METRIC = "timing";
        this.NS_TIMING_METRIC = "nsTiming";
        this.AVERAGE_METRIC = "average";
        this.baseForAvgMetric = 10;
    }
}

