/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.SeqViewLike;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

public final class CompactibleFileStreamLog$ {
    public static CompactibleFileStreamLog$ MODULE$;
    private final String COMPACT_FILE_SUFFIX;

    static {
        new CompactibleFileStreamLog$();
    }

    public String COMPACT_FILE_SUFFIX() {
        return this.COMPACT_FILE_SUFFIX;
    }

    public long getBatchIdFromFileName(String fileName) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(fileName)).stripSuffix(this.COMPACT_FILE_SUFFIX()))).toLong();
    }

    public boolean isCompactionBatch(long batchId, int compactInterval) {
        return (batchId + 1L) % (long)compactInterval == 0L;
    }

    public Seq<Object> getValidBatchesBeforeCompactionBatch(long compactionBatchId, int compactInterval) {
        Predef$.MODULE$.assert(this.isCompactionBatch(compactionBatchId, compactInterval), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(26).append(compactionBatchId).append(" is not a compaction batch").toString());
        return new RichLong(Predef$.MODULE$.longWrapper(package$.MODULE$.max(0L, compactionBatchId - (long)compactInterval))).until((Object)BoxesRunTime.boxToLong((long)compactionBatchId));
    }

    public Seq<Object> getAllValidBatches(long batchId, long compactInterval) {
        Predef$.MODULE$.assert(batchId >= 0L);
        long start = package$.MODULE$.max(0L, (batchId + 1L) / compactInterval * compactInterval - 1L);
        return new RichLong(Predef$.MODULE$.longWrapper(start)).to((Object)BoxesRunTime.boxToLong((long)batchId));
    }

    public long nextCompactionBatchId(long batchId, long compactInterval) {
        return (batchId + compactInterval + 1L) / compactInterval * compactInterval - 1L;
    }

    public int deriveCompactInterval(int defaultInterval, int latestCompactBatchId) {
        return latestCompactBatchId + 1 <= defaultInterval ? latestCompactBatchId + 1 : (defaultInterval < (latestCompactBatchId + 1) / 2 ? BoxesRunTime.unboxToInt((Object)CompactibleFileStreamLog$.properDivisors$1(defaultInterval, latestCompactBatchId + 1).head()) : latestCompactBatchId + 1);
    }

    private static final SeqView properDivisors$1(int min, int n) {
        return (SeqView)((SeqViewLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(min), n / 2).view().filter((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)i -> n % i == 0)).$colon$plus((Object)BoxesRunTime.boxToInteger((int)n), SeqView$.MODULE$.canBuildFrom());
    }

    private CompactibleFileStreamLog$() {
        MODULE$ = this;
        this.COMPACT_FILE_SUFFIX = ".compact";
    }
}

