/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog$;
import org.apache.spark.sql.execution.streaming.ManifestFileCommitProtocol;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005v!\u0002\u000e\u001c\u0011\u0003Ac!\u0002\u0016\u001c\u0011\u0003Y\u0003\"\u0002\u001d\u0002\t\u0003I\u0004b\u0002\u001e\u0002\u0005\u0004%\ta\u000f\u0005\u0007\t\u0006\u0001\u000b\u0011\u0002\u001f\t\u000b\u0015\u000bA\u0011\u0001$\t\u000bA\fA\u0011A9\t\u000f\u0005\u0015\u0011\u0001\"\u0001\u0002\b\u0019)!f\u0007\u0001\u0002\u000e!Q\u00111\u0004\u0005\u0003\u0002\u0003\u0006I!!\b\t\u0011-C!\u0011!Q\u0001\naC!\"!\n\t\u0005\u0003\u0005\u000b\u0011BA\u0014\u0011%\t\u0019\u0004\u0003B\u0001B\u0003%A\n\u0003\u0006\u00026!\u0011\t\u0011)A\u0005\u0003oAa\u0001\u000f\u0005\u0005\u0002\u0005u\u0002\u0002\u00031\t\u0005\u0004%I!a\u0013\t\u000f\u00055\u0003\u0002)A\u0005C\"I\u0011q\n\u0005C\u0002\u0013%\u0011\u0011\u000b\u0005\b\u0003'B\u0001\u0015!\u0003\u007f\u0011%\t)\u0006\u0003b\u0001\n\u0013\t\t\u0006C\u0004\u0002X!\u0001\u000b\u0011\u0002@\t\u0013\u0005e\u0003B1A\u0005\n\u0005m\u0003\u0002CA2\u0011\u0001\u0006I!!\u0018\t\u000f\u0005\u0015\u0004\u0002\"\u0003\u0002h!9\u0011q\u000e\u0005\u0005B\u0005E\u0004bBAO\u0011\u0011\u0005\u0013qT\u0001\u000f\r&dWm\u0015;sK\u0006l7+\u001b8l\u0015\taR$A\u0005tiJ,\u0017-\\5oO*\u0011adH\u0001\nKb,7-\u001e;j_:T!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0001\"!K\u0001\u000e\u0003m\u0011aBR5mKN#(/Z1n'&t7nE\u0002\u0002YI\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0007CA\u001a7\u001b\u0005!$BA\u001b\"\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001c5\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u0015\u0002\u00175,G/\u00193bi\u0006$\u0015N]\u000b\u0002yA\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0005Y\u0006twMC\u0001B\u0003\u0011Q\u0017M^1\n\u0005\rs$AB*ue&tw-\u0001\u0007nKR\fG-\u0019;b\t&\u0014\b%A\u0006iCNlU\r^1eCR\fG\u0003B$K?&\u0004\"!\f%\n\u0005%s#a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0017\u0016\u0001\r\u0001T\u0001\u0005a\u0006$\b\u000eE\u0002N+bs!AT*\u000f\u0005=\u0013V\"\u0001)\u000b\u0005E;\u0013A\u0002\u001fs_>$h(C\u00010\u0013\t!f&A\u0004qC\u000e\\\u0017mZ3\n\u0005Y;&aA*fc*\u0011AK\f\t\u00033vs!AW.\u0011\u0005=s\u0013B\u0001//\u0003\u0019\u0001&/\u001a3fM&\u00111I\u0018\u0006\u00039:BQ\u0001Y\u0003A\u0002\u0005\f!\u0002[1e_>\u00048i\u001c8g!\t\u0011w-D\u0001d\u0015\t!W-\u0001\u0003d_:4'B\u00014$\u0003\u0019A\u0017\rZ8pa&\u0011\u0001n\u0019\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b),\u0001\u0019A6\u0002\u000fM\fHnQ8oMB\u0011AN\\\u0007\u0002[*\u0011QgH\u0005\u0003_6\u0014qaU)M\u0007>tg-\u0001\rdQ\u0016\u001c7.R:dCB,G-T3uC\u0012\fG/\u0019)bi\"$RA];}\u0003\u0007\u0001\"!L:\n\u0005Qt#\u0001B+oSRDQA\u001e\u0004A\u0002]\f!AZ:\u0011\u0005aTX\"A=\u000b\u0005Y,\u0017BA>z\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\u0006{\u001a\u0001\rA`\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\t\u0003q~L1!!\u0001z\u0005\u0011\u0001\u0016\r\u001e5\t\u000b)4\u0001\u0019A6\u00027\u0005t7-Z:u_JL5/T3uC\u0012\fG/\u0019#je\u0016\u001cGo\u001c:z)\u00159\u0015\u0011BA\u0006\u0011\u0015Yu\u00011\u0001\u007f\u0011\u0015\u0001w\u00011\u0001b'\u0019A\u0011qBA\u000beA\u0019Q(!\u0005\n\u0007\u0005MaH\u0001\u0004PE*,7\r\u001e\t\u0004S\u0005]\u0011bAA\r7\t!1+\u001b8l\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\ty\"!\t\u000e\u0003}I1!a\t \u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003)1\u0017\u000e\\3G_Jl\u0017\r\u001e\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011QF\u000f\u0002\u0017\u0011\fG/Y:pkJ\u001cWm]\u0005\u0005\u0003c\tYC\u0001\u0006GS2,gi\u001c:nCR\fA\u0003]1si&$\u0018n\u001c8D_2,XN\u001c(b[\u0016\u001c\u0018aB8qi&|gn\u001d\t\u00063\u0006e\u0002\fW\u0005\u0004\u0003wq&aA'baRa\u0011qHA!\u0003\u0007\n)%a\u0012\u0002JA\u0011\u0011\u0006\u0003\u0005\b\u00037q\u0001\u0019AA\u000f\u0011\u0015Ye\u00021\u0001Y\u0011\u001d\t)C\u0004a\u0001\u0003OAa!a\r\u000f\u0001\u0004a\u0005bBA\u001b\u001d\u0001\u0007\u0011qG\u000b\u0002C\u0006Y\u0001.\u00193p_B\u001cuN\u001c4!\u0003!\u0011\u0017m]3QCRDW#\u0001@\u0002\u0013\t\f7/\u001a)bi\"\u0004\u0013a\u00027pOB\u000bG\u000f[\u0001\tY><\u0007+\u0019;iA\u00059a-\u001b7f\u0019><WCAA/!\rI\u0013qL\u0005\u0004\u0003CZ\"!\u0005$jY\u0016\u001cFO]3b[NKgn\u001b'pO\u0006Aa-\u001b7f\u0019><\u0007%A\rcCNL7m\u0016:ji\u0016TuNY*uCR\u001cHK]1dW\u0016\u0014XCAA5!\u0011\tI#a\u001b\n\t\u00055\u00141\u0006\u0002\u001a\u0005\u0006\u001c\u0018nY,sSR,'j\u001c2Ti\u0006$8\u000f\u0016:bG.,'/\u0001\u0005bI\u0012\u0014\u0015\r^2i)\u0015\u0011\u00181OA?\u0011\u001d\t)\b\u0007a\u0001\u0003o\nqAY1uG\"LE\rE\u0002.\u0003sJ1!a\u001f/\u0005\u0011auN\\4\t\u000f\u0005}\u0004\u00041\u0001\u0002\u0002\u0006!A-\u0019;b!\u0011\t\u0019)a&\u000f\t\u0005\u0015\u0015Q\u0013\b\u0005\u0003\u000f\u000b\u0019J\u0004\u0003\u0002\n\u0006Ee\u0002BAF\u0003\u001fs1aTAG\u0013\u00051\u0013B\u0001\u0013&\u0013\t\u00113%\u0003\u0002!C%\u0011AkH\u0005\u0005\u00033\u000bYJA\u0005ECR\fgI]1nK*\u0011AkH\u0001\ti>\u001cFO]5oOR\t\u0001\f")
public class FileStreamSink
implements Sink,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final FileFormat fileFormat;
    private final Seq<String> partitionColumnNames;
    private final Map<String, String> options;
    private final Configuration hadoopConf;
    private final Path basePath;
    private final Path logPath;
    private final FileStreamSinkLog fileLog;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean ancestorIsMetadataDirectory(Path path, Configuration configuration) {
        return FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(path, configuration);
    }

    public static void checkEscapedMetadataPath(FileSystem fileSystem, Path path, SQLConf sQLConf) {
        FileStreamSink$.MODULE$.checkEscapedMetadataPath(fileSystem, path, sQLConf);
    }

    public static boolean hasMetadata(Seq<String> seq, Configuration configuration, SQLConf sQLConf) {
        return FileStreamSink$.MODULE$.hasMetadata(seq, configuration, sQLConf);
    }

    public static String metadataDir() {
        return FileStreamSink$.MODULE$.metadataDir();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public String name() {
        return Sink.name$(this);
    }

    @Override
    public StructType schema() {
        return Sink.schema$(this);
    }

    @Override
    public Set<TableCapability> capabilities() {
        return Sink.capabilities$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private Path basePath() {
        return this.basePath;
    }

    private Path logPath() {
        return this.logPath;
    }

    private FileStreamSinkLog fileLog() {
        return this.fileLog;
    }

    private BasicWriteJobStatsTracker basicWriteJobStatsTracker() {
        SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.hadoopConf());
        return new BasicWriteJobStatsTracker(serializableHadoopConf, BasicWriteJobStatsTracker$.MODULE$.metrics());
    }

    @Override
    public void addBatch(long batchId, Dataset<Row> data) {
        if (batchId <= BoxesRunTime.unboxToLong((Object)this.fileLog().getLatest().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Skipping already committed batch ").append(batchId).toString());
        } else {
            FileCommitProtocol committer = FileCommitProtocol$.MODULE$.instantiate(this.sparkSession.sessionState().conf().streamingFileCommitProtocolClass(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString(), this.path, FileCommitProtocol$.MODULE$.instantiate$default$4());
            FileCommitProtocol fileCommitProtocol = committer;
            if (fileCommitProtocol instanceof ManifestFileCommitProtocol) {
                ManifestFileCommitProtocol manifestFileCommitProtocol = (ManifestFileCommitProtocol)fileCommitProtocol;
                manifestFileCommitProtocol.setupManifestOptions(this.fileLog(), batchId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Seq partitionColumns = (Seq)this.partitionColumnNames.map((Function1 & Serializable & scala.Serializable)col -> {
                Function2 nameEquality = data.sparkSession().sessionState().conf().resolver();
                return (Attribute)data.logicalPlan().output().find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink.$anonfun$addBatch$5(nameEquality, col, f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(38).append("Partition column ").append((String)col).append(" not found in schema ").append(data.schema()).toString());
                });
            }, Seq$.MODULE$.canBuildFrom());
            QueryExecution qe = data.queryExecution();
            FileFormatWriter$.MODULE$.write(this.sparkSession, qe.executedPlan(), this.fileFormat, committer, new FileFormatWriter.OutputSpec(this.path, (Map<Map<String, String>, String>)Predef$.MODULE$.Map().empty(), (Seq<Attribute>)qe.analyzed().output()), this.hadoopConf(), (Seq<Attribute>)partitionColumns, (Option<BucketSpec>)None$.MODULE$, (Seq<WriteJobStatsTracker>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BasicWriteJobStatsTracker[]{this.basicWriteJobStatsTracker()}))), this.options);
        }
    }

    public String toString() {
        return new StringBuilder(10).append("FileSink[").append(this.path).append("]").toString();
    }

    public static final /* synthetic */ boolean $anonfun$addBatch$5(Function2 nameEquality$1, String col$1, Attribute f) {
        return BoxesRunTime.unboxToBoolean((Object)nameEquality$1.apply((Object)f.name(), (Object)col$1));
    }

    public FileStreamSink(SparkSession sparkSession, String path, FileFormat fileFormat, Seq<String> partitionColumnNames, Map<String, String> options) {
        this.sparkSession = sparkSession;
        this.path = path;
        this.fileFormat = fileFormat;
        this.partitionColumnNames = partitionColumnNames;
        this.options = options;
        Sink.$init$(this);
        Logging.$init$((Logging)this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.basePath = new Path(path);
        Path metadataDir = new Path(this.basePath(), FileStreamSink$.MODULE$.metadataDir());
        FileSystem fs = metadataDir.getFileSystem(this.hadoopConf());
        FileStreamSink$.MODULE$.checkEscapedMetadataPath(fs, metadataDir, sparkSession.sessionState().conf());
        this.logPath = metadataDir;
        this.fileLog = new FileStreamSinkLog(FileStreamSinkLog$.MODULE$.VERSION(), sparkSession, this.logPath().toString());
    }
}

