/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\t\u0005g\u0001\u0002\u0012$\u00019B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0007\u0001\u0002!\t!J!\t\u0011\u0015\u0003!\u0019!C\u0001K\u0019Ca\u0001\u0015\u0001!\u0002\u00139\u0005bB)\u0001\u0005\u0004%IA\u0015\u0005\u0007/\u0002\u0001\u000b\u0011B*\t\u000fa\u0003!\u0019!C\u00053\"1Q\u000e\u0001Q\u0001\niCqa\u001f\u0001C\u0002\u0013%A\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011B?\t\u0011\u0005%\u0001A1A\u0005\nqDq!a\u0003\u0001A\u0003%Q\u0010C\u0005\u0002\u000e\u0001\u0001\r\u0011\"\u0003\u0002\u0010!I\u0011\u0011\u0003\u0001A\u0002\u0013%\u00111\u0003\u0005\b\u0003?\u0001\u0001\u0015)\u0003k\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u00020\u0001!\t!a\u000e\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005e\u0005bBA\\\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!!4\u0001\t\u0003\ty\r\u0003\u0005\u0002T\u0002!\t!JAk\u0011\u001d\tI\u000f\u0001C\u0005\u0003WD\u0001B!\u001b\u0001\t\u0003)#1\u000e\u0005\u000b\u0005\u0003\u0003\u0011\u0013!C\u0001K\t\r\u0005B\u0003BL\u0001E\u0005I\u0011A\u0013\u0003\u0004\"Q!\u0011\u0014\u0001\u0012\u0002\u0013\u0005QEa'\t\u0015\t}\u0005!%A\u0005\u0002\u0015\u0012\t\u000b\u0003\u0005\u0003&\u0002!\t!\nBT\u0011\u001d\u0011i\u000b\u0001C\u0005\u0005_\u0013Qc\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180T1oC\u001e,'O\u0003\u0002%K\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0004\u0001=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g\r\u0005\u00027s5\tqG\u0003\u00029O\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002;o\t9Aj\\4hS:<\u0017\u0001D:qCJ\\7+Z:tS>t\u0007CA\u001f?\u001b\u0005)\u0013BA &\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019a\u0014N\\5u}Q\u0011!\t\u0012\t\u0003\u0007\u0002i\u0011a\t\u0005\u0006w\t\u0001\r\u0001P\u0001\u0016gR\fG/Z*u_J,7i\\8sI&t\u0017\r^8s+\u00059\u0005C\u0001%O\u001b\u0005I%B\u0001&L\u0003\u0015\u0019H/\u0019;f\u0015\t!CJ\u0003\u0002NK\u0005IQ\r_3dkRLwN\\\u0005\u0003\u001f&\u0013\u0001d\u0015;bi\u0016\u001cFo\u001c:f\u0007>|'\u000fZ5oCR|'OU3g\u0003Y\u0019H/\u0019;f'R|'/Z\"p_J$\u0017N\\1u_J\u0004\u0013a\u00037jgR,g.\u001a:CkN,\u0012a\u0015\t\u0003)Vk\u0011aS\u0005\u0003-.\u0013\u0011d\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM\u001d\"vg\u0006aA.[:uK:,'OQ;tA\u0005i\u0011m\u0019;jm\u0016\fV/\u001a:jKN,\u0012A\u0017\t\u00057\u0002\u0014'.D\u0001]\u0015\tif,A\u0004nkR\f'\r\\3\u000b\u0005}\u000b\u0014AC2pY2,7\r^5p]&\u0011\u0011\r\u0018\u0002\b\u0011\u0006\u001c\b.T1q!\t\u0019\u0007.D\u0001e\u0015\t)g-\u0001\u0003vi&d'\"A4\u0002\t)\fg/Y\u0005\u0003S\u0012\u0014A!V+J\tB\u00111i[\u0005\u0003Y\u000e\u0012ab\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180\u0001\bbGRLg/Z)vKJLWm\u001d\u0011)\t!y\u0017P\u001f\t\u0003a^l\u0011!\u001d\u0006\u0003eN\f!bY8oGV\u0014(/\u001a8u\u0015\t!X/\u0001\u0006b]:|G/\u0019;j_:T\u0011A^\u0001\u0006U\u00064\u0018\r_\u0005\u0003qF\u0014\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0003m\f\u0011#Y2uSZ,\u0017+^3sS\u0016\u001cHj\\2l+\u0005i\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002\u0019\fA\u0001\\1oO&\u0019\u0011QA@\u0003\r=\u0013'.Z2u\u0003I\t7\r^5wKF+XM]5fg2{7m\u001b\u0011\u0002)\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>tGj\\2l\u0003U\tw/Y5u)\u0016\u0014X.\u001b8bi&|g\u000eT8dW\u0002\n1\u0003\\1tiR+'/\\5oCR,G-U;fef,\u0012A[\u0001\u0018Y\u0006\u001cH\u000fV3s[&t\u0017\r^3e#V,'/_0%KF$B!!\u0006\u0002\u001cA\u0019\u0001'a\u0006\n\u0007\u0005e\u0011G\u0001\u0003V]&$\b\u0002CA\u000f\u001d\u0005\u0005\t\u0019\u00016\u0002\u0007a$\u0013'\u0001\u000bmCN$H+\u001a:nS:\fG/\u001a3Rk\u0016\u0014\u0018\u0010\t\u0015\u0006\u001f=L\u00181E\u0011\u0003\u0003\u0013\ta!Y2uSZ,WCAA\u0015!\u0011\u0001\u00141\u00066\n\u0007\u00055\u0012GA\u0003BeJ\f\u00170A\u0002hKR$2A[A\u001a\u0011\u0019\t)$\u0005a\u0001E\u0006\u0011\u0011\u000e\u001a\u000b\u0004U\u0006e\u0002bBA\u001b%\u0001\u0007\u00111\b\t\u0005\u0003{\tYE\u0004\u0003\u0002@\u0005\u001d\u0003cAA!c5\u0011\u00111\t\u0006\u0004\u0003\u000bj\u0013A\u0002\u001fs_>$h(C\u0002\u0002JE\na\u0001\u0015:fI\u00164\u0017\u0002BA'\u0003\u001f\u0012aa\u0015;sS:<'bAA%c\u0005\u0019\u0012m^1ji\u0006s\u0017\u0010V3s[&t\u0017\r^5p]R\u0011\u0011Q\u0003\u0015\u0006'\u0005]\u00131\r\t\u0006a\u0005e\u0013QL\u0005\u0004\u00037\n$A\u0002;ie><8\u000fE\u0002D\u0003?J1!!\u0019$\u0005]\u0019FO]3b[&tw-U;fef,\u0005pY3qi&|g.M\u0004\u001f\u0003w\t)'a&2\u0013\r\n9'a\u001c\u0002\u000e\u0006ET\u0003BA5\u0003W*\"!a\u000f\u0005\u000f\u00055TF1\u0001\u0002x\t\tA+\u0003\u0003\u0002r\u0005M\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002vE\na\u0001\u001e5s_^\u001c\u0018\u0003BA=\u0003\u007f\u00022\u0001MA>\u0013\r\ti(\r\u0002\b\u001d>$\b.\u001b8h!\u0011\t\t)a\"\u000f\u0007A\n\u0019)C\u0002\u0002\u0006F\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\n\u0006-%!\u0003+ie><\u0018M\u00197f\u0015\r\t))M\u0019\nG\u0005=\u0015\u0011SAJ\u0003kr1\u0001MAI\u0013\r\t)(M\u0019\u0006EA\n\u0014Q\u0013\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005uC\u0003BAN\u0003C\u00032\u0001MAO\u0013\r\ty*\r\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\u000b\u0006a\u0001\u0003K\u000b\u0011\u0002^5nK>,H/T:\u0011\u0007A\n9+C\u0002\u0002*F\u0012A\u0001T8oO\"*A#a\u0016\u0002.F:a$a\u000f\u00020\u0006U\u0016'C\u0012\u0002h\u0005=\u0014\u0011WA9c%\u0019\u0013qRAI\u0003g\u000b)(M\u0003#aE\n)*M\u0002'\u0003;\nqB]3tKR$VM]7j]\u0006$X\rZ\u0001\fC\u0012$G*[:uK:,'\u000f\u0006\u0003\u0002\u0016\u0005u\u0006bBA`-\u0001\u0007\u0011\u0011Y\u0001\tY&\u001cH/\u001a8feB\u00191)a1\n\u0007\u0005\u00157E\u0001\fTiJ,\u0017-\\5oOF+XM]=MSN$XM\\3s\u00039\u0011X-\\8wK2K7\u000f^3oKJ$B!!\u0006\u0002L\"9\u0011qX\fA\u0002\u0005\u0005\u0017!\u00047jgRd\u0015n\u001d;f]\u0016\u00148\u000f\u0006\u0002\u0002RB)\u0001'a\u000b\u0002B\u0006\t\u0002o\\:u\u0019&\u001cH/\u001a8fe\u00163XM\u001c;\u0015\t\u0005U\u0011q\u001b\u0005\b\u00033L\u0002\u0019AAn\u0003\u0015)g/\u001a8u!\u0011\ti.a9\u000f\u0007\r\u000by.C\u0002\u0002b\u000e\nac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM]\u0005\u0005\u0003K\f9OA\u0003Fm\u0016tGOC\u0002\u0002b\u000e\n1b\u0019:fCR,\u0017+^3ssR1\u0012Q^Az\u0003{\u0014\tA!\t\u0003,\t}\"\u0011\nB'\u0005#\u0012Y\u0006E\u0002U\u0003_L1!!=L\u0005U\u0019FO]3b[&tw-U;fef<&/\u00199qKJDq!!>\u001b\u0001\u0004\t90A\tvg\u0016\u00148\u000b]3dS\u001aLW\r\u001a(b[\u0016\u0004R\u0001MA}\u0003wI1!a?2\u0005\u0019y\u0005\u000f^5p]\"9\u0011q \u000eA\u0002\u0005]\u0018aH;tKJ\u001c\u0006/Z2jM&,Gm\u00115fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]\"9!1\u0001\u000eA\u0002\t\u0015\u0011A\u00013g!\u0011\u00119Aa\u0007\u000f\t\t%!\u0011\u0004\b\u0005\u0005\u0017\u00119B\u0004\u0003\u0003\u000e\tUa\u0002\u0002B\b\u0005'qA!!\u0011\u0003\u0012%\tA&\u0003\u0002+W%\u0011\u0001&K\u0005\u0003M\u001dJ1!!\"&\u0013\u0011\u0011iBa\b\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAACK!9!1\u0005\u000eA\u0002\t\u0015\u0012\u0001D3yiJ\fw\n\u001d;j_:\u001c\b\u0003CA\u001f\u0005O\tY$a\u000f\n\t\t%\u0012q\n\u0002\u0004\u001b\u0006\u0004\bb\u0002B\u00175\u0001\u0007!qF\u0001\u0005g&t7\u000e\u0005\u0003\u00032\tmRB\u0001B\u001a\u0015\u0011\u0011)Da\u000e\u0002\u000f\r\fG/\u00197pO*\u0019!\u0011H\u0013\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002\u0002B\u001f\u0005g\u0011Q\u0001V1cY\u0016DqA!\u0011\u001b\u0001\u0004\u0011\u0019%\u0001\u0006pkR\u0004X\u000f^'pI\u0016\u00042a\u0011B#\u0013\r\u00119e\t\u0002\u000b\u001fV$\b/\u001e;N_\u0012,\u0007b\u0002B&5\u0001\u0007\u00111T\u0001\u001akN,G+Z7q\u0007\",7m\u001b9pS:$Hj\\2bi&|g\u000eC\u0004\u0003Pi\u0001\r!a'\u0002;I,7m\u001c<fe\u001a\u0013x.\\\"iK\u000e\\\u0007o\\5oi2{7-\u0019;j_:DqAa\u0015\u001b\u0001\u0004\u0011)&A\u0004ue&<w-\u001a:\u0011\u0007\r\u00139&C\u0002\u0003Z\r\u0012q\u0001\u0016:jO\u001e,'\u000fC\u0004\u0003^i\u0001\rAa\u0018\u0002\u0019Q\u0014\u0018nZ4fe\u000ecwnY6\u0011\t\t\u0005$QM\u0007\u0003\u0005GR!!Z\u0014\n\t\t\u001d$1\r\u0002\u0006\u00072|7m[\u0001\u000bgR\f'\u000f^)vKJLH#\u00066\u0003n\t=$\u0011\u000fB:\u0005k\u00129H!\u001f\u0003|\tu$q\u0010\u0005\b\u0003k\\\u0002\u0019AA|\u0011\u001d\typ\u0007a\u0001\u0003oDqAa\u0001\u001c\u0001\u0004\u0011)\u0001C\u0004\u0003$m\u0001\rA!\n\t\u000f\t52\u00041\u0001\u00030!9!\u0011I\u000eA\u0002\t\r\u0003\"\u0003B&7A\u0005\t\u0019AAN\u0011%\u0011ye\u0007I\u0001\u0002\u0004\tY\nC\u0005\u0003Tm\u0001\n\u00111\u0001\u0003V!I!QL\u000e\u0011\u0002\u0003\u0007!qL\u0001\u0015gR\f'\u000f^)vKJLH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t\u0015%\u0006BAN\u0005\u000f[#A!#\u0011\t\t-%1S\u0007\u0003\u0005\u001bSAAa$\u0003\u0012\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003iFJAA!&\u0003\u000e\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139\u0003Q\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!Q\u0014\u0016\u0005\u0005+\u00129)A\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$H%\r\u0019\u0016\u0005\t\r&\u0006\u0002B0\u0005\u000f\u000baC\\8uS\u001aL\u0018+^3ssR+'/\\5oCRLwN\u001c\u000b\u0005\u0003+\u0011I\u000b\u0003\u0004\u0003,\u0002\u0002\rA[\u0001\u0010i\u0016\u0014X.\u001b8bi\u0016$\u0017+^3ss\u0006QRO\u001c:fO&\u001cH/\u001a:UKJl\u0017N\\1uK\u0012\u001cFO]3b[R!\u0011Q\u0003BY\u0011\u0019\u0011\u0019,\ta\u0001E\u0006\tB/\u001a:nS:\fG/\u001a3Rk\u0016\u0014\u00180\u00133)\u0007\u0001\u00119\f\u0005\u0003\u0003:\nuVB\u0001B^\u0015\t!x%\u0003\u0003\u0003@\nm&\u0001C#w_24\u0018N\\4")
public class StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private StreamingQuery lastTerminatedQuery;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesLock() {
        return this.activeQueriesLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private StreamingQuery lastTerminatedQuery() {
        return this.lastTerminatedQuery;
    }

    private void lastTerminatedQuery_$eq(StreamingQuery x$1) {
        this.lastTerminatedQuery = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.nanoTime();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(startTime, timeoutMs) && this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
            bl = this.lastTerminatedQuery() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQuery_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public StreamingQueryListener[] listListeners() {
        return (StreamingQueryListener[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.listenerBus().listeners()).asScala()).toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        Tuple2 tuple2;
        Path checkpointPath;
        FileSystem fs;
        BooleanRef deleteCheckpointOnStop = BooleanRef.create((boolean)false);
        String checkpointLocation = (String)userSpecifiedCheckpointLocation.map((Function1 & Serializable & scala.Serializable)userSpecified -> new Path(userSpecified).toString()).orElse((Function0 & Serializable & scala.Serializable)() -> df.sparkSession().sessionState().conf().checkpointLocation().map((Function1 & Serializable & scala.Serializable)location -> new Path(location, (String)userSpecifiedName.getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var3_5;
            if (!useTempCheckpointLocation) {
                throw new AnalysisException(new StringBuilder(119).append("checkpointLocation must be specified either through option(\"checkpointLocation\", ...) or ").append("SparkSession.conf.set(\"").append(SQLConf$.MODULE$.CHECKPOINT_LOCATION().key()).append("\", ...)").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            deleteCheckpointOnStop$1.elem = true;
            String x$1 = "temporary";
            String x$2 = Utils$.MODULE$.createTempDir$default$1();
            String tempDir = Utils$.MODULE$.createTempDir(x$2, x$1).getCanonicalPath();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(235).append("Temporary checkpoint location created which is deleted normally when").append(" the query didn't fail: ").append(tempDir).append(". If it's required to delete it under any").append(" circumstances, please set ").append(SQLConf$.MODULE$.FORCE_DELETE_TEMP_CHECKPOINT_LOCATION().key()).append(" to").append(" true. Important to know deleting temp checkpoint folder is best effort.").toString());
            return var3_5;
        });
        if (!recoverFromCheckpointLocation && (fs = (checkpointPath = new Path(checkpointLocation, "offsets")).getFileSystem(df.sparkSession().sessionState().newHadoopConf())).exists(checkpointPath)) {
            throw new AnalysisException(new StringBuilder(87).append("This query does not support recovering from checkpoint location. ").append("Delete ").append(checkpointPath).append(" to start over.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        boolean operationCheckEnabled = this.sparkSession.sessionState().conf().isUnsupportedOperationCheckEnabled();
        if (this.sparkSession.sessionState().conf().adaptiveExecutionEnabled()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append(SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()).append(" ").append("is not supported in streaming DataFrames/Datasets and will be disabled.").toString());
        }
        if ((tuple2 = new Tuple2((Object)sink, (Object)trigger)) != null) {
            Table table = (Table)tuple2._1();
            Trigger trigger2 = (Trigger)tuple2._2();
            if (table instanceof SupportsWrite) {
                SupportsWrite supportsWrite = (SupportsWrite)table;
                if (trigger2 instanceof ContinuousTrigger) {
                    ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
                    if (!operationCheckEnabled) return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, supportsWrite, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
                    UnsupportedOperationChecker$.MODULE$.checkForContinuous(analyzedPlan, outputMode);
                    return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, supportsWrite, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
                }
            }
        }
        if (!operationCheckEnabled) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        UnsupportedOperationChecker$.MODULE$.checkForStreaming(analyzedPlan, outputMode);
        return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
    }

    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock);
        Object object = this.activeQueriesLock();
        synchronized (object) {
            userSpecifiedName.foreach((Function1 & Serializable & scala.Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            Option activeOption = Option$.MODULE$.apply((Object)this.sparkSession.sharedState().activeStreamingQueries().putIfAbsent(query.id(), this));
            if (activeOption.isDefined() || this.activeQueries().values().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$3(query, x$2)))) {
                throw new IllegalStateException(new StringBuilder(162).append("Cannot start query with id ").append(query.id()).append(" as another query with same id is ").append("already active. Perhaps you are attempting to restart a query from checkpoint ").append("that is already active.").toString());
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
        }
        catch (Throwable e) {
            this.unregisterTerminatedStream(query.id());
            throw e;
        }
        return query;
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return Trigger.ProcessingTime(0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        this.unregisterTerminatedStream(terminatedQuery.id());
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            if (this.lastTerminatedQuery() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQuery_$eq(terminatedQuery);
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    private void unregisterTerminatedStream(UUID terminatedQueryId) {
        Object object = this.activeQueriesLock();
        synchronized (object) {
            this.sparkSession.sharedState().activeStreamingQueries().remove(terminatedQueryId, this);
            this.activeQueries().$minus$eq((Object)terminatedQueryId);
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Registered listener ").append(listener.getClass().getName()).toString());
    }

    public static final /* synthetic */ void $anonfun$new$1(StreamingQueryManager $this, Seq classNames) {
        Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, $this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable & scala.Serializable)listener -> {
            StreamingQueryManager.$anonfun$new$2($this, listener);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean isTimedout$1(long startTime$1, long timeoutMs$1) {
        return System.nanoTime() - startTime$1 >= TimeUnit.MILLISECONDS.toNanos(timeoutMs$1);
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$1)))) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot start query with name ").append(name).append(" as a query with that name is already active").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$3(StreamingQueryWrapper query$1, StreamingQuery x$2) {
        UUID uUID = x$2.id();
        UUID uUID2 = query$1.id();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public StreamingQueryManager(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env());
        this.listenerBus = new StreamingQueryListenerBus(sparkSession.sparkContext().listenerBus());
        this.activeQueries = new HashMap();
        this.activeQueriesLock = new Object();
        this.awaitTerminationLock = new Object();
        this.lastTerminatedQuery = null;
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable & scala.Serializable)classNames -> {
                StreamingQueryManager.$anonfun$new$1(this, classNames);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw new SparkException("Exception when registering StreamingQueryListener", (Throwable)e);
        }
    }
}

