/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.spark.SparkException;
import org.apache.spark.sql.execution.datasources.orc.OrcFiltersBase;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Not$;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class OrcFilters$
implements OrcFiltersBase {
    public static OrcFilters$ MODULE$;

    static {
        new OrcFilters$();
    }

    @Override
    public Option<Filter> buildTree(Seq<Filter> filters) {
        return OrcFiltersBase.buildTree$(this, filters);
    }

    @Override
    public String quoteAttributeNameIfNeeded(String name) {
        return OrcFiltersBase.quoteAttributeNameIfNeeded$(this, name);
    }

    @Override
    public boolean isSearchableType(DataType dataType) {
        return OrcFiltersBase.isSearchableType$(this, dataType);
    }

    public Option<SearchArgument> createFilter(StructType schema, Seq<Filter> filters) {
        Map dataTypeMap = ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.dataType()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Option<Filter> conjunctionOptional = this.buildTree(this.convertibleFilters(schema, (Map<String, DataType>)dataTypeMap, filters));
        return conjunctionOptional.map((Function1 & Serializable & scala.Serializable)conjunction -> MODULE$.buildSearchArgument((Map<String, DataType>)dataTypeMap, (Filter)conjunction, SearchArgumentFactory.newBuilder()).build());
    }

    public Seq<Filter> convertibleFilters(StructType schema, Map<String, DataType> dataTypeMap, Seq<Filter> filters) {
        return (Seq)filters.flatMap((Function1 & Serializable & scala.Serializable)filter -> Option$.MODULE$.option2Iterable(this.convertibleFiltersHelper$1((Filter)filter, true, (Map)dataTypeMap)), Seq$.MODULE$.canBuildFrom());
    }

    private PredicateLeaf.Type getPredicateLeafType(DataType dataType) {
        PredicateLeaf.Type type;
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            type = PredicateLeaf.Type.BOOLEAN;
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : LongType$.MODULE$.equals(dataType2)));
            if (bl) {
                type = PredicateLeaf.Type.LONG;
            } else {
                boolean bl2 = FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2);
                if (bl2) {
                    type = PredicateLeaf.Type.FLOAT;
                } else if (StringType$.MODULE$.equals(dataType2)) {
                    type = PredicateLeaf.Type.STRING;
                } else if (DateType$.MODULE$.equals(dataType2)) {
                    type = PredicateLeaf.Type.DATE;
                } else if (TimestampType$.MODULE$.equals(dataType2)) {
                    type = PredicateLeaf.Type.TIMESTAMP;
                } else if (dataType2 instanceof DecimalType) {
                    type = PredicateLeaf.Type.DECIMAL;
                } else {
                    throw new UnsupportedOperationException(new StringBuilder(10).append("DataType: ").append(dataType.catalogString()).toString());
                }
            }
        }
        return type;
    }

    private Object castLiteralValue(Object value, DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        boolean bl2 = ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : LongType$.MODULE$.equals(dataType2)));
        Object object = bl2 ? BoxesRunTime.boxToLong((long)((Number)value).longValue()) : ((bl = FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2)) ? BoxesRunTime.boxToDouble((double)((Number)value).doubleValue()) : (dataType2 instanceof DecimalType ? new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)value))) : value));
        return object;
    }

    private SearchArgument.Builder buildSearchArgument(Map<String, DataType> dataTypeMap, Filter expression, SearchArgument.Builder builder) {
        SearchArgument.Builder builder2;
        Filter filter = expression;
        if (filter instanceof And) {
            And and = (And)filter;
            Filter left = and.left();
            Filter right = and.right();
            SearchArgument.Builder lhs = this.buildSearchArgument(dataTypeMap, left, builder.startAnd());
            SearchArgument.Builder rhs = this.buildSearchArgument(dataTypeMap, right, lhs);
            builder2 = rhs.end();
        } else if (filter instanceof Or) {
            Or or = (Or)filter;
            Filter left = or.left();
            Filter right = or.right();
            SearchArgument.Builder lhs = this.buildSearchArgument(dataTypeMap, left, builder.startOr());
            SearchArgument.Builder rhs = this.buildSearchArgument(dataTypeMap, right, lhs);
            builder2 = rhs.end();
        } else if (filter instanceof Not) {
            Not not = (Not)filter;
            Filter child = not.child();
            builder2 = this.buildSearchArgument(dataTypeMap, child, builder.startNot()).end();
        } else {
            builder2 = (SearchArgument.Builder)this.buildLeafSearchArgument(dataTypeMap, filter, builder).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new SparkException("The input filter of OrcFilters.buildSearchArgument should be fully convertible.");
            });
        }
        return builder2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<SearchArgument.Builder> buildLeafSearchArgument(Map<String, DataType> dataTypeMap, Filter expression, SearchArgument.Builder builder) {
        IsNotNull isNotNull;
        String attribute;
        IsNull isNull;
        String attribute2;
        Filter filter = expression;
        if (filter instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter;
            String attribute3 = equalTo.attribute();
            Object value = equalTo.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute3))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute3);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute3));
                return new Some((Object)builder.startAnd().equals(quotedName, this.getType$1(attribute3, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
            String attribute4 = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute4))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute4);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute4));
                return new Some((Object)builder.startAnd().nullSafeEquals(quotedName, this.getType$1(attribute4, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof LessThan) {
            LessThan lessThan = (LessThan)filter;
            String attribute5 = lessThan.attribute();
            Object value = lessThan.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute5))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute5);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute5));
                return new Some((Object)builder.startAnd().lessThan(quotedName, this.getType$1(attribute5, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
            String attribute6 = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute6))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute6);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute6));
                return new Some((Object)builder.startAnd().lessThanEquals(quotedName, this.getType$1(attribute6, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter;
            String attribute7 = greaterThan.attribute();
            Object value = greaterThan.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute7))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute7);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute7));
                return new Some((Object)builder.startNot().lessThanEquals(quotedName, this.getType$1(attribute7, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
            String attribute8 = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute8))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute8);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute8));
                return new Some((Object)builder.startNot().lessThan(quotedName, this.getType$1(attribute8, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof IsNull && this.isSearchableType((DataType)dataTypeMap.apply((Object)(attribute2 = (isNull = (IsNull)filter).attribute())))) {
            String quotedName = this.quoteAttributeNameIfNeeded(attribute2);
            return new Some((Object)builder.startAnd().isNull(quotedName, this.getType$1(attribute2, dataTypeMap)).end());
        }
        if (filter instanceof IsNotNull && this.isSearchableType((DataType)dataTypeMap.apply((Object)(attribute = (isNotNull = (IsNotNull)filter).attribute())))) {
            String quotedName = this.quoteAttributeNameIfNeeded(attribute);
            return new Some((Object)builder.startNot().isNull(quotedName, this.getType$1(attribute, dataTypeMap)).end());
        }
        if (!(filter instanceof In)) return None$.MODULE$;
        In in = (In)filter;
        String attribute9 = in.attribute();
        Object[] values = in.values();
        if (!this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute9))) return None$.MODULE$;
        String quotedName = this.quoteAttributeNameIfNeeded(attribute9);
        Object[] castedValues = (Object[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.castLiteralValue(v, (DataType)dataTypeMap.apply((Object)attribute9)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        return new Some((Object)builder.startAnd().in(quotedName, this.getType$1(attribute9, dataTypeMap), (Object[])Predef$.MODULE$.genericArrayOps((Object)castedValues).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.AnyRef()))).end());
    }

    public static final /* synthetic */ Option $anonfun$convertibleFilters$1(OrcFilters$ $this, Filter right$1, boolean canPartialPushDown$1, Map dataTypeMap$2, Filter lhs) {
        return $this.convertibleFiltersHelper$1(right$1, canPartialPushDown$1, dataTypeMap$2).map((Function1 & Serializable & scala.Serializable)rhs -> new Or(lhs, rhs));
    }

    public static final /* synthetic */ Filter $anonfun$convertibleFilters$3(Filter x1$1, SearchArgument.Builder _) {
        return x1$1;
    }

    /*
     * Unable to fully structure code
     */
    private final Option convertibleFiltersHelper$1(Filter filter, boolean canPartialPushDown, Map dataTypeMap$2) {
        block10: {
            block6: {
                block8: {
                    block9: {
                        block7: {
                            var6_4 = filter;
                            if (!(var6_4 instanceof And)) break block6;
                            var7_5 = (And)var6_4;
                            left = var7_5.left();
                            right = var7_5.right();
                            leftResultOptional = this.convertibleFiltersHelper$1(left, canPartialPushDown, dataTypeMap$2);
                            var12_10 = new Tuple2((Object)leftResultOptional, (Object)(rightResultOptional = this.convertibleFiltersHelper$1(right, canPartialPushDown, dataTypeMap$2)));
                            if (var12_10 == null) break block7;
                            var13_11 = (Option)var12_10._1();
                            var14_12 = (Option)var12_10._2();
                            if (!(var13_11 instanceof Some)) break block7;
                            var15_13 = (Some)var13_11;
                            leftResult = (Filter)var15_13.value();
                            if (!(var14_12 instanceof Some)) break block7;
                            var17_15 = (Some)var14_12;
                            rightResult = (Filter)var17_15.value();
                            var5_17 = new Some((Object)new And(leftResult, rightResult));
                            break block8;
                        }
                        if (var12_10 == null) break block9;
                        var19_18 = (Option)var12_10._1();
                        var20_19 = (Option)var12_10._2();
                        if (!(var19_18 instanceof Some)) break block9;
                        var21_20 = (Some)var19_18;
                        leftResult = (Filter)var21_20.value();
                        if (!None$.MODULE$.equals(var20_19) || !canPartialPushDown) break block9;
                        var5_17 = new Some((Object)leftResult);
                        break block8;
                    }
                    if (var12_10 == null) ** GOTO lbl-1000
                    var23_22 = (Option)var12_10._1();
                    var24_23 = (Option)var12_10._2();
                    if (!None$.MODULE$.equals(var23_22) || !(var24_23 instanceof Some)) ** GOTO lbl-1000
                    var25_24 = (Some)var24_23;
                    rightResult = (Filter)var25_24.value();
                    if (canPartialPushDown) {
                        var5_17 = new Some((Object)rightResult);
                    } else lbl-1000:
                    // 3 sources

                    {
                        var5_17 = None$.MODULE$;
                    }
                }
                var4_26 = var5_17;
                break block10;
            }
            if (var6_4 instanceof Or) {
                var27_27 = (Or)var6_4;
                left = var27_27.left();
                right = var27_27.right();
                var4_26 = this.convertibleFiltersHelper$1(left, canPartialPushDown, dataTypeMap$2).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$convertibleFilters$1(org.apache.spark.sql.execution.datasources.orc.OrcFilters$ org.apache.spark.sql.sources.Filter boolean scala.collection.immutable.Map org.apache.spark.sql.sources.Filter ), (Lorg/apache/spark/sql/sources/Filter;)Lscala/Option;)((OrcFilters$)this, (Filter)right, (boolean)canPartialPushDown, (Map)dataTypeMap$2));
            } else if (var6_4 instanceof Not) {
                var30_30 = (Not)var6_4;
                pred = var30_30.child();
                childResultOptional = this.convertibleFiltersHelper$1(pred, false, dataTypeMap$2);
                var4_26 = childResultOptional.map((Function1)Not$.MODULE$);
            } else {
                var4_26 = this.buildLeafSearchArgument((Map<String, DataType>)dataTypeMap$2, var6_4, SearchArgumentFactory.newBuilder()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$convertibleFilters$3(org.apache.spark.sql.sources.Filter org.apache.hadoop.hive.ql.io.sarg.SearchArgument$Builder ), (Lorg/apache/hadoop/hive/ql/io/sarg/SearchArgument$Builder;)Lorg/apache/spark/sql/sources/Filter;)((Filter)var6_4));
            }
        }
        return var4_26;
    }

    private final PredicateLeaf.Type getType$1(String attribute, Map dataTypeMap$3) {
        return this.getPredicateLeafType((DataType)dataTypeMap$3.apply((Object)attribute));
    }

    private OrcFilters$() {
        MODULE$ = this;
        OrcFiltersBase.$init$(this);
    }
}

