/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u0014)\u0001]BQ!\u0014\u0001\u0005\u00029+A!\u0015\u0001\u0005%\"IA\r\u0001a\u0001\u0002\u0004%I!\u001a\u0005\nY\u0002\u0001\r\u00111A\u0005\n5D\u0011\u0002\u001d\u0001A\u0002\u0003\u0005\u000b\u0015\u00024\t\u0013E\u0004\u0001\u0019!a\u0001\n\u0013\u0011\b\"\u0003=\u0001\u0001\u0004\u0005\r\u0011\"\u0003z\u0011%Y\b\u00011A\u0001B\u0003&1\u000fC\u0005}\u0001\u0001\u0007\t\u0019!C\u0005{\"Y\u00111\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0007\u0011)\t\t\u0002\u0001a\u0001\u0002\u0003\u0006KA \u0005\f\u0003'\u0001\u0001\u0019!a\u0001\n\u0013\t)\u0002C\u0006\u0002\u001e\u0001\u0001\r\u00111A\u0005\n\u0005}\u0001bCA\u0012\u0001\u0001\u0007\t\u0011)Q\u0005\u0003/A1\"!\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002(!Y\u0011Q\t\u0001A\u0002\u0003\u0007I\u0011BA$\u0011-\tY\u0005\u0001a\u0001\u0002\u0003\u0006K!!\u000b\t\u0013\u00055\u0003A1A\u0005\n\u0005=\u0003\u0002CA-\u0001\u0001\u0006I!!\u0015\t\u0013\u0005m\u0003A1A\u0005\n\u0005=\u0003\u0002CA/\u0001\u0001\u0006I!!\u0015\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u0011Q\u0014\u0001\u0005B\u0005}\u0005bBAR\u0001\u0011\u0005\u0013Q\u0015\u0005\b\u0003W\u0003A\u0011BAW\u0011\u001d\t9\f\u0001C\u0005\u0003sCq!!2\u0001\t\u0013\t9\rC\u0004\u0002R\u0002!\t!a5\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\"9\u0011Q\u001e\u0001\u0005\n\u0005=\bbBA~\u0001\u0011%\u0011Q \u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0002\u000f\u001d\u0011\t\u0003\u000bE\u0001\u0005G1aa\n\u0015\t\u0002\t\u0015\u0002BB'#\t\u0003\u0011i\u0003C\u0005\u00030\t\u0012\r\u0011\"\u0001\u00032!A!1\u0007\u0012!\u0002\u0013\u0011i\u0001C\u0004\u00036\t\"\tAa\u000e\u0003'A\u000b'/];fi^\u0013\u0018\u000e^3TkB\u0004xN\u001d;\u000b\u0005%R\u0013a\u00029beF,X\r\u001e\u0006\u0003W1\n1\u0002Z1uCN|WO]2fg*\u0011QFL\u0001\nKb,7-\u001e;j_:T!a\f\u0019\u0002\u0007M\fHN\u0003\u00022e\u0005)1\u000f]1sW*\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u001dH!\rIt(Q\u0007\u0002u)\u00111\bP\u0001\u0004CBL'BA\u001f?\u0003\u0019A\u0017\rZ8pa*\u0011\u0011FM\u0005\u0003\u0001j\u0012Ab\u0016:ji\u0016\u001cV\u000f\u001d9peR\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u0018\u0002\u0011\r\fG/\u00197zgRL!AR\"\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015B\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0019&\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fB\u0011\u0001\u000bA\u0007\u0002Q\tYa+\u00197vK^\u0013\u0018\u000e^3s!\u0015\u0019f\u000b\u00170b\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&!\u0003$v]\u000e$\u0018n\u001c83!\tIF,D\u0001[\u0015\tY6)A\u0006fqB\u0014Xm]:j_:\u001c\u0018BA/[\u0005I\u0019\u0006/Z2jC2L'0\u001a3HKR$XM]:\u0011\u0005M{\u0016B\u00011U\u0005\rIe\u000e\u001e\t\u0003'\nL!a\u0019+\u0003\tUs\u0017\u000e^\u0001\u0007g\u000eDW-\\1\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b\u0018\u0002\u000bQL\b/Z:\n\u0005-D'AC*ueV\u001cG\u000fV=qK\u0006Q1o\u00195f[\u0006|F%Z9\u0015\u0005\u0005t\u0007bB8\u0005\u0003\u0003\u0005\rAZ\u0001\u0004q\u0012\n\u0014aB:dQ\u0016l\u0017\rI\u0001\u0011e>|GOR5fY\u0012<&/\u001b;feN,\u0012a\u001d\t\u0004'R4\u0018BA;U\u0005\u0015\t%O]1z!\t9(!D\u0001\u0001\u0003Q\u0011xn\u001c;GS\u0016dGm\u0016:ji\u0016\u00148o\u0018\u0013fcR\u0011\u0011M\u001f\u0005\b_\u001e\t\t\u00111\u0001t\u0003E\u0011xn\u001c;GS\u0016dGm\u0016:ji\u0016\u00148\u000fI\u0001\u000fe\u0016\u001cwN\u001d3D_:\u001cX/\\3s+\u0005q\bcA@\u0002\b5\u0011\u0011\u0011\u0001\u0006\u0004w\u0005\r!bAA\u0003}\u0005\u0011\u0011n\\\u0005\u0005\u0003\u0013\t\tA\u0001\bSK\u000e|'\u000fZ\"p]N,X.\u001a:\u0002%I,7m\u001c:e\u0007>t7/^7fe~#S-\u001d\u000b\u0004C\u0006=\u0001bB8\u000b\u0003\u0003\u0005\rA`\u0001\u0010e\u0016\u001cwN\u001d3D_:\u001cX/\\3sA\u0005ArO]5uK2+w-Y2z!\u0006\u0014\u0018/^3u\r>\u0014X.\u0019;\u0016\u0005\u0005]\u0001cA*\u0002\u001a%\u0019\u00111\u0004+\u0003\u000f\t{w\u000e\\3b]\u0006arO]5uK2+w-Y2z!\u0006\u0014\u0018/^3u\r>\u0014X.\u0019;`I\u0015\fHcA1\u0002\"!Aq.DA\u0001\u0002\u0004\t9\"A\rxe&$X\rT3hC\u000eL\b+\u0019:rk\u0016$hi\u001c:nCR\u0004\u0013aE8viB,H\u000fV5nKN$\u0018-\u001c9UsB,WCAA\u0015!\u0011\tY#!\u0010\u000f\t\u00055\u0012q\u0007\b\u0005\u0003_\t\u0019$\u0004\u0002\u00022)\u0011!JL\u0005\u0005\u0003k\t\t$A\u0004T#2\u001buN\u001c4\n\t\u0005e\u00121H\u0001\u001b!\u0006\u0014\u0018/^3u\u001fV$\b/\u001e;US6,7\u000f^1naRK\b/\u001a\u0006\u0005\u0003k\t\t$\u0003\u0003\u0002@\u0005\u0005#!\u0002,bYV,\u0017bAA\")\nYQI\\;nKJ\fG/[8o\u0003]yW\u000f\u001e9viRKW.Z:uC6\u0004H+\u001f9f?\u0012*\u0017\u000fF\u0002b\u0003\u0013B\u0001b\u001c\t\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0015_V$\b/\u001e;US6,7\u000f^1naRK\b/\u001a\u0011\u0002\u001fQLW.Z:uC6\u0004()\u001e4gKJ,\"!!\u0015\u0011\tM#\u00181\u000b\t\u0004'\u0006U\u0013bAA,)\n!!)\u001f;f\u0003A!\u0018.\\3ti\u0006l\u0007OQ;gM\u0016\u0014\b%A\u0007eK\u000eLW.\u00197Ck\u001a4WM]\u0001\u000fI\u0016\u001c\u0017.\\1m\u0005V4g-\u001a:!\u0003\u0011Ig.\u001b;\u0015\t\u0005\r\u00141\u0012\t\u0005\u0003K\n)I\u0004\u0003\u0002h\u0005\u0005e\u0002BA5\u0003\u007frA!a\u001b\u0002~9!\u0011QNA>\u001d\u0011\ty'!\u001f\u000f\t\u0005E\u0014qO\u0007\u0003\u0003gR1!!\u001e7\u0003\u0019a$o\\8u}%\tQ'\u0003\u00024i%\u0011\u0011FM\u0005\u0003{yJ!a\u000f\u001f\n\u0007\u0005\r%(\u0001\u0007Xe&$XmU;qa>\u0014H/\u0003\u0003\u0002\b\u0006%%\u0001D,sSR,7i\u001c8uKb$(bAABu!9\u0011Q\u0012\fA\u0002\u0005=\u0015!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0003\u0002\u0012\u0006eUBAAJ\u0015\u0011\t)*a&\u0002\t\r|gN\u001a\u0006\u0003{IJA!a'\u0002\u0014\ni1i\u001c8gS\u001e,(/\u0019;j_:\fq\u0002\u001d:fa\u0006\u0014XMR8s/JLG/\u001a\u000b\u0004C\u0006\u0005\u0006\"\u0002?\u0018\u0001\u0004q\u0018!B<sSR,GcA1\u0002(\"1\u0011\u0011\u0016\rA\u0002\u0005\u000b1A]8x\u0003-9(/\u001b;f\r&,G\u000eZ:\u0015\u000f\u0005\fy+!-\u00024\"1\u0011\u0011V\rA\u0002\u0005CQ\u0001Z\rA\u0002\u0019Da!!.\u001a\u0001\u0004\u0019\u0018\u0001\u00044jK2$wK]5uKJ\u001c\u0018AC7bW\u0016<&/\u001b;feR\u0019a/a/\t\u000f\u0005u&\u00041\u0001\u0002@\u0006AA-\u0019;b)f\u0004X\rE\u0002h\u0003\u0003L1!a1i\u0005!!\u0015\r^1UsB,\u0017!E7bW\u0016$UmY5nC2<&/\u001b;feR)a/!3\u0002N\"1\u00111Z\u000eA\u0002y\u000b\u0011\u0002\u001d:fG&\u001c\u0018n\u001c8\t\r\u0005=7\u00041\u0001_\u0003\u0015\u00198-\u00197f\u0003=i\u0017m[3BeJ\f\u0017p\u0016:ji\u0016\u0014Hc\u0001<\u0002V\"9\u0011q\u001b\u000fA\u0002\u0005e\u0017!C1se\u0006LH+\u001f9f!\r9\u00171\\\u0005\u0004\u0003;D'!C!se\u0006LH+\u001f9f\u00035i\u0017m[3NCB<&/\u001b;feR\u0019a/a9\t\u000f\u0005\u0015X\u00041\u0001\u0002h\u00069Q.\u00199UsB,\u0007cA4\u0002j&\u0019\u00111\u001e5\u0003\u000f5\u000b\u0007\u000fV=qK\u0006q1m\u001c8tk6,W*Z:tC\u001e,GcA1\u0002r\"A\u00111\u001f\u0010\u0005\u0002\u0004\t)0A\u0001g!\u0011\u0019\u0016q_1\n\u0007\u0005eHK\u0001\u0005=Eft\u0017-\\3?\u00031\u0019wN\\:v[\u0016<%o\\;q)\r\t\u0017q \u0005\t\u0003g|B\u00111\u0001\u0002v\u0006a1m\u001c8tk6,g)[3mIR1!Q\u0001B\u0005\u0005;!2!\u0019B\u0004\u0011!\t\u0019\u0010\tCA\u0002\u0005U\bb\u0002B\u0006A\u0001\u0007!QB\u0001\u0006M&,G\u000e\u001a\t\u0005\u0005\u001f\u00119B\u0004\u0003\u0003\u0012\tM\u0001cAA9)&\u0019!Q\u0003+\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011IBa\u0007\u0003\rM#(/\u001b8h\u0015\r\u0011)\u0002\u0016\u0005\u0007\u0005?\u0001\u0003\u0019\u00010\u0002\u000b%tG-\u001a=\u0002'A\u000b'/];fi^\u0013\u0018\u000e^3TkB\u0004xN\u001d;\u0011\u0005A\u00133c\u0001\u0012\u0003(A\u00191K!\u000b\n\u0007\t-BK\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005G\t\u0001c\u0015)B%.{&kT,`'\u000eCU)T!\u0016\u0005\t5\u0011!E*Q\u0003J[uLU(X?N\u001b\u0005*R'BA\u0005I1/\u001a;TG\",W.\u0019\u000b\u0006C\ne\"1\b\u0005\u0006I\u001a\u0002\rA\u001a\u0005\b\u0003\u001b3\u0003\u0019AAH\u0001")
public class ParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void setSchema(StructType structType, Configuration configuration) {
        ParquetWriteSupport$.MODULE$.setSchema(structType, configuration);
    }

    public static String SPARK_ROW_SCHEMA() {
        return ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        Predef$.MODULE$.assert(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(new StringOps(Predef$.MODULE$.augmentString(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))).toBoolean());
        String key = SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(SQLConf.ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((TraversableOnce)((TraversableLike)this.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeWriter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.schema());
        java.util.Map metadata = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY()), (Object)org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)schemaString)}))).asJava();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("Initialized Parquet WriteSupport with Catalyst schema:\n         |").append(this.schema().prettyJson()).append("\n         |and corresponding Parquet message type:\n         |").append(messageType).append("\n       ").toString())).stripMargin());
        return new WriteSupport.WriteContext(messageType, metadata);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row, this.schema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType2) {
        Function2 & Serializable & scala.Serializable intersect;
        block21: {
            while (true) {
                DecimalType decimalType;
                Option option;
                DataType dataType3;
                if (BooleanType$.MODULE$.equals(dataType3 = dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (ByteType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (ShortType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                boolean bl = IntegerType$.MODULE$.equals(dataType3) ? true : DateType$.MODULE$.equals(dataType3);
                if (bl) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (LongType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (FloatType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (DoubleType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (StringType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (TimestampType$.MODULE$.equals(dataType3)) {
                    Function2 & Serializable & scala.Serializable intersect2;
                    Enumeration.Value value = this.outputTimestampType();
                    Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                            ParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                            return BoxedUnit.UNIT;
                        };
                    } else {
                        Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                ParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                return BoxedUnit.UNIT;
                            };
                        } else {
                            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                    ParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                    return BoxedUnit.UNIT;
                                };
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                    intersect = intersect2;
                    break block21;
                }
                if (BinaryType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType3)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    intersect = this.makeDecimalWriter(precision, scale);
                    break block21;
                }
                if (dataType3 instanceof StructType) {
                    StructType structType = (StructType)dataType3;
                    Function2[] fieldWriters = (Function2[])((TraversableOnce)((TraversableLike)structType.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeWriter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class));
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType3;
                    intersect = this.makeArrayWriter(arrayType);
                    break block21;
                }
                if (dataType3 instanceof MapType) {
                    MapType mapType = (MapType)dataType3;
                    intersect = this.makeMapWriter(mapType);
                    break block21;
                }
                if (!(dataType3 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = userDefinedType.sqlType();
            }
            throw scala.sys.package$.MODULE$.error(new StringBuilder(23).append("Unsupported data type ").append(dataType2).append(".").toString());
        }
        return intersect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(DecimalType$.MODULE$.MAX_PRECISION()).toString());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable & scala.Serializable int32Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable int64Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (true != bl3) return binaryWriterUsingUnscaledBytes;
        if (precision > Decimal$.MODULE$.MAX_LONG_DIGITS()) return binaryWriterUsingUnscaledBytes;
        return binaryWriterUsingUnscaledLong;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl4 = sp2._1$mcZ$sp();
        boolean bl5 = sp2._2$mcZ$sp();
        if (true != bl4) throw new MatchError((Object)sp2);
        if (false != bl5) throw new MatchError((Object)sp2);
        return this.twoLevelArrayWriter$1("array", elementWriter);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType());
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType());
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeMapWriter$1(this, repeatedGroupName, keyWriter, valueWriter, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(row.getLong(ordinal));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        Tuple2.mcIJ.sp sp3 = sp2;
        int julianDay2 = sp3._1$mcI$sp();
        long timeOfDayNanos2 = sp3._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long millis = DateTimeUtils$.MODULE$.toMillis(row.getLong(ordinal));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).head()) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(ParquetWriteSupport $this, String repeatedGroupName$1, String elementFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                if (array.isNullAt(i$2.elem)) break block0;
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$1(this, repeatedGroupName, elementFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(ParquetWriteSupport $this, String repeatedFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$6(this, repeatedFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(ParquetWriteSupport $this, String repeatedGroupName$2, Function2 keyWriter$1, Function2 valueWriter$1, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (map.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                if (map.valueArray().isNullAt(i$3.elem)) break block0;
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    public ParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
    }
}

