/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.schema.Type;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.SpecificParquetRecordReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedColumnReader;
import org.apache.spark.sql.execution.vectorized.ColumnVectorUtils;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class VectorizedParquetRecordReader
extends SpecificParquetRecordReaderBase<Object> {
    private int capacity;
    private int batchIdx = 0;
    private int numBatched = 0;
    private VectorizedColumnReader[] columnReaders;
    private long rowsReturned;
    private long totalCountLoadedSoFar = 0L;
    private boolean[] missingColumns;
    private TimeZone convertTz = null;
    private ColumnarBatch columnarBatch;
    private WritableColumnVector[] columnVectors;
    private boolean returnColumnarBatch;
    private final MemoryMode MEMORY_MODE;

    public VectorizedParquetRecordReader(TimeZone convertTz, boolean useOffHeap, int capacity) {
        this.convertTz = convertTz;
        this.MEMORY_MODE = useOffHeap ? MemoryMode.OFF_HEAP : MemoryMode.ON_HEAP;
        this.capacity = capacity;
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException, UnsupportedOperationException {
        super.initialize(inputSplit, taskAttemptContext);
        this.initializeInternal();
    }

    @Override
    public void initialize(String path, List<String> columns) throws IOException, UnsupportedOperationException {
        super.initialize(path, columns);
        this.initializeInternal();
    }

    @Override
    public void close() throws IOException {
        if (this.columnarBatch != null) {
            this.columnarBatch.close();
            this.columnarBatch = null;
        }
        super.close();
    }

    public boolean nextKeyValue() throws IOException {
        this.resultBatch();
        if (this.returnColumnarBatch) {
            return this.nextBatch();
        }
        if (this.batchIdx >= this.numBatched && !this.nextBatch()) {
            return false;
        }
        ++this.batchIdx;
        return true;
    }

    public Object getCurrentValue() {
        if (this.returnColumnarBatch) {
            return this.columnarBatch;
        }
        return this.columnarBatch.getRow(this.batchIdx - 1);
    }

    public float getProgress() {
        return (float)this.rowsReturned / (float)this.totalRowCount;
    }

    private void initBatch(MemoryMode memMode, StructType partitionColumns, InternalRow partitionValues) {
        StructType batchSchema = new StructType();
        for (StructField f : this.sparkSchema.fields()) {
            batchSchema = batchSchema.add(f);
        }
        if (partitionColumns != null) {
            for (StructField f : partitionColumns.fields()) {
                batchSchema = batchSchema.add(f);
            }
        }
        this.columnVectors = memMode == MemoryMode.OFF_HEAP ? OffHeapColumnVector.allocateColumns(this.capacity, batchSchema) : OnHeapColumnVector.allocateColumns(this.capacity, batchSchema);
        this.columnarBatch = new ColumnarBatch((ColumnVector[])this.columnVectors);
        if (partitionColumns != null) {
            int partitionIdx = this.sparkSchema.fields().length;
            for (int i = 0; i < partitionColumns.fields().length; ++i) {
                ColumnVectorUtils.populate(this.columnVectors[i + partitionIdx], partitionValues, i);
                this.columnVectors[i + partitionIdx].setIsConstant();
            }
        }
        for (int i = 0; i < this.missingColumns.length; ++i) {
            if (!this.missingColumns[i]) continue;
            this.columnVectors[i].putNulls(0, this.capacity);
            this.columnVectors[i].setIsConstant();
        }
    }

    private void initBatch() {
        this.initBatch(this.MEMORY_MODE, null, null);
    }

    public void initBatch(StructType partitionColumns, InternalRow partitionValues) {
        this.initBatch(this.MEMORY_MODE, partitionColumns, partitionValues);
    }

    public ColumnarBatch resultBatch() {
        if (this.columnarBatch == null) {
            this.initBatch();
        }
        return this.columnarBatch;
    }

    public void enableReturningBatches() {
        this.returnColumnarBatch = true;
    }

    public boolean nextBatch() throws IOException {
        for (WritableColumnVector vector : this.columnVectors) {
            vector.reset();
        }
        this.columnarBatch.setNumRows(0);
        if (this.rowsReturned >= this.totalRowCount) {
            return false;
        }
        this.checkEndOfRowGroup();
        int num = (int)Math.min((long)this.capacity, this.totalCountLoadedSoFar - this.rowsReturned);
        for (int i = 0; i < this.columnReaders.length; ++i) {
            if (this.columnReaders[i] == null) continue;
            this.columnReaders[i].readBatch(num, this.columnVectors[i]);
        }
        this.rowsReturned += (long)num;
        this.columnarBatch.setNumRows(num);
        this.numBatched = num;
        this.batchIdx = 0;
        return true;
    }

    private void initializeInternal() throws IOException, UnsupportedOperationException {
        this.missingColumns = new boolean[this.requestedSchema.getFieldCount()];
        List columns = this.requestedSchema.getColumns();
        List paths = this.requestedSchema.getPaths();
        for (int i = 0; i < this.requestedSchema.getFieldCount(); ++i) {
            Type t = (Type)this.requestedSchema.getFields().get(i);
            if (!t.isPrimitive() || t.isRepetition(Type.Repetition.REPEATED)) {
                throw new UnsupportedOperationException("Complex types not supported.");
            }
            Object[] colPath = (String[])paths.get(i);
            if (this.fileSchema.containsPath((String[])colPath)) {
                ColumnDescriptor fd = this.fileSchema.getColumnDescription((String[])colPath);
                if (!fd.equals(columns.get(i))) {
                    throw new UnsupportedOperationException("Schema evolution not supported.");
                }
                this.missingColumns[i] = false;
                continue;
            }
            if (((ColumnDescriptor)columns.get(i)).getMaxDefinitionLevel() == 0) {
                throw new IOException("Required column is missing in data file. Col: " + Arrays.toString(colPath));
            }
            this.missingColumns[i] = true;
        }
    }

    private void checkEndOfRowGroup() throws IOException {
        if (this.rowsReturned != this.totalCountLoadedSoFar) {
            return;
        }
        PageReadStore pages = this.reader.readNextRowGroup();
        if (pages == null) {
            throw new IOException("expecting more rows but reached last block. Read " + this.rowsReturned + " out of " + this.totalRowCount);
        }
        List columns = this.requestedSchema.getColumns();
        List types = this.requestedSchema.asGroupType().getFields();
        this.columnReaders = new VectorizedColumnReader[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            if (this.missingColumns[i]) continue;
            this.columnReaders[i] = new VectorizedColumnReader((ColumnDescriptor)columns.get(i), ((Type)types.get(i)).getOriginalType(), pages.getPageReader((ColumnDescriptor)columns.get(i)), this.convertTz);
        }
        this.totalCountLoadedSoFar += pages.getRowCount();
    }
}

