/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.parquet;

import java.io.Serializable;
import java.net.URI;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.datasources.v2.FilePartitionReaderFactory;
import org.apache.spark.sql.execution.datasources.v2.PartitionReaderWithPartitionValues;
import org.apache.spark.sql.execution.datasources.v2.parquet.ParquetPartitionReaderFactory$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function5;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rMc\u0001\u0002$H\u0001bC\u0001\u0002\u001c\u0001\u0003\u0016\u0004%\t!\u001c\u0005\tg\u0002\u0011\t\u0012)A\u0005]\"AA\u000f\u0001BK\u0002\u0013\u0005Q\u000fC\u0005\u0002\u0006\u0001\u0011\t\u0012)A\u0005m\"Q\u0011q\u0001\u0001\u0003\u0016\u0004%\t!!\u0003\t\u0015\u0005]\u0001A!E!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u001a\u0001\u0011)\u001a!C\u0001\u0003\u0013A!\"a\u0007\u0001\u0005#\u0005\u000b\u0011BA\u0006\u0011)\ti\u0002\u0001BK\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003?\u0001!\u0011#Q\u0001\n\u0005-\u0001BCA\u0011\u0001\tU\r\u0011\"\u0001\u0002$!Q\u0011q\u0007\u0001\u0003\u0012\u0003\u0006I!!\n\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!I\u0011Q\n\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003/\u0002\u0001\u0015!\u0003\u0002R!I\u0011\u0011\f\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002\f!I\u0011Q\f\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002R!I\u0011\u0011\r\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002R!I\u0011Q\r\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002R!I\u0011\u0011\u000e\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003W\u0002\u0001\u0015!\u0003\u0002R!I\u0011Q\u000e\u0001C\u0002\u0013%\u0011q\u000e\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002r!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003w\u0002\u0001\u0015!\u0003\u0002R!I\u0011Q\u0010\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003\u007f\u0002\u0001\u0015!\u0003\u0002R!I\u0011\u0011\u0011\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002R!I\u0011Q\u0011\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003\u000f\u0003\u0001\u0015!\u0003\u0002R!I\u0011\u0011\u0012\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003\u0017\u0003\u0001\u0015!\u0003\u0002R!I\u0011Q\u0012\u0001C\u0002\u0013%\u0011q\u000e\u0005\t\u0003\u001f\u0003\u0001\u0015!\u0003\u0002r!9\u0011\u0011\u0013\u0001\u0005B\u0005M\u0005bBAU\u0001\u0011\u0005\u00131\u0016\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDqA!\u0019\u0001\t\u0013\u0011\u0019\u0007C\u0004\u0003j\u0001!IAa\u001b\t\u000f\t\u0005\u0005\u0001\"\u0003\u0003\u0004\"9!\u0011\u0013\u0001\u0005\n\tM\u0005\"\u0003BP\u0001\u0005\u0005I\u0011\u0001BQ\u0011%\u0011y\u000bAI\u0001\n\u0003\u0011\t\fC\u0005\u0003H\u0002\t\n\u0011\"\u0001\u0003J\"I!Q\u001a\u0001\u0012\u0002\u0013\u0005!q\u001a\u0005\n\u0005'\u0004\u0011\u0013!C\u0001\u0005\u001fD\u0011B!6\u0001#\u0003%\tAa4\t\u0013\t]\u0007!%A\u0005\u0002\te\u0007\"\u0003Bo\u0001\u0005\u0005I\u0011\tBp\u0011%\u00119\u000fAA\u0001\n\u0003\ty\u0007C\u0005\u0003j\u0002\t\t\u0011\"\u0001\u0003l\"I!\u0011\u001f\u0001\u0002\u0002\u0013\u0005#1\u001f\u0005\n\u0007\u0003\u0001\u0011\u0011!C\u0001\u0007\u0007A\u0011ba\u0002\u0001\u0003\u0003%\te!\u0003\t\u0013\r-\u0001!!A\u0005B\r5\u0001\"CB\b\u0001\u0005\u0005I\u0011IB\t\u000f%\u0019)bRA\u0001\u0012\u0003\u00199B\u0002\u0005G\u000f\u0006\u0005\t\u0012AB\r\u0011\u001d\tI\u0004\u0011C\u0001\u0007OA\u0011ba\u0003A\u0003\u0003%)e!\u0004\t\u0013\r%\u0002)!A\u0005\u0002\u000e-\u0002\"CB\u001d\u0001\u0006\u0005I\u0011QB\u001e\u0011%\u0019I\u0005QA\u0001\n\u0013\u0019YEA\u000fQCJ\fX/\u001a;QCJ$\u0018\u000e^5p]J+\u0017\rZ3s\r\u0006\u001cGo\u001c:z\u0015\tA\u0015*A\u0004qCJ\fX/\u001a;\u000b\u0005)[\u0015A\u0001<3\u0015\taU*A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001(P\u0003%)\u00070Z2vi&|gN\u0003\u0002Q#\u0006\u00191/\u001d7\u000b\u0005I\u001b\u0016!B:qCJ\\'B\u0001+V\u0003\u0019\t\u0007/Y2iK*\ta+A\u0002pe\u001e\u001c\u0001aE\u0003\u00013v\u001b\u0017\u000e\u0005\u0002[76\t\u0011*\u0003\u0002]\u0013\nQb)\u001b7f!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe\u001a\u000b7\r^8ssB\u0011a,Y\u0007\u0002?*\u0011\u0001-U\u0001\tS:$XM\u001d8bY&\u0011!m\u0018\u0002\b\u0019><w-\u001b8h!\t!w-D\u0001f\u0015\u00051\u0017!B:dC2\f\u0017B\u00015f\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u001a6\n\u0005-,'\u0001D*fe&\fG.\u001b>bE2,\u0017aB:rY\u000e{gNZ\u000b\u0002]B\u0011q.]\u0007\u0002a*\u0011\u0001mT\u0005\u0003eB\u0014qaU)M\u0007>tg-\u0001\u0005tc2\u001cuN\u001c4!\u0003=\u0011'o\\1eG\u0006\u001cH/\u001a3D_:4W#\u0001<\u0011\u0007]TH0D\u0001y\u0015\tI\u0018+A\u0005ce>\fGmY1ti&\u00111\u0010\u001f\u0002\n\u0005J|\u0017\rZ2bgR\u00042!`A\u0001\u001b\u0005q(BA@R\u0003\u0011)H/\u001b7\n\u0007\u0005\raPA\rTKJL\u0017\r\\5{C\ndWmQ8oM&<WO]1uS>t\u0017\u0001\u00052s_\u0006$7-Y:uK\u0012\u001cuN\u001c4!\u0003)!\u0017\r^1TG\",W.Y\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#y\u0015!\u0002;za\u0016\u001c\u0018\u0002BA\u000b\u0003\u001f\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003-!\u0017\r^1TG\",W.\u0019\u0011\u0002\u001dI,\u0017\r\u001a#bi\u0006\u001c6\r[3nC\u0006y!/Z1e\t\u0006$\u0018mU2iK6\f\u0007%A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b\u0003A\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007%A\u0004gS2$XM]:\u0016\u0005\u0005\u0015\u0002#\u00023\u0002(\u0005-\u0012bAA\u0015K\n)\u0011I\u001d:bsB!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022=\u000bqa]8ve\u000e,7/\u0003\u0003\u00026\u0005=\"A\u0002$jYR,'/\u0001\u0005gS2$XM]:!\u0003\u0019a\u0014N\\5u}Qq\u0011QHA!\u0003\u0007\n)%a\u0012\u0002J\u0005-\u0003cAA \u00015\tq\tC\u0003m\u001b\u0001\u0007a\u000eC\u0003u\u001b\u0001\u0007a\u000fC\u0004\u0002\b5\u0001\r!a\u0003\t\u000f\u0005eQ\u00021\u0001\u0002\f!9\u0011QD\u0007A\u0002\u0005-\u0001bBA\u0011\u001b\u0001\u0007\u0011QE\u0001\u0010SN\u001c\u0015m]3TK:\u001c\u0018\u000e^5wKV\u0011\u0011\u0011\u000b\t\u0004I\u0006M\u0013bAA+K\n9!i\\8mK\u0006t\u0017\u0001E5t\u0007\u0006\u001cXmU3og&$\u0018N^3!\u00031\u0011Xm];miN\u001b\u0007.Z7b\u00035\u0011Xm];miN\u001b\u0007.Z7bA\u0005IRM\\1cY\u0016|eM\u001a%fCB\u001cu\u000e\\;n]Z+7\r^8s\u0003i)g.\u00192mK>3g\rS3ba\u000e{G.^7o-\u0016\u001cGo\u001c:!\u0003Y)g.\u00192mKZ+7\r^8sSj,GMU3bI\u0016\u0014\u0018aF3oC\ndWMV3di>\u0014\u0018N_3e%\u0016\fG-\u001a:!\u0003I)g.\u00192mKJ+7m\u001c:e\r&dG/\u001a:\u0002'\u0015t\u0017M\u00197f%\u0016\u001cwN\u001d3GS2$XM\u001d\u0011\u0002'QLW.Z:uC6\u00048i\u001c8wKJ\u001c\u0018n\u001c8\u0002)QLW.Z:uC6\u00048i\u001c8wKJ\u001c\u0018n\u001c8!\u0003!\u0019\u0017\r]1dSRLXCAA9!\r!\u00171O\u0005\u0004\u0003k*'aA%oi\u0006I1-\u00199bG&$\u0018\u0010I\u0001\u001cK:\f'\r\\3QCJ\fX/\u001a;GS2$XM\u001d)vg\"$un\u001e8\u00029\u0015t\u0017M\u00197f!\u0006\u0014\u0018/^3u\r&dG/\u001a:QkNDGi\\<oA\u0005a\u0001/^:i\t><h\u000eR1uK\u0006i\u0001/^:i\t><h\u000eR1uK\u0002\n\u0011\u0003];tQ\u0012{wO\u001c+j[\u0016\u001cH/Y7q\u0003I\u0001Xo\u001d5E_^tG+[7fgR\fW\u000e\u001d\u0011\u0002\u001fA,8\u000f\u001b#po:$UmY5nC2\f\u0001\u0003];tQ\u0012{wO\u001c#fG&l\u0017\r\u001c\u0011\u0002/A,8\u000f\u001b#po:\u001cFO]5oON#\u0018M\u001d;XSRD\u0017\u0001\u00079vg\"$un\u001e8TiJLgnZ*uCJ$x+\u001b;iA\u0005I\u0002/^:i\t><h.\u00138GS2$XM\u001d+ie\u0016\u001c\bn\u001c7e\u0003i\u0001Xo\u001d5E_^t\u0017J\u001c$jYR,'\u000f\u00165sKNDw\u000e\u001c3!\u0003Q\u0019X\u000f\u001d9peR\u001cu\u000e\\;n]\u0006\u0014(+Z1egR!\u0011\u0011KAK\u0011\u001d\t9\n\u000ba\u0001\u00033\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0011\t\u0005m\u0015QU\u0007\u0003\u0003;SA!a(\u0002\"\u0006!!/Z1e\u0015\r\t\u0019kT\u0001\nG>tg.Z2u_JLA!a*\u0002\u001e\nq\u0011J\u001c9viB\u000b'\u000f^5uS>t\u0017a\u00032vS2$'+Z1eKJ$B!!,\u0002@B1\u00111TAX\u0003gKA!!-\u0002\u001e\ny\u0001+\u0019:uSRLwN\u001c*fC\u0012,'\u000f\u0005\u0003\u00026\u0006mVBAA\\\u0015\r\tIlT\u0001\tG\u0006$\u0018\r\\=ti&!\u0011QXA\\\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000f\u0005\u0005\u0017\u00061\u0001\u0002D\u0006!a-\u001b7f!\u0011\t)-a2\u000e\u0003-K1!!3L\u0005=\u0001\u0016M\u001d;ji&|g.\u001a3GS2,\u0017a\u00052vS2$7i\u001c7v[:\f'OU3bI\u0016\u0014H\u0003BAh\u0003;\u0004b!a'\u00020\u0006E\u0007\u0003BAj\u00033l!!!6\u000b\u0007\u0005]w*\u0001\u0006wK\u000e$xN]5{K\u0012LA!a7\u0002V\ni1i\u001c7v[:\f'OQ1uG\"Dq!!1+\u0001\u0004\t\u0019-A\bck&dGMU3bI\u0016\u0014()Y:f+\u0011\t\u0019O!\u0003\u0015\r\u0005\u0015(1\u0004B\u000f!!\t9/!=\u0002v\n\u0015QBAAu\u0015\u0011\tY/!<\u0002\u00135\f\u0007O]3ek\u000e,'bAAx'\u00061\u0001.\u00193p_BLA!a=\u0002j\na!+Z2pe\u0012\u0014V-\u00193feB!\u0011q\u001fB\u0001\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018\u0001\u00027b]\u001eT!!a@\u0002\t)\fg/Y\u0005\u0005\u0005\u0007\tIP\u0001\u0003W_&$\u0007\u0003\u0002B\u0004\u0005\u0013a\u0001\u0001B\u0004\u0003\f-\u0012\rA!\u0004\u0003\u0003Q\u000bBAa\u0004\u0003\u0016A\u0019AM!\u0005\n\u0007\tMQMA\u0004O_RD\u0017N\\4\u0011\u0007\u0011\u00149\"C\u0002\u0003\u001a\u0015\u00141!\u00118z\u0011\u001d\t\tm\u000ba\u0001\u0003\u0007DqAa\b,\u0001\u0004\u0011\t#A\bck&dGMU3bI\u0016\u0014h)\u001e8d!=!'1\u0005B\u0014\u0003g\u0013\u0019Da\u0010\u0003V\u0005\u0015\u0018b\u0001B\u0013K\nIa)\u001e8di&|g.\u000e\t\u0005\u0005S\u0011y#\u0004\u0002\u0003,)!\u0011q\u001eB\u0017\u0015\tA5+\u0003\u0003\u00032\t-\"!\u0005)beF,X\r^%oaV$8\u000b\u001d7jiB!!Q\u0007B\u001e\u001b\t\u00119D\u0003\u0003\u0003:\u0005%\u0018\u0001\u0002;bg.LAA!\u0010\u00038\t1B+Y:l\u0003R$X-\u001c9u\u0007>tG/\u001a=u\u00136\u0004H\u000eE\u0003e\u0005\u0003\u0012)%C\u0002\u0003D\u0015\u0014aa\u00149uS>t\u0007\u0003\u0002B$\u0005#j!A!\u0013\u000b\t\t-#QJ\u0001\naJ,G-[2bi\u0016TAAa\u0014\u0003.\u00059a-\u001b7uKJ\u0014\u0014\u0002\u0002B*\u0005\u0013\u0012qBR5mi\u0016\u0014\bK]3eS\u000e\fG/\u001a\t\u0006I\n\u0005#q\u000b\t\u0005\u00053\u0012i&\u0004\u0002\u0003\\)\u0019q0!@\n\t\t}#1\f\u0002\t)&lWMW8oK\u0006\u00192M]3bi\u0016\u0014vn\u001e\"bg\u0016\u0014V-\u00193feR!!Q\rB4!!\t9/!=\u0002v\u0006M\u0006bBAaY\u0001\u0007\u00111Y\u0001\u001bGJ,\u0017\r^3S_^\u0014\u0015m]3QCJ\fX/\u001a;SK\u0006$WM\u001d\u000b\r\u0005K\u0012iG!\u001d\u0003v\te$Q\u0010\u0005\b\u0005_j\u0003\u0019\u0001B\u0014\u0003\u0015\u0019\b\u000f\\5u\u0011\u001d\u0011\u0019(\fa\u0001\u0003g\u000bq\u0002]1si&$\u0018n\u001c8WC2,Xm\u001d\u0005\b\u0005oj\u0003\u0019\u0001B\u001a\u0003QA\u0017\rZ8pa\u0006#H/Z7qi\u000e{g\u000e^3yi\"9!1P\u0017A\u0002\t}\u0012A\u00029vg\",G\rC\u0004\u0003\u00005\u0002\rA!\u0016\u0002\u0013\r|gN^3siRS\u0018AF2sK\u0006$XMV3di>\u0014\u0018N_3e%\u0016\fG-\u001a:\u0015\t\t\u0015%q\u0012\t\u0005\u0005\u000f\u0013Y)\u0004\u0002\u0003\n*\u0011\u0001jS\u0005\u0005\u0005\u001b\u0013IIA\u000fWK\u000e$xN]5{K\u0012\u0004\u0016M]9vKR\u0014VmY8sIJ+\u0017\rZ3s\u0011\u001d\t\tM\fa\u0001\u0003\u0007\fQd\u0019:fCR,\u0007+\u0019:rk\u0016$h+Z2u_JL'0\u001a3SK\u0006$WM\u001d\u000b\r\u0005\u000b\u0013)Ja&\u0003\u001a\nm%Q\u0014\u0005\b\u0005_z\u0003\u0019\u0001B\u0014\u0011\u001d\u0011\u0019h\fa\u0001\u0003gCqAa\u001e0\u0001\u0004\u0011\u0019\u0004C\u0004\u0003|=\u0002\rAa\u0010\t\u000f\t}t\u00061\u0001\u0003V\u0005!1m\u001c9z)9\tiDa)\u0003&\n\u001d&\u0011\u0016BV\u0005[Cq\u0001\u001c\u0019\u0011\u0002\u0003\u0007a\u000eC\u0004uaA\u0005\t\u0019\u0001<\t\u0013\u0005\u001d\u0001\u0007%AA\u0002\u0005-\u0001\"CA\raA\u0005\t\u0019AA\u0006\u0011%\ti\u0002\rI\u0001\u0002\u0004\tY\u0001C\u0005\u0002\"A\u0002\n\u00111\u0001\u0002&\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BZU\rq'QW\u0016\u0003\u0005o\u0003BA!/\u0003D6\u0011!1\u0018\u0006\u0005\u0005{\u0013y,A\u0005v]\u000eDWmY6fI*\u0019!\u0011Y3\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003F\nm&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BfU\r1(QW\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tN\u000b\u0003\u0002\f\tU\u0016AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"Aa7+\t\u0005\u0015\"QW\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u0005\b\u0003BA|\u0005GLAA!:\u0002z\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u0016\t5\b\"\u0003Bxs\u0005\u0005\t\u0019AA9\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u001f\t\u0007\u0005o\u0014iP!\u0006\u000e\u0005\te(b\u0001B~K\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t}(\u0011 \u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002R\r\u0015\u0001\"\u0003Bxw\u0005\u0005\t\u0019\u0001B\u000b\u0003!A\u0017m\u001d5D_\u0012,GCAA9\u0003!!xn\u0015;sS:<GC\u0001Bq\u0003\u0019)\u0017/^1mgR!\u0011\u0011KB\n\u0011%\u0011yOPA\u0001\u0002\u0004\u0011)\"A\u000fQCJ\fX/\u001a;QCJ$\u0018\u000e^5p]J+\u0017\rZ3s\r\u0006\u001cGo\u001c:z!\r\ty\u0004Q\n\u0005\u0001\u000em\u0011\u000e\u0005\t\u0004\u001e\r\rbN^A\u0006\u0003\u0017\tY!!\n\u0002>5\u00111q\u0004\u0006\u0004\u0007C)\u0017a\u0002:v]RLW.Z\u0005\u0005\u0007K\u0019yBA\tBEN$(/Y2u\rVt7\r^5p]Z\"\"aa\u0006\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001d\u0005u2QFB\u0018\u0007c\u0019\u0019d!\u000e\u00048!)An\u0011a\u0001]\")Ao\u0011a\u0001m\"9\u0011qA\"A\u0002\u0005-\u0001bBA\r\u0007\u0002\u0007\u00111\u0002\u0005\b\u0003;\u0019\u0005\u0019AA\u0006\u0011\u001d\t\tc\u0011a\u0001\u0003K\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004>\r\u0015\u0003#\u00023\u0003B\r}\u0002#\u00043\u0004B94\u00181BA\u0006\u0003\u0017\t)#C\u0002\u0004D\u0015\u0014a\u0001V;qY\u00164\u0004\"CB$\t\u0006\u0005\t\u0019AA\u001f\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004NA!\u0011q_B(\u0013\u0011\u0019\t&!?\u0003\r=\u0013'.Z2u\u0001")
public class ParquetPartitionReaderFactory
extends FilePartitionReaderFactory
implements Logging,
Product,
scala.Serializable {
    private final SQLConf sqlConf;
    private final Broadcast<SerializableConfiguration> broadcastedConf;
    private final StructType dataSchema;
    private final StructType readDataSchema;
    private final StructType partitionSchema;
    private final Filter[] filters;
    private final boolean isCaseSensitive;
    private final StructType resultSchema;
    private final boolean enableOffHeapColumnVector;
    private final boolean enableVectorizedReader;
    private final boolean enableRecordFilter;
    private final boolean timestampConversion;
    private final int capacity;
    private final boolean enableParquetFilterPushDown;
    private final boolean pushDownDate;
    private final boolean pushDownTimestamp;
    private final boolean pushDownDecimal;
    private final boolean pushDownStringStartWith;
    private final int pushDownInFilterThreshold;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Tuple6<SQLConf, Broadcast<SerializableConfiguration>, StructType, StructType, StructType, Filter[]>> unapply(ParquetPartitionReaderFactory parquetPartitionReaderFactory) {
        return ParquetPartitionReaderFactory$.MODULE$.unapply(parquetPartitionReaderFactory);
    }

    public static ParquetPartitionReaderFactory apply(SQLConf sQLConf, Broadcast<SerializableConfiguration> broadcast, StructType structType, StructType structType2, StructType structType3, Filter[] filterArray) {
        return ParquetPartitionReaderFactory$.MODULE$.apply(sQLConf, broadcast, structType, structType2, structType3, filterArray);
    }

    public static Function1<Tuple6<SQLConf, Broadcast<SerializableConfiguration>, StructType, StructType, StructType, Filter[]>, ParquetPartitionReaderFactory> tupled() {
        return ParquetPartitionReaderFactory$.MODULE$.tupled();
    }

    public static Function1<SQLConf, Function1<Broadcast<SerializableConfiguration>, Function1<StructType, Function1<StructType, Function1<StructType, Function1<Filter[], ParquetPartitionReaderFactory>>>>>> curried() {
        return ParquetPartitionReaderFactory$.MODULE$.curried();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SQLConf sqlConf() {
        return this.sqlConf;
    }

    public Broadcast<SerializableConfiguration> broadcastedConf() {
        return this.broadcastedConf;
    }

    public StructType dataSchema() {
        return this.dataSchema;
    }

    public StructType readDataSchema() {
        return this.readDataSchema;
    }

    public StructType partitionSchema() {
        return this.partitionSchema;
    }

    public Filter[] filters() {
        return this.filters;
    }

    private boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    private StructType resultSchema() {
        return this.resultSchema;
    }

    private boolean enableOffHeapColumnVector() {
        return this.enableOffHeapColumnVector;
    }

    private boolean enableVectorizedReader() {
        return this.enableVectorizedReader;
    }

    private boolean enableRecordFilter() {
        return this.enableRecordFilter;
    }

    private boolean timestampConversion() {
        return this.timestampConversion;
    }

    private int capacity() {
        return this.capacity;
    }

    private boolean enableParquetFilterPushDown() {
        return this.enableParquetFilterPushDown;
    }

    private boolean pushDownDate() {
        return this.pushDownDate;
    }

    private boolean pushDownTimestamp() {
        return this.pushDownTimestamp;
    }

    private boolean pushDownDecimal() {
        return this.pushDownDecimal;
    }

    private boolean pushDownStringStartWith() {
        return this.pushDownStringStartWith;
    }

    private int pushDownInFilterThreshold() {
        return this.pushDownInFilterThreshold;
    }

    @Override
    public boolean supportColumnarReads(InputPartition partition) {
        return this.sqlConf().parquetVectorizedReaderEnabled() && this.sqlConf().wholeStageEnabled() && this.resultSchema().length() <= this.sqlConf().wholeStageMaxNumFields() && this.resultSchema().forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetPartitionReaderFactory.$anonfun$supportColumnarReads$1(x$2)));
    }

    @Override
    public PartitionReader<InternalRow> buildReader(PartitionedFile file) {
        RecordReader<Void, InternalRow> reader = this.enableVectorizedReader() ? this.createVectorizedReader(file) : this.createRowBaseReader(file);
        PartitionReader<InternalRow> fileReader = new PartitionReader<InternalRow>(null, reader){
            private final RecordReader reader$1;

            public boolean next() {
                return this.reader$1.nextKeyValue();
            }

            public InternalRow get() {
                return (InternalRow)this.reader$1.getCurrentValue();
            }

            public void close() {
                this.reader$1.close();
            }
            {
                this.reader$1 = reader$1;
            }
        };
        return new PartitionReaderWithPartitionValues(fileReader, this.readDataSchema(), this.partitionSchema(), file.partitionValues());
    }

    @Override
    public PartitionReader<ColumnarBatch> buildColumnarReader(PartitionedFile file) {
        VectorizedParquetRecordReader vectorizedReader = this.createVectorizedReader(file);
        vectorizedReader.enableReturningBatches();
        return new PartitionReader<ColumnarBatch>(null, vectorizedReader){
            private final VectorizedParquetRecordReader vectorizedReader$1;

            public boolean next() {
                return this.vectorizedReader$1.nextKeyValue();
            }

            public ColumnarBatch get() {
                return (ColumnarBatch)this.vectorizedReader$1.getCurrentValue();
            }

            public void close() {
                this.vectorizedReader$1.close();
            }
            {
                this.vectorizedReader$1 = vectorizedReader$1;
            }
        };
    }

    private <T> RecordReader<Void, T> buildReaderBase(PartitionedFile file, Function5<ParquetInputSplit, InternalRow, TaskAttemptContextImpl, Option<FilterPredicate>, Option<TimeZone>, RecordReader<Void, T>> buildReaderFunc) {
        None$ none$;
        LazyRef footerFileMetaData$lzy = new LazyRef();
        Configuration conf = ((SerializableConfiguration)this.broadcastedConf().value()).value();
        Path filePath = new Path(new URI(file.filePath()));
        ParquetInputSplit split = new ParquetInputSplit(filePath, file.start(), file.start() + file.length(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), null);
        if (this.enableParquetFilterPushDown()) {
            MessageType parquetSchema = ParquetPartitionReaderFactory.footerFileMetaData$1(footerFileMetaData$lzy, conf, filePath).getSchema();
            ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, this.pushDownDate(), this.pushDownTimestamp(), this.pushDownDecimal(), this.pushDownStringStartWith(), this.pushDownInFilterThreshold(), this.isCaseSensitive());
            none$ = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.filters())).flatMap((Function1 & Serializable & scala.Serializable)predicate -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter((Filter)predicate)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FilterPredicate.class))))).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
        } else {
            none$ = None$.MODULE$;
        }
        None$ pushed = none$;
        None$ convertTz = this.timestampConversion() && !ParquetPartitionReaderFactory.isCreatedByParquetMr$1(footerFileMetaData$lzy, conf, filePath) ? new Some((Object)DateTimeUtils$.MODULE$.getTimeZone(conf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
        TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
        TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(conf, attemptId);
        if (pushed.isDefined()) {
            ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
        }
        RecordReader reader = (RecordReader)buildReaderFunc.apply((Object)split, (Object)file.partitionValues(), (Object)hadoopAttemptContext, (Object)pushed, (Object)convertTz);
        reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
        return reader;
    }

    private RecordReader<Void, InternalRow> createRowBaseReader(PartitionedFile file) {
        return this.buildReaderBase(file, (Function5 & Serializable & scala.Serializable)(split, partitionValues, hadoopAttemptContext, pushed, convertTz) -> this.createRowBaseParquetReader((ParquetInputSplit)split, (InternalRow)partitionValues, (TaskAttemptContextImpl)hadoopAttemptContext, (Option<FilterPredicate>)pushed, (Option<TimeZone>)convertTz));
    }

    private RecordReader<Void, InternalRow> createRowBaseParquetReader(ParquetInputSplit split, InternalRow partitionValues, TaskAttemptContextImpl hadoopAttemptContext, Option<FilterPredicate> pushed, Option<TimeZone> convertTz) {
        ParquetRecordReader parquetRecordReader;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
        Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        ParquetReadSupport readSupport = new ParquetReadSupport(convertTz, false);
        if (pushed.isDefined() && this.enableRecordFilter()) {
            FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
            parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
        } else {
            parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
        }
        ParquetRecordReader reader = parquetRecordReader;
        RecordReaderIterator iter = new RecordReaderIterator(reader);
        taskContext.foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$4 -> {
            iter.close();
            return BoxedUnit.UNIT;
        }));
        return reader;
    }

    /*
     * WARNING - void declaration
     */
    private VectorizedParquetRecordReader createVectorizedReader(PartitionedFile file) {
        void var2_2;
        VectorizedParquetRecordReader vectorizedReader = (VectorizedParquetRecordReader)this.buildReaderBase(file, (Function5 & Serializable & scala.Serializable)(split, partitionValues, hadoopAttemptContext, pushed, convertTz) -> this.createParquetVectorizedReader((ParquetInputSplit)split, (InternalRow)partitionValues, (TaskAttemptContextImpl)hadoopAttemptContext, (Option<FilterPredicate>)pushed, (Option<TimeZone>)convertTz));
        vectorizedReader.initBatch(this.partitionSchema(), file.partitionValues());
        return var2_2;
    }

    private VectorizedParquetRecordReader createParquetVectorizedReader(ParquetInputSplit split, InternalRow partitionValues, TaskAttemptContextImpl hadoopAttemptContext, Option<FilterPredicate> pushed, Option<TimeZone> convertTz) {
        Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((TimeZone)convertTz.orNull(Predef$.MODULE$.$conforms()), this.enableOffHeapColumnVector() && taskContext.isDefined(), this.capacity());
        RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
        taskContext.foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$6 -> {
            iter.close();
            return BoxedUnit.UNIT;
        }));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Appending ").append(this.partitionSchema()).append(" ").append(partitionValues).toString());
        return vectorizedReader;
    }

    public ParquetPartitionReaderFactory copy(SQLConf sqlConf, Broadcast<SerializableConfiguration> broadcastedConf, StructType dataSchema, StructType readDataSchema, StructType partitionSchema, Filter[] filters) {
        return new ParquetPartitionReaderFactory(sqlConf, broadcastedConf, dataSchema, readDataSchema, partitionSchema, filters);
    }

    public SQLConf copy$default$1() {
        return this.sqlConf();
    }

    public Broadcast<SerializableConfiguration> copy$default$2() {
        return this.broadcastedConf();
    }

    public StructType copy$default$3() {
        return this.dataSchema();
    }

    public StructType copy$default$4() {
        return this.readDataSchema();
    }

    public StructType copy$default$5() {
        return this.partitionSchema();
    }

    public Filter[] copy$default$6() {
        return this.filters();
    }

    public String productPrefix() {
        return "ParquetPartitionReaderFactory";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Filter[] filterArray;
        int n = x$1;
        switch (n) {
            case 0: {
                filterArray = this.sqlConf();
                break;
            }
            case 1: {
                filterArray = this.broadcastedConf();
                break;
            }
            case 2: {
                filterArray = this.dataSchema();
                break;
            }
            case 3: {
                filterArray = this.readDataSchema();
                break;
            }
            case 4: {
                filterArray = this.partitionSchema();
                break;
            }
            case 5: {
                filterArray = this.filters();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return filterArray;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParquetPartitionReaderFactory;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParquetPartitionReaderFactory)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParquetPartitionReaderFactory parquetPartitionReaderFactory = (ParquetPartitionReaderFactory)x$1;
        SQLConf sQLConf = this.sqlConf();
        SQLConf sQLConf2 = parquetPartitionReaderFactory.sqlConf();
        if (sQLConf == null) {
            if (sQLConf2 != null) {
                return false;
            }
        } else if (!sQLConf.equals(sQLConf2)) return false;
        Broadcast<SerializableConfiguration> broadcast = this.broadcastedConf();
        Broadcast<SerializableConfiguration> broadcast2 = parquetPartitionReaderFactory.broadcastedConf();
        if (broadcast == null) {
            if (broadcast2 != null) {
                return false;
            }
        } else if (!broadcast.equals(broadcast2)) return false;
        StructType structType = this.dataSchema();
        StructType structType2 = parquetPartitionReaderFactory.dataSchema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        StructType structType3 = this.readDataSchema();
        StructType structType4 = parquetPartitionReaderFactory.readDataSchema();
        if (structType3 == null) {
            if (structType4 != null) {
                return false;
            }
        } else if (!structType3.equals(structType4)) return false;
        StructType structType5 = this.partitionSchema();
        StructType structType6 = parquetPartitionReaderFactory.partitionSchema();
        if (structType5 == null) {
            if (structType6 != null) {
                return false;
            }
        } else if (!structType5.equals(structType6)) return false;
        if (this.filters() != parquetPartitionReaderFactory.filters()) return false;
        if (!parquetPartitionReaderFactory.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$enableVectorizedReader$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$supportColumnarReads$1(StructField x$2) {
        return x$2.dataType() instanceof AtomicType;
    }

    private static final /* synthetic */ FileMetaData footerFileMetaData$lzycompute$1(LazyRef footerFileMetaData$lzy$1, Configuration conf$1, Path filePath$1) {
        FileMetaData fileMetaData;
        LazyRef lazyRef = footerFileMetaData$lzy$1;
        synchronized (lazyRef) {
            fileMetaData = footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : (FileMetaData)footerFileMetaData$lzy$1.initialize((Object)ParquetFileReader.readFooter((Configuration)conf$1, (Path)filePath$1, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData());
        }
        return fileMetaData;
    }

    private static final FileMetaData footerFileMetaData$1(LazyRef footerFileMetaData$lzy$1, Configuration conf$1, Path filePath$1) {
        return footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : ParquetPartitionReaderFactory.footerFileMetaData$lzycompute$1(footerFileMetaData$lzy$1, conf$1, filePath$1);
    }

    private static final boolean isCreatedByParquetMr$1(LazyRef footerFileMetaData$lzy$1, Configuration conf$1, Path filePath$1) {
        return ParquetPartitionReaderFactory.footerFileMetaData$1(footerFileMetaData$lzy$1, conf$1, filePath$1).getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetPartitionReaderFactory(SQLConf sqlConf, Broadcast<SerializableConfiguration> broadcastedConf, StructType dataSchema, StructType readDataSchema, StructType partitionSchema, Filter[] filters) {
        this.sqlConf = sqlConf;
        this.broadcastedConf = broadcastedConf;
        this.dataSchema = dataSchema;
        this.readDataSchema = readDataSchema;
        this.partitionSchema = partitionSchema;
        this.filters = filters;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        this.resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readDataSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        this.enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        this.enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && this.resultSchema().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetPartitionReaderFactory.$anonfun$enableVectorizedReader$1(x$1)));
        this.enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        this.timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        this.capacity = sqlConf.parquetVectorizedReaderBatchSize();
        this.enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        this.pushDownDate = sqlConf.parquetFilterPushDownDate();
        this.pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        this.pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        this.pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        this.pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
    }
}

