/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.parquet;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.v2.FileWriteBuilder;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4Aa\u0002\u0005\u00013!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011!\u0011\u0005A!A!\u0002\u0013Q\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u000bE\u0003A\u0011\u0001*\t\u000be\u0003A\u0011\t.\u0003'A\u000b'/];fi^\u0013\u0018\u000e^3Ck&dG-\u001a:\u000b\u0005%Q\u0011a\u00029beF,X\r\u001e\u0006\u0003\u00171\t!A\u001e\u001a\u000b\u00055q\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0004\t\u0002\u0013\u0015DXmY;uS>t'BA\t\u0013\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011c\u0001\u0001\u001b=A\u00111\u0004H\u0007\u0002\u0015%\u0011QD\u0003\u0002\u0011\r&dWm\u0016:ji\u0016\u0014U/\u001b7eKJ\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\n\u0002\u0011%tG/\u001a:oC2L!a\t\u0011\u0003\u000f1{wmZ5oO\u00069q\u000e\u001d;j_:\u001c\bC\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0011\u0003\u0011)H/\u001b7\n\u0005):#\u0001G\"bg\u0016Len]3og&$\u0018N^3TiJLgnZ'ba\u0006)\u0001/\u0019;igB\u0019Qf\u000e\u001e\u000f\u00059\"dBA\u00183\u001b\u0005\u0001$BA\u0019\u0019\u0003\u0019a$o\\8u}%\t1'A\u0003tG\u0006d\u0017-\u0003\u00026m\u00059\u0001/Y2lC\u001e,'\"A\u001a\n\u0005aJ$aA*fc*\u0011QG\u000e\t\u0003w}r!\u0001P\u001f\u0011\u0005=2\u0014B\u0001 7\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y2\u0014A\u00034pe6\fGOT1nK\u0006\u00012/\u001e9q_J$8\u000fR1uCRK\b/\u001a\t\u0005\u000b\u001aCe*D\u00017\u0013\t9eGA\u0005Gk:\u001cG/[8ocA\u0011\u0011\nT\u0007\u0002\u0015*\u00111\nE\u0001\u0006if\u0004Xm]\u0005\u0003\u001b*\u0013\u0001\u0002R1uCRK\b/\u001a\t\u0003\u000b>K!\u0001\u0015\u001c\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"RaU+W/b\u0003\"\u0001\u0016\u0001\u000e\u0003!AQ\u0001J\u0003A\u0002\u0015BQaK\u0003A\u00021BQAQ\u0003A\u0002iBQaQ\u0003A\u0002\u0011\u000bA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$RaW0gaR\u0004\"\u0001X/\u000e\u00031I!A\u0018\u0007\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000b\u00014\u0001\u0019A1\u0002\u000fM\fHnQ8oMB\u0011!\rZ\u0007\u0002G*\u0011\u0011\u0005E\u0005\u0003K\u000e\u0014qaU)M\u0007>tg\rC\u0003h\r\u0001\u0007\u0001.A\u0002k_\n\u0004\"!\u001b8\u000e\u0003)T!a\u001b7\u0002\u00135\f\u0007O]3ek\u000e,'BA7\u0015\u0003\u0019A\u0017\rZ8pa&\u0011qN\u001b\u0002\u0004\u0015>\u0014\u0007\"\u0002\u0013\u0007\u0001\u0004\t\b\u0003B\u001esuiJ!a]!\u0003\u00075\u000b\u0007\u000fC\u0003v\r\u0001\u0007a/\u0001\u0006eCR\f7k\u00195f[\u0006\u0004\"!S<\n\u0005aT%AC*ueV\u001cG\u000fV=qK\u0002")
public class ParquetWriteBuilder
extends FileWriteBuilder
implements Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sqlConf.writeLegacyParquetFormat())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sqlConf.parquetOutputTimestampType().toString());
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if (!(jobSummaryLevel != null ? !jobSummaryLevel.equals(jobSummaryLevel2) : jobSummaryLevel2 != null) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString());
        }
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    public ParquetWriteBuilder(CaseInsensitiveStringMap options, Seq<String> paths, String formatName, Function1<DataType, Object> supportsDataType) {
        super(options, paths, formatName, supportsDataType);
        Logging.$init$((Logging)this);
    }
}

