/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.concurrent.duration.Duration;

public final class Triggers$ {
    public static Triggers$ MODULE$;

    static {
        new Triggers$();
    }

    public void validate(long intervalMs) {
        Predef$.MODULE$.require(intervalMs >= 0L, (Function0 & java.io.Serializable & Serializable)() -> "the interval of trigger should not be negative");
    }

    public long convert(String interval) {
        CalendarInterval cal = IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)interval));
        if (cal.months != 0) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Doesn't support month or year interval: ").append(interval).toString());
        }
        return TimeUnit.MICROSECONDS.toMillis(cal.microseconds + (long)cal.days * 86400000000L);
    }

    public long convert(Duration interval) {
        return interval.toMillis();
    }

    public long convert(long interval, TimeUnit unit) {
        return unit.toMillis(interval);
    }

    private Triggers$() {
        MODULE$ = this;
    }
}

