/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001\u0002\f\u0018\u0001\tBQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001A\u0002\u0013%!\bC\u0004G\u0001\u0001\u0007I\u0011B$\t\r5\u0003\u0001\u0015)\u0003<\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015i\u0006\u0001\"\u0001_\u0011%\t\u0019\u0002AI\u0001\n\u0003\t)\u0002C\u0005\u0002,\u0001\t\n\u0011\"\u0001\u0002.!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA\u0019\u0001\u0011\u0005\u0011Q\t\u0005\n\u0003[\u0002\u0011\u0013!C\u0001\u0003_B\u0001\"a\u001d\u0001\t\u0003I\u0012Q\u000f\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\t9\u000b\u0001C\u0005\u0003SCq!a.\u0001\t\u0003\tI\fC\u0004\u00028\u0002!\t!!3\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0007bBAo\u0001\u0011%\u0011q\u001c\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u00051\u0019\u0015m\u00195f\u001b\u0006t\u0017mZ3s\u0015\tA\u0012$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!dG\u0001\u0004gFd'B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M!\u0001aI\u00150!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fMB\u0011!&L\u0007\u0002W)\u0011AfG\u0001\tS:$XM\u001d8bY&\u0011af\u000b\u0002\b\u0019><w-\u001b8h!\t\u00014'D\u00012\u0015\t\u0011t#\u0001\u0005bI\u0006\u0004H/\u001b<f\u0013\t!\u0014GA\fBI\u0006\u0004H/\u001b<f'B\f'o\u001b)mC:DU\r\u001c9fe\u00061A(\u001b8jiz\"\u0012a\u000e\t\u0003q\u0001i\u0011aF\u0001\u000bG\u0006\u001c\u0007.\u001a3ECR\fW#A\u001e\u0011\u0007q\n5)D\u0001>\u0015\tqt(A\u0005j[6,H/\u00192mK*\u0011\u0001)J\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\">\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0003q\u0011K!!R\f\u0003\u0015\r\u000b7\r[3e\t\u0006$\u0018-\u0001\bdC\u000eDW\r\u001a#bi\u0006|F%Z9\u0015\u0005![\u0005C\u0001\u0013J\u0013\tQUE\u0001\u0003V]&$\bb\u0002'\u0004\u0003\u0003\u0005\raO\u0001\u0004q\u0012\n\u0014aC2bG\",G\rR1uC\u0002B#\u0001B(\u0011\u0005\u0011\u0002\u0016BA)&\u0005!1x\u000e\\1uS2,\u0007F\u0001\u0003T!\t!C+\u0003\u0002VK\tIAO]1og&,g\u000e^\u0001\u000bG2,\u0017M]\"bG\",G#\u0001%\u0002\u000f%\u001cX)\u001c9usV\t!\f\u0005\u0002%7&\u0011A,\n\u0002\b\u0005>|G.Z1o\u0003)\u0019\u0017m\u00195f#V,'/\u001f\u000b\u0006\u0011~\u000b\u00181\u0001\u0005\u0006A\u001e\u0001\r!Y\u0001\u0006cV,'/\u001f\u0019\u0003E\"\u00042a\u00193g\u001b\u0005I\u0012BA3\u001a\u0005\u001d!\u0015\r^1tKR\u0004\"a\u001a5\r\u0001\u0011I\u0011nXA\u0001\u0002\u0003\u0015\tA\u001b\u0002\u0004?\u0012\n\u0014CA6o!\t!C.\u0003\u0002nK\t9aj\u001c;iS:<\u0007C\u0001\u0013p\u0013\t\u0001XEA\u0002B]fDqA]\u0004\u0011\u0002\u0003\u00071/A\u0005uC\ndWMT1nKB\u0019A\u0005\u001e<\n\u0005U,#AB(qi&|g\u000e\u0005\u0002x}:\u0011\u0001\u0010 \t\u0003s\u0016j\u0011A\u001f\u0006\u0003w\u0006\na\u0001\u0010:p_Rt\u0014BA?&\u0003\u0019\u0001&/\u001a3fM&\u0019q0!\u0001\u0003\rM#(/\u001b8h\u0015\tiX\u0005C\u0005\u0002\u0006\u001d\u0001\n\u00111\u0001\u0002\b\u0005a1\u000f^8sC\u001e,G*\u001a<fYB!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000em\tqa\u001d;pe\u0006<W-\u0003\u0003\u0002\u0012\u0005-!\u0001D*u_J\fw-\u001a'fm\u0016d\u0017\u0001F2bG\",\u0017+^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0018)\u001a1/!\u0007,\u0005\u0005m\u0001\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\n&\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\tyBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAcY1dQ\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\u001aTCAA\u0018U\u0011\t9!!\u0007\u0002\u0019Ut7-Y2iKF+XM]=\u0015\u000b!\u000b)$!\u0011\t\r\u0001T\u0001\u0019AA\u001ca\u0011\tI$!\u0010\u0011\t\r$\u00171\b\t\u0004O\u0006uBaCA \u0003k\t\t\u0011!A\u0003\u0002)\u00141a\u0018\u00133\u0011\u0019\t\u0019E\u0003a\u00015\u000691-Y:dC\u0012,G#\u0003%\u0002H\u0005=\u0013qMA5\u0011\u0019a2\u00021\u0001\u0002JA\u00191-a\u0013\n\u0007\u00055\u0013D\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004\u0002R-\u0001\r!a\u0015\u0002\tAd\u0017M\u001c\t\u0005\u0003+\n\u0019'\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\u001dawnZ5dC2TA!!\u0018\u0002`\u0005)\u0001\u000f\\1og*\u0019\u0011\u0011M\r\u0002\u0011\r\fG/\u00197zgRLA!!\u001a\u0002X\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u0019\t\u0019e\u0003a\u00015\"A\u00111N\u0006\u0011\u0002\u0003\u0007!,\u0001\u0005cY>\u001c7.\u001b8h\u0003Y)hnY1dQ\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\"TCAA9U\rQ\u0016\u0011D\u0001\u0018C:\fG.\u001f>f\u0007>dW/\u001c8DC\u000eDW-U;fef$r\u0001SA<\u0003w\ni\bC\u0004\u0002z5\u0001\r!!\u0013\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\t\u000bej\u0001\u0019A\"\t\u000f\u0005}T\u00021\u0001\u0002\u0002\u000611m\u001c7v[:\u0004b!a!\u0002\u000e\u0006Me\u0002BAC\u0003\u0013s1!_AD\u0013\u00051\u0013bAAFK\u00059\u0001/Y2lC\u001e,\u0017\u0002BAH\u0003#\u00131aU3r\u0015\r\tY)\n\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*!\u0011\u0011TA0\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005u\u0015q\u0013\u0002\n\u0003R$(/\u001b2vi\u0016\fQB]3dC\u000eDWMQ=QY\u0006tG#\u0002%\u0002$\u0006\u0015\u0006B\u0002\u000f\u000f\u0001\u0004\tI\u0005C\u0004\u0002R9\u0001\r!a\u0015\u0002%I,7-Y2iK\nK8i\u001c8eSRLwN\u001c\u000b\u0006\u0011\u0006-\u0016Q\u0016\u0005\u00079=\u0001\r!!\u0013\t\u000f\u0005=v\u00021\u0001\u00022\u0006I1m\u001c8eSRLwN\u001c\t\u0006I\u0005M6IW\u0005\u0004\u0003k+#!\u0003$v]\u000e$\u0018n\u001c82\u0003Aawn\\6va\u000e\u000b7\r[3e\t\u0006$\u0018\r\u0006\u0003\u0002<\u0006u\u0006c\u0001\u0013u\u0007\"1\u0001\r\u0005a\u0001\u0003\u007f\u0003D!!1\u0002FB!1\rZAb!\r9\u0017Q\u0019\u0003\f\u0003\u000f\fi,!A\u0001\u0002\u000b\u0005!NA\u0002`IM\"B!a/\u0002L\"9\u0011\u0011K\tA\u0002\u0005M\u0013!D;tK\u000e\u000b7\r[3e\t\u0006$\u0018\r\u0006\u0003\u0002T\u0005E\u0007bBA)%\u0001\u0007\u00111K\u0001\u000ee\u0016\u001c\u0017m\u00195f\u0005f\u0004\u0016\r\u001e5\u0015\u000b!\u000b9.!7\t\rq\u0019\u0002\u0019AA%\u0011\u0019\tYn\u0005a\u0001m\u0006a!/Z:pkJ\u001cW\rU1uQ\u0006\u0001Bn\\8lkB\fe\u000e\u001a*fMJ,7\u000f\u001b\u000b\b5\u0006\u0005\u00181]A{\u0011\u001d\t\t\u0006\u0006a\u0001\u0003'Bq!!:\u0015\u0001\u0004\t9/\u0001\u0002ggB!\u0011\u0011^Ay\u001b\t\tYO\u0003\u0003\u0002f\u00065(bAAx;\u00051\u0001.\u00193p_BLA!a=\u0002l\nQa)\u001b7f'f\u001cH/Z7\t\u000f\u0005]H\u00031\u0001\u0002z\u0006i\u0011/^1mS\u001aLW\r\u001a)bi\"\u0004B!!;\u0002|&!\u0011Q`Av\u0005\u0011\u0001\u0016\r\u001e5\u00027I,gM]3tQ\u001aKG.Z%oI\u0016D\u0018J\u001a(fG\u0016\u001c8/\u0019:z)\u001dQ&1\u0001B\n\u0005+AqA!\u0002\u0016\u0001\u0004\u00119!A\u0005gS2,\u0017J\u001c3fqB!!\u0011\u0002B\b\u001b\t\u0011YAC\u0002\u0003\u000e]\t1\u0002Z1uCN|WO]2fg&!!\u0011\u0003B\u0006\u0005%1\u0015\u000e\\3J]\u0012,\u0007\u0010C\u0004\u0002fV\u0001\r!a:\t\u000f\u0005]X\u00031\u0001\u0002z\u0002")
public class CacheManager
implements Logging,
AdaptiveSparkPlanHelper {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, TraversableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    @Override
    public <T> SparkSession getOrCloneSessionWithAqeOff(SparkSession session) {
        return AdaptiveSparkPlanHelper.getOrCloneSessionWithAqeOff$(this, session);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        LogicalPlan planToCache = query.logicalPlan();
        if (this.lookupCachedData(planToCache).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asked to cache already cached data.");
        } else {
            SparkSession sessionWithAqeOff = this.getOrCloneSessionWithAqeOff(query.sparkSession());
            InMemoryRelation inMemoryRelation = (InMemoryRelation)((Object)sessionWithAqeOff.withActive((Function0 & Serializable & scala.Serializable)() -> {
                QueryExecution qe = sessionWithAqeOff.sessionState().executePlan(planToCache);
                return InMemoryRelation$.MODULE$.apply(sessionWithAqeOff.sessionState().conf().useCompression(), sessionWithAqeOff.sessionState().conf().columnBatchSize(), storageLevel, qe.executedPlan(), tableName, qe.optimizedPlan());
            }));
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.lookupCachedData(planToCache).nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Data has already been cached.");
                } else {
                    CachedData cachedData = new CachedData(planToCache, inMemoryRelation);
                    this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData, IndexedSeq$.MODULE$.canBuildFrom())));
                }
            }
        }
    }

    public Option<String> cacheQuery$default$2() {
        return None$.MODULE$;
    }

    public StorageLevel cacheQuery$default$3() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query.sparkSession(), query.logicalPlan(), cascade, this.uncacheQuery$default$4());
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        block3: {
            Function1 & Serializable & scala.Serializable shouldRemove = cascade ? (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$1(plan, x$3)) : (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.sameResult((QueryPlan)plan));
            IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$4(shouldRemove, cd)));
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$6(cd, x$6)))))));
            }
            plansToUncache.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                CacheManager.$anonfun$uncacheQuery$7(blocking, x$7);
                return BoxedUnit.UNIT;
            });
            if (cascade) break block3;
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$8(plan, cd)));
        }
    }

    public boolean uncacheQuery$default$4() {
        return false;
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, (LogicalPlan)relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        Map newColStats = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        Tuple2 tuple23 = tuple22;
        long rowCount2 = tuple23._1$mcJ$sp();
        Map newColStats2 = (Map)tuple23._2();
        relation.updateStats(rowCount2, (Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(plan, x$10)));
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$12)))))));
        }
        needToRecache.map((Function1 & Serializable & scala.Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.lookupCachedData(query.logicalPlan());
    }

    public Option<CachedData> lookupCachedData(LogicalPlan plan) {
        return this.cachedData().find((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = plan.transformDown((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                IgnoreCachedData ignoreCachedData;
                A1 A1 = x1;
                Object object = A1 instanceof IgnoreCachedData ? (ignoreCachedData = (IgnoreCachedData)A1) : this.$outer.lookupCachedData(A1).map((Function1 & Serializable & scala.Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)((Object)cachedPlan), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        HintInfo hint = (HintInfo)tuple2._1();
                        LogicalPlan p = (LogicalPlan)tuple2._2();
                        ResolvedHint resolvedHint = new ResolvedHint(p, hint);
                        return resolvedHint;
                    });
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> A1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof IgnoreCachedData ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        return newPlan.transformAllExpressions((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    object = subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof SubqueryExpression;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        Tuple2 tuple2 = new Tuple2((Object)fs, (Object)fs.makeQualified(path));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileSystem fs2 = (FileSystem)tuple2._1();
        Path qualifiedPath = (Path)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fs2, (Object)qualifiedPath);
        Tuple2 tuple23 = tuple22;
        FileSystem fs3 = (FileSystem)tuple23._1();
        Path qualifiedPath2 = (Path)tuple23._2();
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs3, qualifiedPath2, x$15)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        DataSourceV2Relation dataSourceV2Relation;
        Table fileTable;
        boolean bl;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            boolean bl2;
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                bl2 = this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else if (logicalPlan2 instanceof DataSourceV2Relation && (fileTable = (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2).table()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            bl = this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            String prefixToInvalidate = qualifiedPath.toString();
            needToRefresh = ((IterableLike)fileIndex.rootPaths().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.startsWith(prefixToInvalidate)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$1(LogicalPlan plan$1, LogicalPlan x$3) {
        return x$3.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.sameResult((QueryPlan)plan$1))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$4(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$6(CachedData cd$1, CachedData x$6) {
        return x$6 == cd$1;
    }

    public static final /* synthetic */ void $anonfun$uncacheQuery$7(boolean blocking$1, CachedData x$7) {
        x$7.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$8(LogicalPlan plan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.sameResult((QueryPlan)plan$1))).isDefined() && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan plan$2, CachedData x$10) {
        return x$10.plan().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.sameResult((QueryPlan)plan$2))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$2, CachedData x$12) {
        return x$12 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$1, CachedData cd) {
        InMemoryRelation newCache;
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        SparkSession sessionWithAqeOff = $this.getOrCloneSessionWithAqeOff(spark$1);
        InMemoryRelation x$6 = newCache = (InMemoryRelation)((Object)sessionWithAqeOff.withActive((Function0 & Serializable & scala.Serializable)() -> {
            QueryExecution qe = sessionWithAqeOff.sessionState().executePlan(cd.plan());
            SparkPlan x$1 = qe.executedPlan();
            boolean x$2 = cd.cachedRepresentation().cacheBuilder().copy$default$1();
            int x$3 = cd.cachedRepresentation().cacheBuilder().copy$default$2();
            StorageLevel x$4 = cd.cachedRepresentation().cacheBuilder().copy$default$3();
            Option<String> x$5 = cd.cachedRepresentation().cacheBuilder().copy$default$5();
            return InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder().copy(x$2, x$3, x$4, x$1, x$5), qe.optimizedPlan());
        }));
        LogicalPlan x$7 = cd.copy$default$1();
        CachedData recomputedPlan = cd.copy(x$7, x$6);
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.lookupCachedData(recomputedPlan.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = recomputedPlan;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData, IndexedSeq$.MODULE$.canBuildFrom())));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$15) {
        return x$15.plan().find((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$16, fs$1, qualifiedPath$1))).isDefined();
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        AdaptiveSparkPlanHelper.$init$(this);
        this.cachedData = (IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

