/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.command.AlterTableSerDePropertiesCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u000f\u001f\u0001.B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\u000b\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005[\u0001\tE\t\u0015!\u0003M\u0011!Y\u0006A!f\u0001\n\u0003a\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011B/\t\u0011\t\u0004!Q3A\u0005\u0002\rD\u0001B\u001f\u0001\u0003\u0012\u0003\u0006I\u0001\u001a\u0005\u0006w\u0002!\t\u0001 \u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011%\ti\u0003AA\u0001\n\u0003\ty\u0003C\u0005\u0002:\u0001\t\n\u0011\"\u0001\u0002<!I\u0011\u0011\u000b\u0001\u0012\u0002\u0013\u0005\u00111\u000b\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u00033B\u0011\"!\u0018\u0001#\u0003%\t!a\u0018\t\u0013\u0005\r\u0004!!A\u0005B\u0005\u0015\u0004\"CA;\u0001\u0005\u0005I\u0011AA<\u0011%\ty\bAA\u0001\n\u0003\t\t\tC\u0005\u0002\u000e\u0002\t\t\u0011\"\u0011\u0002\u0010\"I\u0011Q\u0014\u0001\u0002\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003S\u0003\u0011\u0011!C!\u0003W;\u0011\"a,\u001f\u0003\u0003E\t!!-\u0007\u0011uq\u0012\u0011!E\u0001\u0003gCaa_\f\u0005\u0002\u0005\u0005\u0007\"CAb/\u0005\u0005IQIAc\u0011%\t9mFA\u0001\n\u0003\u000bI\rC\u0005\u0002T^\t\t\u0011\"!\u0002V\"I\u00111]\f\u0002\u0002\u0013%\u0011Q\u001d\u0002!\u00032$XM\u001d+bE2,7+\u001a:EKB\u0013x\u000e]3si&,7oQ8n[\u0006tGM\u0003\u0002 A\u000591m\\7nC:$'BA\u0011#\u0003%)\u00070Z2vi&|gN\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001YYR\u0004\t\u0005\u0002.i5\taF\u0003\u00020a\u00059An\\4jG\u0006d'BA\u00193\u0003\u0015\u0001H.\u00198t\u0015\t\u0019$%\u0001\u0005dCR\fG._:u\u0013\t)dFA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA\u001c9\u001b\u0005q\u0012BA\u001d\u001f\u0005=\u0011VO\u001c8bE2,7i\\7nC:$\u0007CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$a\u0002)s_\u0012,8\r\u001e\t\u0003w\u0005K!A\u0011\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0013Q\f'\r\\3OC6,W#A#\u0011\u0005\u0019;U\"\u0001\u001a\n\u0005!\u0013$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u0015Q\f'\r\\3OC6,\u0007%\u0001\btKJ$Wm\u00117bgNt\u0015-\\3\u0016\u00031\u00032aO'P\u0013\tqEH\u0001\u0004PaRLwN\u001c\t\u0003!^s!!U+\u0011\u0005IcT\"A*\u000b\u0005QS\u0013A\u0002\u001fs_>$h(\u0003\u0002Wy\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1F(A\btKJ$Wm\u00117bgNt\u0015-\\3!\u0003=\u0019XM\u001d3f!J|\u0007/\u001a:uS\u0016\u001cX#A/\u0011\u0007mje\f\u0005\u0003Q?>{\u0015B\u00011Z\u0005\ri\u0015\r]\u0001\u0011g\u0016\u0014H-\u001a)s_B,'\u000f^5fg\u0002\n\u0001\u0002]1siN\u0003XmY\u000b\u0002IB\u00191(T3\u0011\u0005\u0019<hBA4u\u001d\tA'O\u0004\u0002jc:\u0011!\u000e\u001d\b\u0003W>t!\u0001\u001c8\u000f\u0005Ik\u0017\"A\u0015\n\u0005\u001dB\u0013BA\u0013'\u0013\t\u0019C%\u0003\u00024E%\u00111OM\u0001\bG\u0006$\u0018\r\\8h\u0013\t)h/\u0001\u0007DCR\fGn\\4UsB,7O\u0003\u0002te%\u0011\u00010\u001f\u0002\u0013)\u0006\u0014G.\u001a)beRLG/[8o'B,7M\u0003\u0002vm\u0006I\u0001/\u0019:u'B,7\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000futx0!\u0001\u0002\u0004A\u0011q\u0007\u0001\u0005\u0006\u0007&\u0001\r!\u0012\u0005\u0006\u0015&\u0001\r\u0001\u0014\u0005\u00067&\u0001\r!\u0018\u0005\u0006E&\u0001\r\u0001Z\u0001\u0004eVtG\u0003BA\u0005\u0003G\u0001b!a\u0003\u0002\u0016\u0005ma\u0002BA\u0007\u0003#q1AUA\b\u0013\u0005i\u0014bAA\ny\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\f\u00033\u00111aU3r\u0015\r\t\u0019\u0002\u0010\t\u0005\u0003;\ty\"D\u0001#\u0013\r\t\tC\t\u0002\u0004%><\bbBA\u0013\u0015\u0001\u0007\u0011qE\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003;\tI#C\u0002\u0002,\t\u0012Ab\u00159be.\u001cVm]:j_:\fAaY8qsRIQ0!\r\u00024\u0005U\u0012q\u0007\u0005\b\u0007.\u0001\n\u00111\u0001F\u0011\u001dQ5\u0002%AA\u00021CqaW\u0006\u0011\u0002\u0003\u0007Q\fC\u0004c\u0017A\u0005\t\u0019\u00013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\b\u0016\u0004\u000b\u0006}2FAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-C(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0014\u0002F\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u000b\u0016\u0004\u0019\u0006}\u0012AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u00037R3!XA \u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!\u0019+\u0007\u0011\fy$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003O\u0002B!!\u001b\u0002t5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'\u0001\u0003mC:<'BAA9\u0003\u0011Q\u0017M^1\n\u0007a\u000bY'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002zA\u00191(a\u001f\n\u0007\u0005uDHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0004\u0006%\u0005cA\u001e\u0002\u0006&\u0019\u0011q\u0011\u001f\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\fJ\t\t\u00111\u0001\u0002z\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!%\u0011\r\u0005M\u0015\u0011TAB\u001b\t\t)JC\u0002\u0002\u0018r\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY*!&\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003C\u000b9\u000bE\u0002<\u0003GK1!!*=\u0005\u001d\u0011un\u001c7fC:D\u0011\"a#\u0015\u0003\u0003\u0005\r!a!\u0002\r\u0015\fX/\u00197t)\u0011\t\t+!,\t\u0013\u0005-U#!AA\u0002\u0005\r\u0015\u0001I!mi\u0016\u0014H+\u00192mKN+'\u000fR3Qe>\u0004XM\u001d;jKN\u001cu.\\7b]\u0012\u0004\"aN\f\u0014\t]\t)\f\u0011\t\n\u0003o\u000bi,\u0012'^Ivl!!!/\u000b\u0007\u0005mF(A\u0004sk:$\u0018.\\3\n\t\u0005}\u0016\u0011\u0018\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DCAAY\u0003!!xn\u0015;sS:<GCAA4\u0003\u0015\t\u0007\u000f\u001d7z)%i\u00181ZAg\u0003\u001f\f\t\u000eC\u0003D5\u0001\u0007Q\tC\u0003K5\u0001\u0007A\nC\u0003\\5\u0001\u0007Q\fC\u0003c5\u0001\u0007A-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005]\u0017q\u001c\t\u0005w5\u000bI\u000eE\u0004<\u00037,E*\u00183\n\u0007\u0005uGH\u0001\u0004UkBdW\r\u000e\u0005\t\u0003C\\\u0012\u0011!a\u0001{\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003O\u0004B!!\u001b\u0002j&!\u00111^A6\u0005\u0019y%M[3di\u0002")
public class AlterTableSerDePropertiesCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final Option<String> serdeClassName;
    private final Option<Map<String, String>> serdeProperties;
    private final Option<Map<String, String>> partSpec;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TableIdentifier, Option<String>, Option<Map<String, String>>, Option<Map<String, String>>>> unapply(AlterTableSerDePropertiesCommand alterTableSerDePropertiesCommand) {
        return AlterTableSerDePropertiesCommand$.MODULE$.unapply(alterTableSerDePropertiesCommand);
    }

    public static Function1<Tuple4<TableIdentifier, Option<String>, Option<Map<String, String>>, Option<Map<String, String>>>, AlterTableSerDePropertiesCommand> tupled() {
        return AlterTableSerDePropertiesCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<String>, Function1<Option<Map<String, String>>, Function1<Option<Map<String, String>>, AlterTableSerDePropertiesCommand>>>> curried() {
        return AlterTableSerDePropertiesCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableSerDePropertiesCommand alterTableSerDePropertiesCommand = this;
        synchronized (alterTableSerDePropertiesCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<String> serdeClassName() {
        return this.serdeClassName;
    }

    public Option<Map<String, String>> serdeProperties() {
        return this.serdeProperties;
    }

    public Option<Map<String, String>> partSpec() {
        return this.partSpec;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        if (this.partSpec().isDefined() && DDLUtils$.MODULE$.isDatasourceTable(table)) {
            throw new AnalysisException("Operation not allowed: ALTER TABLE SET [SERDE | SERDEPROPERTIES] for a specific partition is not supported for tables created with the datasource API", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.serdeClassName().isDefined() && DDLUtils$.MODULE$.isDatasourceTable(table)) {
            throw new AnalysisException("Operation not allowed: ALTER TABLE SET SERDE is not supported for tables created with the datasource API", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.partSpec().isEmpty()) {
            Option x$1 = this.serdeClassName().orElse((Function0 & Serializable & scala.Serializable)() -> table.storage().serde());
            Map x$2 = table.storage().properties().$plus$plus((GenTraversableOnce)this.serdeProperties().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
            Option x$3 = table.withNewStorage$default$1();
            Option x$4 = table.withNewStorage$default$2();
            Option x$5 = table.withNewStorage$default$3();
            boolean x$6 = table.withNewStorage$default$4();
            CatalogTable newTable = table.withNewStorage(x$3, x$4, x$5, x$6, x$1, x$2);
            catalog.alterTable(newTable);
        } else {
            Map spec = (Map)this.partSpec().get();
            CatalogTablePartition part = catalog.getPartition(table.identifier(), spec);
            Option x$7 = this.serdeClassName().orElse((Function0 & Serializable & scala.Serializable)() -> part.storage().serde());
            Map x$8 = part.storage().properties().$plus$plus((GenTraversableOnce)this.serdeProperties().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
            Option x$9 = part.storage().copy$default$1();
            Option x$10 = part.storage().copy$default$2();
            Option x$11 = part.storage().copy$default$3();
            boolean x$12 = part.storage().copy$default$5();
            CatalogStorageFormat x$13 = part.storage().copy(x$9, x$10, x$11, x$7, x$12, x$8);
            Map x$14 = part.copy$default$1();
            Map x$15 = part.copy$default$3();
            long x$16 = part.copy$default$4();
            long x$17 = part.copy$default$5();
            Option x$18 = part.copy$default$6();
            CatalogTablePartition newPart = part.copy(x$14, x$13, x$15, x$16, x$17, x$18);
            catalog.alterPartitions(table.identifier(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{newPart})));
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableSerDePropertiesCommand copy(TableIdentifier tableName, Option<String> serdeClassName, Option<Map<String, String>> serdeProperties, Option<Map<String, String>> partSpec) {
        return new AlterTableSerDePropertiesCommand(tableName, serdeClassName, serdeProperties, partSpec);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<String> copy$default$2() {
        return this.serdeClassName();
    }

    public Option<Map<String, String>> copy$default$3() {
        return this.serdeProperties();
    }

    public Option<Map<String, String>> copy$default$4() {
        return this.partSpec();
    }

    public String productPrefix() {
        return "AlterTableSerDePropertiesCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.tableName();
                break;
            }
            case 1: {
                option = this.serdeClassName();
                break;
            }
            case 2: {
                option = this.serdeProperties();
                break;
            }
            case 3: {
                option = this.partSpec();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableSerDePropertiesCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableSerDePropertiesCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableSerDePropertiesCommand alterTableSerDePropertiesCommand = (AlterTableSerDePropertiesCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableSerDePropertiesCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<String> option = this.serdeClassName();
        Option<String> option2 = alterTableSerDePropertiesCommand.serdeClassName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Map<String, String>> option3 = this.serdeProperties();
        Option<Map<String, String>> option4 = alterTableSerDePropertiesCommand.serdeProperties();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Map<String, String>> option5 = this.partSpec();
        Option<Map<String, String>> option6 = alterTableSerDePropertiesCommand.partSpec();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!alterTableSerDePropertiesCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableSerDePropertiesCommand(TableIdentifier tableName, Option<String> serdeClassName, Option<Map<String, String>> serdeProperties, Option<Map<String, String>> partSpec) {
        this.tableName = tableName;
        this.serdeClassName = serdeClassName;
        this.serdeProperties = serdeProperties;
        this.partSpec = partSpec;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        Predef$.MODULE$.require(serdeClassName.isDefined() || serdeProperties.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "ALTER TABLE attempted to set neither serde class name nor serde properties");
    }
}

