/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeExec$;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.joins.HashedRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SparkFatalException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001\u0002\u0015*\u0001ZB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t!\u0002\u0011\t\u0012)A\u0005\r\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003T\u0011\u0015A\u0006\u0001\"\u0001Z\u0011!i\u0006A1A\u0005\u00025r\u0006BB4\u0001A\u0003%q\f\u0003\u0005i\u0001!\u0015\r\u0011\"\u0011j\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\t9\u0001\u0001C!\u0003\u0013A!\"a\u0003\u0001\u0011\u000b\u0007I\u0011BA\u0007\u0011)\t)\u0004\u0001EC\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003\u0003\u0002!\u0019!C\u0005\u0003\u0007B\u0001\"a\u0013\u0001A\u0003%\u0011Q\t\u0005\f\u0003\u001f\u0002\u0001R1A\u0005\u00025\n\t\u0006C\u0004\u0002^\u0001!\t&a\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0015\u0002j!A\u0011q\u0010\u0001\u0005R5\n\t\tC\u0005\u0002\u0018\u0002\t\t\u0011\"\u0001\u0002\u001a\"I\u0011q\u0014\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0015\u0005\n\u0003o\u0003\u0011\u0013!C\u0001\u0003sC\u0011\"!0\u0001\u0003\u0003%\t%a0\t\u0013\u0005\u0005\u0007!!A\u0005\u0002\u0005\r\u0007\"CAf\u0001\u0005\u0005I\u0011AAg\u0011%\t\u0019\u000eAA\u0001\n\u0003\n)\u000eC\u0005\u0002`\u0002\t\t\u0011\"\u0001\u0002b\"I\u00111\u001e\u0001\u0002\u0002\u0013\u0005\u0013Q^\u0004\b\u0003cL\u0003\u0012AAz\r\u0019A\u0013\u0006#\u0001\u0002v\"1\u0001,\bC\u0001\u0003{D\u0011\"a@\u001e\u0005\u0004%\t!a\u0011\t\u0011\t\u0005Q\u0004)A\u0005\u0003\u000bB\u0011Ba\u0001\u001e\u0005\u0004%\t!a\u0011\t\u0011\t\u0015Q\u0004)A\u0005\u0003\u000bB!Ba\u0002\u001e\u0005\u0004%\ta\u000bB\u0005\u0011!\u0011\t\"\bQ\u0001\n\t-\u0001\"\u0003B\n;\u0005\u0005I\u0011\u0011B\u000b\u0011%\u0011Y\"HA\u0001\n\u0003\u0013i\u0002C\u0005\u00030u\t\t\u0011\"\u0003\u00032\t)\"I]8bI\u000e\f7\u000f^#yG\"\fgnZ3Fq\u0016\u001c'B\u0001\u0016,\u0003!)\u0007p\u00195b]\u001e,'B\u0001\u0017.\u0003%)\u00070Z2vi&|gN\u0003\u0002/_\u0005\u00191/\u001d7\u000b\u0005A\n\u0014!B:qCJ\\'B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001om\n\u0005C\u0001\u001d:\u001b\u0005I\u0013B\u0001\u001e*\u0005!)\u0005p\u00195b]\u001e,\u0007C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002)s_\u0012,8\r\u001e\t\u0003y\tK!aQ\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t5|G-Z\u000b\u0002\rB\u0011qIT\u0007\u0002\u0011*\u0011\u0011JS\u0001\ta\"L8/[2bY*\u00111\nT\u0001\u0006a2\fgn\u001d\u0006\u0003\u001b6\n\u0001bY1uC2L8\u000f^\u0005\u0003\u001f\"\u0013QB\u0011:pC\u0012\u001c\u0017m\u001d;N_\u0012,\u0017!B7pI\u0016\u0004\u0013!B2iS2$W#A*\u0011\u0005Q+V\"A\u0016\n\u0005Y[#!C*qCJ\\\u0007\u000b\\1o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"2AW.]!\tA\u0004\u0001C\u0003E\u000b\u0001\u0007a\tC\u0003R\u000b\u0001\u00071+A\u0003sk:LE-F\u0001`!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003vi&d'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014A!V+J\t\u00061!/\u001e8JI\u0002\nq!\\3ue&\u001c7/F\u0001k!\u0011Y\u0007O\u001d=\u000e\u00031T!!\u001c8\u0002\u0013%lW.\u001e;bE2,'BA8>\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003c2\u00141!T1q!\t\u0019h/D\u0001u\u0015\t)8-\u0001\u0003mC:<\u0017BA<u\u0005\u0019\u0019FO]5oOB\u0011\u0011\u0010`\u0007\u0002u*\u00111pK\u0001\u0007[\u0016$(/[2\n\u0005uT(!C*R\u00196+GO]5d\u0003IyW\u000f\u001e9viB\u000b'\u000f^5uS>t\u0017N\\4\u0016\u0005\u0005\u0005\u0001cA$\u0002\u0004%\u0019\u0011Q\u0001%\u0003\u0019A\u000b'\u000f^5uS>t\u0017N\\4\u0002\u001d\u0011|7)\u00198p]&\u001c\u0017\r\\5{KR\t1+A\u0004qe>l\u0017n]3\u0016\u0005\u0005=\u0001CBA\t\u0003/\tY\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\u001f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u001a\u0005M!a\u0002)s_6L7/\u001a\t\u0007\u0003;\t\u0019#a\n\u000e\u0005\u0005}!bAA\u0011_\u0005I!M]8bI\u000e\f7\u000f^\u0005\u0005\u0003K\tyBA\u0005Ce>\fGmY1tiB\u0019A(!\u000b\n\u0007\u0005-RHA\u0002B]fD3aCA\u0018!\ra\u0014\u0011G\u0005\u0004\u0003gi$!\u0003;sC:\u001c\u0018.\u001a8u\u0003A\u0019w.\u001c9mKRLwN\u001c$viV\u0014X-\u0006\u0002\u0002:A1\u0011\u0011CA\u001e\u00037IA!!\u0010\u0002\u0014\t1a)\u001e;ve\u0016D3\u0001DA\u0018\u0003\u001d!\u0018.\\3pkR,\"!!\u0012\u0011\u0007q\n9%C\u0002\u0002Ju\u0012A\u0001T8oO\u0006AA/[7f_V$\b\u0005K\u0002\u000f\u0003_\taB]3mCRLwN\u001c$viV\u0014X-\u0006\u0002\u0002TA1\u0011QKA-\u00037i!!a\u0016\u000b\u0007\u0005U\u0011-\u0003\u0003\u0002>\u0005]\u0003fA\b\u00020\u0005IAm\u001c)sKB\f'/\u001a\u000b\u0003\u0003C\u00022\u0001PA2\u0013\r\t)'\u0010\u0002\u0005+:LG/A\u0005e_\u0016CXmY;uKR\u0011\u00111\u000e\t\u0007\u0003[\n\u0019(a\u001e\u000e\u0005\u0005=$bAA9_\u0005\u0019!\u000f\u001a3\n\t\u0005U\u0014q\u000e\u0002\u0004%\u0012#\u0005\u0003BA=\u0003wj\u0011\u0001T\u0005\u0004\u0003{b%aC%oi\u0016\u0014h.\u00197S_^\f!\u0003Z8Fq\u0016\u001cW\u000f^3Ce>\fGmY1tiV!\u00111QAF)\t\t)\t\u0005\u0004\u0002\u001e\u0005\r\u0012q\u0011\t\u0005\u0003\u0013\u000bY\t\u0004\u0001\u0005\u000f\u00055%C1\u0001\u0002\u0010\n\tA+\u0005\u0003\u0002\u0012\u0006\u001d\u0002c\u0001\u001f\u0002\u0014&\u0019\u0011QS\u001f\u0003\u000f9{G\u000f[5oO\u0006!1m\u001c9z)\u0015Q\u00161TAO\u0011\u001d!5\u0003%AA\u0002\u0019Cq!U\n\u0011\u0002\u0003\u00071+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r&f\u0001$\u0002&.\u0012\u0011q\u0015\t\u0005\u0003S\u000b\u0019,\u0004\u0002\u0002,*!\u0011QVAX\u0003%)hn\u00195fG.,GMC\u0002\u00022v\n!\"\u00198o_R\fG/[8o\u0013\u0011\t),a+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m&fA*\u0002&\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012A]\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000b\u00042\u0001PAd\u0013\r\tI-\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003O\ty\rC\u0005\u0002Rb\t\t\u00111\u0001\u0002F\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a6\u0011\r\u0005e\u00171\\A\u0014\u001b\u0005q\u0017bAAo]\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019/!;\u0011\u0007q\n)/C\u0002\u0002hv\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002Rj\t\t\u00111\u0001\u0002(\u00051Q-];bYN$B!a9\u0002p\"I\u0011\u0011[\u000e\u0002\u0002\u0003\u0007\u0011qE\u0001\u0016\u0005J|\u0017\rZ2bgR,\u0005p\u00195b]\u001e,W\t_3d!\tATd\u0005\u0003\u001e\u0003o\f\u0005c\u0001\u001f\u0002z&\u0019\u00111`\u001f\u0003\r\u0005s\u0017PU3g)\t\t\u00190\u0001\rN\u0003b{&IU(B\t\u000e\u000b5\u000bV0U\u0003\ncUi\u0018*P/N\u000b\u0011$T!Y?\n\u0013v*\u0011#D\u0003N#v\fV!C\u0019\u0016{&kT,TA\u0005IR*\u0011-`\u0005J{\u0015\tR\"B'R{F+\u0011\"M\u000b~\u0013\u0015\fV#T\u0003ii\u0015\tW0C%>\u000bEiQ!T)~#\u0016I\u0011'F?\nKF+R*!\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/\u0006\u0002\u0003\fA!\u0011\u0011\u0003B\u0007\u0013\u0011\u0011y!a\u0005\u0003?\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'oU3sm&\u001cW-A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002\nQ!\u00199qYf$RA\u0017B\f\u00053AQ\u0001R\u0013A\u0002\u0019CQ!U\u0013A\u0002M\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003 \t-\u0002#\u0002\u001f\u0003\"\t\u0015\u0012b\u0001B\u0012{\t1q\n\u001d;j_:\u0004R\u0001\u0010B\u0014\rNK1A!\u000b>\u0005\u0019!V\u000f\u001d7fe!A!Q\u0006\u0014\u0002\u0002\u0003\u0007!,A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!1\u0007\t\u0004g\nU\u0012b\u0001B\u001ci\n1qJ\u00196fGR\u0004")
public class BroadcastExchangeExec
extends Exchange {
    private Map<String, SQLMetric> metrics;
    private transient Promise<Broadcast<Object>> promise;
    private transient scala.concurrent.Future<Broadcast<Object>> completionFuture;
    private transient Future<Broadcast<Object>> relationFuture;
    private final BroadcastMode mode;
    private final SparkPlan child;
    private final UUID runId;
    private final transient long timeout;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<BroadcastMode, SparkPlan>> unapply(BroadcastExchangeExec broadcastExchangeExec) {
        return BroadcastExchangeExec$.MODULE$.unapply(broadcastExchangeExec);
    }

    public static long MAX_BROADCAST_TABLE_BYTES() {
        return BroadcastExchangeExec$.MODULE$.MAX_BROADCAST_TABLE_BYTES();
    }

    public static long MAX_BROADCAST_TABLE_ROWS() {
        return BroadcastExchangeExec$.MODULE$.MAX_BROADCAST_TABLE_ROWS();
    }

    public BroadcastMode mode() {
        return this.mode;
    }

    @Override
    public SparkPlan child() {
        return this.child;
    }

    public UUID runId() {
        return this.runId;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataSize"), (Object)SQLMetrics$.MODULE$.createSizeMetric(this.sparkContext(), "data size")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collectTime"), (Object)SQLMetrics$.MODULE$.createTimingMetric(this.sparkContext(), "time to collect")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buildTime"), (Object)SQLMetrics$.MODULE$.createTimingMetric(this.sparkContext(), "time to build")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broadcastTime"), (Object)SQLMetrics$.MODULE$.createTimingMetric(this.sparkContext(), "time to broadcast"))}));
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    @Override
    public Partitioning outputPartitioning() {
        return new BroadcastPartitioning(this.mode());
    }

    public SparkPlan doCanonicalize() {
        return new BroadcastExchangeExec(this.mode().canonicalized(), (SparkPlan)this.child().canonicalized());
    }

    private Promise<Broadcast<Object>> promise$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.promise = Promise$.MODULE$.apply();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.promise;
    }

    private Promise<Broadcast<Object>> promise() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.promise$lzycompute() : this.promise;
    }

    private scala.concurrent.Future<Broadcast<Object>> completionFuture$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.completionFuture = this.promise().future();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.completionFuture;
    }

    public scala.concurrent.Future<Broadcast<Object>> completionFuture() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.completionFuture$lzycompute() : this.completionFuture;
    }

    private long timeout() {
        return this.timeout;
    }

    private Future<Broadcast<Object>> relationFuture$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.relationFuture = SQLExecution$.MODULE$.withThreadLocalCaptured(this.sqlContext().sparkSession(), (ExecutorService)BroadcastExchangeExec$.MODULE$.executionContext(), (Function0 & Serializable & scala.Serializable)() -> {
                    Broadcast broadcast;
                    try {
                        long l;
                        Object relation;
                        this.sparkContext().setJobGroup(this.runId().toString(), new StringBuilder(27).append("broadcast exchange (runId ").append(this.runId()).append(")").toString(), true);
                        long beforeCollect = System.nanoTime();
                        Tuple2<Object, Iterator<InternalRow>> tuple2 = this.child().executeCollectIterator();
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        long numRows = tuple2._1$mcJ$sp();
                        Iterator input = (Iterator)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numRows), (Object)input);
                        Tuple2 tuple23 = tuple22;
                        long numRows2 = tuple23._1$mcJ$sp();
                        Iterator input2 = (Iterator)tuple23._2();
                        if (numRows2 >= BroadcastExchangeExec$.MODULE$.MAX_BROADCAST_TABLE_ROWS()) {
                            throw new SparkException(new StringBuilder(44).append("Cannot broadcast the table over ").append(BroadcastExchangeExec$.MODULE$.MAX_BROADCAST_TABLE_ROWS()).append(" rows: ").append(numRows2).append(" rows").toString());
                        }
                        long beforeBuild = System.nanoTime();
                        this.longMetric("collectTime").$plus$eq(TimeUnit.NANOSECONDS.toMillis(beforeBuild - beforeCollect));
                        Object object = relation = this.mode().transform(input2, (Option)new Some((Object)BoxesRunTime.boxToLong((long)numRows2)));
                        if (object instanceof HashedRelation) {
                            HashedRelation hashedRelation = (HashedRelation)object;
                            l = hashedRelation.estimatedSize();
                        } else if (object instanceof InternalRow[]) {
                            InternalRow[] internalRowArray = (InternalRow[])object;
                            l = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])internalRowArray)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)BroadcastExchangeExec.$anonfun$relationFuture$2(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                        } else {
                            throw new SparkException(new StringBuilder(56).append("[BUG] BroadcastMode.transform returned unexpected ").append("type: ").append(relation.getClass().getName()).toString());
                        }
                        long dataSize = l;
                        this.longMetric("dataSize").$plus$eq(dataSize);
                        if (dataSize >= BroadcastExchangeExec$.MODULE$.MAX_BROADCAST_TABLE_BYTES()) {
                            throw new SparkException(new StringBuilder(55).append("Cannot broadcast the table that is larger than 8GB: ").append(dataSize >> 30).append(" GB").toString());
                        }
                        long beforeBroadcast = System.nanoTime();
                        this.longMetric("buildTime").$plus$eq(TimeUnit.NANOSECONDS.toMillis(beforeBroadcast - beforeBuild));
                        Broadcast broadcasted = this.sparkContext().broadcast(relation, ClassTag$.MODULE$.Any());
                        this.longMetric("broadcastTime").$plus$eq(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beforeBroadcast));
                        String executionId = this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
                        SQLMetrics$.MODULE$.postDriverMetricUpdates(this.sparkContext(), executionId, (Seq<SQLMetric>)this.metrics().values().toSeq());
                        this.promise().trySuccess((Object)broadcasted);
                        broadcast = broadcasted;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof OutOfMemoryError) {
                            OutOfMemoryError outOfMemoryError = (OutOfMemoryError)throwable2;
                            SparkFatalException ex = new SparkFatalException(new OutOfMemoryError(new StringBuilder(225).append("Not enough memory to build and broadcast the table to all worker nodes. As a workaround, you can either disable broadcast by setting ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append(" to -1 or increase the spark ").append("driver memory by setting ").append("spark.driver.memory").append(" to a higher value.").toString()).initCause(outOfMemoryError.getCause()));
                            this.promise().tryFailure((Throwable)ex);
                            throw ex;
                        }
                        if (!NonFatal$.MODULE$.apply(throwable2)) {
                            SparkFatalException ex = new SparkFatalException(throwable2);
                            this.promise().tryFailure((Throwable)ex);
                            throw ex;
                        }
                        if (throwable2 != null) {
                            Throwable throwable3 = throwable2;
                            this.promise().tryFailure(throwable3);
                            throw throwable3;
                        }
                        throw throwable;
                    }
                    return broadcast;
                });
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.relationFuture;
    }

    public Future<Broadcast<Object>> relationFuture() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.relationFuture$lzycompute() : this.relationFuture;
    }

    @Override
    public void doPrepare() {
        this.relationFuture();
    }

    @Override
    public RDD<InternalRow> doExecute() {
        throw new UnsupportedOperationException("BroadcastExchange does not support the execute() code path.");
    }

    @Override
    public <T> Broadcast<T> doExecuteBroadcast() {
        Broadcast<Object> broadcast;
        try {
            broadcast = this.relationFuture().get(this.timeout(), TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            Object object;
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Could not execute broadcast in ").append(this.timeout()).append(" secs.").toString(), ex);
            if (!this.relationFuture().isDone()) {
                this.sparkContext().cancelJobGroup(this.runId().toString());
                object = BoxesRunTime.boxToBoolean((boolean)this.relationFuture().cancel(true));
            } else {
                object = BoxedUnit.UNIT;
            }
            throw new SparkException(new StringBuilder(130).append("Could not execute broadcast in ").append(this.timeout()).append(" secs. ").append("You can increase the timeout for broadcasts via ").append(SQLConf$.MODULE$.BROADCAST_TIMEOUT().key()).append(" or ").append("disable broadcast join by setting ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append(" to -1").toString(), (Throwable)ex);
        }
        return broadcast;
    }

    public BroadcastExchangeExec copy(BroadcastMode mode, SparkPlan child) {
        return new BroadcastExchangeExec(mode, child);
    }

    public BroadcastMode copy$default$1() {
        return this.mode();
    }

    public SparkPlan copy$default$2() {
        return this.child();
    }

    public String productPrefix() {
        return "BroadcastExchangeExec";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.mode();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BroadcastExchangeExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BroadcastExchangeExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        BroadcastExchangeExec broadcastExchangeExec = (BroadcastExchangeExec)x$1;
        BroadcastMode broadcastMode = this.mode();
        BroadcastMode broadcastMode2 = broadcastExchangeExec.mode();
        if (broadcastMode == null) {
            if (broadcastMode2 != null) {
                return false;
            }
        } else if (!broadcastMode.equals(broadcastMode2)) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = broadcastExchangeExec.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        if (!broadcastExchangeExec.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$relationFuture$2(InternalRow x$2) {
        return ((UnsafeRow)x$2).getSizeInBytes();
    }

    public BroadcastExchangeExec(BroadcastMode mode, SparkPlan child) {
        this.mode = mode;
        this.child = child;
        this.runId = UUID.randomUUID();
        this.timeout = SQLConf$.MODULE$.get().broadcastTimeout();
    }
}

