/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.optimizer.BuildLeft$;
import org.apache.spark.sql.catalyst.optimizer.BuildRight$;
import org.apache.spark.sql.catalyst.optimizer.BuildSide;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.SinglePartition$;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.PartialMapperPartitionSpec;
import org.apache.spark.sql.execution.ShufflePartitionSpec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.CustomShuffleReaderExec;
import org.apache.spark.sql.execution.adaptive.CustomShuffleReaderExec$;
import org.apache.spark.sql.execution.adaptive.CustomShuffleReaderRule;
import org.apache.spark.sql.execution.adaptive.OptimizeLocalShuffleReader$BroadcastJoinWithShuffleLeft$;
import org.apache.spark.sql.execution.adaptive.OptimizeLocalShuffleReader$BroadcastJoinWithShuffleRight$;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.execution.exchange.ENSURE_REQUIREMENTS$;
import org.apache.spark.sql.execution.exchange.EnsureRequirements$;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeLike;
import org.apache.spark.sql.execution.exchange.ShuffleOrigin;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class OptimizeLocalShuffleReader$
extends Rule<SparkPlan>
implements CustomShuffleReaderRule {
    public static OptimizeLocalShuffleReader$ MODULE$;
    private final Seq<ShuffleOrigin> supportedShuffleOrigins;
    private final EnsureRequirements$ ensureRequirements;

    static {
        new OptimizeLocalShuffleReader$();
    }

    @Override
    public Seq<ShuffleOrigin> supportedShuffleOrigins() {
        return this.supportedShuffleOrigins;
    }

    private EnsureRequirements$ ensureRequirements() {
        return this.ensureRequirements;
    }

    /*
     * WARNING - void declaration
     */
    private SparkPlan createProbeSideLocalReader(SparkPlan plan) {
        SparkPlan sparkPlan;
        SparkPlan optimizedPlan2 = (SparkPlan)plan.transformDown((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Tuple2<SparkPlan, BuildSide>> option;
                Object object;
                A1 A1 = x1;
                Option<Tuple2<SparkPlan, BuildSide>> option2 = OptimizeLocalShuffleReader$BroadcastJoinWithShuffleLeft$.MODULE$.unapply(A1);
                if (!option2.isEmpty()) {
                    SparkPlan shuffleStage = (SparkPlan)((Object)((Tuple2)option2.get())._1());
                    BuildSide buildSide = (BuildSide)((Tuple2)option2.get())._2();
                    if (BuildRight$.MODULE$.equals(buildSide)) {
                        CustomShuffleReaderExec localReader = OptimizeLocalShuffleReader$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeLocalShuffleReader$$createLocalReader(shuffleStage);
                        BroadcastHashJoinExec qual$1 = (BroadcastHashJoinExec)A1;
                        CustomShuffleReaderExec x$1 = localReader;
                        Seq<Expression> x$2 = qual$1.copy$default$1();
                        Seq<Expression> x$3 = qual$1.copy$default$2();
                        JoinType x$4 = qual$1.copy$default$3();
                        BuildSide x$5 = qual$1.copy$default$4();
                        Option<Expression> x$6 = qual$1.copy$default$5();
                        SparkPlan x$7 = qual$1.copy$default$7();
                        boolean x$8 = qual$1.copy$default$8();
                        object = qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8);
                        return (B1)object;
                    }
                }
                if (!(option = OptimizeLocalShuffleReader$BroadcastJoinWithShuffleRight$.MODULE$.unapply(A1)).isEmpty()) {
                    SparkPlan shuffleStage = (SparkPlan)((Object)((Tuple2)option.get())._1());
                    BuildSide buildSide = (BuildSide)((Tuple2)option.get())._2();
                    if (BuildLeft$.MODULE$.equals(buildSide)) {
                        CustomShuffleReaderExec localReader = OptimizeLocalShuffleReader$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeLocalShuffleReader$$createLocalReader(shuffleStage);
                        BroadcastHashJoinExec qual$2 = (BroadcastHashJoinExec)A1;
                        CustomShuffleReaderExec x$9 = localReader;
                        Seq<Expression> x$10 = qual$2.copy$default$1();
                        Seq<Expression> x$11 = qual$2.copy$default$2();
                        JoinType x$12 = qual$2.copy$default$3();
                        BuildSide x$13 = qual$2.copy$default$4();
                        Option<Expression> x$14 = qual$2.copy$default$5();
                        SparkPlan x$15 = qual$2.copy$default$6();
                        boolean x$16 = qual$2.copy$default$8();
                        object = qual$2.copy(x$10, x$11, x$12, x$13, x$14, x$15, x$9, x$16);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                BuildSide buildSide;
                Option<Tuple2<SparkPlan, BuildSide>> option;
                BuildSide buildSide2;
                SparkPlan sparkPlan = x1;
                Option<Tuple2<SparkPlan, BuildSide>> option2 = OptimizeLocalShuffleReader$BroadcastJoinWithShuffleLeft$.MODULE$.unapply(sparkPlan);
                boolean bl = !option2.isEmpty() && BuildRight$.MODULE$.equals(buildSide2 = (BuildSide)((Tuple2)option2.get())._2()) ? true : !(option = OptimizeLocalShuffleReader$BroadcastJoinWithShuffleRight$.MODULE$.unapply(sparkPlan)).isEmpty() && BuildLeft$.MODULE$.equals(buildSide = (BuildSide)((Tuple2)option.get())._2());
                return bl;
            }
        });
        int numShuffles = this.ensureRequirements().apply(optimizedPlan2).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof ShuffleExchangeExec) {
                    ShuffleExchangeExec shuffleExchangeExec = (ShuffleExchangeExec)A1;
                    object = shuffleExchangeExec;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                SparkPlan sparkPlan = x2;
                boolean bl = sparkPlan instanceof ShuffleExchangeExec;
                return bl;
            }
        }).length();
        if (numShuffles > 0) {
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> "OptimizeLocalShuffleReader rule is not applied due to additional shuffles will be introduced.");
            sparkPlan = plan;
        } else {
            void var2_2;
            sparkPlan = var2_2;
        }
        return sparkPlan;
    }

    public CustomShuffleReaderExec org$apache$spark$sql$execution$adaptive$OptimizeLocalShuffleReader$$createLocalReader(SparkPlan plan) {
        CustomShuffleReaderExec customShuffleReaderExec;
        CustomShuffleReaderExec customShuffleReaderExec2;
        SparkPlan s;
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof CustomShuffleReaderExec && (s = (customShuffleReaderExec2 = (CustomShuffleReaderExec)sparkPlan).child()) instanceof ShuffleQueryStageExec) {
            ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)s;
            customShuffleReaderExec = CustomShuffleReaderExec$.MODULE$.apply(shuffleQueryStageExec, this.getPartitionSpecs(shuffleQueryStageExec, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)customShuffleReaderExec2.partitionSpecs().length()))));
        } else if (sparkPlan instanceof ShuffleQueryStageExec) {
            ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan;
            customShuffleReaderExec = CustomShuffleReaderExec$.MODULE$.apply(shuffleQueryStageExec, this.getPartitionSpecs(shuffleQueryStageExec, (Option<Object>)None$.MODULE$));
        } else {
            throw new MatchError((Object)sparkPlan);
        }
        return customShuffleReaderExec;
    }

    private Seq<ShufflePartitionSpec> getPartitionSpecs(ShuffleQueryStageExec shuffleStage, Option<Object> advisoryParallelism) {
        int numMappers = shuffleStage.shuffle().numMappers();
        int numReducers = shuffleStage.shuffle().numPartitions();
        int expectedParallelism = BoxesRunTime.unboxToInt((Object)advisoryParallelism.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> numReducers));
        Seq<Object> splitPoints = numMappers == 0 ? (Seq<Object>)Seq$.MODULE$.empty() : this.equallyDivide(numReducers, package$.MODULE$.max(1, expectedParallelism / numMappers));
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMappers).flatMap((Function1 & Serializable & scala.Serializable)mapIndex -> OptimizeLocalShuffleReader$.$anonfun$getPartitionSpecs$2(splitPoints, numReducers, BoxesRunTime.unboxToInt((Object)mapIndex)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Seq<Object> equallyDivide(int numElements, int numBuckets) {
        int elementsPerBucket = numElements / numBuckets;
        int remaining = numElements % numBuckets;
        int splitPoint = (elementsPerBucket + 1) * remaining;
        return (Seq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remaining).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$1 -> x$1 * (elementsPerBucket + 1), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(remaining), numBuckets).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> splitPoint + (i - remaining) * elementsPerBucket, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public SparkPlan apply(SparkPlan plan) {
        SparkPlan sparkPlan;
        SparkPlan sparkPlan2;
        if (!BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.LOCAL_SHUFFLE_READER_ENABLED()))) {
            return plan;
        }
        SparkPlan sparkPlan3 = plan;
        if (sparkPlan3 != null && this.canUseLocalShuffleReader(sparkPlan2 = sparkPlan3)) {
            sparkPlan = this.org$apache$spark$sql$execution$adaptive$OptimizeLocalShuffleReader$$createLocalReader(sparkPlan2);
        } else if (sparkPlan3 != null) {
            SparkPlan sparkPlan4 = sparkPlan3;
            sparkPlan = this.createProbeSideLocalReader(sparkPlan4);
        } else {
            throw new MatchError((Object)sparkPlan3);
        }
        return sparkPlan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseLocalShuffleReader(SparkPlan plan) {
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof ShuffleQueryStageExec) {
            ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan;
            if (!shuffleQueryStageExec.mapStats().isDefined()) return false;
            if (!this.supportLocalReader(shuffleQueryStageExec.shuffle())) return false;
            return true;
        }
        if (!(sparkPlan instanceof CustomShuffleReaderExec)) return false;
        CustomShuffleReaderExec customShuffleReaderExec = (CustomShuffleReaderExec)sparkPlan;
        SparkPlan s = customShuffleReaderExec.child();
        Seq<ShufflePartitionSpec> partitionSpecs = customShuffleReaderExec.partitionSpecs();
        if (!(s instanceof ShuffleQueryStageExec)) return false;
        ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)s;
        if (!shuffleQueryStageExec.mapStats().isDefined()) return false;
        if (!partitionSpecs.nonEmpty()) return false;
        if (!this.supportLocalReader(shuffleQueryStageExec.shuffle())) return false;
        return true;
    }

    private boolean supportLocalReader(ShuffleExchangeLike s) {
        Partitioning partitioning = ((SparkPlan)((Object)s)).outputPartitioning();
        SinglePartition$ singlePartition$ = SinglePartition$.MODULE$;
        return (partitioning == null ? singlePartition$ != null : !partitioning.equals(singlePartition$)) && this.supportedShuffleOrigins().contains((Object)s.shuffleOrigin());
    }

    public static final /* synthetic */ Iterator $anonfun$getPartitionSpecs$2(Seq splitPoints$1, int numReducers$1, int mapIndex) {
        return ((IterableLike)splitPoints$1.$colon$plus((Object)BoxesRunTime.boxToInteger((int)numReducers$1), Seq$.MODULE$.canBuildFrom())).sliding(2).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq = x0$1;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            int start = BoxesRunTime.unboxToInt((Object)((SeqLike)some.get()).apply(0));
            int end = BoxesRunTime.unboxToInt((Object)((SeqLike)some.get()).apply(1));
            PartialMapperPartitionSpec partialMapperPartitionSpec = new PartialMapperPartitionSpec(mapIndex, start, end);
            return partialMapperPartitionSpec;
        });
    }

    private OptimizeLocalShuffleReader$() {
        MODULE$ = this;
        this.supportedShuffleOrigins = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ENSURE_REQUIREMENTS$[]{ENSURE_REQUIREMENTS$.MODULE$}));
        this.ensureRequirements = EnsureRequirements$.MODULE$;
    }
}

