/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import java.io.Serializable;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.CoalescedPartitionSpec;
import org.apache.spark.sql.execution.ShufflePartitionSpec;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

public final class ShufflePartitionsUtil$
implements Logging {
    public static ShufflePartitionsUtil$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ShufflePartitionsUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public final double SMALL_PARTITION_FACTOR() {
        return 0.2;
    }

    public final double MERGED_PARTITION_FACTOR() {
        return 1.2;
    }

    public Seq<ShufflePartitionSpec> coalescePartitions(MapOutputStatistics[] mapOutputStatistics, long advisoryTargetSize, int minNumPartitions) {
        long totalPostShuffleInputSize = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapOutputStatistics)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)ShufflePartitionsUtil$.$anonfun$coalescePartitions$1(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long maxTargetSize = package$.MODULE$.max((long)package$.MODULE$.ceil((double)totalPostShuffleInputSize / (double)minNumPartitions), 16L);
        long targetSize = package$.MODULE$.min(maxTargetSize, advisoryTargetSize);
        String shuffleIds = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapOutputStatistics)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.shuffleId()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).mkString(", ");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("For shuffle(").append(shuffleIds).append("), advisory target size: ").append(advisoryTargetSize).append(", ").append("actual target size ").append(targetSize).append(".").toString());
        int[] distinctNumShufflePartitions = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapOutputStatistics)).map((Function1 & Serializable & scala.Serializable)stats -> BoxesRunTime.boxToInteger((int)ShufflePartitionsUtil$.$anonfun$coalescePartitions$4(stats)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).distinct();
        Predef$.MODULE$.assert(distinctNumShufflePartitions.length == 1, (Function0 & Serializable & scala.Serializable)() -> "There should be only one distinct value of the number of shuffle partitions among registered Exchange operators.");
        int numPartitions = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(distinctNumShufflePartitions)).head());
        ArrayBuffer partitionSpecs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        IntRef latestSplitPoint = IntRef.create((int)0);
        LongRef coalescedSize = LongRef.create((long)0L);
        IntRef i = IntRef.create((int)0);
        while (i.elem < numPartitions) {
            long totalSizeOfCurrentPartition = 0L;
            for (int j = 0; j < mapOutputStatistics.length; ++j) {
                totalSizeOfCurrentPartition += mapOutputStatistics[j].bytesByPartitionId()[i.elem];
            }
            if (i.elem > latestSplitPoint.elem && coalescedSize.elem + totalSizeOfCurrentPartition > targetSize) {
                ShufflePartitionsUtil$.createPartitionSpec$1(ShufflePartitionsUtil$.createPartitionSpec$default$1$1(), coalescedSize, partitionSpecs, latestSplitPoint, i);
                latestSplitPoint.elem = i.elem;
                coalescedSize.elem = totalSizeOfCurrentPartition;
            } else {
                coalescedSize.elem += totalSizeOfCurrentPartition;
            }
            ++i.elem;
        }
        ShufflePartitionsUtil$.createPartitionSpec$1(partitionSpecs.isEmpty(), coalescedSize, partitionSpecs, latestSplitPoint, i);
        return partitionSpecs.toSeq();
    }

    public int[] splitSizeListByTargetSize(Seq<Object> sizes, long targetSize) {
        ArrayBuffer partitionStartIndices = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        LongRef currentPartitionSize = LongRef.create((long)0L);
        LongRef lastPartitionSize = LongRef.create((long)-1L);
        for (int i = 0; i < sizes.length(); ++i) {
            if (i > 0 && currentPartitionSize.elem + BoxesRunTime.unboxToLong((Object)sizes.apply(i)) > targetSize) {
                ShufflePartitionsUtil$.tryMergePartitions$1(lastPartitionSize, currentPartitionSize, targetSize, partitionStartIndices);
                partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                currentPartitionSize.elem = BoxesRunTime.unboxToLong((Object)sizes.apply(i));
                continue;
            }
            currentPartitionSize.elem += BoxesRunTime.unboxToLong((Object)sizes.apply(i));
        }
        ShufflePartitionsUtil$.tryMergePartitions$1(lastPartitionSize, currentPartitionSize, targetSize, partitionStartIndices);
        return (int[])partitionStartIndices.toArray(ClassTag$.MODULE$.Int());
    }

    public static final /* synthetic */ long $anonfun$coalescePartitions$1(MapOutputStatistics x$1) {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$1.bytesByPartitionId())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$coalescePartitions$4(MapOutputStatistics stats) {
        return stats.bytesByPartitionId().length;
    }

    private static final void createPartitionSpec$1(boolean forceCreate, LongRef coalescedSize$1, ArrayBuffer partitionSpecs$1, IntRef latestSplitPoint$1, IntRef i$1) {
        block0: {
            if (coalescedSize$1.elem <= 0L && !forceCreate) break block0;
            partitionSpecs$1.$plus$eq((Object)new CoalescedPartitionSpec(latestSplitPoint$1.elem, i$1.elem));
        }
    }

    private static final boolean createPartitionSpec$default$1$1() {
        return false;
    }

    private static final void tryMergePartitions$1(LongRef lastPartitionSize$1, LongRef currentPartitionSize$1, long targetSize$2, ArrayBuffer partitionStartIndices$1) {
        boolean shouldMergePartitions;
        boolean bl = shouldMergePartitions = lastPartitionSize$1.elem > -1L && ((double)(currentPartitionSize$1.elem + lastPartitionSize$1.elem) < (double)targetSize$2 * 1.2 || (double)currentPartitionSize$1.elem < (double)targetSize$2 * 0.2 || (double)lastPartitionSize$1.elem < (double)targetSize$2 * 0.2);
        if (shouldMergePartitions) {
            partitionStartIndices$1.remove(partitionStartIndices$1.length() - 1);
            lastPartitionSize$1.elem += currentPartitionSize$1.elem;
        } else {
            lastPartitionSize$1.elem = currentPartitionSize$1.elem;
        }
    }

    private ShufflePartitionsUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

