/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u0013'\u0001MB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!Y\u0007A!A!\u0002\u0013a\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011Q\u0004!Q1A\u0005BUD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\u0006w\u0002!\t\u0001 \u0005\n\u0003\u0017\u0001!\u0019!C!\u0003\u001bA\u0001\"!\u0007\u0001A\u0003%\u0011q\u0002\u0005\f\u00037\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0002C\u0006\u00022\u0001\u0001\r\u00111A\u0005\n\u0005M\u0002bCA \u0001\u0001\u0007\t\u0011)Q\u0005\u0003?A1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L!Y\u0011Q\u000b\u0001A\u0002\u0003\u0007I\u0011BA,\u0011-\tY\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0014\t\u0017\u0005}\u0003\u00011AA\u0002\u0013%\u0011\u0011\r\u0005\f\u0003G\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0007\u0003\u0006\u0002j\u0001\u0001\r\u0011!Q!\nEDq!!\u001c\u0001\t\u0003\ny\u0007C\u0004\u0002r\u0001!\t&!\b\t\u000f\u0005M\u0004\u0001\"\u0015\u0002L!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBA=\u0001\u0011%\u0011q\u000f\u0005\b\u0003w\u0002A\u0011IA?\u0011\u001d\ty\t\u0001C!\u0003#Cq!!'\u0001\t\u0003\tYjB\u0004\u0002(\u001aB\t!!+\u0007\r\u00152\u0003\u0012AAV\u0011\u0019Yh\u0004\"\u0001\u0002@\"A\u0011\u0011\u0019\u0010\u0005\u0002)\n\u0019\rC\u0004\u0002nz!\t!a<\t\u0013\u0005Uh$%A\u0005\u0002\u0005]\b\"\u0003B\u0007=E\u0005I\u0011\u0001B\b\u0011%\u0011\u0019BHI\u0001\n\u0003\u0011)BA\tJ]6+Wn\u001c:z\r&dW-\u00138eKbT!a\n\u0015\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003S)\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005-b\u0013aA:rY*\u0011QFL\u0001\u0006gB\f'o\u001b\u0006\u0003_A\na!\u00199bG\",'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0004CA\u001b7\u001b\u00051\u0013BA\u001c'\u0005i\u0001\u0016M\u001d;ji&|g.\u001b8h\u0003^\f'/\u001a$jY\u0016Le\u000eZ3y\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tQ4(D\u0001+\u0013\ta$F\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\ns_>$\b+\u0019;igN\u0003XmY5gS\u0016$\u0007cA J\u0019:\u0011\u0001I\u0012\b\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007J\na\u0001\u0010:p_Rt\u0014\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001dC\u0015a\u00029bG.\fw-\u001a\u0006\u0002\u000b&\u0011!j\u0013\u0002\u0004'\u0016\f(BA$I!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0002gg*\u0011\u0011KL\u0001\u0007Q\u0006$wn\u001c9\n\u0005Ms%\u0001\u0002)bi\"\f!\u0002]1sC6,G/\u001a:t!\u00111&,X/\u000f\u0005]C\u0006CA!I\u0013\tI\u0006*\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u00131!T1q\u0015\tI\u0006\n\u0005\u0002W=&\u0011q\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u0002'U\u001cXM]*qK\u000eLg-[3e'\u000eDW-\\1\u0011\u0007\t\u001cW-D\u0001I\u0013\t!\u0007J\u0001\u0004PaRLwN\u001c\t\u0003M&l\u0011a\u001a\u0006\u0003Q*\nQ\u0001^=qKNL!A[4\u0003\u0015M#(/^2u)f\u0004X-A\bgS2,7\u000b^1ukN\u001c\u0015m\u00195f!\t)T.\u0003\u0002oM\tya)\u001b7f'R\fG/^:DC\u000eDW-\u0001\u000evg\u0016\u00148\u000b]3dS\u001aLW\r\u001a)beRLG/[8o'B,7\rE\u0002cGF\u0004\"!\u000e:\n\u0005M4#!\u0004)beRLG/[8o'B,7-A\tnKR\fG-\u0019;b\u001fB\u001cH+[7f\u001dN,\u0012A\u001e\t\u0004E\u000e<\bC\u00012y\u0013\tI\bJ\u0001\u0003M_:<\u0017AE7fi\u0006$\u0017\r^1PaN$\u0016.\\3Og\u0002\na\u0001P5oSRtD#D?\u007f\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\tI\u0001\u0005\u00026\u0001!)\u0001(\u0003a\u0001s!)Q(\u0003a\u0001}!)A+\u0003a\u0001+\")\u0001-\u0003a\u0001C\"91.\u0003I\u0001\u0002\u0004a\u0007bB8\n!\u0003\u0005\r\u0001\u001d\u0005\bi&\u0001\n\u00111\u0001w\u0003%\u0011xn\u001c;QCRD7/\u0006\u0002\u0002\u0010A)\u0011\u0011CA\f\u00196\u0011\u00111\u0003\u0006\u0004\u0003+A\u0015AC2pY2,7\r^5p]&\u0019!*a\u0005\u0002\u0015I|w\u000e\u001e)bi\"\u001c\b%A\bdC\u000eDW\r\u001a'fC\u001a4\u0015\u000e\\3t+\t\ty\u0002E\u0004\u0002\"\u0005\u001dB*a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003'\tq!\\;uC\ndW-\u0003\u0003\u0002*\u0005\r\"!\u0004'j].,G\rS1tQ6\u000b\u0007\u000fE\u0002N\u0003[I1!a\fO\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\u0014G\u0006\u001c\u0007.\u001a3MK\u00064g)\u001b7fg~#S-\u001d\u000b\u0005\u0003k\tY\u0004E\u0002c\u0003oI1!!\u000fI\u0005\u0011)f.\u001b;\t\u0013\u0005uR\"!AA\u0002\u0005}\u0011a\u0001=%c\u0005\u00012-Y2iK\u0012dU-\u00194GS2,7\u000f\t\u0015\u0004\u001d\u0005\r\u0003c\u00012\u0002F%\u0019\u0011q\t%\u0003\u0011Y|G.\u0019;jY\u0016\fAdY1dQ\u0016$G*Z1g\t&\u0014Hk\\\"iS2$'/\u001a8GS2,7/\u0006\u0002\u0002NA)aK\u0017'\u0002PA)!-!\u0015\u0002,%\u0019\u00111\u000b%\u0003\u000b\u0005\u0013(/Y=\u0002A\r\f7\r[3e\u0019\u0016\fg\rR5s)>\u001c\u0005.\u001b7ee\u0016tg)\u001b7fg~#S-\u001d\u000b\u0005\u0003k\tI\u0006C\u0005\u0002>A\t\t\u00111\u0001\u0002N\u0005i2-Y2iK\u0012dU-\u00194ESJ$vn\u00115jY\u0012\u0014XM\u001c$jY\u0016\u001c\b\u0005K\u0002\u0012\u0003\u0007\n1cY1dQ\u0016$\u0007+\u0019:uSRLwN\\*qK\u000e,\u0012!]\u0001\u0018G\u0006\u001c\u0007.\u001a3QCJ$\u0018\u000e^5p]N\u0003XmY0%KF$B!!\u000e\u0002h!A\u0011QH\n\u0002\u0002\u0003\u0007\u0011/\u0001\u000bdC\u000eDW\r\u001a)beRLG/[8o'B,7\r\t\u0015\u0004)\u0005\r\u0013!\u00049beRLG/[8o'B,7\rF\u0001r\u0003%aW-\u00194GS2,7/\u0001\fmK\u00064G)\u001b:U_\u000eC\u0017\u000e\u001c3sK:4\u0015\u000e\\3t\u0003\u001d\u0011XM\u001a:fg\"$\"!!\u000e\u0002\u0011I,gM]3tQB\na!Z9vC2\u001cH\u0003BA@\u0003\u000b\u00032AYAA\u0013\r\t\u0019\t\u0013\u0002\b\u0005>|G.Z1o\u0011\u001d\t9I\u0007a\u0001\u0003\u0013\u000bQa\u001c;iKJ\u00042AYAF\u0013\r\ti\t\u0013\u0002\u0004\u0003:L\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005M\u0005c\u00012\u0002\u0016&\u0019\u0011q\u0013%\u0003\u0007%sG/A\u0007mSN$H*Z1g\r&dWm\u001d\u000b\u0005\u0003;\u000b\u0019\u000b\u0005\u0004\u0002\"\u0005}\u00151F\u0005\u0005\u0003C\u000b\u0019CA\u0007MS:\\W\r\u001a%bg\"\u001cV\r\u001e\u0005\u0007\u0003Kc\u0002\u0019\u0001 \u0002\u000bA\fG\u000f[:\u0002#%sW*Z7pef4\u0015\u000e\\3J]\u0012,\u0007\u0010\u0005\u00026=M)a$!,\u00024B\u0019!-a,\n\u0007\u0005E\u0006J\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003k\u000bY,\u0004\u0002\u00028*\u0019\u0011\u0011\u0018\u0017\u0002\u0011%tG/\u001a:oC2LA!!0\u00028\n9Aj\\4hS:<GCAAU\u0003E\u0011W\u000f\\6MSN$H*Z1g\r&dWm\u001d\u000b\u000b\u0003\u000b\fy-!5\u0002b\u0006-\b\u0003B J\u0003\u000f\u0004bAYAe\u0019\u00065\u0017bAAf\u0011\n1A+\u001e9mKJ\u0002BaP%\u0002,!1\u0011Q\u0015\u0011A\u0002yBq!a5!\u0001\u0004\t).\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!a6\u0002^6\u0011\u0011\u0011\u001c\u0006\u0004\u00037\u0004\u0016\u0001B2p]\u001aLA!a8\u0002Z\ni1i\u001c8gS\u001e,(/\u0019;j_:Dq!a9!\u0001\u0004\t)/\u0001\u0004gS2$XM\u001d\t\u0004\u001b\u0006\u001d\u0018bAAu\u001d\nQ\u0001+\u0019;i\r&dG/\u001a:\t\u000ba\u0002\u0003\u0019A\u001d\u0002\u001fMDw.\u001e7e\r&dG/\u001a:PkR$B!a \u0002r\"1\u00111_\u0011A\u0002u\u000b\u0001\u0002]1uQ:\u000bW.Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005e(f\u00017\u0002|.\u0012\u0011Q \t\u0005\u0003\u007f\u0014I!\u0004\u0002\u0003\u0002)!!1\u0001B\u0003\u0003%)hn\u00195fG.,GMC\u0002\u0003\b!\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YA!\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0005#Q3\u0001]A~\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!q\u0003\u0016\u0004m\u0006m\b")
public class InMemoryFileIndex
extends PartitioningAwareFileIndex {
    private final SparkSession sparkSession;
    private final FileStatusCache fileStatusCache;
    private final Option<PartitionSpec> userSpecifiedPartitionSpec;
    private final Option<Object> metadataOpsTimeNs;
    private final Seq<Path> rootPaths;
    private volatile LinkedHashMap<Path, FileStatus> cachedLeafFiles;
    private volatile Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles;
    private volatile PartitionSpec cachedPartitionSpec;

    public static Option<Object> $lessinit$greater$default$7() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<PartitionSpec> $lessinit$greater$default$6() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6();
    }

    public static FileStatusCache $lessinit$greater$default$5() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean shouldFilterOut(String string) {
        return InMemoryFileIndex$.MODULE$.shouldFilterOut(string);
    }

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return this.metadataOpsTimeNs;
    }

    @Override
    public Seq<Path> rootPaths() {
        return this.rootPaths;
    }

    private LinkedHashMap<Path, FileStatus> cachedLeafFiles() {
        return this.cachedLeafFiles;
    }

    private void cachedLeafFiles_$eq(LinkedHashMap<Path, FileStatus> x$1) {
        this.cachedLeafFiles = x$1;
    }

    private Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles;
    }

    private void cachedLeafDirToChildrenFiles_$eq(Map<Path, FileStatus[]> x$1) {
        this.cachedLeafDirToChildrenFiles = x$1;
    }

    private PartitionSpec cachedPartitionSpec() {
        return this.cachedPartitionSpec;
    }

    private void cachedPartitionSpec_$eq(PartitionSpec x$1) {
        this.cachedPartitionSpec = x$1;
    }

    @Override
    public PartitionSpec partitionSpec() {
        if (this.cachedPartitionSpec() == null) {
            if (this.userSpecifiedPartitionSpec.isDefined()) {
                this.cachedPartitionSpec_$eq((PartitionSpec)this.userSpecifiedPartitionSpec.get());
            } else {
                this.cachedPartitionSpec_$eq(this.inferPartitioning());
            }
        }
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Partition spec: ").append(this.cachedPartitionSpec()).toString());
        return this.cachedPartitionSpec();
    }

    @Override
    public LinkedHashMap<Path, FileStatus> leafFiles() {
        return this.cachedLeafFiles();
    }

    @Override
    public Map<Path, FileStatus[]> leafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles();
    }

    @Override
    public void refresh() {
        this.fileStatusCache.invalidateAll();
        this.refresh0();
    }

    private void refresh0() {
        LinkedHashSet<FileStatus> files = this.listLeafFiles(this.rootPaths());
        this.cachedLeafFiles_$eq((LinkedHashMap<Path, FileStatus>)((LinkedHashMap)new LinkedHashMap().$plus$plus$eq((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getPath()), f), LinkedHashSet$.MODULE$.canBuildFrom()))));
        this.cachedLeafDirToChildrenFiles_$eq((Map<Path, FileStatus[]>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files.toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().getParent()));
        this.cachedPartitionSpec_$eq(null);
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof InMemoryFileIndex) {
            InMemoryFileIndex inMemoryFileIndex = (InMemoryFileIndex)object;
            Set set = this.rootPaths().toSet();
            Set set2 = inMemoryFileIndex.rootPaths().toSet();
            bl = !(set != null ? !set.equals(set2) : set2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.rootPaths().toSet().hashCode();
    }

    public LinkedHashSet<FileStatus> listLeafFiles(Seq<Path> paths) {
        long startTime = System.nanoTime();
        LinkedHashSet output = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer pathsToFetch = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        paths.foreach((Function1 & Serializable & scala.Serializable)path -> {
            InMemoryFileIndex.$anonfun$listLeafFiles$1(this, output, pathsToFetch, path);
            return BoxedUnit.UNIT;
        });
        PathFilter filter = FileInputFormat.getInputPathFilter((JobConf)new JobConf(this.hadoopConf(), this.getClass()));
        Seq<Tuple2<Path, Seq<FileStatus>>> discovered = InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)pathsToFetch.toSeq(), this.hadoopConf(), filter, this.sparkSession);
        discovered.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            Seq leafFiles = (Seq)tuple2._2();
            HiveCatalogMetrics$.MODULE$.incrementFilesDiscovered(leafFiles.size());
            $this.fileStatusCache.putLeafFiles(path, (FileStatus[])leafFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
            LinkedHashSet linkedHashSet = (LinkedHashSet)output.$plus$plus$eq((TraversableOnce)leafFiles);
            return linkedHashSet;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("It took ").append((System.nanoTime() - startTime) / 1000000L).append(" ms to list leaf files").append(" for ").append(paths.length()).append(" paths.").toString());
        return output;
    }

    public static final /* synthetic */ void $anonfun$listLeafFiles$1(InMemoryFileIndex $this, LinkedHashSet output$1, ArrayBuffer pathsToFetch$1, Path path) {
        ArrayBuffer arrayBuffer;
        Option<FileStatus[]> option = $this.fileStatusCache.getLeafFiles(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            FileStatus[] files = (FileStatus[])some.value();
            HiveCatalogMetrics$.MODULE$.incrementFileCacheHits(files.length);
            arrayBuffer = (AbstractIterable)output$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)));
        } else if (None$.MODULE$.equals(option)) {
            arrayBuffer = pathsToFetch$1.$plus$eq((Object)path);
        } else {
            throw new MatchError(option);
        }
    }

    public InMemoryFileIndex(SparkSession sparkSession, Seq<Path> rootPathsSpecified, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache, Option<PartitionSpec> userSpecifiedPartitionSpec, Option<Object> metadataOpsTimeNs) {
        this.sparkSession = sparkSession;
        this.fileStatusCache = fileStatusCache;
        this.userSpecifiedPartitionSpec = userSpecifiedPartitionSpec;
        this.metadataOpsTimeNs = metadataOpsTimeNs;
        super(sparkSession, parameters, userSpecifiedSchema, fileStatusCache);
        this.rootPaths = (Seq)rootPathsSpecified.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(x$1, this.hadoopConf())));
        this.refresh0();
    }
}

