/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ValuesType;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils;
import org.apache.spark.sql.execution.datasources.SchemaColumnConvertNotSupportedException;
import org.apache.spark.sql.execution.datasources.parquet.ParquetDictionary;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowConverter;
import org.apache.spark.sql.execution.datasources.parquet.SpecificParquetRecordReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedPlainValuesReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedRleValuesReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedValuesReader;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;

public class VectorizedColumnReader {
    private long valuesRead;
    private long endOfPageValueCount;
    private final Dictionary dictionary;
    private boolean isCurrentPageDictionaryEncoded;
    private final int maxDefLevel;
    private SpecificParquetRecordReaderBase.IntIterator repetitionLevelColumn;
    private SpecificParquetRecordReaderBase.IntIterator definitionLevelColumn;
    private ValuesReader dataColumn;
    private VectorizedRleValuesReader defColumn;
    private final long totalValueCount;
    private int pageValueCount;
    private final PageReader pageReader;
    private final ColumnDescriptor descriptor;
    private final OriginalType originalType;
    private final ZoneId convertTz;
    private static final ZoneId UTC = ZoneOffset.UTC;
    private final String datetimeRebaseMode;
    private final String int96RebaseMode;

    public VectorizedColumnReader(ColumnDescriptor descriptor, OriginalType originalType, PageReader pageReader, ZoneId convertTz, String datetimeRebaseMode, String int96RebaseMode) throws IOException {
        this.descriptor = descriptor;
        this.pageReader = pageReader;
        this.convertTz = convertTz;
        this.originalType = originalType;
        this.maxDefLevel = descriptor.getMaxDefinitionLevel();
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException("could not decode the dictionary for " + descriptor, e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
        this.totalValueCount = pageReader.getTotalValueCount();
        if (this.totalValueCount == 0L) {
            throw new IOException("totalValueCount == 0");
        }
        assert ("LEGACY".equals(datetimeRebaseMode) || "EXCEPTION".equals(datetimeRebaseMode) || "CORRECTED".equals(datetimeRebaseMode));
        this.datetimeRebaseMode = datetimeRebaseMode;
        assert ("LEGACY".equals(int96RebaseMode) || "EXCEPTION".equals(int96RebaseMode) || "CORRECTED".equals(int96RebaseMode));
        this.int96RebaseMode = int96RebaseMode;
    }

    private boolean next() throws IOException {
        if (this.valuesRead >= this.endOfPageValueCount) {
            if (this.valuesRead >= this.totalValueCount) {
                return false;
            }
            this.readPage();
        }
        ++this.valuesRead;
        return this.definitionLevelColumn.nextInt() == this.maxDefLevel;
    }

    private boolean isLazyDecodingSupported(PrimitiveType.PrimitiveTypeName typeName) {
        boolean isSupported = false;
        switch (typeName) {
            case INT32: {
                isSupported = this.originalType != OriginalType.DATE || "CORRECTED".equals(this.datetimeRebaseMode);
                break;
            }
            case INT64: {
                if (this.originalType == OriginalType.TIMESTAMP_MICROS) {
                    isSupported = "CORRECTED".equals(this.datetimeRebaseMode);
                    break;
                }
                isSupported = this.originalType != OriginalType.TIMESTAMP_MILLIS;
                break;
            }
            case FLOAT: 
            case DOUBLE: 
            case BINARY: {
                isSupported = true;
            }
        }
        return isSupported;
    }

    static int rebaseDays(int julianDays, boolean failIfRebase) {
        if (failIfRebase) {
            if (julianDays < RebaseDateTime.lastSwitchJulianDay()) {
                throw DataSourceUtils.newRebaseExceptionInRead("Parquet");
            }
            return julianDays;
        }
        return RebaseDateTime.rebaseJulianToGregorianDays((int)julianDays);
    }

    private static long rebaseTimestamp(long julianMicros, boolean failIfRebase, String format) {
        if (failIfRebase) {
            if (julianMicros < RebaseDateTime.lastSwitchJulianTs()) {
                throw DataSourceUtils.newRebaseExceptionInRead(format);
            }
            return julianMicros;
        }
        return RebaseDateTime.rebaseJulianToGregorianMicros((long)julianMicros);
    }

    static long rebaseMicros(long julianMicros, boolean failIfRebase) {
        return VectorizedColumnReader.rebaseTimestamp(julianMicros, failIfRebase, "Parquet");
    }

    static long rebaseInt96(long julianMicros, boolean failIfRebase) {
        return VectorizedColumnReader.rebaseTimestamp(julianMicros, failIfRebase, "Parquet INT96");
    }

    void readBatch(int total, WritableColumnVector column) throws IOException {
        int rowId = 0;
        WritableColumnVector dictionaryIds = null;
        if (this.dictionary != null) {
            dictionaryIds = column.reserveDictionaryIds(total);
        }
        while (total > 0) {
            int leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            if (leftInPage == 0) {
                this.readPage();
                leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            }
            int num = Math.min(total, leftInPage);
            PrimitiveType.PrimitiveTypeName typeName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
            if (this.isCurrentPageDictionaryEncoded) {
                this.defColumn.readIntegers(num, dictionaryIds, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
                if (column.hasDictionary() || rowId == 0 && this.isLazyDecodingSupported(typeName)) {
                    column.setDictionary(new ParquetDictionary(this.dictionary));
                } else {
                    this.decodeDictionaryIds(rowId, num, column, dictionaryIds);
                }
            } else {
                if (column.hasDictionary() && rowId != 0) {
                    this.decodeDictionaryIds(0, rowId, column, column.getDictionaryIds());
                }
                column.setDictionary(null);
                switch (typeName) {
                    case BOOLEAN: {
                        this.readBooleanBatch(rowId, num, column);
                        break;
                    }
                    case INT32: {
                        this.readIntBatch(rowId, num, column);
                        break;
                    }
                    case INT64: {
                        this.readLongBatch(rowId, num, column);
                        break;
                    }
                    case INT96: {
                        this.readBinaryBatch(rowId, num, column);
                        break;
                    }
                    case FLOAT: {
                        this.readFloatBatch(rowId, num, column);
                        break;
                    }
                    case DOUBLE: {
                        this.readDoubleBatch(rowId, num, column);
                        break;
                    }
                    case BINARY: {
                        this.readBinaryBatch(rowId, num, column);
                        break;
                    }
                    case FIXED_LEN_BYTE_ARRAY: {
                        this.readFixedLenByteArrayBatch(rowId, num, column, this.descriptor.getPrimitiveType().getTypeLength());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported type: " + typeName);
                    }
                }
            }
            this.valuesRead += (long)num;
            rowId += num;
            total -= num;
        }
    }

    private boolean shouldConvertTimestamps() {
        return this.convertTz != null && !this.convertTz.equals(UTC);
    }

    private SchemaColumnConvertNotSupportedException constructConvertNotSupportedException(ColumnDescriptor descriptor, WritableColumnVector column) {
        return new SchemaColumnConvertNotSupportedException(Arrays.toString(descriptor.getPath()), descriptor.getPrimitiveType().getPrimitiveTypeName().toString(), column.dataType().catalogString());
    }

    private void decodeDictionaryIds(int rowId, int num, WritableColumnVector column, WritableColumnVector dictionaryIds) {
        switch (this.descriptor.getPrimitiveType().getPrimitiveTypeName()) {
            case INT32: {
                if (column.dataType() == DataTypes.IntegerType || DecimalType.is32BitDecimalType((DataType)column.dataType()) || column.dataType() == DataTypes.DateType && "CORRECTED".equals(this.datetimeRebaseMode)) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        column.putInt(i, this.dictionary.decodeToInt(dictionaryIds.getDictId(i)));
                    }
                    break;
                }
                if (column.dataType() == DataTypes.ByteType) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        column.putByte(i, (byte)this.dictionary.decodeToInt(dictionaryIds.getDictId(i)));
                    }
                    break;
                }
                if (column.dataType() == DataTypes.ShortType) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        column.putShort(i, (short)this.dictionary.decodeToInt(dictionaryIds.getDictId(i)));
                    }
                    break;
                }
                if (column.dataType() == DataTypes.DateType) {
                    boolean failIfRebase = "EXCEPTION".equals(this.datetimeRebaseMode);
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        int julianDays = this.dictionary.decodeToInt(dictionaryIds.getDictId(i));
                        column.putInt(i, VectorizedColumnReader.rebaseDays(julianDays, failIfRebase));
                    }
                    break;
                }
                throw this.constructConvertNotSupportedException(this.descriptor, column);
            }
            case INT64: {
                if (column.dataType() == DataTypes.LongType || DecimalType.is64BitDecimalType((DataType)column.dataType()) || this.originalType == OriginalType.TIMESTAMP_MICROS && "CORRECTED".equals(this.datetimeRebaseMode)) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        column.putLong(i, this.dictionary.decodeToLong(dictionaryIds.getDictId(i)));
                    }
                    break;
                }
                if (this.originalType == OriginalType.TIMESTAMP_MILLIS) {
                    if ("CORRECTED".equals(this.datetimeRebaseMode)) {
                        for (int i = rowId; i < rowId + num; ++i) {
                            if (column.isNullAt(i)) continue;
                            long gregorianMillis = this.dictionary.decodeToLong(dictionaryIds.getDictId(i));
                            column.putLong(i, DateTimeUtils.millisToMicros((long)gregorianMillis));
                        }
                    } else {
                        boolean failIfRebase = "EXCEPTION".equals(this.datetimeRebaseMode);
                        for (int i = rowId; i < rowId + num; ++i) {
                            if (column.isNullAt(i)) continue;
                            long julianMillis = this.dictionary.decodeToLong(dictionaryIds.getDictId(i));
                            long julianMicros = DateTimeUtils.millisToMicros((long)julianMillis);
                            column.putLong(i, VectorizedColumnReader.rebaseMicros(julianMicros, failIfRebase));
                        }
                    }
                    break;
                }
                if (this.originalType == OriginalType.TIMESTAMP_MICROS) {
                    boolean failIfRebase = "EXCEPTION".equals(this.datetimeRebaseMode);
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        long julianMicros = this.dictionary.decodeToLong(dictionaryIds.getDictId(i));
                        column.putLong(i, VectorizedColumnReader.rebaseMicros(julianMicros, failIfRebase));
                    }
                    break;
                }
                throw this.constructConvertNotSupportedException(this.descriptor, column);
            }
            case FLOAT: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNullAt(i)) continue;
                    column.putFloat(i, this.dictionary.decodeToFloat(dictionaryIds.getDictId(i)));
                }
                break;
            }
            case DOUBLE: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNullAt(i)) continue;
                    column.putDouble(i, this.dictionary.decodeToDouble(dictionaryIds.getDictId(i)));
                }
                break;
            }
            case INT96: {
                if (column.dataType() == DataTypes.TimestampType) {
                    boolean failIfRebase = "EXCEPTION".equals(this.int96RebaseMode);
                    if (!this.shouldConvertTimestamps()) {
                        if ("CORRECTED".equals(this.int96RebaseMode)) {
                            for (int i = rowId; i < rowId + num; ++i) {
                                if (column.isNullAt(i)) continue;
                                Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                                column.putLong(i, ParquetRowConverter.binaryToSQLTimestamp(v));
                            }
                        } else {
                            for (int i = rowId; i < rowId + num; ++i) {
                                if (column.isNullAt(i)) continue;
                                Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                                long julianMicros = ParquetRowConverter.binaryToSQLTimestamp(v);
                                long gregorianMicros = VectorizedColumnReader.rebaseInt96(julianMicros, failIfRebase);
                                column.putLong(i, gregorianMicros);
                            }
                        }
                    } else if ("CORRECTED".equals(this.int96RebaseMode)) {
                        for (int i = rowId; i < rowId + num; ++i) {
                            if (column.isNullAt(i)) continue;
                            Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                            long gregorianMicros = ParquetRowConverter.binaryToSQLTimestamp(v);
                            long adjTime = DateTimeUtils.convertTz((long)gregorianMicros, (ZoneId)this.convertTz, (ZoneId)UTC);
                            column.putLong(i, adjTime);
                        }
                    } else {
                        for (int i = rowId; i < rowId + num; ++i) {
                            if (column.isNullAt(i)) continue;
                            Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                            long julianMicros = ParquetRowConverter.binaryToSQLTimestamp(v);
                            long gregorianMicros = VectorizedColumnReader.rebaseInt96(julianMicros, failIfRebase);
                            long adjTime = DateTimeUtils.convertTz((long)gregorianMicros, (ZoneId)this.convertTz, (ZoneId)UTC);
                            column.putLong(i, adjTime);
                        }
                    }
                    break;
                }
                throw this.constructConvertNotSupportedException(this.descriptor, column);
            }
            case BINARY: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNullAt(i)) continue;
                    Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                    column.putByteArray(i, v.getBytes());
                }
                break;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                if (DecimalType.is32BitDecimalType((DataType)column.dataType())) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                        column.putInt(i, (int)ParquetRowConverter.binaryToUnscaledLong(v));
                    }
                    break;
                }
                if (DecimalType.is64BitDecimalType((DataType)column.dataType())) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                        column.putLong(i, ParquetRowConverter.binaryToUnscaledLong(v));
                    }
                    break;
                }
                if (DecimalType.isByteArrayDecimalType((DataType)column.dataType())) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                        column.putByteArray(i, v.getBytes());
                    }
                    break;
                }
                throw this.constructConvertNotSupportedException(this.descriptor, column);
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + this.descriptor.getPrimitiveType().getPrimitiveTypeName());
            }
        }
    }

    private void readBooleanBatch(int rowId, int num, WritableColumnVector column) throws IOException {
        if (column.dataType() != DataTypes.BooleanType) {
            throw this.constructConvertNotSupportedException(this.descriptor, column);
        }
        this.defColumn.readBooleans(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
    }

    private void readIntBatch(int rowId, int num, WritableColumnVector column) throws IOException {
        if (column.dataType() == DataTypes.IntegerType || DecimalType.is32BitDecimalType((DataType)column.dataType())) {
            this.defColumn.readIntegers(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
        } else if (column.dataType() == DataTypes.ByteType) {
            this.defColumn.readBytes(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
        } else if (column.dataType() == DataTypes.ShortType) {
            this.defColumn.readShorts(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
        } else if (column.dataType() == DataTypes.DateType) {
            if ("CORRECTED".equals(this.datetimeRebaseMode)) {
                this.defColumn.readIntegers(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
            } else {
                boolean failIfRebase = "EXCEPTION".equals(this.datetimeRebaseMode);
                this.defColumn.readIntegersWithRebase(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn, failIfRebase);
            }
        } else {
            throw this.constructConvertNotSupportedException(this.descriptor, column);
        }
    }

    private void readLongBatch(int rowId, int num, WritableColumnVector column) throws IOException {
        if (column.dataType() == DataTypes.LongType || DecimalType.is64BitDecimalType((DataType)column.dataType())) {
            this.defColumn.readLongs(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
        } else if (this.originalType == OriginalType.TIMESTAMP_MICROS) {
            if ("CORRECTED".equals(this.datetimeRebaseMode)) {
                this.defColumn.readLongs(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
            } else {
                boolean failIfRebase = "EXCEPTION".equals(this.datetimeRebaseMode);
                this.defColumn.readLongsWithRebase(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn, failIfRebase);
            }
        } else if (this.originalType == OriginalType.TIMESTAMP_MILLIS) {
            if ("CORRECTED".equals(this.datetimeRebaseMode)) {
                for (int i = 0; i < num; ++i) {
                    if (this.defColumn.readInteger() == this.maxDefLevel) {
                        column.putLong(rowId + i, DateTimeUtils.millisToMicros((long)this.dataColumn.readLong()));
                        continue;
                    }
                    column.putNull(rowId + i);
                }
            } else {
                boolean failIfRebase = "EXCEPTION".equals(this.datetimeRebaseMode);
                for (int i = 0; i < num; ++i) {
                    if (this.defColumn.readInteger() == this.maxDefLevel) {
                        long julianMicros = DateTimeUtils.millisToMicros((long)this.dataColumn.readLong());
                        column.putLong(rowId + i, VectorizedColumnReader.rebaseMicros(julianMicros, failIfRebase));
                        continue;
                    }
                    column.putNull(rowId + i);
                }
            }
        } else {
            throw this.constructConvertNotSupportedException(this.descriptor, column);
        }
    }

    private void readFloatBatch(int rowId, int num, WritableColumnVector column) throws IOException {
        if (column.dataType() != DataTypes.FloatType) {
            throw this.constructConvertNotSupportedException(this.descriptor, column);
        }
        this.defColumn.readFloats(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
    }

    private void readDoubleBatch(int rowId, int num, WritableColumnVector column) throws IOException {
        if (column.dataType() != DataTypes.DoubleType) {
            throw this.constructConvertNotSupportedException(this.descriptor, column);
        }
        this.defColumn.readDoubles(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
    }

    private void readBinaryBatch(int rowId, int num, WritableColumnVector column) throws IOException {
        VectorizedValuesReader data = (VectorizedValuesReader)this.dataColumn;
        if (column.dataType() == DataTypes.StringType || column.dataType() == DataTypes.BinaryType || DecimalType.isByteArrayDecimalType((DataType)column.dataType())) {
            this.defColumn.readBinarys(num, column, rowId, this.maxDefLevel, data);
        } else if (column.dataType() == DataTypes.TimestampType) {
            boolean failIfRebase = "EXCEPTION".equals(this.int96RebaseMode);
            if (!this.shouldConvertTimestamps()) {
                if ("CORRECTED".equals(this.int96RebaseMode)) {
                    for (int i = 0; i < num; ++i) {
                        if (this.defColumn.readInteger() == this.maxDefLevel) {
                            long gregorianMicros = ParquetRowConverter.binaryToSQLTimestamp(data.readBinary(12));
                            column.putLong(rowId + i, gregorianMicros);
                            continue;
                        }
                        column.putNull(rowId + i);
                    }
                } else {
                    for (int i = 0; i < num; ++i) {
                        if (this.defColumn.readInteger() == this.maxDefLevel) {
                            long julianMicros = ParquetRowConverter.binaryToSQLTimestamp(data.readBinary(12));
                            long gregorianMicros = VectorizedColumnReader.rebaseInt96(julianMicros, failIfRebase);
                            column.putLong(rowId + i, gregorianMicros);
                            continue;
                        }
                        column.putNull(rowId + i);
                    }
                }
            } else if ("CORRECTED".equals(this.int96RebaseMode)) {
                for (int i = 0; i < num; ++i) {
                    if (this.defColumn.readInteger() == this.maxDefLevel) {
                        long gregorianMicros = ParquetRowConverter.binaryToSQLTimestamp(data.readBinary(12));
                        long adjTime = DateTimeUtils.convertTz((long)gregorianMicros, (ZoneId)this.convertTz, (ZoneId)UTC);
                        column.putLong(rowId + i, adjTime);
                        continue;
                    }
                    column.putNull(rowId + i);
                }
            } else {
                for (int i = 0; i < num; ++i) {
                    if (this.defColumn.readInteger() == this.maxDefLevel) {
                        long julianMicros = ParquetRowConverter.binaryToSQLTimestamp(data.readBinary(12));
                        long gregorianMicros = VectorizedColumnReader.rebaseInt96(julianMicros, failIfRebase);
                        long adjTime = DateTimeUtils.convertTz((long)gregorianMicros, (ZoneId)this.convertTz, (ZoneId)UTC);
                        column.putLong(rowId + i, adjTime);
                        continue;
                    }
                    column.putNull(rowId + i);
                }
            }
        } else {
            throw this.constructConvertNotSupportedException(this.descriptor, column);
        }
    }

    private void readFixedLenByteArrayBatch(int rowId, int num, WritableColumnVector column, int arrayLen) {
        VectorizedValuesReader data = (VectorizedValuesReader)this.dataColumn;
        if (DecimalType.is32BitDecimalType((DataType)column.dataType())) {
            for (int i = 0; i < num; ++i) {
                if (this.defColumn.readInteger() == this.maxDefLevel) {
                    column.putInt(rowId + i, (int)ParquetRowConverter.binaryToUnscaledLong(data.readBinary(arrayLen)));
                    continue;
                }
                column.putNull(rowId + i);
            }
        } else if (DecimalType.is64BitDecimalType((DataType)column.dataType())) {
            for (int i = 0; i < num; ++i) {
                if (this.defColumn.readInteger() == this.maxDefLevel) {
                    column.putLong(rowId + i, ParquetRowConverter.binaryToUnscaledLong(data.readBinary(arrayLen)));
                    continue;
                }
                column.putNull(rowId + i);
            }
        } else if (DecimalType.isByteArrayDecimalType((DataType)column.dataType())) {
            for (int i = 0; i < num; ++i) {
                if (this.defColumn.readInteger() == this.maxDefLevel) {
                    column.putByteArray(rowId + i, data.readBinary(arrayLen).getBytes());
                    continue;
                }
                column.putNull(rowId + i);
            }
        } else {
            throw this.constructConvertNotSupportedException(this.descriptor, column);
        }
    }

    private void readPage() {
        DataPage page = this.pageReader.readPage();
        page.accept((DataPage.Visitor)new DataPage.Visitor<Void>(){

            public Void visit(DataPageV1 dataPageV1) {
                try {
                    VectorizedColumnReader.this.readPageV1(dataPageV1);
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public Void visit(DataPageV2 dataPageV2) {
                try {
                    VectorizedColumnReader.this.readPageV2(dataPageV2);
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void initDataReader(Encoding dataEncoding, ByteBufferInputStream in) throws IOException {
        this.endOfPageValueCount = this.valuesRead + (long)this.pageValueCount;
        if (dataEncoding.usesDictionary()) {
            this.dataColumn = null;
            if (this.dictionary == null) {
                throw new IOException("could not read page in col " + this.descriptor + " as the dictionary was missing for encoding " + dataEncoding);
            }
            Encoding plainDict = Encoding.PLAIN_DICTIONARY;
            if (dataEncoding != plainDict && dataEncoding != Encoding.RLE_DICTIONARY) {
                throw new UnsupportedOperationException("Unsupported encoding: " + dataEncoding);
            }
            this.dataColumn = new VectorizedRleValuesReader();
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            if (dataEncoding != Encoding.PLAIN) {
                throw new UnsupportedOperationException("Unsupported encoding: " + dataEncoding);
            }
            this.dataColumn = new VectorizedPlainValuesReader();
            this.isCurrentPageDictionaryEncoded = false;
        }
        try {
            this.dataColumn.initFromPage(this.pageValueCount, in);
        }
        catch (IOException e) {
            throw new IOException("could not read page in col " + this.descriptor, e);
        }
    }

    private void readPageV1(DataPageV1 page) throws IOException {
        this.pageValueCount = page.getValueCount();
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL);
        if (page.getDlEncoding() != Encoding.RLE && this.descriptor.getMaxDefinitionLevel() != 0) {
            throw new UnsupportedOperationException("Unsupported encoding: " + page.getDlEncoding());
        }
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxDefinitionLevel());
        VectorizedRleValuesReader dlReader = this.defColumn = new VectorizedRleValuesReader(bitWidth);
        this.repetitionLevelColumn = new SpecificParquetRecordReaderBase.ValuesReaderIntIterator(rlReader);
        this.definitionLevelColumn = new SpecificParquetRecordReaderBase.ValuesReaderIntIterator(dlReader);
        try {
            BytesInput bytes = page.getBytes();
            ByteBufferInputStream in = bytes.toInputStream();
            rlReader.initFromPage(this.pageValueCount, in);
            dlReader.initFromPage(this.pageValueCount, in);
            this.initDataReader(page.getValueEncoding(), in);
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }

    private void readPageV2(DataPageV2 page) throws IOException {
        this.pageValueCount = page.getValueCount();
        this.repetitionLevelColumn = SpecificParquetRecordReaderBase.createRLEIterator(this.descriptor.getMaxRepetitionLevel(), page.getRepetitionLevels(), this.descriptor);
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxDefinitionLevel());
        this.defColumn = new VectorizedRleValuesReader(bitWidth, false);
        this.definitionLevelColumn = new SpecificParquetRecordReaderBase.ValuesReaderIntIterator(this.defColumn);
        this.defColumn.initFromPage(this.pageValueCount, page.getDefinitionLevels().toInputStream());
        try {
            this.initDataReader(page.getDataEncoding(), page.getData().toInputStream());
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }
}

